<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Conceptos_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * vistas
	 *
	 * @return object
	 * @author Raquel Romero and Tanya Paredes
	 **/
	public function conceptos()
	{
		$this->trigger_events('conceptos');

		// run each where that was passed
		
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['conceptos']);
		
		return $this;
	}

	/**
	 * conceptos
	 *
	 * @return object
	 * @author Tanya Paredes
	 **/
	public function concepto($id = NULL)
	{
		$this->trigger_events('conceptos');

		if (isset($id))
		{
			$this->where($this->tables['conceptos'].'.gid', $id);
		}

		$this->limit(1);
		//$this->order_by('id', 'nombre');

		return $this->conceptos();
	}

	/* Trae de la tabla view v_tipovista el "concepto y nombre" */
	public function get_vista ($concepto = ''){
		$nombre = $this->db->get_where($this->tables['v_tipovista'], array('concepto' => $concepto));
		return $c_tipo;
	}

	public function get_vista2 ($concepto = ''){
		$nombre = $this->db->get_where($this->tables['v_modulos'], array('concepto' => $concepto));
		return $c_modulo;
	}

	/**
	 * create_concepto
	 *
	 * @author Tanya Paredes
	*/
	
	public function create_concepto($data, $additional_data = array())
	{

		// Verifica si ya se encuentra insertado el nombre de la vista.
		$existing_conceptos = $this->db->get_where($this->tables['conceptos'], array('concepto' => $data['concepto'],'tipoconcepto' => $data['tipoconcepto']))->num_rows();

		
		if($existing_conceptos !== 0)
		{
			$this->ion_auth->set_error('concepto_already_exists');
			return FALSE;
		}

		
		// filter out any data passed that doesnt have a matching column in the groups table
		// and merge the set group data and the additional data
		if (!empty($additional_data)) $data = array_merge($this->_filter_data($this->tables['conceptos'], $additional_data), $data);

		$this->trigger_events('extra_concepto_set');

		// insertar nuevo conceptos
		$this->db->insert($this->tables['conceptos'], $data);
		//$concepto_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('concepto_creation_successful');
		// return the brand new concepto id
		return $concepto_id;
	}	

	  
	public function update_concepto($vid,$data){
		
		$existing_conceptos = $this->db->get_where($this->tables['conceptos'], $data)->num_rows();
	
		if($existing_conceptos !== 0)
		{
			$this->ion_auth->set_error('concepto_already_exists');
			return FALSE;
		}

		$this->db->update($this->tables['conceptos'], $data, array('gid' => $vid));

		$this->set_message('conceptos_update_successful');

		return TRUE;
	}

	public function delete_concepto($vid){

		$this->db->delete($this->tables['conceptos'], array('gid' => $vid));

		return TRUE;

	}

}