<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sesiones extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('sesiones/sesiones_model');
		$this->lang->load('sesiones/sesiones_lang');


		/* Title Page :: Common */
		$this->page_title->push(lang('menu_sesiones'));
		$this->data['pagetitle'] = $this->page_title->show();
		$_SESSION['id_modulo'] = 'SESIONES';

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_sesiones'), 'admin/sesiones');
	}
	
	
	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['sesiones'] = $this->sesiones_model->sesiones_all()->result();

			/* Load Template */
			$this->template->admin_render('sesiones/index', $this->data);
		}
	}


	
	public function mostrar($id)
	{
		//$user_id = $this->input->post('user_id');

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_sesiones'), 'sesiones/sesiones');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Data */
        $id = (int) $id;

       	$this->data['sesiones_info'] = $this->sesiones_model->mostrar_all('login_attempts',array('user_id' => $id))->row();
   
        /* Load Template */
		$this->template->admin_render('sesiones/mostrar', $this->data);
	} 

	  public function delete($id){

		$sesion_delete = $this->sesiones_model->delete_sesiones($id);

		if ($sesion_delete)
		{
			$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
			redirect('sesiones/sesiones');
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}
}