<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('proyectos/proyectos_model');
		$this->lang->load('proyectos/proyectos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'PROYECTOS') {

			$_SESSION['arraywhere_proyectos'] 		 = NULL;
			$_SESSION['arraywhere_proyectos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'PROYECTOS';
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'proyectos/proyectos');
	}

	public function proyecto_mantenimiento($id_proyec)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'proyectos/proyectos');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $proy_datos = $this->proyectos_model->view('proyectos', array('id_proyecto' => $id_proyec))->row();

  /*
  id_proyecto
  numero_contrato
  anyo_contrato
  expediente
  consultora
  descripcion
  contratista
  presupuesto
  tipo_moneda
  fecha_orden_proceder
  plazo_ejecucion
  plazo_ejecucion_catastral
  fecha_hora_insercion
  observaciones
  usuario

*/
			$id_proyecto 				= $proy_datos->id_proyecto;
			$numero_contrato 			= $proy_datos->numero_contrato;
			$anyo_contrato 				= $proy_datos->anyo_contrato;
			$expediente  				= $proy_datos->expediente;
			$consultora  				= $proy_datos->consultora;
			$descripcion  				= $proy_datos->descripcion;
			$contratista  				= $proy_datos->contratista;
			$presupuesto  				= $proy_datos->presupuesto;
			$tipo_moneda  				= $proy_datos->tipo_moneda;
			$fecha_orden_proceder  		= $proy_datos->fecha_orden_proceder;
			$plazo_ejecucion  			= $proy_datos->plazo_ejecucion;
			$plazo_ejecucion_catastral  = $proy_datos->plazo_ejecucion_catastral;
			$fecha_hora_insercion  		= $proy_datos->fecha_hora_insercion;
			$observaciones  			= $proy_datos->observaciones;
			$usuario  					= $proy_datos->usuario;


	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";

			$proyec_info  = $this->proyectos_model->view('proyectos', array('id_proyecto' => $id_proyec))->result_array();



			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_FD_LINEA']		= $this->proyectos_model->contador_registros('franja_dominio_pol', array('id_proyec' => $id_proyec));
			$datos_graficos[0]['MOPC_FC_LINEA']		= $this->proyectos_model->contador_registros('franja_construccion', array('id_proyec' => $id_proyec));
		/*TOCA CAMBIAR A EJE*/
			$datos_graficos[0]['MOPC_EJE']		= $this->proyectos_model->contador_registros('franja_construccion', array('id_proyec' => $id_proyec));

			/************* FIN CANTIDAD DATOS GRAFICOS ****************/



			$this->data['proyec_info'] 		= $proyec_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['id_proyecto'] = array(
				'type'     => 'hidden',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $id_proyecto
			);

			$this->data['numero_contrato'] = array(
				'type'     => 'hidden',
				'name'     => 'numero_contrato',
				'id'       => 'numero_contrato',
				'value'    => $numero_contrato
			);

			$this->data['anyo_contrato'] = array(
				'type'     => 'hidden',
				'name'     => 'anyo_contrato',
				'id'       => 'anyo_contrato',
				'value'    => $anyo_contrato
			);
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ?
				$this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Load Template */
            $this->template->admin_render('proyectos/mantenimiento', $this->data);
		}
	}
/*HASTA AQUI 220319*/

	public function eliminar_geometrias_proyecto($id_proyecto = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');


		$resultado = $this->proyectos_model->eliminar_geometrias_proyecto($id_proyecto);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento/proyecto_mantenimiento/'.$id_proyecto);

	}

	public function download_proyecto($id_proyec = NULL)
	{

        //exec('\dir_intercambio\exp_mopc_expropia_proyec_tabla_a_shp.sh postgres postgres '.trim($id_proyecto).');
        /*$resultado = exec("/dir_intercambio/exp_mopc_expropia_proyec_tabla_a_shp.sh postgres postgres ".trim($id_tramo));

        $download_file = "mopc_proyecto_shp".$id_proyecto.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
		}*/
		
		$resultado= exec("/dir_intercambio/exp_mopc_expropia_proyec_tabla_a_shp.sh postgres postgres ".trim($id_proyec));
		
		redirect('proyectos/Mantenimiento/proyecto_mantenimiento/'.$id_proyec);

	}

	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('proyectos/mantenimiento/proyecto_mantenimiento/'.$_POST['id_proyecto']);
		}

		$id_proyecto 	 = $_POST['id_proyecto'];
		$numero_contrato = $_POST['numero_contrato'];
		$anyo_contrato 	 = $_POST['anyo_contrato'];

		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}


		// pregunta sin existen datos graficos del proyecto.
		$proyecto = $this->proyectos_model->existe_grafico_id_proyecto($id_proyecto)->row()->f_existe_grafico_id_proyecto;

		if ($proyecto>0) {
			$this->session->set_flashdata('message', 'EL PROYECTO YA TIENE DATOS ESPACIALES!');
			redirect('proyectos/mantenimiento/proyecto_mantenimiento/'.$_POST['id_proyec']);
		}
		else {


			//exec('cmd /c "'.trim('md C:\dir_intercambio\proyectos\ ').trim($id_proyecto).'"');
			exec('rm -R /dir_intercambio/proyectos/proyecto'.trim($id_proyecto));
                        exec(trim('mkdir /dir_intercambio/proyectos/proyecto ').trim($id_proyecto));

			//echo 'id_proyec: '.$id_proyec;
			//show_error('TEMPORALMENTE INACTIVO');

			//$ruta_dest = trim('C:\dir_intercambio\proyectos\ ').trim($id_proyecto).trim('\ ');

			$ruta_dest = trim('/dir_intercambio/proyectos/proyecto ').trim($id_proyecto).trim('/ ');


			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					default:
						$i = $i + 1;
						break;

				}
			}

			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) {
				$id_epsg = 32720;
			} elseif ($accion == 3) {
				$id_epsg = 4326;
			} else  {
				$id_epsg = 32721;
			}

			//exec('cmd /c "C:\dir_intercambio\imp_mopc_expropia_proyectos_shp_a_tabla.bat '.trim($id_proyecto).' '.$id_epsg.'"');

			exec('/dir_intercambio/imp_mopc_expropia_proyectos_shp_a_tabla.sh '.trim($id_proyecto).' '.$id_epsg);

			//echo 'id_proyec: '.$id_proyec;
			//show_error('TEMPORALMENTE INACTIVO');

			$actu = $this->proyectos_model->actualizar_shapes_proyecto($id_proyecto, $id_epsg)->row()->actualizar_shapes_proyecto;
/*
resultado=0 -- Sin errores.
resultado=1 -- no existe la tabla temporal.fd 
resultado=2 -- no realiza importación en ide.franja_dominio_pol
resultado=3 -- no existe la tabla temporal.fc 
resultado=4 -- no se realiza importacion en ide.franja_construccion
*/

			if ($actu==2 or $actu==4) {
				$mensaje = $this->proyectos_model->mensaje_error($id_proyecto)->row()->descrip_error;
				//echo 'id_proyec: '.$mensaje;
			//	show_error('TEMPORALMENTE INACTIVO');
				$this->session->set_flashdata('message', $mensaje);
				redirect('proyectos/mantenimiento/proyecto_mantenimiento/'.$_POST['id_proyecto']);
			}
			else {
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3>');

				redirect('proyectos/mantenimiento/proyecto_mantenimiento/'.$_POST['id_proyecto']);

			}
		}
	}

	public function vergrafico ($id_proyec=NULL) {

        	$i_jameuge = "https://www.mopc.gov.py/sgeGis/sgeMap/index.html?id_proyec=" . $id_proyec;
        	$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_proyectos_id_proyec";

			redirect($i_jameuge);
	}


}
