<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Parcelas extends Admin_Controller {

    public function __construct()
    {
        parent::__construct();

		$this->load->model('man_espacial/parcelas/parcelas_model');
        $this->lang->load('parcelas/parcelas');

        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('menu_parcelas'));
        $this->data['pagetitle'] = $this->page_title->show();

			//$_SESSION['arraywhere_aldeas'] 				= NULL;
			//$_SESSION['arraywhere_aldeas_busqueda'] 	= NULL;        

        if ($_SESSION['id_modulo'] != 'PARCELAS') {

			$_SESSION['arraywhere_parcelas'] 			= NULL;
			$_SESSION['arraywhere_parcelas_busqueda'] 	= NULL;
			$_SESSION['arraywhere_aldeas'] 				= NULL;
			$_SESSION['arraywhere_aldeas_busqueda'] 	= NULL;
			$_SESSION['arraywhere_bloques'] 			= NULL;
			$_SESSION['arraywhere_bloques_busqueda'] 	= NULL;

			$_SESSION['id_modulo'] = 'PARCELAS';
		}

        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_parcelas'), 'admin/parcelas');
    }
 	
	public function index()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        	if ($_POST) { 
        		$arraywhere = NULL;
				if ($_POST['localidad']) 
				{
					$arraywhere['localidad'] 					= $_POST['localidad'];
					$arraywherebusq['lower(localidad) like ']	= '%'.strtolower($_POST['localidad']).'%';
				}

				if ($_POST['lote_n']) 
				{
					$arraywhere['lote_n'] 						= $_POST['lote_n'];
					$arraywherebusq['lower(lote_n) like '] 		= '%'.strtolower($_POST['lote_n']).'%';
				}

				if ($_POST['c_i_n']) 
				{
					$arraywhere['c_i_n'] 						= $_POST['c_i_n'];
					$arraywherebusq['c_i_n like '] 				= '%'.$_POST['c_i_n'].'%';
				}

				if ($_POST['ii_nombre']) 
				{
					$arraywhere['ii_nombre'] 					= $_POST['ii_nombre'];
					$arraywherebusq['lower(ii_nombre) like '] 	= '%'.strtolower($_POST['ii_nombre']).'%';
				}

				if ($_POST['ii_ctacte']) 
				{
					$arraywhere['ii_ctacte'] 					= $_POST['ii_ctacte'];
					$arraywherebusq['ii_ctacte like ']			= '%'.$_POST['ii_ctacte'].'%';
				}

				if ($_POST['padron_n']) 
				{
					$arraywhere['padron_n'] 					= $_POST['padron_n'];
					$arraywherebusq['padron_n like '] 			= '%'.$_POST['padron_n'].'%';
				}

				if ($_POST['finca_n']) 
				{
					$arraywhere['finca_n'] 						= $_POST['finca_n'];
					$arraywherebusq['lower(finca_n) like '] 	= '%'.strtolower($_POST['finca_n']).'%';
				}

				if ($_POST['ii_monto']) 
				{
					if (is_numeric($_POST['ii_monto'])) {
						$arraywhere['ii_monto']					= $_POST['ii_monto'];
						$arraywherebusq['ii_monto']				= (double)$_POST['ii_monto'];
					}
				}

				if ($_POST['supha']) 
				{
					if (is_numeric($_POST['supha'])) {
						$arraywhere['supha']					= $_POST['supha'];
						$arraywherebusq['supha'] 				= (double)$_POST['supha'];
					}
				}

				$_SESSION['arraywhere_parcelas'] = $arraywhere;
				$_SESSION['arraywhere_parcelas_busqueda'] = $arraywherebusq;

				redirect('man_espacial/parcelas/parcelas/index/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/parcelas/parcelas/index/',  // url completa de la pagina paginada
				'parcelas',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_parcelas_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['parcelas']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], // resultados por pagina
 				5,							// segmento uri a leer
 				'parcelas',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_parcelas_busqueda']
 				)->result();
			// ----- Fin paginacion

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Load Template */
            $this->template->admin_render('man_espacial/parcelas/index', $this->data);
	        
        }
    }


	public function lotes()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        	if ($_POST) { 
        		$arraywhere = NULL;
				if ($_POST['localidad']) 
				{
					$arraywhere['localidad'] 					= $_POST['localidad'];
					$arraywherebusq['lower(localidad) like ']	= '%'.strtolower($_POST['localidad']).'%';
				}

				if ($_POST['lote_n']) 
				{
					$arraywhere['lote_n'] 						= $_POST['lote_n'];
					$arraywherebusq['lower(lote_n) like '] 		= '%'.strtolower($_POST['lote_n']).'%';
				}

				if ($_POST['c_i_n']) 
				{
					$arraywhere['c_i_n'] 						= $_POST['c_i_n'];
					$arraywherebusq['c_i_n like '] 				= '%'.$_POST['c_i_n'].'%';
				}

				if ($_POST['ii_nombre']) 
				{
					$arraywhere['ii_nombre'] 					= $_POST['ii_nombre'];
					$arraywherebusq['lower(ii_nombre) like '] 	= '%'.strtolower($_POST['ii_nombre']).'%';
				}

				if ($_POST['ii_ctacte']) 
				{
					$arraywhere['ii_ctacte'] 					= $_POST['ii_ctacte'];
					$arraywherebusq['ii_ctacte like ']			= '%'.$_POST['ii_ctacte'].'%';
				}

				if ($_POST['padron_n']) 
				{
					$arraywhere['padron_n'] 					= $_POST['padron_n'];
					$arraywherebusq['padron_n like '] 			= '%'.$_POST['padron_n'].'%';
				}

				if ($_POST['finca_n']) 
				{
					$arraywhere['finca_n'] 						= $_POST['finca_n'];
					$arraywherebusq['lower(finca_n) like '] 	= '%'.strtolower($_POST['finca_n']).'%';
				}

				if ($_POST['ii_monto']) 
				{
					if (is_numeric($_POST['ii_monto'])) {
						$arraywhere['ii_monto']					= $_POST['ii_monto'];
						$arraywherebusq['ii_monto']				= (double)$_POST['ii_monto'];
					}
				}

				if ($_POST['supha']) 
				{
					if (is_numeric($_POST['supha'])) {
						$arraywhere['supha']					= $_POST['supha'];
						$arraywherebusq['supha'] 				= (double)$_POST['supha'];
					}
				}

				$_SESSION['arraywhere_parcelas'] = $arraywhere;
				$_SESSION['arraywhere_parcelas_busqueda'] = $arraywherebusq;

				redirect('man_espacial/parcelas/parcelas/lotes/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/parcelas/parcelas/lotes/',  // url completa de la pagina paginada
				'lotes',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_parcelas_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['lotes']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], // resultados por pagina
 				5,							// segmento uri a leer
 				'lotes',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_parcelas_busqueda']
 				)->result();
			// ----- Fin paginacion

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Load Template */
            $this->template->admin_render('man_espacial/parcelas/lotes', $this->data);
	        
        }
    }


	public function bolotes()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        	if ($_POST) { 
			$arraywhere = NULL;
		
			if ($_POST['id']) 
			{
				if (is_numeric($_POST['id'])) {
					$arraywhere['id']			= $_POST['id'];
					$arraywherebusq['id'] 			= (integer)$_POST['id'];
				}
			}        				
		
			if ($_POST['lote']) 
			{
				$arraywhere['lote'] 				= $_POST['lote'];
				$arraywherebusq['lower(lote) like '] 		= '%'.strtolower($_POST['lote']).'%';
			}
			
			if ($_POST['nombre']) 
			{
				$arraywhere['nombre'] 				= $_POST['nombre'];
				$arraywherebusq['lower(nombre) like ']	  	= '%'.strtolower($_POST['nombre']).'%';
			}
		

		
			if ($_POST['cod_catast']) 
			{
				$arraywhere['cod_catast'] 			= $_POST['cod_catast'];
				$arraywherebusq['lower(cod_catast) like '] 		= '%'.strtolower($_POST['cod_catast']).'%';
			}
		
			if ($_POST['distrito']) 
			{
				$arraywhere['distrito'] 			= $_POST['distrito'];
				$arraywherebusq['lower(distrito) like '] 	= '%'.strtolower($_POST['distrito']).'%';
			}
		
			if ($_POST['manzano']) 
			{
				$arraywhere['manzano'] 				= $_POST['manzano'];
				$arraywherebusq['lower(manzano) like ']		= '%'.strtolower($_POST['manzano']).'%';
			}
		
			if ($_POST['zonas']) 
			{
				$arraywhere['zonas'] 				= $_POST['zonas'];
				$arraywherebusq['lower(zonas) like '] 		= '%'.strtolower($_POST['zonas']).'%';
			}
		
			if ($_POST['sup_m2']) 
			{
				if (is_numeric($_POST['sup_m2'])) {
					$arraywhere['sup_m2']			= $_POST['sup_m2'];
					$arraywherebusq['sup_m2'] 		= (double)$_POST['sup_m2'];
				}
			}
		
			if ($_POST['obs']) 
			{
				$arraywhere['obs'] 				= $_POST['obs'];
				$arraywherebusq['lower(obs) like '] 		= '%'.strtolower($_POST['obs']).'%';
			}
		

		
			$_SESSION['arraywhere_parcelas'] = $arraywhere;
			$_SESSION['arraywhere_parcelas_busqueda'] = $arraywherebusq;
		
			redirect('man_espacial/parcelas/parcelas/bolotes/');				
		}
		
		 // ----- Paginacion Generica 
		$mi_paginacion = $this->ion_auth->paginacion_generica(
			12, 						// resultados por por_pagina, 
			5, 							// segmento uri a leer, 
			5, 							// cantidad_enlaces,
			base_url(). 'man_espacial/parcelas/parcelas/bolotes/',  // url completo del paginado
			'bolotes',		// scheme y nombre de la tabla, para la consulta
			$_SESSION['arraywhere_parcelas_busqueda']
			);
		
		$this->data['pagination'] 		= $mi_paginacion['pagination'];
		
		$this->data['bolotes']	  		= $this->ion_auth_model->segmentador_paginas(
			$mi_paginacion['per_page'], // resultados por pagina
			5,							// segmento uri a leer
			'bolotes',					// el nombre de la tabla a consultar $nombre_tabla
			$_SESSION['arraywhere_parcelas_busqueda']
			)->result();
		// ----- Fin paginacion
		
		/* Breadcrumbs */
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
		
            /* Load Template */
            $this->template->admin_render('man_espacial/parcelas/bolotes', $this->data);
	        
        }
    }








	public function aldeas()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        	if ($_POST) { 
        		$arraywhere = NULL;
				if ($_POST['localidad']) 
				{
					$arraywhere['localidad'] 					= $_POST['localidad'];
					$arraywherebusq['lower(localidad) like ']	= '%'.strtolower($_POST['localidad']).'%';
				}

				if ($_POST['aldea_zona']) 
				{
					$arraywhere['aldea_zona'] 						= $_POST['aldea_zona'];
					$arraywherebusq['lower(aldea_zona) like '] 		= '%'.strtolower($_POST['aldea_zona']).'%';
				}

				if ($_POST['sup_actual']) 
				{
					$arraywhere['sup_actual'] 						= $_POST['sup_actual'];
					$arraywherebusq['sup_actual like '] 				= '%'.$_POST['sup_actual'].'%';
				}

				if ($_POST['objectid']) 
				{
					$arraywhere['objectid'] 					= $_POST['objectid'];
					$arraywherebusq['lower(objectid) like '] 	= '%'.strtolower($_POST['objectid']).'%';
				}				

				$_SESSION['arraywhere_aldeas'] = $arraywhere;
				$_SESSION['arraywhere_aldeas_busqueda'] = $arraywherebusq;

				redirect('man_espacial/parcelas/parcelas/aldeas/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/parcelas/parcelas/aldeas/',  // url completa de la pagina paginada
				'aldeas',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_aldeas_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['aldeas']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], // resultados por pagina
 				5,							// segmento uri a leer
 				'aldeas',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_aldeas_busqueda']
 				)->result();
			// ----- Fin paginacion

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Load Template */
            $this->template->admin_render('man_espacial/parcelas/aldeas', $this->data);
	        
        }
    }


	public function bloques()
	{
        if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
        {
            redirect('auth/login', 'refresh');
        }
        else
        {
        	if ($_POST) { 
        		$arraywhere = NULL;

				if ($_POST['nro_bloque']) 
				{
					if (is_numeric($_POST['nro_bloque'])) {
						$arraywhere['nro_bloque'] 					= $_POST['nro_bloque'];
						$arraywherebusq['nro_bloque'] 				= $_POST['nro_bloque'];
					}
				}
/*
				if ($_POST['nro_bloque']) 
				{
					$arraywhere['nro_bloque'] 					= $_POST['nro_bloque'];
					$arraywherebusq['lower(nro_bloque) like ']	= '%'.strtolower($_POST['nro_bloque']).'%';
				}
*/
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 						= $_POST['nombre'];
					$arraywherebusq['lower(nombre) like '] 		= '%'.strtolower($_POST['nombre']).'%';
				}

				if ($_POST['sup_actual']) 
				{
					if (is_numeric($_POST['sup_actual'])) {
						$arraywhere['sup_actual'] 					= $_POST['sup_actual'];
						$arraywherebusq['sup_actual'] 				= $_POST['sup_actual'];
					}
				}		
/*
				if ($_POST['sup_actual']) 
				{
					if (is_numeric($_POST['sup_actual'])) {
						$arraywhere['sup_actual'] 					= $_POST['sup_actual'];
						$arraywherebusq['lower(sup_actual::varchar) like '] 	= '%'.strtolower($_POST['sup_actual']).'%';
					}
				}							
*/
/*
				if ($_POST['sup_actual']) 
				{
					$arraywhere['sup_actual'] 						= $_POST['sup_actual'];
					$arraywherebusq['sup_actual like '] 				= '%'.$_POST['sup_actual'].'%';
				}
*/

				if ($_POST['objectid']) 
				{
					if (is_numeric($_POST['objectid'])) {
						$arraywhere['objectid'] 					= $_POST['objectid'];
						$arraywherebusq['objectid'] 				= $_POST['objectid'];
					}
				}
/*				
				if ($_POST['objectid']) 
				{
					$arraywhere['objectid'] 					= $_POST['objectid'];
					$arraywherebusq['lower(objectid) like '] 	= '%'.strtolower($_POST['objectid']).'%';
				}				
*/                         
				$_SESSION['arraywhere_bloques'] = $arraywhere;
				$_SESSION['arraywhere_bloques_busqueda'] = $arraywherebusq;

				redirect('man_espacial/parcelas/parcelas/bloques/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/parcelas/parcelas/bloques/',  // url completa de la pagina paginada
				'bloques',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_bloques_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['bloques']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], // resultados por pagina
 				5,							// segmento uri a leer
 				'bloques',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_bloques_busqueda']
 				)->result();
			// ----- Fin paginacion

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

            /* Load Template */
            $this->template->admin_render('man_espacial/parcelas/bloques', $this->data);
	        
        }
    }



	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_geocolonias'), 'geocolonias/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_desc', 'lang:geocolonia_col_desc', 'required|alpha_dash');

		if ($this->form_validation->run() == TRUE)
		{
			$new_geocolonia_id = $this->geocolonias_model->create_geocolonia($this->input->post('dpto_cod'), $this->input->post('dist_cod'), $this->input->post('col_cod'), $this->input->post('id_codgeo'), $this->input->post('col_desc'));
			if ($new_geocolonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('geocolonias/geocolonias', 'refresh');
			}
		}
		else
		{
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			$this->data['dpto_cod'] = array(
				'name'  => 'dpto_cod',
				'id'    => 'dpto_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('dpto_cod')
			);
			$this->data['dist_cod'] = array(
				'name'  => 'dist_cod',
				'id'    => 'dist_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_cod')
			);
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod')
			);
			$this->data['id_codgeo'] = array(
				'name'  => 'id_codgeo',
				'id'    => 'id_codgeo',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('id_codgeo')
			);
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
                'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
			);
            /* Load Template */
            $this->template->admin_render('geocolonias/create', $this->data);
		}
	}


	public function delete()
	{
        if ( ! $this->ion_auth->logged_in())
        {
            redirect('auth/login', 'refresh');
        }
        elseif ( ! $this->ion_auth->is_admin())
		{
            return show_error('You must be an administrator to view this page.');
        }
        else
        {
            $this->load->view('geocolonias/delete');
        }
	}


	public function edit($gid,$dpto,$dist,$col)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid) OR ! $dpto OR empty($dpto) OR ! $dist OR empty($dist) OR ! $col OR empty($col))
		{
			redirect('auth', 'refresh');
		}

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_geocolonias_edit'), 'geocolonias/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();



        /* Variables *///Trae de la base de datos la fila seleccionada
		$geocolonia = $this->geocolonias_model->view($dpto,$dist,$col)->row();

        /* Validate form input */
        $this->form_validation->set_rules('geocolonia_col_cod', $this->lang->line('edit_geocolonia_validation_name_label'), 'required|is_numeric|max_length[3]');
        
        $this->form_validation->set_rules('geocolonia_col_desc', $this->lang->line('edit_geocolonia_validation_name_label'), 'required');
		
		$this->form_validation->set_rules('geocolonia_id_codgeo', $this->lang->line('edit_geocolonia_validation_desc_label'), 'required|is_numeric|min_length[7]|max_length[7]');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$geocolonia_update = $this->geocolonias_model->update_geocolonia($gid, $_POST['departamento'], $_POST['dist'], $_POST['geocolonia_col_cod'], $_POST['geocolonia_id_codgeo'], $_POST['geocolonia_col_desc']);

				if ($geocolonia_update)
				{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
					$this->session->set_flashdata('message', $this->lang->line('geocolonia_update_successful'));
					redirect('man_espacial/geocolonias/geocolonias/edit/'.$gid.'/'.$_POST['departamento'].'/'.$_POST['dist'].'/'.$_POST['geocolonia_col_cod'].'/'); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh'); 
			}
		}

        $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        $this->data['geocolonia']   = $geocolonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $geocolonia->col_desc ? 'readonly' : '';
		
		//creando campos
		$this->data['geocolonia_dpto_cod'] = array(
			'type'    => 'text',
			'name'    => 'geocolonia_dpto_cod',
			'id'      => 'geocolonia_dpto_cod',
			'value'   => $this->form_validation->set_value('geocolonia_dpto_cod', $geocolonia->dpto_cod),
            'class'   => 'form-control',
		);
		$this->data['geocolonia_dist_cod'] = array(
			'type'  => 'text',
			'name'  => 'geocolonia_dist_cod',
			'id'    => 'geocolonia_dist_cod',
			'value' => $this->form_validation->set_value('geocolonia_dist_cod', $geocolonia->dist_cod),
            'class' => 'form-control'
		);
		$this->data['geocolonia_col_cod'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_col_cod',
			'id'       => 'geocolonia_col_cod',
			'value'    => $this->form_validation->set_value('geocolonia_col_cod', $geocolonia->col_cod),
			'data-src' => $geocolonia->col_cod,
            'class'    => 'form-control'
		);
		$this->data['geocolonia_id_codgeo'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_id_codgeo',
			'id'       => 'geocolonia_id_codgeo',
			'value'    => $this->form_validation->set_value('geocolonia_id_codgeo', $geocolonia->id_codgeo),
			'data-src' => $geocolonia->id_codgeo,
            'class'    => 'form-control'
		);
		$this->data['geocolonia_col_desc'] = array(
			'type'     => 'text',
			'name'     => 'geocolonia_col_desc',
			'id'       => 'geocolonia_col_desc',
			'value'    => $this->form_validation->set_value('geocolonia_col_desc', $geocolonia->col_desc),
			'data-src' => $geocolonia->col_desc,
            'class'    => 'form-control'
		);

		$this->data['ddl_dpto'] = $this->geocolonias_model->departamentos()->result();
		$this->data['ddl_dist'] = $this->geocolonias_model->distritos()->result();
        /* Load Template */
        $this->template->admin_render('man_espacial/geocolonias/edit', $this->data);
	}

	/////////////////////////////// VER PORTAL DE MAPAS ///////////////////// 

	public function verparcela ($objectid) {
	
		$bbox = $this->parcelas_model->bb($objectid);
		if ($bbox)
		{
            
			$data['campo1'] = $bbox[0]['campo1'];
        	$data['campo2'] = $bbox[0]['campo2'];
        	$data['campo3'] = $bbox[0]['campo3'];
        	$data['campo4'] = $bbox[0]['campo4'];

        	$data['concat'] = $bbox[0]['campo1']. ',' . $bbox[0]['campo2'] . ',' .$bbox[0]['campo3']. ',' . $bbox[0]['campo4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ms_criamapa.php?tema=selparcel&layers=selparcel";
        	$i_jameuge = $i_jameuge . "&map_layer_selparcel_filter=objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	$i_jameuge = $i_jameuge . "&extenquery=". $data['concat'];

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function verlotes ($objectid) {
	
		$bbox = $this->parcelas_model->bblote($objectid);
		if ($bbox)
		{
            
			$data['campo1'] = $bbox[0]['campo1'];
        	$data['campo2'] = $bbox[0]['campo2'];
        	$data['campo3'] = $bbox[0]['campo3'];
        	$data['campo4'] = $bbox[0]['campo4'];

        	$data['concat'] = $bbox[0]['campo1']. ',' . $bbox[0]['campo2'] . ',' .$bbox[0]['campo3']. ',' . $bbox[0]['campo4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ms_criamapa.php?tema=sellote&layers=sellote";
        	$i_jameuge = $i_jameuge . "&map_layer_sellote_filter=objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	$i_jameuge = $i_jameuge . "&extenquery=". $data['concat'];

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function verlotes_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/mmapvisor/index.html?tipo_consulta=bolotes_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	public function verbloques_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/byavisor/index.html?tipo_consulta=bloques_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	public function veraldeas_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/byavisor/index.html?tipo_consulta=aldeas_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	public function vercolonias_ol ($gid) {

	/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
	*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/byavisor/index.html?tipo_consulta=colonias_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);

			redirect($i_jameuge);
	}

	public function veraldea ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
            
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ms_criamapa.php?tema=selaldea&layers=aldeas";
        	$i_jameuge = $i_jameuge . "&map_layer_aldeas_filter=objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapext=". $data['concat'];
        	$i_jameuge = $i_jameuge . "&extenquery=". $data['concat'];

			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////
	//////////////// GENERAR PLANOS DE ADEAS /////////////////////


	public function generarplanoaldeasU ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}



	public function generarplanoaldeasA ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_UsoAlter.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_UsoAlter.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoaldeasU86 ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Uso1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Uso1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoaldeasC ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Capacidad.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Capacidad.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasT ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Taxonomia.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Taxonomia.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasI86 ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Imagen_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Imagen_1986.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoaldeasIAC ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_imagen_actual.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Imagen_Actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Imagen_Actual.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoaldeasF ($objectid) {
	
		$bbox = $this->parcelas_model->bbaldea($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_Aldeas_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_Aldeas_Fincas.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}



	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////
	//////////////// GENERAR PLANOS DE BLOQUES /////////////////////


	public function generarplanobloquesU ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}



	public function generarplanobloquesA ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_UsoAlter.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_UsoAlter.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanobloquesU86 ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Uso1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Uso1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat']; 
        	redirect($i_jameuge);       	
        }
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanobloquesC ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Capacidad.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Capacidad.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesT ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_f1_Taxonomia.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Taxonomia.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesI86 ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Imagen_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Imagen_1986.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanobloquesIAC ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_imagen_actual.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Imagen_Actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Imagen_Actual.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanobloquesF ($objectid) {
	
		$bbox = $this->parcelas_model->bbbloque($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	//$i_jameuge = "http://181.120.22.251:8060/i3geo/ferramentas/imprimir/Mapa_A3_uso_actual86.php?";
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/bloques/Mapa_A3_Bloques_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/bloques/Mapa_A3_Bloques_Fincas.map";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=black_gm.phtml";
        	//$i_jameuge = $i_jameuge . "&titulo=titulo&tema=selparcel&layers=selparcel&interface=googlemaps";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}




	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////
	//////////////// GENERAR PLANOS DE LOTES /////////////////////


	public function generarplanoUT ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);

		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}


	public function generarplanoA2 ($objectid,$lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_UsoAlternativo.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoAlternativo.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;        	
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}

	}

	public function generarplanoF2 ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapafincabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Fincas.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoC ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Capacidad.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Capacidad.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoT ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_Taxonomia.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Taxonomia.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoMS86 ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_mapa_satelital86.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_mapa_satelital86.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoU862 ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_uso_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_uso_1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoIA ($objectid, $lote_n) {
	
		$bbox = $this->parcelas_model->mapabb_lote($lote_n);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f2_imagen_actual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_imagen_actual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&lote_n=" . $lote_n;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	//////////////// GENERAR PLANOS DE PARCELAS /////////////////////
	//////////////// GENERAR PLANOS DE PARCELAS /////////////////////
	//////////////// GENERAR PLANOS DE PARCELAS /////////////////////
	//////////////// GENERAR PLANOS DE PARCELAS /////////////////////




	public function generarplanoU ($objectid) {
	
		$bbox = $this->parcelas_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];

        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_UsoActual.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoActual.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoA ($objectid) {
	
		$bbox = $this->parcelas_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_UsoAlternativo.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_UsoAlternativo.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}

	public function generarplanoF ($objectid) {
	
		$bbox = $this->parcelas_model->mapafincabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_f1_Fincas.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_f1_Fincas.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}


	public function generarplanoU86 ($objectid) {
	
		$bbox = $this->parcelas_model->mapabb($objectid);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
        	$i_jameuge = "http://map.barrientosyasociados.com.py:8061/i3geo/ferramentas/imprimir/Mapa_A3_uso_1986.php?";
        	$i_jameuge = $i_jameuge . "mapfile=C:/ms4w03/ms4w/Apache/htdocs/i3geo/aplicmap/Mapa_A3_uso_1986.map";
        	$i_jameuge = $i_jameuge . "&objectid=" . $objectid;
        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
        	
			redirect($i_jameuge);
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}



	
}