<?php

// Abstraer
defined('BASEPATH') OR exit('No direct script access allowed');

class Colonias extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();  
		

		$this->load->model('man_espacial/colonias/colonias_model');
		$this->lang->load('colonias/colonias');
		// inicializamos la librería
        $this->load->library('Classes/PHPExcel.php');

		/* Titulo de la pagina :: Common */ 
		$this->page_title->push(lang('menu_colonias'));
		$this->data['pagetitle'] = $this->page_title->show();
		if ($_SESSION['id_modulo'] != 'COLONIAS') {

			$_SESSION['arraywhere_colonias'] = NULL;
			$_SESSION['arraywhere_colonias_busq'] = NULL;
			$_SESSION['id_modulo'] = 'COLONIAS';
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_colonias'), 'admin/colonias');
	}




	public function index()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

             if ($_POST) {

				if ($_POST['dpto_cod']) 
				{
					$arraywhere['dpto_cod'] 					= $_POST['dpto_cod'];
					$arraywherebusq['dpto_cod like '] 			= '%'.$_POST['dpto_cod'].'%';
				}
				if ($_POST['dist_cod']) 
				{
					$arraywhere['dist_cod'] 					= $_POST['dist_cod'];
					$arraywherebusq['dist_cod like '] 			= '%'.$_POST['dist_cod'].'%';
				}
				if ($_POST['col_cod']) 
				{
					if (is_numeric($_POST['col_cod'])) {
						$arraywhere['col_cod'] 					= $_POST['col_cod'];
						$arraywherebusq['col_cod'] 				= $_POST['col_cod'];
					}
				}
				if ($_POST['col_desc']) 
				{
					$arraywhere['col_desc'] 					= $_POST['col_desc'];
					$arraywherebusq['lower(col_desc) like '] 	= '%'.strtolower($_POST['col_desc']).'%';
				}
				if ($_POST['col_codgeo']) 
				{
					$arraywhere['col_codgeo'] 					= $_POST['col_codgeo'];
					$arraywherebusq['col_codgeo like '] 		= '%'.$_POST['col_codgeo'].'%';
				}

				$_SESSION['arraywhere_colonias'] = $arraywhere;
				$_SESSION['arraywhere_colonias_busq'] = $arraywherebusq;

				redirect('man_espacial/colonias/Colonias/index');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				8, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/colonias/Colonias/index/',  // url completa de la pagina paginada
				'v_colonias_index',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_colonias_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['colonias']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'v_colonias_index',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_colonias_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/colonias/index', $this->data);
		}
	}

	public function indexusos()
	{
		//Abstraer con las vistas dinamicas. Jaime - Raquel
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}else{

             if ($_POST) {

				if ($_POST['uso']) 
				{
					$arraywhere['uso'] 					= $_POST['uso'];
					$arraywherebusq['lower(uso) like '] 			= '%'.strtolower($_POST['uso']).'%';
				}
				if ($_POST['nombre_uso']) 
				{
					$arraywhere['nombre_uso'] 					= $_POST['nombre_uso'];
					$arraywherebusq['lower(nombre_uso) like '] 			= '%'.strtolower($_POST['nombre_uso']).'%';
				}
				if ($_POST['r']) 
				{
					if (is_numeric($_POST['r'])) {
						$arraywhere['r'] 					= $_POST['r'];
						$arraywherebusq['cast(r as varchar) like '] 	= '%'.$_POST['r'].'%';
					}
				}
				if ($_POST['g']) 
				{
					if (is_numeric($_POST['g'])) {
						$arraywhere['g'] 					= $_POST['g'];
						$arraywherebusq['cast(g as varchar) like '] 	= '%'.$_POST['g'].'%';
					}
				}
				if ($_POST['b']) 
				{
					if (is_numeric($_POST['b'])) {
						$arraywhere['b'] 					= $_POST['b'];
						$arraywherebusq['cast(b as varchar) like '] 	= '%'.$_POST['b'].'%';
					}
				}

				$_SESSION['arraywhere_colonias'] = $arraywhere;
				$_SESSION['arraywhere_colonias_busq'] = $arraywherebusq;

				redirect('man_espacial/colonias/Colonias/indexusos');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				8, 						// resultados por por_pagina, 
				5, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'man_espacial/colonias/Colonias/indexusos/',  // url completa de la pagina paginada
				'usos',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_colonias_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['usos']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				5,								// segmento uri a leer
 				'usos',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_colonias_busq']
 				)->result();
			// ----- Fin paginacion

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs - Miga de pan */
			$this->data['breadcrumb'] 	= $this->breadcrumbs->show();

			/* Cargar plantilla predefinida */
			$this->template->admin_render('man_espacial/colonias/indexusos', $this->data);
		}
	}


	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_colonias'), 'colonias/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_cod' , 'lang:colonia_col_cod' , 'required|is_numeric|max_length[3]');
		$this->form_validation->set_rules('col_desc', 'lang:colonia_col_desc', 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$dptodistritocolonia = $_POST['dpto_distrito_colonia'];
			
			if ($_POST['dpto_cod']) {
				$arraycampos['dpto_cod']   			= $_POST['dpto_cod'];
			}

			if ($_POST['dist_cod']) {
				$arraycampos['dist_cod']   			= $_POST['dist_cod'];
			}

			if ($_POST['col_cod']) {
				$arraycampos['col_cod']   			= $_POST['col_cod'];
			}
			if ($_POST['col_codgeo']) {
				$arraycampos['col_codgeo']   			= $_POST['col_codgeo'];
			}			
			else {
				$arraycampos['col_codgeo']   			= $dptodistritocolonia;
			}
			if ($_POST['dist_matriz']) {

				$arraycampos['dist_matriz']			= $_POST['dist_matriz'];
			}

			if ($_POST['col_desc']) {
				$arraycampos['col_desc']   			= strtoupper($_POST['col_desc']);
			}

			if ($_POST['resolucion_hab']) {
				$arraycampos['resolucion_hab']   			= $_POST['resolucion_hab'];
			}

			if ($_POST['fecha_hab']) {
				$arraycampos['fecha_hab']   			= $_POST['fecha_hab'];
			}

			if ($_POST['fecha_inscripcion']) {
				$arraycampos['fecha_inscripcion']   			= $_POST['fecha_inscripcion'];
			}

			if ($_POST['antecedentes']) {
				$arraycampos['antecedentes']   			= trim($_POST['antecedentes']);
			}

			$new_colonia_id = $this->colonias_model->create_colonia($arraycampos);
			if ($new_colonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect('man_espacial/colonias/colonias');
			}
		}else{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod'),
				'maxlength' => 3
			);
			 
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
			);

			$this->data['resolucion_hab'] = array(
				'name'  => 'resolucion_hab',
				'id'    => 'resolucion_hab',
				'type'  => 'text',
				'class' => 'form-control',
			);

			$this->data['fecha_hab'] = array(
				'name'  => 'fecha_hab',
				'id'    => 'fecha_hab',
				'type'  => 'text',
				'class' => 'form-control',
			);

			$this->data['antecedentes'] = array(
				'type'  => 'text',
				'name'  => 'antecedentes',
				'id'    => 'antecedentes',
				'style' => 'width: 268px;height: 150px',
				'class' => 'form-control'
			);

			$this->data['fecha_inscripcion'] = array(
				'name'  => 'fecha_inscripcion',
				'id'    => 'fecha_inscripcion',
				'type'  => 'text',
				'class' => 'form-control',
			);

			$dptos[''] = 'Dpto. Distrito y Colonia';
			//$dpto_distrito = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
			$dpto_distrito = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($dpto_distrito as $dd) {
				$col_cod = str_pad($dd['col_cod'], 3, "0", STR_PAD_LEFT);
				$dpto_distritos[$dd['dpto'].$dd['distrito'].$col_cod] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'].' - Colonia.:('.$col_cod.') '.$dd['col_desc'];
			}
			$this->data['dpto_distrito_colonia'] = $dpto_distritos;
			//$this->data['dpto_distrito_colonia_sel'] = $geocolonia->dpto_cod.$geocolonia->dist_cod.$geocolonia->col_cod;

			$dptos[''] = 'Seleccione el departamento';
			$departamentos = $this->colonias_model->dropdown_data('departamentos')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($departamentos as $dpto) {
				$dptos[$dpto['dpto']] = $dpto['dpto'].' - '.$dpto['dpto_desc'];
			}
			$this->data['departamentos'] = $dptos;

			$distmtrs[''] = 'Seleccione el distrito matriz';
			$distritos = $this->colonias_model->dropdown_data('distritos')->result_array();
			
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($distritos as $distmtr) {
				$distmtrs[$distmtr['gid']] = 'Dpto: ('.$distmtr['dpto'].') '. $distmtr['dpto_desc'] . ' - Distrito: ('.$distmtr['distrito'].') '. $distmtr['dist_desc'];
			}
			$this->data['dist_matriz'] = $distmtrs;
			
			/* Load Template */
			$this->template->admin_render('man_espacial/colonias/create', $this->data);
		}
	}






	public function edit($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_colonias_edit'), 'colonias/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$colonia = $this->colonias_model->view('colonias', array('gid' => $gid))->row();
		//$colonia = $this->colonias_model->view('geocolonias', array('' => ))->row();

		/* Validate form input */
		//$this->form_validation->set_rules('col_cod', $this->lang->line('edit_colonia_validation_name_label'), 'required|is_numeric|max_length[3]');
		
		$this->form_validation->set_rules('col_desc', $this->lang->line('edit_colonia_validation_name_label'), 'required');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$dptodistrito = $_POST['dpto_cod_distrito'];
				$dpto = substr($dptodistrito, 0, 2);
				$dist = substr($dptodistrito, 2, 2);

				if ($_POST['dpto_cod']) {
					$arraycampos['dpto_cod']			= $_POST['dpto_cod'];
				}

				if ($_POST['dist_cod']) {
					$arraycampos['dist_cod']			= $_POST['dist_cod'];
				}

				if ($_POST['dpto_distrito_colonia']) {
					$arraycampos['col_codgeo'] 			= $_POST['dpto_distrito_colonia'];
				}

				if ($_POST['dist_matriz']) {
					$arraycampos['dist_matriz']			= $_POST['dist_matriz'];
				}

				if ($_POST['col_desc']) {
					$arraycampos['col_desc']			= strtoupper($_POST['col_desc']);
				}

				if ($_POST['resolucion_hab']) {
					$arraycampos['resolucion_hab']		= $_POST['resolucion_hab'];
				}else{
					$arraycampos['resolucion_hab']		= '';
				}

				if ($_POST['fecha_hab']) {
					$arraycampos['fecha_hab']			= $_POST['fecha_hab'];
				}else{
					$arraycampos['fecha_hab']			= NULL;
				}

				if ($_POST['fecha_inscripcion']) {
					$arraycampos['fecha_inscripcion']	= $_POST['fecha_inscripcion'];
				}else{
					$arraycampos['fecha_inscripcion']	= NULL;
				}

				if ($_POST['antecedentes']) {
					$arraycampos['antecedentes']		= trim($_POST['antecedentes']);
				}else{
					$arraycampos['antecedentes']		= '';
				}

				if ($_POST['fecha_inscripcion']) {
					$arraycampos['fecha_inscripcion']	= $_POST['fecha_inscripcion'];
				}else{
					$arraycampos['fecha_inscripcion']	= NULL;
				}

				if ($_POST['fecha_deslinde']) {
					$arraycampos['fecha_deslinde']		= $_POST['fecha_deslinde'];
				}else{
					$arraycampos['fecha_deslinde']		= NULL;
				}

				$colonia_update = $this->colonias_model->update_colonia($gid,$arraycampos);

				if ($colonia_update)
				{

					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_colonia_saved') por $_POST('id') por ejemplo
					$this->session->set_flashdata('message', $this->lang->line('colonia_update_successful'));
					redirect('man_espacial/colonias/colonias/edit/'.$gid); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/colonias/colonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['colonia']   = $colonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->col_desc ? 'readonly' : '';
		
		//creando campos
		$this->data['col_cod'] = array(
			'type'     => 'text',
			'name'     => 'col_cod',
			'id'       => 'col_cod',
			'value'    => $this->form_validation->set_value('colonia_col_cod', $colonia->col_cod),
			'data-src' => $colonia->col_cod,
			'class'    => 'form-control',
			'disabled'    => true
		);
		 
		$this->data['col_desc'] = array(
			'type'     => 'text',
			'name'     => 'col_desc',
			'id'       => 'col_desc',
			'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->col_desc),
			'data-src' => $colonia->col_desc,
			'class'    => 'form-control'
		);

		$this->data['resolucion_hab'] = array(
			'name'  => 'resolucion_hab',
			'id'    => 'resolucion_hab',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('colonia_resolucion_hab', $colonia->resolucion_hab),
			'class' => 'form-control',
		);

		$this->data['fecha_hab'] = array(
			'name'  => 'fecha_hab',
			'id'    => 'fecha_hab',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('colonia_fecha_hab', $colonia->fecha_hab),
			'class' => 'form-control',
		);

		$this->data['antecedentes'] = array(
			'type'  => 'text',
			'name'  => 'antecedentes',
			'id'    => 'antecedentes',
			'style' => 'width: 268px;height: 150px',
			'value'    => $this->form_validation->set_value('colonia_antecedentes', $colonia->antecedentes),
			'class' => 'form-control'
		);

		$this->data['fecha_inscripcion'] = array(
			'name'  => 'fecha_inscripcion',
			'id'    => 'fecha_inscripcion',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('colonia_fecha_inscripcion', $colonia->fecha_inscripcion),
			'class' => 'form-control',
		);

		$this->data['fecha_deslinde'] = array(
			'name'  => 'fecha_deslinde',
			'id'    => 'fecha_deslinde',
			'type'  => 'text',
			'value'    => $this->form_validation->set_value('colonia_fecha_deslinde', $colonia->fecha_deslinde),
			'class' => 'form-control',
		);

		/*$dptos[''] = 'Dpto. Distrito y Colonia';
		$dpto_distrito = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dpto_distrito as $dd) {
			$dpto_distritos[$dd['dpto'].$dd['distrito']] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'];
		}
		$this->data['dpto_distrito'] = $dpto_distritos;
		$this->data['dpto_distrito_sel'] = $colonia->dpto_cod.$colonia->dist_cod;

		$dptodistritocolonias[''] = 'Dpto. Distrito y Colonia';
		$dptodistritocolonia = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dptodistritocolonia as $dd) {
			$col_cod = str_pad($dd['col_cod'], 3, "0", STR_PAD_LEFT);
			$dptodistritocolonias[$dd['dpto'].$dd['distrito'].$col_cod] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'].' - Colonia.:('.$col_cod.') '.$dd['col_desc'];
		}
		$this->data['dpto_distrito_colonia'] = $dptodistritocolonias;
		$this->data['dpto_distrito_colonia_sel'] = $colonia->col_codgeo;
		//$this->data['dpto_distrito_colonia_sel'] = $colonia->dpto_cod.$colonia->dist_cod.str_pad($colonia->col_cod, 3, "0", STR_PAD_LEFT);

		$dptos[''] = 'Seleccione el departamento';
		$departamentos = $this->colonias_model->dropdown_data('departamentos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($departamentos as $dpto) {
			$dptos[$dpto['dpto']] = $dpto['dpto'].' - '.$dpto['dpto_desc'];
		}
		$this->data['departamentos']     = $dptos;
		$this->data['departamentos_sel'] = $colonia->dpto_cod;*/

		$dptos[''] = 'Seleccione el departamento';
		$dpto = $this->colonias_model->dropdown_data('departamentos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dpto as $dp) {
			$dptos[$dp['dpto']] = $dp['dpto'] . ' - ' . $dp['dpto_desc'];
		}
		$this->data['dpto'] = $dptos;
		$this->data['dpto_sel'] = $colonia->dpto_cod;

		$distritos = $this->colonias_model->dropdown_data('distritos',array('dpto' => $colonia->dpto_cod, 'distrito' => $colonia->dist_cod), 'distrito')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distritos as $dist) {
			$dists[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
		}
		if (isset($dists)) {
			$this->data['distritos'] = $dists;
		}else{
			$this->data['distritos'] = NULL;
		}
		$this->data['distritos_sel'] = $colonia->dist_cod;

		$dptodistritocolonias[''] = 'Dpto. Distrito y Colonia';
		//$dptodistritocolonia = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		$dptodistritocolonia = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dptodistritocolonia as $dd) {
			$col_cod = str_pad($dd['col_cod'], 3, "0", STR_PAD_LEFT);
			$dptodistritocolonias[$dd['dpto'].$dd['distrito'].$col_cod] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'].' - Colonia.:('.$col_cod.') '.$dd['col_desc'];
		}
		$this->data['dpto_distrito_colonia'] = $dptodistritocolonias;
		$this->data['dpto_distrito_colonia_sel'] = $colonia->col_codgeo;

		$distmtrs[''] = 'Seleccione el distrito matriz';
		$distritos = $this->colonias_model->dropdown_data('distritos')->result_array();	
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distritos as $distmtr) {
			$distmtrs[$distmtr['gid']] = 'Dpto: ('.$distmtr['dpto'].') '. $distmtr['dpto_desc'] . ' - Distrito: ('.$distmtr['distrito'].') '. $distmtr['dist_desc'];
		}
		$this->data['dist_matriz'] = $distmtrs;
		$this->data['dist_matriz_sel'] = $colonia->dist_matriz;

		/* Load Template */
		$this->template->admin_render('man_espacial/colonias/edit', $this->data);
	}



	public function ver($gid)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $gid OR empty($gid))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_colonias_ver'), 'colonias/ver');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Variables *///Trae de la base de datos la fila seleccionada
		$colonia = $this->colonias_model->view('colonias', array('gid' => $gid))->row();
		//$colonia = $this->colonias_model->view('geocolonias', array('' => ))->row();

		/* Validate form input */
		//$this->form_validation->set_rules('col_cod', $this->lang->line('edit_colonia_validation_name_label'), 'required|is_numeric|max_length[3]');
		
		$this->form_validation->set_rules('col_desc', $this->lang->line('edit_colonia_validation_name_label'), 'required');

		//Se produce cuando el usuario da click en el submit
		if (isset($_POST) && ! empty($_POST))
		{
			if ($this->form_validation->run() == TRUE)
			{
				$dptodistrito = $_POST['dpto_cod_distrito'];
				$dpto = substr($dptodistrito, 0, 2);
				$dist = substr($dptodistrito, 2, 2);

				if ($_POST['dpto_distrito_colonia']) {
					$arraycampos['col_codgeo'] 			= $_POST['dpto_distrito_colonia'];
				}

				if ($_POST['col_desc']) {
					$arraycampos['col_desc']			= strtoupper($_POST['col_desc']);
				}

				if ($_POST['resolucion_hab']) {
					$arraycampos['resolucion_hab']		= $_POST['resolucion_hab'];
				}

				if ($_POST['fecha_hab']) {
					$arraycampos['fecha_hab']			= $_POST['fecha_hab'];
				}

				if ($_POST['fecha_inscripcion']) {
					$arraycampos['fecha_inscripcion']			= $_POST['fecha_inscripcion'];
				}

				if ($_POST['antecedentes']) {
					$arraycampos['antecedentes']		= trim($_POST['antecedentes']);
				}

				if ($_POST['fecha_inscripcion']) {
					$arraycampos['fecha_inscripcion']	= $_POST['fecha_inscripcion'];
				}

				$colonia_update = $this->colonias_model->update_colonia($gid,$arraycampos);

				if ($colonia_update)
				{

					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_colonia_saved') por $_POST('id') por ejemplo
					$this->session->set_flashdata('message', $this->lang->line('colonia_update_successful'));
					redirect('man_espacial/colonias/colonias/ver/'.$gid); //VER OTRA MANERA DE ACTUALIZAR LA PAGINA, YA QUE AL REFRESCAR SOLO VUELVE A TOMAR LOS VALORES DE DPTO, DISTRITO Y COLONIA
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/colonias/colonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		$this->data['colonia']   = $colonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $colonia->col_desc ? 'readonly' : '';
		
		//creando campos
		$this->data['dpto'] = $colonia->dpto_cod;
		$this->data['dist'] = $colonia->dist_cod;
		$this->data['colonia'] = $colonia->col_cod;
		$this->data['gid'] = $colonia->col_cod;

/*
		$this->data['dpto'] = array(
			'type'     => 'text',
			'name'     => 'dpto',
			'id'       => 'dpto',
			'value'    => $this->form_validation->set_value('colonia_dpto', $colonia->dpto_cod),
			'data-src' => $colonia->dpto_cod,
			'class'    => 'form-control',
			'disabled'    => true
		);
		$this->data['dist'] = array(
			'type'     => 'text',
			'name'     => 'dist',
			'id'       => 'dist',
			'value'    => $this->form_validation->set_value('colonia_dist', $colonia->dist_cod),
			'data-src' => $colonia->dist_cod,
			'class'    => 'form-control',
			'disabled'    => true
		);
*/


		$this->data['col_cod'] = array(
			'type'     => 'text',
			'name'     => 'col_cod',
			'id'       => 'col_cod',
			'value'    => $this->form_validation->set_value('colonia_col_cod', $colonia->col_cod),
			'data-src' => $colonia->col_cod,
			'class'    => 'form-control',
			'disabled'    => true
		);
		 
		$this->data['col_desc'] = array(
			'type'     => 'text',
			'name'     => 'col_desc',
			'id'       => 'col_desc',
			'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->col_desc),
			'data-src' => $colonia->col_desc,
			'class'    => 'form-control',
			'disabled'    => true
		);

		$this->data['resolucion_hab'] = array(
				'name'  => 'resolucion_hab',
				'id'    => 'resolucion_hab',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->resolucion_hab),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['fecha_hab'] = array(
				'name'  => 'fecha_hab',
				'id'    => 'fecha_hab',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->fecha_hab),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['antecedentes'] = array(
				'type'  => 'text',
				'name'  => 'antecedentes',
				'id'    => 'antecedentes',
				'style' => 'width: 268px;height: 150px',
				'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->antecedentes),
				'class' => 'form-control',
				'disabled'    => true
			);

			$this->data['fecha_inscripcion'] = array(
				'name'  => 'fecha_inscripcion',
				'id'    => 'fecha_inscripcion',
				'type'  => 'text',
				'value'    => $this->form_validation->set_value('colonia_col_desc', $colonia->fecha_inscripcion),
				'class' => 'form-control',
				'disabled'    => true
			);

		$dptos[''] = 'Dpto. Distrito y Colonia';
		//$dpto_distrito = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		$dpto_distrito = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dpto_distrito as $dd) {
			$dpto_distritos[$dd['dpto'].$dd['distrito']] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'];
		}
		$this->data['dpto_distrito'] = $dpto_distritos;
		$this->data['dpto_distrito_sel'] = $colonia->dpto_cod.$colonia->dist_cod;

		$dptodistritocolonias[''] = 'Dpto. Distrito y Colonia';
		//$dptodistritocolonia = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia')->result_array();
		$dptodistritocolonia = $this->colonias_model->dropdown_data('v_dpto_distrito_colonia_pk')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dptodistritocolonia as $dd) {
			$col_cod = str_pad($dd['col_cod'], 3, "0", STR_PAD_LEFT);
			$dptodistritocolonias[$dd['dpto'].$dd['distrito'].$col_cod] = 'Dpto.: ('.$dd['dpto'].') '.$dd['dpto_desc'].' - Dist.:('.$dd['distrito'].') '.$dd['dist_desc'].' - Colonia.:('.$col_cod.') '.$dd['col_desc'];
		}
		$this->data['dpto_distrito_colonia'] = $dptodistritocolonias;
		$this->data['dpto_distrito_colonia_sel'] = $colonia->col_codgeo;
		//$this->data['dpto_distrito_colonia_sel'] = $colonia->dpto_cod.$colonia->dist_cod.str_pad($colonia->col_cod, 3, "0", STR_PAD_LEFT);

		$dptos[''] = 'Seleccione el departamento';
		$departamentos = $this->colonias_model->dropdown_data('departamentos')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($departamentos as $dpto) {
			$dptos[$dpto['dpto']] = $dpto['dpto'].' - '.$dpto['dpto_desc'];
		}
		$this->data['departamentos']     = $dptos;
		$this->data['departamentos_sel'] = $colonia->dpto_cod;

		/* Load Template */
		$this->template->admin_render('man_espacial/colonias/ver', $this->data);
	}

	/**
	 * 
	 * setExcel
	 */
	public function setExcel () {
	     
	    // configuramos las propiedades del documento
	    $this->phpexcel->getProperties()->setCreator("Arkos Noem Arenom")
	                                 ->setLastModifiedBy("Arkos Noem Arenom")
	                                 ->setTitle("Office 2007 XLSX Test Document")
	                                 ->setSubject("Office 2007 XLSX Test Document")
	                                 ->setDescription("Test document for Office 2007 XLSX, generated using PHP classes.")
	                                 ->setKeywords("office 2007 openxml php")
	                                 ->setCategory("Test result file");
	     
	     
	    // agregamos información a las celdas
	    $this->phpexcel->setActiveSheetIndex(0)
	                ->setCellValue('A5', 'N°')
	                ->setCellValue('B5', 'N° DE TITULO')
	                ->setCellValue('C5', 'MANZANA INDERT')
	                ->setCellValue('D5', 'MANZANA INDERT')
	                ->setCellValue('E5', 'LOTE INDERT')
	                ->setCellValue('F5', 'LOTE SIRT')
	                ->setCellValue('G5', 'NOMBRE DEL BENEFICIARIO')
	                ->setCellValue('H5', 'N° DE C.I. DEL BENEFICIARIO')
	                ->setCellValue('I5', 'NOMBRE DEL OCUPANTE ACTUAL')
	                ->setCellValue('J5', 'N° DE C.I. DEL OCUPANTE ACTUAL')
	                ->setCellValue('K5', 'SUPERFICIE (HAS)')
	                ->setCellValue('L5', 'SITUACION CON RESPECTO AL LOTE')
	                ->setCellValue('M5', 'HACE CUANTO OCUPA EL LOTE')
	                ->setCellValue('N5', 'CONDICION DE LA VIVIENDA')
	                ->setCellValue('O5', 'EXPEDIENTE N°')
	                ->setCellValue('P5', 'AÑO')
	                ->setCellValue('Q5', 'NOMBRE DEL SOLICITANTE SEGÚN EXPEDIENTE')
	                ->setCellValue('R5', 'OTROS DOCUMENTOS')
	                ->setCellValue('S5', 'OBSERVACIONES');

	    $styleArray = array(
							'borders' => array('allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN,
																  'color' => array('argb' => '343b36'),
																  ),
											   ),
							);
		$this->phpexcel->getActiveSheet()->getStyle('A5:S5')->applyFromArray($styleArray);
		$this->phpexcel->getActiveSheet()->getStyle('A5:S5')->getAlignment()->setWrapText(true);	                
	    $this->phpexcel->getActiveSheet()->getStyle('A5:S5')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('d2d2d2');
	     
	    // La librería puede manejar la codificación de caracteres UTF-8
	    for ($i=0; $i < 5; $i++) { 
	    	if ($i > 1) {
	    		$this->phpexcel->setActiveSheetIndex(0)
	                ->setCellValue('A'.$i, 'A')
	                ->setCellValue('B'.$i, 'B')->getStyle('A8')->getAlignment()->setWrapText(true);;
	    	}
	        
	    }
	    //$this->phpexcel->setActiveSheetIndex(0)
	     //           ->setCellValue('A4', 'Miscellaneous glyphs')
	     //           ->setCellValue('A5', 'éàèùâêîôûëïüÿäöüç');
	     
	    // Renombramos la hoja de trabajo
	    $this->phpexcel->getActiveSheet()->setTitle('Simple');
	     
	     
	    // configuramos el documento para que la hoja
	    // de trabajo número 0 sera la primera en mostrarse
	    // al abrir el documento
	    $this->phpexcel->setActiveSheetIndex(0);
	     
	     
	    // redireccionamos la salida al navegador del cliente (Excel2007)
	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment;filename="01simple.xlsx"');
	    header('Cache-Control: max-age=0');
	     
	    $objWriter = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
	    $objWriter->save('php://output');
	     
	}
	// end: setExcel	



	/**
	 * generar_excel_pericia
	 *	Genera un documento excel a partir de los datos obtenidos de la pericias de las parcelas
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function generar_excel_pericia ($dpto, $distrito, $colonia) {

		$col = $this->colonias_model->dropdown_data('colonias', array('dpto_cod' => $dpto, 'dist_cod' => $distrito, 'col_cod' => $colonia))->row();
		$datos_pericia = $this->colonias_model->obtener_pericia('in_planopericia1', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result();
		if ($datos_pericia == FALSE) {
			$this->session->set_flashdata('message', 'NO HAY DATOS SOBRE LA COLONIA <b>'.$col->col_desc.'</b>');
			redirect('man_espacial/colonias/colonias/index/');
		}

		//GENERA ENCABEZADO
		$columnas = $this->colonias_model->dropdown_data('columnas_tabla', array('table_schema' => 'indert', 
																				 'table_name' => 'in_planopericia1'
																				)
														)->result();
		//$ic = 65;
		//$i1 = 1;
		$f = 1;
		$c = 0;
	    foreach ($columnas as $value) 
	    {
	    	//$cell = chr($ic).$i1;
	    	//show_error($cell);
	    	//$this->phpexcel->setActiveSheetIndex(0)->setCellValue(, $value->column_name);
	    	$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow($c, $f)->setValue($value->column_name);

	    	//$i1 = $i1 + 1;
	    	//$ic = $ic + 1;
	    	//$f = $ic + 1;
	    	$c = $c + 1;
	    }

	    $f = 2;
		$c = $c;
		//$i = 1;

		foreach ($datos_pericia as $value) {

			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(0, $f)->setValue($value->objectid);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(1, $f)->setValue($value->dpto);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(2, $f)->setValue($value->dpto_desc);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(3, $f)->setValue($value->distrito);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(4, $f)->setValue($value->dist_desc);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(5, $f)->setValue($value->colonia);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(6, $f)->setValue($value->col_desc);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(7, $f)->setValue($value->mz_agr);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(8, $f)->setValue($value->lote_agr);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(9, $f)->setValue($value->num_p1);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(10, $f)->setValue($value->num_p2);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(11, $f)->setValue($value->lado);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(12, $f)->setValue($value->p1x);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(13, $f)->setValue($value->p1y);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(14, $f)->setValue($value->p2x);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(15, $f)->setValue($value->p2y);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(16, $f)->setValue($value->angulo);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(17, $f)->setValue($value->angulo2);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(18, $f)->setValue($value->azimut);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(19, $f)->setValue($value->azimut_r);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(20, $f)->setValue($value->azimut_t);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(21, $f)->setValue($value->azimutseg);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(22, $f)->setValue($value->azimutseg_r);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(23, $f)->setValue($value->azimutseg_t);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(24, $f)->setValue($value->distancia);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(25, $f)->setValue($value->grados);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(26, $f)->setValue($value->minutos);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(27, $f)->setValue($value->segundos);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(28, $f)->setValue($value->rumbo1);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(29, $f)->setValue($value->rumbo2);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(30, $f)->setValue($value->rumbo3);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(31, $f)->setValue($value->cardinalidad);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(32, $f)->setValue($value->rumbo_fmt);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(33, $f)->setValue($value->lindero);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(34, $f)->setValue($value->sup_sig_ha);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(35, $f)->setValue($value->sup_sig_m2);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(36, $f)->setValue($value->num_aj);
			$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow(37, $f)->setValue($value->num_aj2);

			$f = $f + 1;
		}

		$styleArray = array(
							'borders' => array('allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN,
																  'color' => array('argb' => '343b36'),
																  ),
											   ),
							);
		$this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->applyFromArray($styleArray);
		$this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->getAlignment()->setWrapText(true);	                
	    $this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('d2d2d2');
	    
	    // Renombramos la hoja de trabajo
	    $this->phpexcel->getActiveSheet()->setTitle('Pericias');
	     
	     
	    // configuramos el documento para que la hoja
	    // de trabajo número 0 sera la primera en mostrarse
	    // al abrir el documento
	    $this->phpexcel->setActiveSheetIndex(0);
	     
	     
	    // redireccionamos la salida al navegador del cliente (Excel2007)
	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment;filename="pericia_'.$dpto.'_'.$distrito.'_'.$colonia.'.xlsx"');
	    header('Cache-Control: max-age=0');
	     
	    $objWriter = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
	    $objWriter->save('php://output');
	    
	}


	/**
	 * generar_excel_pericia_res
	 *	Genera un documento excel a partir de los datos obtenidos de la pericias de las parcelas
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function generar_excel_pericia_res ($dpto, $distrito, $colonia) {

		$col = $this->colonias_model->dropdown_data('colonias', array('dpto_cod' => $dpto, 'dist_cod' => $distrito, 'col_cod' => $colonia))->row();
		$datos_pericia = $this->colonias_model->obtener_pericia('v_in_planopericia2', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result_array();
		if ($datos_pericia == FALSE) {
			$this->session->set_flashdata('message', 'NO HAY DATOS SOBRE LA COLONIA <b>'.$col->col_desc.'</b>');
			redirect('man_espacial/colonias/colonias/index/');
		}

		//GENERA ENCABEZADO
		$columnas = $this->colonias_model->dropdown_data('columnas_tabla', array('table_schema' => 'indert', 
																				 'table_name' => 'v_in_planopericia2'
																				)
														)->result();
		//$ic = 65;
		//$i1 = 1;
		$f = 1;
		$c = 0;
	    foreach ($columnas as $value) 
	    {
	    	$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow($c, $f)->setValue($value->column_name);
	    	$c = $c + 1;
	    }

	    $f = 2;
		$c = $c;

		foreach ($datos_pericia as $value) {
			$c = 0;
			/*
			print_r($value);
			show_error(1);
			*/
	    	foreach ($columnas as $columns) 
	    	{
	    		
				$this->phpexcel->setActiveSheetIndex(0)->getCellByColumnAndRow($c, $f)->setValue($value[$columns->column_name]);
	    		
	    		$c = $c + 1;
	    	}


			$f = $f + 1;
		}

		$styleArray = array(
							'borders' => array('allborders' => array('style' => PHPExcel_Style_Border::BORDER_THIN,
																  'color' => array('argb' => '343b36'),
																  ),
											   ),
							);
		$this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->applyFromArray($styleArray);
		$this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->getAlignment()->setWrapText(true);	                
	    $this->phpexcel->getActiveSheet()->getStyle('A1:AL1')->getFill()->setFillType(PHPExcel_Style_Fill::FILL_SOLID)->getStartColor()->setARGB('d2d2d2');
	    
	    // Renombramos la hoja de trabajo
	    $this->phpexcel->getActiveSheet()->setTitle('Pericias');     
	     
	    // configuramos el documento para que la hoja
	    // de trabajo número 0 sera la primera en mostrarse
	    // al abrir el documento
	    $this->phpexcel->setActiveSheetIndex(0);	     
	     
	    // redireccionamos la salida al navegador del cliente (Excel2007)
	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment;filename="pericia_'.$dpto.'_'.$distrito.'_'.$colonia.'.xlsx"');
	    header('Cache-Control: max-age=0');
	     
	    $objWriter = PHPExcel_IOFactory::createWriter($this->phpexcel, 'Excel2007');
	    $objWriter->save('php://output');	    
	}




	/**
	 * generar_excel_pericia_resum
	 *	Genera un documento excel a partir de los datos obtenidos de la pericias de las parcelas
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function generar_excel_pericia_resum ($dpto, $distrito, $colonia) {
		
		$i = 0;
		$parcelas = $this->colonias_model->view('in_temp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result();

		foreach ($parcelas as $prc) {
			$i=$i+1;
			$this->colonias_model->generar_pericia($prc->objectid);
			//echo $prc->objectid;

			//$this->session->set_flashdata('message', 'NO HAY DATOS SOBRE LA COLONIA <b>'.$prc->objectid)."i:".$i;
			//redirect('man_espacial/colonias/colonias/index/');

		}
		return true;


		if ($i != 0) {
			//$this->session->set_flashdata('message', 'NO HAY DATOS SOBRE LA COLONIA <b>'.$colonia);
			$this->session->set_flashdata('message', 'NO HAY DATOS SOBRE LA COLONIA '.$prc->objectid)."i:".$i;
			redirect('man_espacial/colonias/colonias/index/');
		}
	  
	}



	public function trae_distritos()
	{
		//$dpto 	   = $_POST['dpto_cod'];
		$_GET = array_merge($_GET,$_POST);
  		$dpto = $_GET["dpto_cod"];

		$distritos = $this->colonias_model->dropdown_data('distritos',array('dpto' => $dpto), 'distrito')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->distrito . '">' . $value->distrito . ' - ' . $value->dist_desc . '</option>';
		}

		//echo json_encode($distritos);
	}


	/**
	 * generar_excel_pericia_resum
	 *	Genera un documento excel a partir de los datos obtenidos de la pericias de las parcelas
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function obtener_parcelas_sinpericias ($dpto, $distrito, $colonia) {
		
		//$dpto=$_POST['dpto'];
		//$distrito=$_POST['distrito'];
		//$colonia=$_POST['colonia'];
		$resultado = $this->colonias_model->eliminar_basura();
		$parcelas['data'] = $this->colonias_model->obtener_parcelas_sinpericias($dpto, $distrito, $colonia)->result_array();
		$parcelas['cantidad'] = $this->colonias_model->contador_registros('v_pericias_lados', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		$parcelas['cantper'] = $this->colonias_model->contador_registros('in_planopericia1', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}


	/**
	 * obtener_parcelas ($dpto, $distrito, $colonia)
	 * Obtiene las parcelas de in_temp que su pericia no haya sido generada o 
	 * que su pericia sea incongruete con la geometria actual para que sean
	 * obligatoriamente sean nuevamente generadas.
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function obtener_parcelas ($dpto, $distrito, $colonia) {
		
		//$dpto=$_POST['dpto'];
		//$distrito=$_POST['distrito'];
		//$colonia=$_POST['colonia'];
		$parcelas['data'] = $this->colonias_model->obtener_parcelas('v_in_temp_gp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result_array();
		$parcelas['cantidad'] = $this->colonias_model->contador_registros('v_in_temp_gp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		$parcelas['cantper'] = $this->colonias_model->contador_registros('v_in_planopericia1_cnt', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}




	/**
	 * contar_pericia_completa()
	 * contar_pericia_completa()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function contar_pericia_completa () {
		
		$dpto=$_POST['dpto'];
		$distrito=$_POST['distrito'];
		$colonia=$_POST['colonia'];
		$parcelas['cantidad'] = $this->colonias_model->contador_registros('in_temp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));
		echo json_encode($parcelas);

	}


	/**
	 * generar_pericia_completa()
	  *generar_pericia_completa()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function generar_pericia_completa ($dpto, $distrito, $colonia, $gid) {
		$resultado=$this->colonias_model->md_generar_pericia_completa($dpto, $distrito, $colonia);
		if ($resultado) {
			$this->session->set_flashdata('message', 'Pericia generada correctamente!');
			redirect('man_espacial/colonias/colonias/ver/'.$gid);
		}		
		else {
			$this->session->set_flashdata('message', 'Pericia NO generada!');
		}	
	}


	/**
	 * generar_pericia_completa_1_a_1()
	 * generar_pericia_completa_1_a_1()
	 * @return bool
	 * @author Jaime Rojas 
	 **/
	public function generar_pericia_completa_1_a_1 ($dpto, $distrito, $colonia, $gid) {
		$i = 0;
		$parcelas = $this->colonias_model->view('in_temp', array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia))->result();
		foreach ($parcelas as $prc) {
			$i=$i+1;
			$this->colonias_model->generar_pericia($prc->objectid);
			//echo $prc->objectid;
			//$this->session->set_flashdata('message', 'Genero la parcela '.$prc->objectid);
		}
		if ($i == 0) {			
			$this->session->set_flashdata('message', 'La generacion de Pericias NO SE REALIZO!');			
		}
		else {
			$this->session->set_flashdata('message', 'La generacion de pericias se REALIZO! <b>');
			redirect('man_espacial/colonias/colonias/ver/'.$gid);		
		}	
	}


	/**
	* generar_colonia_lineas()
	* generar_colonia_lineas()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_colonia_lineas()
	{	

		// Si se usa mas de una vez el $_POST es necesario asignar sus valores a variables
		$tabla = $_POST['tabla']; 
        $dpto = $_POST['dpto'];
        $distrito = $_POST['distrito'];
        $colonia = $_POST['colonia'];
        
		$existe_colonia = $this->colonias_model->contador_registros($tabla, array('dpto' => $dpto, 'distrito' => $distrito, 'colonia' => $colonia));

		if ($existe_colonia == 0) {
			echo 'NO';
		}else{
			$resultado = $this->colonias_model->md_generar_lineas($dpto, $distrito, $colonia);
			if ($resultado == TRUE) {
				echo 'SI';
			}else{
				echo 'NO';
			}											
		}
	}


	/**
	* existe_colonia()
	* existe_colonia()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function existe_colonia()
	{
		$existe_colonia = $this->colonias_model->contador_registros($_POST['tabla'], array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
		
		if ($existe_colonia > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	/**
	* generar_periciasimple ($objectid) 
	* generar_periciasimple ($objectid) 
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_periciasimple ($objectid) {
		
		//$objectid	= $_POST['objectid'];
		$pericia = $this->colonias_model->generar_periciasimple($objectid);
		if ($pericia == TRUE) {
			return true;
		}else{
			return false;
		}
	}

	/**
	* generar_periciaresumido ($objectid)
	* generar_periciaresumido ($objectid)
	* @return bool
	* @author Jaime Rojas 
	**/
	public function generar_periciaresumido ($objectid) {
		
		//$objectid	= $_POST['objectid'];
		$pericia = $this->colonias_model->generar_periciaresumido($objectid);
		if ($pericia == TRUE) {
			return true;
		}else{
			return false;
		}
	}

	/**
	* eliminar_parcelas()
	* eliminar_parcelas()
	* @return bool
	* @author Jaime Rojas 
	**/
	public function eliminar_parcelas()
	{	
		$existen_parcelas = $this->colonias_model->contador_registros('in_temp',array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
		
		if ($existen_parcelas == 0) {
			echo 'SI';
		}else{
			$eliminar_parcelas = $this->colonias_model->eliminar_parcelas('in_temp',array('dpto' => $_POST['dpto'], 'distrito' => $_POST['distrito'], 'colonia' => $_POST['colonia']));
			echo 'BORRADA';
		}
	}


	/**
	* eliminar_pericia($objectid)
	* eliminar_pericia($objectid)
	* @return bool
	* @author Jaime Rojas 
	**/
	public function eliminar_pericia($objectid)
	{	

		$resultado = $this->colonias_model->eliminar_pericia($objectid);
		if ($resultado == TRUE) {
			return true;
		}else{
			return false;
		}
	}

	/**
	* delete()
	**/
	public function delete()
	{
		if ( ! $this->ion_auth->logged_in())
		{
			redirect('auth/login', 'refresh');
		}
		elseif ( ! $this->ion_auth->is_admin())
		{
			return show_error('You must be an administrator to view this page.');
		}
		else
		{
			$this->load->view('colonias/delete');
		}
	}

	public function vercolonia ($gid) {

/*
        echo '<pre>';
        print_r( $gid );
        echo '</pre>';
        show_error(1); 
*/

        	$i_jameuge = $_SESSION['url_mapserver2']."/sirtvisor/index.html?tipo_consulta=colonia_gid";
        	$i_jameuge = $i_jameuge . "&gid=" . $gid;
        	$i_jameuge = $i_jameuge . "&ip_host=".substr($_SESSION['url_mapserver2'],7,strpos($_SESSION['url_mapserver2'], ":",7)-7);	
			redirect($i_jameuge);
	}




	
}