<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
    ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo 'Expediente '.$codigo_unico['value']; ?></h1>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <?php
                if ($message) {
                    echo '<pre>';
                    echo '<h4><b>Mensaje:</b></h4>';
                    echo '<h5>' . $message . '</h5>';
                    echo '</pre>';
                }
                ?>
        </div>
        <?php require 'info_expe.php' ?>
        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-seg-dao', 'name' => 'formSegDAO'));?>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Seguimiento a la notificación de avalúo del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-7" for="dao_fecha_recepcion_notificacion_avaluo">Fecha de recepción para notificación:</label>
                                <div class="col-sm-5">
                                    <?php if ($habilitado['op']) : ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($dao_fecha_recepcion_notificacion_avaluo);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($dao_fecha_recepcion_notificacion_avaluo);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <br>
                            <div class="form-group">
                                <label class="control-label col-sm-7" for="dao_eleccion_escogida">Elección del afectado:</label>
                                <div class="col-sm-5">
                                    <?php $habilitado['op'] ? $attribute = 'class="form-control selectpicker" data-live-search="true" title="Elección del afectado" id="dao_eleccion_escogida"' : $attribute = 'class="form-control selectpicker" disabled="disabled" data-live-search="true" title="Eleccion escogida" id="dao_eleccion_escogida"';
                                        echo form_dropdown('dao_eleccion_escogida', $dao_eleccion_escogida, $dao_eleccion_escogida_sel, $attribute); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="dao_notificacion2">Fecha de notificación de avalúo:</label>
                                <div class="col-sm-5">
                                    <?php if ($habilitado['op']) : ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($dao_notificacion2);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($dao_notificacion2);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <?php if (isset($tiempo_restante)) : ?>
                            <div class="form-group">
                                <div class="col-sm-12">
                                    <?php if ($tiempo_restante > 0) : ?>
                                    <span><?php echo 'Faltan '.$tiempo_restante.' dias para el vencimiento de la conformidad.'?></span>
                                    <?php endif ?>
                                    <?php if ($tiempo_restante == 0) : ?>
                                    <span>Hoy vence el plazo de la fecha de firma de conformidad.</span>
                                    <?php endif ?>
                                    <?php if ($tiempo_restante == -1) : ?>
                                    <span>Ha vencido el plazo de la fecha de conformidad.</span>
                                    <?php endif ?>
                                </div>
                            </div>
                            <?php endif ?>
                            <br>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="dao_indemnizacion_escogida">Opción escogida:</label>
                                <div class="col-sm-7">
                                    <label>
                                    <?php echo form_radio(
                                        $dao_indemnizacion_escogida['name'],
                                        $dao_indemnizacion_escogida['value_1'],
                                        $dao_indemnizacion_escogida['checked_1']
                                        );?>
                                    <?php echo lang('expedientes_opcion_1'); ?>&nbsp&nbsp
                                    </label>
                                    <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                                    <label>
                                    <?php echo form_radio(
                                        $dao_indemnizacion_escogida['name'],
                                        $dao_indemnizacion_escogida['value_2'],
                                        $dao_indemnizacion_escogida['checked_2']
                                        );?>
                                    <?php echo lang('expedientes_opcion_2'); ?>&nbsp&nbsp
                                    </label>
                                </div>
                            </div>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Seguimiento a la conformidad del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-9" for="dao_firmado_conformidad">Fecha de firma de conformidad:</label>
                                <div class="col-sm-3">
                                    <?php if ($habilitado['op']) : ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($dao_firmado_conformidad);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($dao_firmado_conformidad);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <?php if (!empty($dao_total_notificacion['value'])) : ?>
                            <div class="form-group">
                                <label class="control-label col-sm-9" for="dao_total_notificacion">Valor total para notificación de avalúo por el porcentaje afectado del terreno (Gs.):</label>
                                <div class="col-sm-3"><?php echo form_input($dao_total_notificacion); ?></div>
                            </div>
                            <?php endif ?>
                            <?php if (!empty($dao_total_notificacion2['value'])) : ?>
                            <div class="form-group">
                                <label class="control-label col-sm-9" for="dao_total_notificacion2">Valor total para notificación de avalúo por el total del terreno (Gs.):</label>
                                <div class="col-sm-3"><?php echo form_input($dao_total_notificacion2); ?></div>
                            </div>
                            <?php endif ?>
                            <div class="form-group">
                                <label class="control-label col-sm-9" for="dao_total_conformidad">Valor total con conformidad (Gs.):</label>
                                <div class="col-sm-3"><?php echo form_input($dao_total_conformidad); ?></div>
                            </div>
                        </div>
                        <div class="col-sm-6 dynamic_group">
                            <div class="form-group">
                                <label class="control-label col-sm-4" for="dao_aplica_conformidad">Aplica conformidad:</label>
                                <div class="col-sm-8">
                                    <label>Si&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad['name'],
                                        $dao_aplica_conformidad['value_s'],
                                        $dao_aplica_conformidad['checked_s']
                                        );?>
                                    </label>
                                    <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                                    <label>No&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad['name'],
                                        $dao_aplica_conformidad['value_n'],
                                        $dao_aplica_conformidad['checked_n']
                                        );?>
                                    </label>
                                    <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                                    <label>Pendiente&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad['name'],
                                        $dao_aplica_conformidad['value_p'],
                                        $dao_aplica_conformidad['checked_p']
                                        );?>
                                    </label>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-4" for="dao_aplica_conformidad_ocupante">Aplica conformidad del ocupante:</label>
                                <div class="col-sm-8">
                                    <label>Si&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad_ocupante['name'],
                                        $dao_aplica_conformidad_ocupante['value_s'],
                                        $dao_aplica_conformidad_ocupante['checked_s']
                                        );?>
                                    </label>
                                    <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                                    <label>No&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad_ocupante['name'],
                                        $dao_aplica_conformidad_ocupante['value_n'],
                                        $dao_aplica_conformidad_ocupante['checked_n']
                                        );?>
                                    </label>
                                    <?php echo '&nbsp;';?><?php echo '&nbsp;';?><?php echo '&nbsp;';?>
                                    <label>N/A&nbsp&nbsp
                                    <?php echo form_radio(
                                        $dao_aplica_conformidad_ocupante['name'],
                                        $dao_aplica_conformidad_ocupante['value_p'],
                                        $dao_aplica_conformidad_ocupante['checked_p']
                                        );?>
                                    </label>
                                </div>
                            </div>
                            <?php if (isset($dao_observacion_ocupante['value'])) : ?>
                            <div class="form-group dinamico" value="1">
                                <?php echo form_textarea($dao_observacion_ocupante); ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <div class="col-sm-6">
                            <!-- Sección botones -->
                            <div class="form-group">
                                <?php if ($habilitado['op'] or $habilitado['sis']) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary btn-flat', 'content' =>   'Guardar')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php echo anchor('expedientes/expedientes/', 'Regresar', array('class' => 'btn btn-danger btn-flat', 'content' => 'Regresar')); ?>       
                            </div>
                            <!-- Fin sección botones --> 
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo form_close();?>
    </section>
</div>