<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
    ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo 'Expediente '.$codigo_unico['value']; ?></h1>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <?php
                if ($message) {
                    echo '<pre>';
                    echo '<h4><b>Mensaje:</b></h4>';
                    echo '<h5>' . $message . '</h5>';
                    echo '</pre>';
                }
                ?>
        </div>
        <?php require 'info_expe.php' ?>
        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-edit_expe_dao'));?>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Características del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="control-label col-sm-5" for="dao_ingreso_verificacion">Fecha de ingreso:</label>
                                    <div class="col-sm-6">
                                        <?php if ($editableDAO and ($habilitado['op'] or $habilitado['sis'])): ?>
                                        <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                            <?php echo form_input($dao_ingreso_verificacion);?>
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                        </div>
                                        <?php else : ?>
                                        <?php echo form_input($dao_ingreso_verificacion);?>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="box box-option collapsed-box">
                                    <div class="box-header with-border">
                                        <h3 class="box-title">Historial de fechas de ingreso a DAO</h3>
                                        <div class="box-tools pull-right" >
                                            <!-- Collapse Button -->
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                            <i class="fa fa-plus"></i>
                                            </button>
                                        </div>
                                        <!-- /.box-tools -->
                                    </div>
                                    <!-- /.box-header -->
                                    <div style="display: none;" class="box-body">
                                        <?php
                                            $i = 0;
                                            if (isset($historial_fecha_ingreso)) : ?>
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Fecha ingreso</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($historial_fecha_ingreso as $values) : 
                                                    $i = $i + 1; ?>
                                                <tr>
                                                    <th scope="row"><?php echo $i; ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($values['fecha_ingreso']), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <?php endforeach;?>
                                            </tbody>
                                        </table>
                                        <?php else : ?>
                                        <p>No se encuentran registros.</p>
                                        <?php endif; ?>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="box box-option">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"> Avalúo para porcentaje afectado del terreno</h3>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_terreno"><?php echo lang('expedientes_valor_terreno'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_terreno); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_gastos_transferencia"><?php echo lang('expedientes_valor_gastos_transferencia'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_gastos_transferencia); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_mejoras_edilicias"><?php echo lang('expedientes_valor_mejoras_edilicias'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_mejoras_edilicias); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_mejoras_agroforestales"><?php echo lang('expedientes_valor_mejoras_agroforestales'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_mejoras_agroforestales); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_total_mejoras"><?php echo lang('expedientes_valor_total_mejoras'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_total_mejoras); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_total_notificacion"><?php echo lang('expedientes_valor_total_notificacion'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_total_notificacion); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="box box-option">
                                    <div class="box-header with-border">
                                        <h3 class="box-title"> Avalúo por el total del terreno</h3>
                                    </div>
                                    <div class="box-body">
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_terreno2"><?php echo lang('expedientes_valor_terreno'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_terreno2); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_gastos_transferencia2"><?php echo lang('expedientes_valor_gastos_transferencia'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_gastos_transferencia2); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_mejoras_edilicias2"><?php echo lang('expedientes_valor_mejoras_edilicias'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_mejoras_edilicias2); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_mejoras_agroforestales2"><?php echo lang('expedientes_valor_mejoras_agroforestales'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_mejoras_agroforestales2); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_total_mejoras2"><?php echo lang('expedientes_valor_total_mejoras'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_total_mejoras2); ?></div>
                                        </div>
                                        <div class="form-group">
                                            <label class="control-label col-sm-6" for="dao_total_notificacion2"><?php echo lang('expedientes_valor_total_notificacion'); ?></label>
                                            <div class="col-sm-6"><?php echo form_input($dao_total_notificacion2); ?></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Revisión del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="dao_supervisor">Supervisor asignado:</label>
                                <div class="col-sm-6"><?php echo form_input($dao_supervisor); ?></div>
                            </div>
                            <br>
                            <div class="form-group">
                                <div class="col-sm-9">
                                    <label class="control-label">Observaciones:</label>
                                </div>
                                <?php if ($tiene_observaciones) : ?>
                                <div class="col-sm-3">
                                    <?php echo anchor('expedientes/expedientes/ver_observacion/'.$id.'/dao', '<i class="btn btn-xs bg-green color-palette">Ver observaciones</i>'); ?>
                                </div>
                                <?php endif ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_plano_mejoras">Planilla de mejoras:</label>
                                <?php echo form_textarea($observacion_plano_mejoras); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_planilla_terreno">Planilla de cálculo del valor del terreno:</label>
                                <?php echo form_textarea($observacion_planilla_terreno); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_gastos_transferencia">Gastos de transferencia:</label>
                                <?php echo form_textarea($observacion_gastos_transferencia); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_planilla_forestal">Planilla agroforestal:</label>
                                <?php echo form_textarea($observacion_planilla_forestal); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_avaluo_conformidad">Notificación de avalúo y conformidad:</label>
                                <?php echo form_textarea($observacion_avaluo_conformidad); ?>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="dao_fecha_verificacion">Fecha de revisión:</label>
                                <div class="col-sm-6">
                                    <?php if ($editableDAO and ($habilitado['sup'] or $habilitado['sis'])): ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($dao_fecha_verificacion);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($dao_fecha_verificacion);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <div class="col-sm-6">
                            <!-- Sección botones -->
                            <div class="form-group">
                                <?php if ($editableDAO and ($habilitado['sup'] or $habilitado['sis'])) : ?>
                                <?php if ($editableUBI == 't') : ?>
                                <p>No se puede aprobar porque el expediente no esta aprobado en UBI</p>
                                <button type="button" class="btn btn-disabled ">Guardar aprobado</button>              
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php else : ?>
                                <button type="button" class="btn btn-primary " data-toggle="modal" data-target="#myModal">Guardar aprobado</button>              
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php endif; ?>
                                <?php if ($editableDAO and !$habilitado['coor']) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary ', 'content' =>   'Guardar pendiente')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php if (!$editableDAO and ($habilitado['coor'] or $habilitado['coor_DAO'])) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '3','class' => 'btn btn-success ', 'content' =>   'Habilitar edición')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php echo anchor('expedientes/expedientes/', 'Regresar', array('class' => 'btn btn-danger ', 'content' => 'Regresar')); ?>       
                            </div>
                            <!-- Fin sección botones --> 
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="dao_fecha_aprobacion">Fecha de aprobación:</label>
                                <div class="col-sm-6">
                                    <?php echo form_input($dao_fecha_aprobacion);?>   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php require 'modal_aprobar.php' ?>
        <?php echo form_close();?>
    </section>
</div>