<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
    ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo 'Expediente '.$codigo_unico['value']; ?></h1>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <?php
                if ($message) {
                    echo '<pre>';
                    echo '<h4><b>Mensaje:</b></h4>';
                    echo '<h5>' . $message . '</h5>';
                    echo '</pre>';
                }
                ?>
        </div>
        <?php require 'info_expe.php' ?>
        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-edit_expe_daj'));?>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Características del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-sm-12">
                            <div class="col-sm-7">
                                <div class="form-group">
                                    <label class="control-label col-sm-5" for="daj_fecha_entrada">Fecha de ingreso:</label>
                                    <div class="col-sm-6">
                                        <?php if ($editable): ?>
                                        <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                            <?php echo form_input($daj_fecha_entrada);?>
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                        </div>
                                        <?php else : ?>
                                        <?php echo form_input($daj_fecha_entrada);?>
                                        <?php endif ?>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="col-sm-6 control-label">Documentación presentada:</label>
                                    <div class="form-group">
                                        <div class="col-sm-8">
                                            <?php foreach ($documentos as $documento) :?>
                                            <?php
                                                $doc_id     = $documento['id'];
                                                $checked = null;
                                                $item    = null;
                                                
                                                foreach ($documentos_sel as $sel) {
                                                    if ($doc_id == $sel['tipo_documento_id']) {
                                                        $checked = ' checked="checked"';
                                                        break;
                                                    }
                                                }
                                                ?>
                                            <div class="checkbox">
                                                <label>
                                                <input type="checkbox" name="documentos[]" value="<?php echo $documento['id'];?>"<?php echo $checked; ?>>
                                                <?php echo htmlspecialchars($documento['descripcion'], ENT_QUOTES, 'UTF-8'); ?>
                                                </label>
                                            </div>
                                            <?php endforeach?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-5">
                                <div class="box box-option collapsed-box">
                                    <div class="box-header with-border">
                                        <h3 class="box-title">Historial de fechas de ingreso a DAJ</h3>
                                        <div class="box-tools pull-right" >
                                            <!-- Collapse Button -->
                                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                            <i class="fa fa-plus"></i>
                                            </button>
                                        </div>
                                        <!-- /.box-tools -->
                                    </div>
                                    <!-- /.box-header -->
                                    <div style="display: none;" class="box-body">
                                        <?php
                                            $i = 0;
                                            if (isset($historial_fecha_ingreso)) : ?>
                                        <table class="table">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>Fecha ingreso</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($historial_fecha_ingreso as $values) : 
                                                    $i = $i + 1; ?>
                                                <tr>
                                                    <th scope="row"><?php echo $i; ?></th>
                                                    <td><?php echo htmlspecialchars(formato_fecha($values['fecha_ingreso']), ENT_QUOTES, 'UTF-8'); ?></td>
                                                </tr>
                                                <?php endforeach;?>
                                            </tbody>
                                        </table>
                                        <?php else : ?>
                                        <p>No se encuentran registros.</p>
                                        <?php endif; ?>
                                    </div>
                                    <!-- /.box-body -->
                                </div>
                                <div class="form-group">
                                    <label for="daj_documentos_adicionales">Documentos adicionales:</label>
                                    <?php echo form_textarea($daj_documentos_adicionales); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Revisión del expediente</h3>
                    </div>
                    <div class="box-body">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="daj_supervisor">Supervisor asignado:</label>
                                <div class="col-sm-6"><?php echo form_input($daj_supervisor); ?></div>
                            </div>
                            <br>
                            <div class="form-group">
                                <div class="col-sm-9">
                                    <label class="control-label">Observaciones:</label>
                                </div>
                                <?php if ($tiene_observaciones) : ?>
                                <div class="col-sm-3">
                                    <?php echo anchor('expedientes/expedientes/ver_observacion/'.$id.'/daj', '<i class="btn btn-xs bg-green color-palette">Ver observaciones</i>'); ?>
                                </div>
                                <?php endif ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_condicion_dominio">Condición de dominio:</label>
                                <?php echo form_textarea($observacion_condicion_dominio); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_documentacion_faltante">Documentación faltante:</label>
                                <?php echo form_textarea($observacion_documentacion_faltante); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_notificacion_avaluo">Notificación de avalúo:</label>
                                <?php echo form_textarea($observacion_notificacion_avaluo); ?>
                            </div>
                            <div class="form-group">
                                <label for="observacion_conformidad_afectado">Conformidad del afectado:</label>
                                <?php echo form_textarea($observacion_conformidad_afectado); ?>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="daj_fecha_revision">Fecha de revisión:</label>
                                <div class="col-sm-6">
                                    <?php if ($editable and $habilitado['sup']): ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($daj_fecha_revision);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($daj_fecha_revision);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <br>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <div class="col-sm-6">
                            <!-- Sección botones -->
                            <div class="form-group">
                                <?php if ($editable and ($habilitado['sup'] or $habilitado['sis'])) : ?>
                                <?php if ($editableUBI == 't' and $editableDAO == 'f') : ?>
                                <p>No se puede aprobar porque el expediente no esta aprobado en UBI</p>
                                <button type="button" class="btn btn-disabled ">Guardar aprobado</button>              
                                <?php elseif ($editableUBI == 'f' and $editableDAO == 't') : ?>
                                <p>No se puede aprobar porque el expediente no esta aprobado en DAO</p>
                                <button type="button" class="btn btn-disabled ">Guardar aprobado</button>                
                                <?php elseif ($editableUBI == 't' and $editableDAO == 't') : ?>
                                <p>No se puede aprobar porque el expediente no esta aprobado en UBI y DAO</p>
                                <button type="button" class="btn btn-disabled ">Guardar aprobado</button>              
                                <?php else: ?>
                                <button type="button" class="btn btn-primary " data-toggle="modal" data-target="#myModal">Guardar aprobado</button>              
                                <?php endif; ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php if ($editable and !$habilitado['coor']) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary ', 'content' =>   'Guardar pendiente')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php if (!$editable and ($habilitado['coor'] or $habilitado['coor_DAJ'])) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '3','class' => 'btn btn-success ', 'content' =>   'Habilitar edición')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php echo anchor('expedientes/expedientes/', 'Regresar', array('class' => 'btn btn-danger ', 'content' => 'Regresar')); ?>       
                            </div>
                            <!-- Fin sección botones --> 
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="daj_fecha_aprobacion">Fecha de aprobación:</label>
                                <div class="col-sm-6">
                                    <?php echo form_input($daj_fecha_aprobacion);?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php require 'modal_aprobar.php' ?>
        <?php echo form_close();?>
    </section>
</div>