$(document).ready(function(){
    //funcion para hacer mas dinamica la parte de agregar actividades
    $('#guardarActividad').on('click', function() {
        const descripcion = $('#nueva_actividad').val().trim();
        if (!descripcion) {
            alert("La descripción no puede estar vacía.");
            return;
        }

        $.ajax({
            url: "<?= site_url('man_espacial/proyectos/proyectos/agregar_actividad'); ?>",
            method: "POST",
            data: { descripcion: descripcion },
            success: function(res) {
                try {
                    const data = JSON.parse(res);
                    if (data.success) {
                        const nueva = new Option(data.id + ' - ' + data.descripcion, data.id, true, true);
                        $('#actividad').append(nueva).selectpicker('refresh');
                        $('#actividad').selectpicker('val', data.id);

                        $('#modalActividad').modal('hide');
                        $('#nueva_actividad').val('');
                        alert("Actividad añadida correctamente.");
                        window.location.href = "<?= site_url('man_espacial/proyectos/proyectos/edit/' . $_SESSION['identificador'] . '/E'); ?>";
                    } else {
                        alert(data.error || 'No se pudo guardar la actividad.');
                    }
                } catch (e) {
                    console.error("Error en la respuesta:", e);
                    alert("Hubo un error inesperado.");
                }
            },
            error: function(err) {
                console.error("Error en el AJAX:", err);
                alert("Error de comunicación con el servidor.");
            }
        });
    });
    //Funcion de proyectos para poder cambiar los campos de distritos y hacerlos mas dinamicos
    $('#dpto').change(function() {
        var dpto = $(this).val();
        $('#distrito').html('<option value="">Cargando...</option>').selectpicker('refresh');

        $.post("<?= site_url('man_espacial/proyectos/get_distritos'); ?>", { dpto: dpto }, function(data) {
            var distritos = JSON.parse(data);
            var options = '<option value="">Seleccione un distrito</option>';
            $.each(distritos, function(index, distrito) {
                options += '<option value="' + distrito.distrito + '">' + distrito.dist_desc + '</option>';
            });
            $('#distrito').html(options).selectpicker('refresh');
            $('#barloc').html(options).selectpicker('refresh');
        });
    });

   //funcion para poder agregar las locaclidades y hacerlos mas dinamicos
    $('#distrito').change(function() {
        var dpto = $('#dpto').val();
        var distrito = $(this).val();

        console.log("Departamento seleccionado:", dpto);
        console.log("Distrito seleccionado:", distrito);
        $('#barloc').html('<option value="">Cargando...</option>').selectpicker('refresh');

        $.post("<?= site_url('man_espacial/proyectos/get_barloc'); ?>", { dpto: dpto, distrito: distrito }, function(data) {
            var barlocs = JSON.parse(data);
            var options = '<option value="">Seleccione un barrio/localidad</option>';
            $.each(barlocs, function(index, barloc) {
                options += '<option value="' + barloc.id + '">' + barloc.barlo_desc + '</option>';
            });
            $('#barloc').html(options).selectpicker('refresh');
        });
    });
    //utilizamos el evento keyup para coger la información
    //cada vez que se pulsa alguna tecla con el foco en el buscador
    $('#dpto').keyup(function(){
        //en info tenemos lo que vamos escribiendo en el buscador
        var info = $(this).val();
        //hacemos la petición al método poblaciones del controlador buscador
        //pasando la variable info
		
		if (info != '') {
            $.post('buscar',{ info : info }, function(data){
 
                //si autocompletado nos devuelve algo
                if(data != '')
                {
                    //en el div con clase contenedor mostramos la info
                    $(".muestra_geocolonias").show();
                    $(".muestra_geocolonias").html(data);
                    //alert(data);
                    
                }else{ 
                    //alert("NO FUNCIONA");
                    //$(".muestra_geocolonias").html('');
                    $(".muestra_geocolonias").show();
                    $(".muestra_geocolonias").html(data);
                }
            })
        } else {
            $.post('buscar2',{ info : info }, function(data){ 
                //si autocompletado nos devuelve algo
                if(data != '')
                {
                    //en el div con clase contenedor mostramos la info
                    $(".muestra_geocolonias").show();
                    $(".muestra_geocolonias").html(data);
                    //alert(data);
                }else{
                    //alert("NO FUNCIONA");
                    //$(".muestra_geocolonias").html('');
                    $(".muestra_geocolonias").show();
                    $(".muestra_geocolonias").html(data);
                }
            })
        }
        
 
    })
    //Pantalla coloniax\s
    $('#dpto_cod').change(function(event) {
        //alert('Funcionaaaaaa');
        
        event.preventDefault();
        var sistema = $("#nomsistema").val() ;
        url_metodo = "/" + sistema + "/man_espacial/colonias/colonias/trae_distritos";
        dpto_cod = this.value;
        //console.log('Dpto: ' + dpto_cod);
        jQuery.ajax({
        type: "POST",
        url: url_metodo,
        data: {dpto_cod: dpto_cod},
        success: function(res) {
            if (res)
            {
                //console.log(res);
                $("#dist_cod").html(res);

                var pad = "000"
                col_cod = pad.substring(0, pad.length - $("#col_cod").val().length) + $("#col_cod").val();

                id_codgeo = dpto_cod + $("#dist_cod").val() + col_cod;
                $("select[name=dist_cod]").selectpicker("refresh");
                $("#id_codgeo").val(id_codgeo);
            }
        }

        });
    });    
});
function actualizarCamposPorEstado(estado) {
    var todosLosCampos = [
        '#mesa_control', '#mesa_fecha_ini', '#mesa_fecha_pago', '#mesa_fecha_fin', '#mesa_obs',
        '#atec_ini', '#atec_ini_fecha', '#atec_ini_fecha_fin', '#atec_ini_obs',
        '#geomatica', '#geo_fecha_ini', '#geo_fecha_fin', '#geo_obs',
        '#atecnico', '#atec_fecha_ini', '#atec_fecha_fin', '#atec_obs', '#direc_mades',
        '#rima_p', '#rima_p_fecha', '#rima_p_fecha_fin', '#rima_p_obs',
        '#rima_w', '#rima_w_fecha', '#rima_w_fecha_fin', '#rima_w_obs',
        '#diva', '#diva_fecha_ini', '#diva_fecha_fin', '#diva_obs',
        '#dir_gen', '#dir_gen_fecha_ini', '#dir_gen_fecha_fin', '#dir_gen_obs'
    ];

    // Deshabilitar todo por defecto
    $(todosLosCampos.join(',')).prop('disabled', true);
    $('.btn.btn-primary.btn-flat').prop('disabled', true);

    var estadosMesa = ['02', '03', '04', '05', '06', '07'];
    var estadosAtecIni = ['03', '04', '05', '06', '07'];
    var estadosGeomatica = ['04', '05', '06', '07'];
    var estadosAnalisisTecnico = ['05', '06', '07'];
    var estadosRimaPublicacion = ['06', '07'];
    var estadosRimaWeb = ['06', '07'];
    var estadosDiva = ['07'];
    var estadosDireccionGeneral = ['07'];

    function habilitarCampos(campos) {
        $(campos.join(',')).prop('disabled', false);
        $(campos[0]).closest('.form-group.col-md-12').find('button').prop('disabled', false);
    }

    if (estadosMesa.includes(estado)) {
        habilitarCampos(['#mesa_control', '#mesa_fecha_ini', '#mesa_fecha_pago', '#mesa_fecha_fin', '#mesa_obs']);
    }
    if (estadosAtecIni.includes(estado)) {
        habilitarCampos(['#atec_ini', '#atec_ini_fecha', '#atec_ini_fecha_fin', '#atec_ini_obs']);
    }
    if (estadosGeomatica.includes(estado)) {
        habilitarCampos(['#geomatica', '#geo_fecha_ini', '#geo_fecha_fin', '#geo_obs']);
    }
    if (estadosAnalisisTecnico.includes(estado)) {
        habilitarCampos(['#atecnico', '#atec_fecha_ini', '#atec_fecha_fin', '#atec_obs', '#direc_mades']);
    }
    if (estadosRimaPublicacion.includes(estado)) {
        habilitarCampos(['#rima_p', '#rima_p_fecha', '#rima_p_fecha_fin', '#rima_p_obs']);
    }
    if (estadosRimaWeb.includes(estado)) {
        habilitarCampos(['#rima_w', '#rima_w_fecha', '#rima_w_fecha_fin', '#rima_w_obs']);
    }
    if (estadosDiva.includes(estado)) {
        habilitarCampos(['#diva', '#diva_fecha_ini', '#diva_fecha_fin', '#diva_obs']);
    }
    if (estadosDireccionGeneral.includes(estado)) {
        habilitarCampos(['#dir_gen', '#dir_gen_fecha_ini', '#dir_gen_fecha_fin', '#dir_gen_obs']);
    }
}
