<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
        <!-- Puedes agregar breadcrumbs o títulos aquí -->
    </section>

    <section class="content">
        <div class="container mt-5">
            
            <?php
            echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
            ?>

            <h1 class="mb-4">Listado de Resoluciones , Proyecto: <?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?></h1>
            <form class="row g-3 mb-4" method="get" >
                <div class="col-md-3">
                    <label for="nro_resolucion" class="form-label">Nro Resolución</label>
                    <input type="text" class="form-control" name="nro_resolucion" id="nro_resolucion" value="<?= $this->input->get('nro_resolucion') ?>">
                </div>
                <div class="col-md-3">
                    <label for="gestion_resolucion" class="form-label">Gestión</label>
                    <input type="text" class="form-control" name="gestion_resolucion" id="gestion_resolucion" value="<?= $this->input->get('gestion_resolucion') ?>">
                </div>
                <div class="col-md-3">
                    <label for="estado" class="form-label">Estado</label>
                    <select name="estado" id="estado" class="form-control">
                        <?php foreach ($dropdown_estados as $key => $value): ?>
                            <option value="<?php echo $key; ?>" 
                                <?php echo isset($filters['estado']) && $filters['estado'] == $key ? 'selected' : ''; ?>>
                                <?php echo $value; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="tipo_resoluciones" class="form-label">Tipo Resoluciones</label>
                    <select name="tipo_resoluciones" id="tipo_resoluciones" class="form-control">
                        <?php foreach ($dropdown_tipo_resoluciones as $key => $value): ?>
                            <option value="<?php echo $key; ?>" 
                                <?php echo isset($filters['tipo_resoluciones']) && $filters['tipo_resoluciones'] == $key ? 'selected' : ''; ?>>
                                <?php echo $value; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="col-md-3 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                </div>
            </form>
            <?php 
                $user_id = $this->session->userdata('user_id');
                $tipo_usuario = $_SESSION['tipo_usuario'][0];
                $id_cliente = $_SESSION['id_cliente'][0];
                if ($tipo_usuario == 'C') { 
            ?> 
            
            <?php
                } else {  
            ?>   
                <a href="<?= site_url('resoluciones/create/'. $id_proyecto) ?>" class="btn btn-success mt-3">Crear Nueva Resolución</a>
                <br>
            <?php
                } 
            ?>      
            <br>
            <div class="table-container">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th>Acciones</th>
                                <th>ID</th>
                                <th>Estado</th>
                                <th>Nro Resolución</th>
                                <th>Gestión</th>
                                <th>Fecha Resolución</th>
                                <th>Tipo de Resolución</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($resoluciones as $resolucion): ?>
                            <tr>
                                <td>    
                                    <?php 
                                    $user_id = $this->session->userdata('user_id');
                                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                    $id_cliente = $_SESSION['id_cliente'][0];
                                    if ($tipo_usuario == 'C') { 
                                    ?>
                                    <a href="<?= site_url('resoluciones/views/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-info btn-sm" >Ver</a>
                                    <?php
                                    } else {  
                                    ?>
                                    <a href="<?= site_url('resoluciones/edit/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-warning btn-sm">Editar</a>
                                    &nbsp;
                                    <a href="<?= site_url('resoluciones/delete/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Estás seguro?')">Eliminar</a>
                                    &nbsp;
                                    <a href="<?= site_url('resoluciones/views/' . $resolucion->id_resoluciones. '/' .$resolucion->id_proyecto) ?>" class="btn btn-info btn-sm" >Ver</a>
                                    <?php
                                    } 
                                    ?>
                                </td>
                                <td><?= $resolucion->id_resoluciones ?></td>
                                <td><?= $resolucion->estado == 'A' ? 'Activo' : 'Inactivo' ?></td>
                                <td><?= $resolucion->nro_resolucion ?></td>
                                <td><?= $resolucion->gestion_resolucion ?></td>
                                <td><?= $resolucion->fecha_resolucion ?></td>
                                <td><?= $resolucion->tipo_resoluciones ?></td>      
                               
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="pagination">
                <?= $pagination ?>
            </div>
        </div>
    </section>
</div>

<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>