<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px;
        }
        .btn-container .btn {
            margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    <section class="content-header">
    <section class="content">
        <div class="container mt-5">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Editar Evaluación de Proyecto</h4>
                </div>
                <div class="card-body">
                    <form action="<?= site_url('proyectos_evaluaciones/edit/' . $proyecto['id']) ?>" method="post">
                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="proyecto_id">ID del Proyecto</label>
                                <input type="number" class="form-control" name="proyecto_id" id="proyecto_id" value="<?= set_value('proyecto_id', $proyecto['proyecto_id']) ?>" required readonly>
                                <?= form_error('proyecto_id', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="form-group col-md-8">
                                <label for="categoria">Categoría</label>
                                <input type="text" class="form-control" name="categoria" id="categoria" value="<?= set_value('categoria', $proyecto['categoria']) ?>" required>
                                <?= form_error('categoria', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="estado">Estado</label>
                                <select name="estado" id="estado" class="form-control">
                                    <option value="1" <?= set_select('estado', 'presentado', $proyecto['estado'] == '1') ?>>Presentado</option>
                                    <option value="2" <?= set_select('estado', 'aprobado', $proyecto['estado'] == '2') ?>>Aprobado</option>
                                    <option value="3" <?= set_select('estado', 'rechazado', $proyecto['estado'] == '3') ?>>Rechazado</option>
                                    <option value="0" <?= set_select('estado', 'no requiere', $proyecto['estado'] == '0') ?>>No Requiere</option>
                                </select>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="si_no">Aprobado</label>
                                <select name="si_no" id="si_no" class="form-control">
                                    <option value="1" <?= set_select('si_no', '1', $proyecto['si_no'] == 1) ?>>Sí</option>
                                    <option value="0" <?= set_select('si_no', '0', $proyecto['si_no'] == 0) ?>>N/A</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="fecha">Fecha</label>
                                <input type="date" class="form-control" name="fecha" id="fecha" value="<?= set_value('fecha', $proyecto['fecha']) ?>">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="observaciones">Observaciones</label>
                                <textarea class="form-control" name="observaciones" id="observaciones" rows="3"><?= set_value('observaciones', $proyecto['observaciones']) ?></textarea>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="btn-container">
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                    <a href="<?= site_url('proyectos_evaluaciones/index/'.$proyecto['proyecto_id']) ?>" class="btn btn-warning">Cancelar</a>
                                    
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                </div>
            </div>
        </div>
    </section>
</div>
    <!-- Modal para mensajes -->
    <div class="modal fade" id="mensajeModal" tabindex="-1" role="dialog" aria-labelledby="mensajeModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header alert-success">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="mensajeModalLabel">Mensaje</h4>
                </div>
                <div class="modal-body">
                    <?= $this->session->flashdata('message') ?: $this->session->flashdata('error') ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>
                </div>
                </div>
            </div>
        </div>

    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>

    <script>
        $(document).ready(function() {
            <?php if ($this->session->flashdata('message') || $this->session->flashdata('error')): ?>
                $('#mensajeModal').modal('show');
            <?php endif; ?>
        });
    </script>

</body>
