<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px; /* Espaciado interno */
            border-radius: 5px; /* Bordes redondeados */
            background-color: #ffffff; /* Fondo blanco */
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4 text-center">Listado de Proyectos</h1>

              <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label for="codigo" class="form-label">Código</label>
                        <input type="text" name="codigo" id="codigo" class="form-control" value="<?= isset($filters['codigo']) ? $filters['codigo'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" value="<?= isset($filters['nombre']) ? $filters['nombre'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="estado" class="form-label">Estado</label>
                        <select name="estado" id="estado" class="form-control">
                            <?php foreach ($dropdown_estados as $key => $value): ?>
                                <option value="<?= $key ?>" <?= (isset($filters['estado']) && $filters['estado'] == $key) ? 'selected' : '' ?>><?= $value ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-3">
                        <label for="consultor" class="form-label">Consultor</label>
                        <input type="text" name="consultor" id="consultor" class="form-control" value="<?= isset($filters['consultor']) ? $filters['consultor'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="proponente" class="form-label">Proponente</label>
                        <input type="text" name="proponente" id="proponente" class="form-control" value="<?= isset($filters['proponente']) ? $filters['proponente'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_inicio" class="form-label">Fecha Inicio</label>
                        <input type="date" name="fecha_inicio" id="fecha_inicio" class="form-control" value="<?= isset($filters['fecha_inicio']) ? $filters['fecha_inicio'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="fecha_inicio2" class="form-label">Fecha Final</label>
                        <input type="date" name="fecha_inicio2" id="fecha_inicio2" class="form-control" value="<?= isset($filters['fecha_inicio2']) ? $filters['fecha_inicio2'] : '' ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="gid" class="form-label">ID Proyecto</label>
                        <input type="text" name="gid" id="gid" class="form-control" value="<?= isset($filters['gid']) ? $filters['gid'] : '' ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-success w-100">Filtrar</button>
                        &nbsp
                        <a href="<?= site_url('man_espacial/proyectos/proyectos/limpiar_filtros') ?>" class="btn btn-primary">Limpiar</a>
                    </div>
                </form>


                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?>
                <a href="<?= site_url('man_espacial/proyectos/proyectos/export_excel') ?>" class="btn btn-success mb-3">Excel</a>
                <br>
                <?php
                    } else {  
                ?>    
                <a href="<?= site_url('man_espacial/proyectos/proyectos/create') ?>" class="btn btn-success mb-3">Crear Proyecto</a>
                &nbsp
                <a href="<?= site_url('man_espacial/proyectos/proyectos/export_excel') ?>" class="btn btn-success mb-3">Excel</a>
                <br>
                <?php
                    } 
                ?>                                                                                                                            
                

                <!-- Contenedor con fondo blanco -->
                <br>
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Estado</th>
                                    <th>codigo</th>
                                    <th>Nombre</th>
                                    <th>Consultor</th>
                                    <th>Proponente</th>
                                    <th>Fecha Inicio</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if (!empty($proyectos)): ?>
                                    <?php foreach ($proyectos as $proyecto): ?>
                                        <tr>
                                        <td>
                                            <!-- Botón para abrir el modal -->
                                            <button type="button" class="btn btn-secondary btn-sm w-100" data-toggle="modal" data-target="#actionModal<?php echo $proyecto['gid']; ?>">
                                                Acciones ↓
                                            </button>

                                            <!-- Modal -->
                                            <div class="modal fade" id="actionModal<?php echo $proyecto['gid']; ?>" tabindex="-1" role="dialog" aria-labelledby="actionModalLabel<?php echo $proyecto['gid']; ?>" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="actionModalLabel<?php echo $proyecto['gid']; ?>">Opciones para el Proyecto <?php echo $proyecto['gid']; ?></h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="list-group">
                                                            <?php 
                                                            $user_id = $this->session->userdata('user_id');
                                                            $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                                            $id_cliente = $_SESSION['id_cliente'][0];
                                                            if ($tipo_usuario == 'C') { 
                                                            ?>
                                                                <?php echo anchor('man_espacial/parcelas/parcelas/verproyecto_ol/'.$proyecto['gid'], 'Ver Mapa', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('man_espacial/proyectos/proyectos/ver/'.$proyecto['gid'], 'Ver', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('pga/index/'.$proyecto['gid'], 'PGA', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('declaraciones/index/'.$proyecto['gid'], 'DIA', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('resoluciones/index/'.$proyecto['gid'], 'Resoluciones', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('proyectos_evaluaciones/index/'.$proyecto['gid'], 'Evaluaciones de proyectos', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php //echo anchor('man_espacial/proyectos/proyectos/export_excel/'.$proyecto['gid'], 'Excel', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                
                                                            <?php
                                                            } else {  
                                                            ?>
                                                                <?php echo anchor('man_espacial/parcelas/parcelas/verproyecto_ol/'.$proyecto['gid'], 'Ver Mapa ', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('man_espacial/proyectos/proyectos/ver/'.$proyecto['gid'], 'Ver', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('man_espacial/proyectos/proyectos/edit/'.$proyecto['gid'], 'Editar', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('man_espacial/proyectos/Mantenimiento/mantenimiento_colmen/'.$proyecto['gid'], 'Mantenimiento', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('pga/index/'.$proyecto['gid'], 'PGA', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('declaraciones/index/'.$proyecto['gid'], 'DIA', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('resoluciones/index/'.$proyecto['gid'], 'Resoluciones', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('proyectos_evaluaciones/index/'.$proyecto['gid'], 'Evaluaciones de proyectos', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php //echo anchor('man_espacial/proyectos/proyectos/export_excel/'.$proyecto['gid'], 'Excel', ['class' => 'list-group-item list-group-item-action']); ?>
                                                                <?php echo anchor('man_espacial/proyectos/proyectos/delete/'.$proyecto['gid'], 'Eliminar', ['class' => 'btn btn-danger btn-block', 'onclick' => "return confirm('¿Está seguro?')"]); ?>
                                                            <?php
                                                            } 
                                                            ?>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                            <td><?= $proyecto['gid'] ?></td>
                                            <td><?= $proyecto['des_estado'] ?></td>
                                            <td><?= $proyecto['codigo'] ?></td>
                                            <td><?= substr($proyecto['nombre'], 0, 20) ?></td>
                                            <td><?= substr($proyecto['consultor'], 0, 20) ?></td>
                                            <td><?= $proyecto['proponente'] ?></td>
                                            <td><?= date('d/m/Y', strtotime($proyecto['fecha_inicio'])) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <tr>
                                        <td colspan="6" class="text-center">No se encontraron proyectos.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
</body>
