<!DOCTYPE html>
<!--html lang="en"-->
<!--head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Grupos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet">
</head-->
<body>

            <div class="content-wrapper">
                <section class="content-header">
                    <?php //echo $pagetitle; ?>
                    <?php //echo $breadcrumb; ?>
                </section>

                <section class="content">


    <div class="container mt-4">
        <h1 class="text-center mb-4">Grupos</h1>

        <!-- Formulario para filtrar por cliente -->
        <form method="get" action="<?= site_url('grupos2/grupos/index'); ?>" class="mb-4">
            <div class="row g-2">
                <div class="col-md-8 col-sm-12">
                    <label for="id_cliente" class="form-label">ID Cliente:</label>
                    <input type="text" name="id_cliente" id="id_cliente" 
                           class="form-control" placeholder="Ingrese el ID del cliente"
                           value="<?= isset($id_cliente) ? $id_cliente : '0' ?>">
                </div>
                <div class="col-md-4 col-sm-12 d-flex align-items-end">
                    <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                </div>
            </div>
        </form>

        <!-- Mostrar los resultados -->
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <thead class="table-dark">
                    <tr>
                        <th>ID</th>
                        <th>ID Cliente</th>
                        <th>Nombre del Grupo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($grupos)): ?>
                        <?php foreach ($grupos as $grupo): ?>
                            <tr>
                                <td><?= $grupo['id']; ?></td>
                                <td><?= $grupo['id_cliente']; ?></td>
                                <td><?= $grupo['nombre_grupo']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="3" class="text-center">No se encontraron grupos.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Paginación -->
        <nav aria-label="Page navigation">
            <ul class="pagination justify-content-center">
                <?php $pagination; ?>
            </ul>
        </nav>
    </div>
</body>
                    </section>
            </div>

    <!-- Enlace al JavaScript de Bootstrap 5 -->
    <!--script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js"></script-->
<!--/body-->
<!--/html-->

