<head>
    <style>
        body {
            background-color: #f8f9fa;
        }
        .form-section {
            margin-bottom: 15px;
        }
        .btn-container {
            margin-top: 30px;
        }
        .btn-container .btn {
            margin-right: 10px;
        }
    </style>
</head>
<body>
<div class="content-wrapper">
    
    <section class="content-header">
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger">
                <?= $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('message')): ?>
            <div class="alert alert-success">
                <?= $this->session->flashdata('message'); ?>
            </div>
        <?php endif; ?>
    </section>

    <section class="content">
        <div class="container mt-5">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4>Crear Departamento</h4>
                </div>
                <div class="card-body">
                    <form action="<?= site_url('dpto/create') ?>" method="post">
                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="dpto">Código Dpto</label>
                                <input type="text" class="form-control" name="dpto" id="dpto" required>
                                <?= form_error('dpto', '<small class="text-danger">', '</small>') ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="dpto_desc">Descripción</label>
                                <input type="text" class="form-control" name="dpto_desc" id="dpto_desc" required>
                                <?= form_error('dpto_desc', '<small class="text-danger">', '</small>') ?>
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-4">
                                <label for="cod">Código</label>
                                <input type="text" class="form-control" name="cod" id="cod">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="region">Región</label>
                                <input type="text" class="form-control" name="region" id="region">
                            </div>
                            <div class="form-group col-md-4">
                                <label for="dpto_snc">Dpto SNC</label>
                                <input type="text" class="form-control" name="dpto_snc" id="dpto_snc">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-6">
                                <label for="shape_leng">Longitud</label>
                                <input type="number" step="0.01" class="form-control" name="shape_leng" id="shape_leng">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="shape_area">Área</label>
                                <input type="number" step="0.01" class="form-control" name="shape_area" id="shape_area">
                            </div>
                        </div>

                        <div class="form-row">
                            <div class="form-group col-md-12">
                                <div class="btn-container">
                                    <button type="submit" class="btn btn-primary">Guardar</button>
                                    <a href="<?= base_url('dpto/index') ?>" class="btn btn-warning">Cancelar</a>
                                </div>
                            </div>
                        </div>
                    </form>
                    <br>
                </div>
            </div>
        </div>
    </section>
</div>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
</body>
