<head>
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px;
            border-radius: 5px;
            background-color: #ffffff;
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">
            <div class="container mt-5">
                
                <?php
                echo anchor('man_espacial/proyectos/proyectos/index', '<button type="button" class="btn btn-primary btn-lg w-100">Volver</button>');
                ?>

                <h1 class="mb-4">Listado de Declaraciones, Proyecto: <?php echo isset($nombre_proyecto) ? $nombre_proyecto : 'No especificado'; ?></h1>


                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
                    <!-- Filtro por ID de declaración -->
                    <div class="col-md-3">
                        <label for="id_declaracion" class="form-label">ID Declaración</label>
                        <input type="text" name="id_declaracion" id="id_declaracion" class="form-control" 
                            value="<?php echo isset($filters['id_declaracion']) ? $filters['id_declaracion'] : ''; ?>">
                    </div>

                     <!-- Filtro por Nro de declaración -->
                     <div class="col-md-3">
                        <label for="nro_declaracion" class="form-label">Nro. Declaración</label>
                        <input type="text" name="nro_declaracion" id="nro_declaracion" class="form-control" 
                            value="<?php echo isset($filters['nro_declaracion']) ? $filters['nro_declaracion'] : ''; ?>">
                    </div>

                    <!-- Filtro por Nro de declaración -->
                    <div class="col-md-3">
                        <label for="gestion_declaracion" class="form-label">Gestion</label>
                        <input type="text" name="gestion_declaracion" id="gestion_declaracion" class="form-control" 
                            value="<?php echo isset($filters['gestion_declaracion']) ? $filters['gestion_declaracion'] : ''; ?>">
                    </div>

                    <!-- Filtro por Estado -->
                    <div class="col-md-3">
                        <label for="des_estado" class="form-label">Estado</label>
                        <select name="des_estado" id="des_estado" class="form-control">
                            <?php foreach ($dropdown_estados as $key => $value): ?>
                                <option value="<?php echo $key; ?>" 
                                    <?php echo isset($filters['des_estado']) && $filters['des_estado'] == $key ? 'selected' : ''; ?>>
                                    <?php echo $value; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Filtro por Fecha Desde -->
                <!--    <div class="col-md-3">
                        <label for="fecha_desde" class="form-label">Fecha Desde</label>
                        <input type="date" name="fecha_desde" id="fecha_desde" class="form-control" 
                            value="<?php echo isset($filters['fecha_desde']) ? $filters['fecha_desde'] : ''; ?>">
                    </div>  -->

                    <!-- Filtro por Fecha Hasta -->
                 <!--    <div class="col-md-3">
                        <label for="fecha_hasta" class="form-label">Fecha Hasta</label>
                        <input type="date" name="fecha_hasta" id="fecha_hasta" class="form-control" 
                            value="<?php echo isset($filters['fecha_hasta']) ? $filters['fecha_hasta'] : ''; ?>">
                    </div>  -->


                    <!-- Botón para aplicar los filtros -->
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>

                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                <a href="<?= site_url('declaraciones/create/'. $id_proyecto) ?>" class="btn btn-success mb-3">Crear Declaración</a>
                <br>
                <?php
                    } 
                ?>                                                                
                <br>
                <!-- Tabla de Declaraciones -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Estado</th>
                                    <th>Nro Declaración</th>
                                    <th>Gestión</th>
                                    <th>DIA</th>
                                    <th>Fecha</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($declaraciones as $declaracion): ?>
                                    <tr>
                                    <td>
                                        <?php 
                                        $user_id = $this->session->userdata('user_id');
                                        $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                        $id_cliente = $_SESSION['id_cliente'][0];
                                        if ($tipo_usuario == 'C') { 
                                        ?>
                                        <a href="<?= site_url('declaraciones/views/'.$declaracion['id_declaracion']. '/' .$declaracion['id_proyecto']) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                        } else {  
                                        ?>
                                        <a href="<?= site_url('declaraciones/edit/'.$declaracion['id_declaracion']. '/' . $declaracion['id_proyecto']) ?>" class="btn btn-warning btn-sm">Editar</a>
                                        &nbsp
                                        <a href="<?= site_url('declaraciones/delete/'.$declaracion['id_declaracion']. '/' .$declaracion['id_proyecto']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                        &nbsp
                                        <a href="<?= site_url('declaraciones/views/'.$declaracion['id_declaracion']. '/' .$declaracion['id_proyecto']) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                        } 
                                        ?>
                                        </td>
                                        <td><?php echo $declaracion['id_declaracion']; ?></td>
                                        <td><?php echo $declaracion['des_estado']; ?></td>
                                        <td><?php echo $declaracion['nro_declaracion']; ?></td>
                                        <td><?php echo $declaracion['gestion_declaracion']; ?></td>
                                        <td><?php echo $declaracion['dia']; ?></td>
                                        <td><?php echo $declaracion['des_fecha_declaracion']; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?php echo $pagination; ?>
                </div>
            </div>
        </section>
    </div>
</body>
