<head> 
    <style>
        body {
            background-color: #f8f9fa;
        }

        .form-inline {
            gap: 10px;
        }

        .table th {
            background-color: #007bff;
            color: white;
        }

        .btn-primary, .btn-success {
            margin-top: 10px;
        }

        .table-container {
            max-width: 1200px;
            margin: auto;
            padding: 20px; /* Espaciado interno */
            border-radius: 5px; /* Bordes redondeados */
            background-color: #ffffff; /* Fondo blanco */
        }

        .table {
            font-size: 15px;
        }

        .pagination {
            display: flex;
            justify-content: center;
            margin-top: 20px;
        }

        .pagination a, .pagination strong {
            padding: 10px 15px;
            margin: 0 5px;
            text-decoration: none;
            background-color: #007bff;
            color: #ffffff;
            border-radius: 3px;
        }

        .pagination a:hover {
            background-color: #0056b3;
        }

        .pagination strong {
            background-color: #6c757d;
        }

        @media (max-width: 768px) {
            .table th, .table td {
                font-size: 14px;
            }
        }
    </style>
</head>
<body>
    <div class="content-wrapper">
        <section class="content-header">
            <?php //echo $pagetitle; ?>
            <?php //echo $breadcrumb; ?>
        </section>

        <section class="content">
            <div class="container mt-5">
                <h1 class="mb-4">Proponente</h1>

                <!-- Formulario de filtros -->
                <form method="get" class="row g-3 mb-4">
                    <div class="col-md-3">
                        <label for="cedularuc" class="form-label">Cédula/RUC</label>
                        <input type="text" name="cedularuc" id="cedularuc" class="form-control" 
                            value="<?php echo isset($filters['cedularuc']) ? htmlspecialchars($filters['cedularuc'], ENT_QUOTES, 'UTF-8') : ''; ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="nombre" class="form-label">Nombre</label>
                        <input type="text" name="nombre" id="nombre" class="form-control" 
                            value="<?php echo isset($filters['nombre']) ? htmlspecialchars($filters['nombre'], ENT_QUOTES, 'UTF-8') : ''; ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="apellido" class="form-label">Apellido</label>
                        <input type="text" name="apellido" id="apellido" class="form-control" 
                            value="<?php echo isset($filters['apellido']) ? htmlspecialchars($filters['apellido'], ENT_QUOTES, 'UTF-8') : ''; ?>">
                    </div>
                    <div class="col-md-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="text" name="email" id="email" class="form-control" 
                            value="<?php echo isset($filters['email']) ? htmlspecialchars($filters['email'], ENT_QUOTES, 'UTF-8') : ''; ?>">
                    </div>
                    <div class="col-md-3 d-flex align-items-end">
                        <button type="submit" class="btn btn-primary w-100">Filtrar</button>
                    </div>
                </form>

                <?php 
                    $user_id = $this->session->userdata('user_id');
                    $tipo_usuario = $_SESSION['tipo_usuario'][0];
                    $id_cliente = $_SESSION['id_cliente'][0];
                    if ($tipo_usuario == 'C') { 
                ?> 
                
                <?php
                    } else {  
                ?>   
                    <a href="<?= site_url('clientes/Clientes/create') ?>" class="btn btn-success mb-3">Crear Nuevo Proponente</a>
                    <br>
                <?php
                    } 
                ?>
                
                <br>
                <!-- Contenedor con fondo blanco -->
                <div class="table-container">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Acciones</th>
                                    <th>ID</th>
                                    <th>Cédula/RUC</th>
                                    <th>Nombre</th>
                                    <th>Apellido</th>
                                    <th>Email</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($clientes as $cliente): ?>
                                    <tr>
                                        <td>
                                        <?php 
                                            $user_id = $this->session->userdata('user_id');
                                            $tipo_usuario = $_SESSION['tipo_usuario'][0];
                                            $id_cliente = $_SESSION['id_cliente'][0];
                                            if ($tipo_usuario == 'C') { 
                                        ?> 
                                            <a href="<?= site_url('clientes/Clientes/edit/'.$cliente['id_cliente']) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp
                                            <a href="<?= site_url('clientes/Clientes/view/'.$cliente['id_cliente']) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } else {  
                                        ?>   
                                            <a href="<?= site_url('clientes/Clientes/edit/'.$cliente['id_cliente']) ?>" class="btn btn-warning btn-sm">Editar</a>
                                            &nbsp
                                            <a href="<?= site_url('clientes/Clientes/delete/'.$cliente['id_cliente']) ?>" class="btn btn-danger btn-sm" onclick="return confirm('¿Está seguro?')">Eliminar</a>
                                            &nbsp
                                            <a href="<?= site_url('clientes/Clientes/view/'.$cliente['id_cliente']) ?>" class="btn btn-info btn-sm">Ver</a>
                                        <?php
                                            } 
                                        ?>
                                            
                                        </td>
                                        <td><?= $cliente['id_cliente'] ?></td>
                                        <td><?= $cliente['cedularuc'] ?></td>
                                        <td><?= $cliente['nombre'] ?></td>
                                        <td><?= $cliente['apellido'] ?></td>
                                        <td><?= $cliente['email'] ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <!-- Paginación -->
                <div class="pagination">
                    <?= $pagination ?>
                </div>
            </div>
        </section>
    </div>
</body>
