<?php
defined('BASEPATH') OR exit('No direct script access allowed');

?>
<?php
    // Asegurar valores para PHP 5
    $proyectos_proximos_vencer = isset($alertas['proximos_vencer']) ? $alertas['proximos_vencer'] : 0;
    $proyectos_vencidos = isset($alertas['vencidos']) ? $alertas['vencidos'] : 0;

    // Definir color según los datos
    $color = 'bg-green'; // Verde si no hay alertas

    if ($proyectos_proximos_vencer > 0) {
        $color = 'bg-yellow'; // Amarillo si hay proyectos por vencer
    }
    if ($proyectos_vencidos > 0) {
        $color = 'bg-red'; // Rojo si hay proyectos vencidos
    }
?>
<?php
    // Declaraciones
    $proximos_vencer_declaraciones = isset($declaraciones_alertas['proximos_vencer']) ? $declaraciones_alertas['proximos_vencer'] : 0;
    $vencidos_declaraciones = isset($declaraciones_alertas['vencidos']) ? $declaraciones_alertas['vencidos'] : 0;
    $color_declaraciones = 'bg-green'; // Verde si no hay alertas

    if ($proximos_vencer_declaraciones > 0) {
        $color_declaraciones = 'bg-yellow'; // Amarillo si hay declaraciones por vencer
    }
    if ($vencidos_declaraciones > 0) {
        $color_declaraciones = 'bg-red'; // Rojo si hay declaraciones vencidas
    }
?>

<?php
    // Resoluciones
    $proximos_vencer_resoluciones = isset($resoluciones_alertas['proximos_vencer']) ? $resoluciones_alertas['proximos_vencer'] : 0;
    $vencidos_resoluciones = isset($resoluciones_alertas['vencidos']) ? $resoluciones_alertas['vencidos'] : 0;
    $vencen_6_meses_resoluciones = isset($resoluciones_alertas['vencen_6_meses']) ? $resoluciones_alertas['vencen_6_meses'] : 0;
    $color_resoluciones = 'bg-green'; // Verde si no hay alertas

    if ($vencen_6_meses_resoluciones > 0) {
        $color_resoluciones = 'bg-orange'; // Naranja si hay resoluciones que vencen en 6 meses
    }
?>
<?php
    // Resoluciones
    $proximos_vencer_6m_resoluciones = isset($resoluciones_alertas['proximos_vencer_6m']) ? $resoluciones_alertas['proximos_vencer_6m'] : 0;
    $proximos_vencer_3m_resoluciones = isset($resoluciones_alertas['proximos_vencer_3m']) ? $resoluciones_alertas['proximos_vencer_3m'] : 0;
    $proximos_vencer_1m_resoluciones = isset($resoluciones_alertas['proximos_vencer_1m']) ? $resoluciones_alertas['proximos_vencer_1m'] : 0;
    $proximos_vencer_15d_resoluciones = isset($resoluciones_alertas['proximos_vencer_15d']) ? $resoluciones_alertas['proximos_vencer_15d'] : 0;
    $vencidos_resoluciones = isset($resoluciones_alertas['vencidos']) ? $resoluciones_alertas['vencidos'] : 0;

    // Colores para los cuadros
    $color_6m = 'bg-green'; // Por defecto verde si no hay alertas
    $color_3m = 'bg-green';
    $color_1m = 'bg-green';
    $color_15d_vencidos = 'bg-green'; // Combinado para 15 días y vencidos

    // Lógica para 6 meses
    if ($proximos_vencer_6m_resoluciones > 0) {
        $color_6m = 'bg-blue'; // Azul si hay resoluciones que vencen en 6 meses
    }

    // Lógica para 3 meses
    if ($proximos_vencer_3m_resoluciones > 0) {
        $color_3m = 'bg-orange'; // Naranja si hay resoluciones que vencen en 3 meses
    }

    // Lógica para 1 mes
    if ($proximos_vencer_1m_resoluciones > 0) {
        $color_1m = 'bg-yellow'; // Amarillo si hay resoluciones que vencen en 1 mes
    }

    // Lógica combinada para 15 días y vencidos
    if ($proximos_vencer_15d_resoluciones > 0 || $vencidos_resoluciones > 0) {
        $color_15d_vencidos = 'bg-red'; // Rojo si hay resoluciones que vencen en 15 días o ya están vencidas
    }
?>





            <div class="content-wrapper">
                <section class="content-header">
                    <?php echo $pagetitle; ?>
                    <?php echo $breadcrumb; ?>
                </section>

                <section class="content">
                    <h2>Alertas de vencimientos de presentacion de Auditorias</h2>
                <div class="row">

                    <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <a href="ruta_a_tu_pagina_de_Resoluciones" class="info-box-icon <?= $color_6m ?>">
                                    <i class="fa fa-balance-scale"></i>
                                </a>
                                <div class="info-box-content">
                                    <span class="info-box-text">6 Meses</span>
                                    <span class="info-box-number">
                                        <?php if ($proximos_vencer_6m_resoluciones > 0 ): ?>
                                            <?= $proximos_vencer_6m_resoluciones; ?> por vencer en 6 meses
                                        <?php else: ?>
                                            No hay resoluciones próximas a vencer.
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <a href="ruta_a_tu_pagina_de_Resoluciones" class="info-box-icon <?= $color_3m ?>" title="Ir a ver las resoluciones">
                                    <i class="fa fa-file-text"></i>
                                </a>
                                <div class="info-box-content">
                                    <span class="info-box-text">3 Meses</span>
                                    <span class="info-box-number">
                                        <?php if ($proximos_vencer_3m_resoluciones > 0): ?>
                                            <?= $proximos_vencer_3m_resoluciones; ?> por vencer en 3 meses
                                        <?php else: ?>
                                            No hay resoluciones próximos a vencer.
                                        <?php endif; ?>
                                    </span>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <div class="info-box">
                                    <span class="info-box-icon <?= $color_1m ?>"><i class="fa fa-file-text"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">1 Mes</span>
                                        <span class="info-box-number">
                                            <?php if ($proximos_vencer_1m_resoluciones > 0): ?>
                                                <?= $proximos_vencer_1m_resoluciones; ?> por vencer en 1 mes
                                            <?php else: ?>
                                                No hay resoluciones próximas a vencer.
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <div class="info-box">
                                    <span class="info-box-icon <?= $color_15d_vencidos ?>"><i class="fa fa-exclamation-triangle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">15 dias o vencidas</span>
                                        <span class="info-box-number">
                                            <?php if ($proximos_vencer_15d_resoluciones > 0 || $vencidos_resoluciones > 0): ?>
                                                <?= $proximos_vencer_15d_resoluciones; ?> por vencer en 15 dias | <?= $vencidos_resoluciones; ?> vencidas
                                            <?php else: ?>
                                                No hay resoluciones próximas a vencer.
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                       
                    <div class="clearfix visible-sm-block"></div>
                        
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-user"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Users</span>
                                    <span class="info-box-number"><?php echo $count_users; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-shield"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Security groups</span>
                                    <span class="info-box-number"><?php echo $count_groups; ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 col-sm-6 col-xs-12">
                            <div class="info-box">
                                <span class="info-box-icon bg-aqua"><i class="fa fa-user"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Clientes Activos</span>
                                    <span class="info-box-number">
                                        24.321
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    

                    <div class="row">
                        <div class="col-md-12">
<?php
/*
if ($url_exist) {
    echo 'OK';
} else {
    echo 'KO';
}
*/
?>
                        </div>

                        <div class="col-md-12">
                            <section class="content-header">
                                <h1>Dashboard de Proyectos</h1>
                            </section>

                            <section class="content">
                                <div class="row">
                                    <!-- Contenedor para los gráficos principales -->
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico de líneas ocupa 6 columnas -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Sector</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="bar-chart" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> <!-- Cierre del row anidado -->
                                            </div>

                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Tipo de Estudio</h3></center>
                            
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="barChart" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        </div>
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Tipo de Impacto Ambiental</h3></center>
                            
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="barChartTipoProyecto" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                            
                                            <div class="col-md-6">
                                                <div class="row">
                                                    <!-- Gráfico Donut 2 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y tipo de estudio</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="line-chart" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>  
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        </div> <!-- Cierre del row principal -->
                                    </div>
                                <div class="col-md-12">
                                    <div class="row">
                                        <!-- Contenedor para los otros dos gráficos -->
                                        <div class="col-md-3">
                                                <div class="row">
                                                    <!-- Gráfico Donut 1 -->
                                                    <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-danger h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Tipos de Estudio</h3></center>
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="pieChart" style="height: 350px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    
                                                </div> <!-- Cierre del row anidado -->
                                            </div>
                                        <div class="col-md-9">
                                            <div class="row">
                                                <!-- Gráfico de líneas ocupa 6 columnas -->
                                                <div class="col-md-12 d-flex align-items-stretch">
                                                        <div class="box box-info h-100">
                                                            <div class="box-header with-border">
                                                                <center><h3 class="box-title">Proyectos por Año y Estados del Proyecto</h3></center>
                            
                                                                <div class="box-tools pull-right">
                                                                    <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-minus"></i></button>
                                                                </div>
                                                            </div>
                                                            <div class="box-body">
                                                                <canvas id="barChartEvaluaciones" style="height: 475px; width: 100%;"></canvas>
                                                            </div>
                                                        </div>
                                                    </div>  
                                            </div> <!-- Cierre del row anidado -->
                                        </div>
                                    </div> <!-- Cierre del row principal -->
                                </div>


                                    <!-- Sección de Recursos alineada debajo de los gráficos -->
                                    <div class="col-md-12">
                                        <div class="box box-primary">
                                            <div class="box-header with-border">
                                                <h3 class="box-title">Resources</h3>
                                            </div>
                                            <div class="box-body">
                                                <div class="progress-group">
                                                    <span class="progress-text">Disk use space</span>
                                                    <span class="progress-number">
                                                        <strong><?php echo byte_format($disk_usespace, 2); ?></strong>/<?php echo byte_format($disk_totalspace, 2); ?>
                                                    </span>
                                                    <div class="progress">
                                                        <div class="progress-bar progress-bar-aqua" role="progressbar" aria-valuenow="<?php echo $disk_usepercent; ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $disk_usepercent; ?>%"></div>
                                                    </div>
                                                </div>
                                                <div class="progress-group">
                                                    <span class="progress-text">Memory usage</span>
                                                    <span class="progress-number">
                                                        <strong><?php echo byte_format($memory_usage, 2); ?></strong>/<?php echo byte_format($memory_peak_usage, 2); ?>
                                                    </span>
                                                    <div class="progress">
                                                        <div class="progress-bar progress-bar-red" role="progressbar" aria-valuenow="<?php echo $memory_usepercent; ?>" aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $memory_usepercent; ?>%"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <!-- Cargar Chart.js antes de ejecutar el script -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<script>
    console.log("El script de la vista se está ejecutando.");
</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        console.log("Cargando el Donut Chart...");

        fetch('http://217.77.14.121/ema/api/proyectos/tipos-estudio')
            .then(response => response.json())
            .then(data => {
                console.log("Datos recibidos para Donut Chart:", data);

                if (!Array.isArray(data) || data.length === 0) {
                    console.warn("No hay datos disponibles para el gráfico.");
                    return;
                }

                let labels = data.map(item => item.tipo_estudio || "Sin Tipo");
                let counts = data.map(item => item.cantidad);
                let colors = labels.map(() => `hsl(${Math.random() * 360}, 70%, 50%)`);

                let ctx = document.getElementById("pieChart").getContext("2d");

                if (!ctx) {
                    console.error("No se encontró el canvas del gráfico.");
                    return;
                }

                new Chart(ctx, {
                    type: "pie",
                    data: {
                        labels: labels,
                        datasets: [{
                            data: counts,
                            backgroundColor: colors,
                        }]
                    },
                    options: {
                        responsive: true,
                        plugins: {
                            legend: { position: "bottom" }
                        }
                    }
                });

            })
            .catch(error => console.error("Error en la petición:", error));
    });
</script>
<script>
   document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico se está ejecutando.");

    
    fetch('http://217.77.14.121/ema/Chart/get_sales_data_by_state')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            
            let labels = data.map(item => item.year + ' - ' + item.estado_nombre); 
            let counts = data.map(item => parseInt(item.total)); 

            console.log("Labels:", labels);
            console.log("Counts:", counts);

            let ctx = document.getElementById("line-chart");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "line",  
                data: {
                    labels: labels,
                    datasets: [{
                        label: "Proyectos por Año y Estado",
                        data: counts,
                        borderColor: "rgba(60, 141, 188, 1)",  
                        backgroundColor: "rgba(60, 141, 188, 0.2)",  
                        fill: true,
                        tension: 0.4  
                    }]
                },
                options: {
                    responsive: true,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true  
                            }
                        }]
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        console.log("Cargando Chart - Estados...");

        setTimeout(() => {
            fetch('http://217.77.14.121/ema/api/proyectos/tipo_estidio')
                .then(response => response.json())
                .then(data => {
                    console.log("Datos recibidos para Bar Chart - Estados:", data);

                    if (!Array.isArray(data) || data.length === 0) {
                        console.warn("No hay datos disponibles para el gráfico.");
                        return;
                    }

                    let labels = data.map((item, index) => `${index + 1}- ${item.estado || "Desconocido"}`);
                    let counts = data.map(item => item.total);
                    let colors = "#3b82f6"; 

                    let ctx = document.getElementById("donutEstadosChart").getContext("2d");

                    if (!ctx) {
                        console.error("No se encontró el canvas del gráfico de estados.");
                        return;
                    }

                    
                    if (window.barChartEstados instanceof Chart) {
                        window.barChartEstados.destroy();
                    }

                    
                    window.barChartEstados = new Chart(ctx, {
                        type: "bar",
                        data: {
                            labels: labels,
                            datasets: [{
                                label: "Total",
                                data: counts,
                                backgroundColor: colors,
                                borderColor: "#1e3a8a",
                                borderWidth: 1
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: { position: "right" },
                                tooltip: {
                                    callbacks: {
                                        label: function (tooltipItem) {
                                            return `${tooltipItem.label}: ${tooltipItem.raw}`;
                                        }
                                    }
                                }
                            },
                            scales: {
                                x: {
                                    ticks: {
                                        autoSkip: false,
                                        maxRotation: 30,
                                        minRotation: 0
                                    }
                                },
                                y: {
                                    beginAtZero: true,
                                    ticks: {
                                        stepSize: 1
                                    }
                                }
                            }
                        }
                    });

                    console.log("Gráfico generado con éxito.");

                })
                .catch(error => console.error("Error en la petición de Estados:", error));
        }, 500);
    });
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico se está ejecutando.");

    fetch('http://217.77.14.121/ema/Chart/get_sales_data')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            let labels = [];  
            let datasets = [];  

            
            let colors = [
                "rgba(255, 99, 132, 1)", 
                "rgba(54, 162, 235, 1)", 
                "rgba(255, 206, 86, 1)", 
                "rgba(75, 192, 192, 1)", 
                "rgba(153, 102, 255, 1)", 
                "rgba(255, 159, 64, 1)", 
                "rgba(201, 203, 207, 1)"  
            ];

            let colorIndex = 0;

            
            data.forEach(item => {
                
                item.year.forEach(year => {
                    if (!labels.includes(year)) {
                        labels.push(year);
                    }
                });

                let borderColor = colors[colorIndex % colors.length]; 
                let backgroundColor = borderColor.replace("1)", "0.2)"); 

                datasets.push({
                    label: item.label,  
                    data: item.data,    
                    borderColor: borderColor,
                    backgroundColor: backgroundColor,
                    fill: true,
                    tension: 0.4
                });

                colorIndex++; 
            });

            let ctx = document.getElementById("line-chart2");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            
            new Chart(ctx, {
                type: "line",
                data: {
                    labels: labels,  
                    datasets: datasets 
                },
                options: {
                    responsive: true,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("El script del gráfico de barras se está ejecutando.");

    fetch('http://217.77.14.121/ema/Chart/sector_proyecto')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos desde la API:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos para mostrar en el gráfico.");
                return;
            }

            let labels = [];  
            let datasets = [];  
            
            let colors = [
                "rgba(255, 99, 132, 0.8)", 
                "rgba(54, 162, 235, 0.8)", 
                "rgba(255, 206, 86, 0.8)", 
                "rgba(75, 192, 192, 0.8)", 
                "rgba(153, 102, 255, 0.8)", 
                "rgba(255, 159, 64, 0.8)", 
                "rgba(201, 203, 207, 0.8)"  
            ];

            let borderColors = colors.map(color => color.replace("0.8", "1"));  

            let colorIndex = 0;

            data.forEach(item => {
                item.year.forEach(year => {
                    if (!labels.includes(year)) {
                        labels.push(year);
                    }
                });

                datasets.push({
                    label: item.label,  
                    data: item.data,    
                    backgroundColor: colors[colorIndex % colors.length],  
                    borderColor: borderColors[colorIndex % borderColors.length], 
                    borderWidth: 1
                });

                colorIndex++; 
            });

            let ctx = document.getElementById("bar-chart").getContext("2d");

            if (!ctx) {
                console.error("No se encontró el canvas para el gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: labels,  
                    datasets: datasets 
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    },
                    scales: {
                        x: {
                            beginAtZero: true
                        },
                        y: {
                            beginAtZero: true
                        }
                    }
                }
            });
        })
        .catch(error => console.error("Error en la petición:", error));
});
</script>
<script>
document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Tipos de Estudio...");

    fetch('http://217.77.14.121/ema/Chart/tipo_estudio')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let allYears = [];
            let datasets = [];

            
            data.forEach(d => {
                if (d.years) {
                    d.years.forEach(year => {
                        if (!allYears.includes(year)) {
                            allYears.push(year);
                        }
                    });
                }
            });

            allYears.sort((a, b) => a - b); 

            data.forEach((item, index) => {
                let dataValues = allYears.map(year => {
                    let yearIndex = item.years.indexOf(year);
                    return yearIndex !== -1 ? item.data[yearIndex] : 0;
                });

                datasets.push({
                    label: item.label || "Desconocido",
                    data: dataValues,
                    backgroundColor: `hsl(${index * 40}, 70%, 50%)`,
                    borderColor: `hsl(${index * 40}, 70%, 30%)`,
                    borderWidth: 1
                });
            });

            let ctx = document.getElementById("barChart");

            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: allYears,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Tipo de Proyecto...");

    fetch('http://217.77.14.121/ema/Chart/get_tipo_proyecto_data')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let allYears = [];
            let datasets = [];

          
            data.forEach(d => {
                if (d.years) {
                    d.years.forEach(year => {
                        if (!allYears.includes(year)) {
                            allYears.push(year);
                        }
                    });
                }
            });

            allYears.sort((a, b) => a - b); 

            data.forEach((item, index) => {
                let dataValues = allYears.map(year => {
                    let yearIndex = item.years.indexOf(year);
                    return yearIndex !== -1 ? item.data[yearIndex] : 0;
                });

                datasets.push({
                    label: item.label || "Desconocido",
                    data: dataValues,
                    backgroundColor: `hsl(${index * 40}, 70%, 50%)`,
                    borderColor: `hsl(${index * 40}, 70%, 30%)`,
                    borderWidth: 1
                });
            });

            let ctx = document.getElementById("barChartTipoProyecto");

            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: allYears,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico de Tipo de Proyecto generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
});

</script>
<script>
    document.addEventListener("DOMContentLoaded", function () {
    console.log("Cargando gráfico de Evaluaciones de Proyectos...");

    fetch('http://217.77.14.121/ema/Chart/get_proyectos_evaluaciones_data')
        .then(response => response.json())
        .then(data => {
            console.log("Datos recibidos:", data);

            if (!Array.isArray(data) || data.length === 0) {
                console.warn("No hay datos disponibles para el gráfico.");
                return;
            }

            let allYears = [];
            let categories = {};
            
            
            const estadosFiltrados = ["aprobado", "presentado"];

            data.forEach(d => {
                if (!categories[d.label]) {
                    categories[d.label] = {
                        label: d.label,
                        data: {},
                        backgroundColor: `hsl(${Object.keys(categories).length * 40}, 70%, 50%)`,
                        borderColor: `hsl(${Object.keys(categories).length * 40}, 70%, 30%)`,
                        borderWidth: 1
                    };
                }

                d.years.forEach((year, index) => {
                    let estado = d.estados[index];

                    
                    if (estadosFiltrados.includes(estado)) {
                        if (!allYears.includes(year)) {
                            allYears.push(year);
                        }

                        let key = `${year}-${estado}`;
                        categories[d.label].data[key] = d.data[index];
                    }
                });
            });

            allYears.sort((a, b) => a - b);

            let estadosUnicos = [...new Set(data.flatMap(d => d.estados))].filter(estado => estadosFiltrados.includes(estado));

            let datasets = [];
            
            Object.values(categories).forEach(cat => {
                estadosUnicos.forEach(estado => {
                    let dataValues = allYears.map(year => cat.data[`${year}-${estado}`] || 0);
                    datasets.push({
                        label: `${cat.label} - ${estado}`,
                        data: dataValues,
                        backgroundColor: cat.backgroundColor,
                        borderColor: cat.borderColor,
                        borderWidth: 1
                    });
                });
            });

            let ctx = document.getElementById("barChartEvaluaciones");

            if (!ctx) {
                console.error("No se encontró el canvas del gráfico.");
                return;
            }

            new Chart(ctx, {
                type: "bar",
                data: {
                    labels: allYears,
                    datasets: datasets
                },
                options: {
                    responsive: true,
                    scales: {
                        y: {
                            beginAtZero: true
                        }
                    },
                    plugins: {
                        legend: {
                            position: "top"
                        }
                    }
                }
            });

            console.log("Gráfico de Evaluaciones de Proyectos generado correctamente.");
        })
        .catch(error => console.error("Error en la petición:", error));
    });

</script>






