-- DROP VIEW bya.v_resumen_uso86;

CREATE OR REPLACE VIEW bya.v_resumen_uso86
 AS
 SELECT t.id_colonia,
    u.uso,
    t.categorias,
    count(*) AS cantidad
   FROM bya.uso86 t
     LEFT JOIN bya.usos u ON u.nombre_uso::text = t.categorias::text
  GROUP BY t.id_colonia, u.uso, t.categorias
  ORDER BY t.id_colonia, u.uso, t.categorias;

ALTER TABLE bya.v_resumen_uso86
    OWNER TO postgres;

-- DROP VIEW bya.v_uso86;

CREATE OR REPLACE VIEW bya.v_uso86
 AS
 SELECT uso86.gid,
    uso86.objectid,
    uso86.proyecto,
    uso86.propiet,
    uso86.dpto,
    uso86.dist,
    uso86.lugar,
    uso86.bloque,
    uso86.uso,
    uso86.categorias,
    uso86.superf_ha,
    uso86.area_m2,
    st_transform(st_setsrid(uso86.geom, 32721), 32720) AS geom
   FROM bya.uso86;

ALTER TABLE bya.v_uso86
    OWNER TO postgres;


-- DROP VIEW bya.v_uso86_t;

CREATE OR REPLACE VIEW bya.v_uso86_t
 AS
 SELECT uso86.gid,
    uso86.objectid,
    uso86.proyecto,
    uso86.propiet,
    uso86.dpto,
    uso86.dist,
    uso86.lugar,
    uso86.bloque,
    uso86.uso,
    uso86.categorias,
    uso86.superf_ha,
    uso86.area_m2,
    st_setsrid(uso86.geom, 32721) AS geom
   FROM bya.uso86;

ALTER TABLE bya.v_uso86_t
    OWNER TO postgres;

-- DROP VIEW i3geo.v_aldeas_uso86_p1;

CREATE OR REPLACE VIEW i3geo.v_aldeas_uso86_p1
 AS
 SELECT st_transform(st_setsrid(i.g_intersec, 32721), 4326) AS the_geom,
    i.objectid_par,
    i.objectid,
    i.categorias,
    i.uso,
    i.localidad,
    st_area(i.g_intersec) AS area
   FROM ( SELECT a.objectid AS objectid_par,
            b.objectid,
            b.categorias,
            b.uso,
            a.localidad,
            st_intersection(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision)) AS g_intersec
           FROM bya.aldeas a,
            bya.uso86 b
          WHERE st_intersects(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision))) i
  WHERE st_area(i.g_intersec) > 0::double precision;

ALTER TABLE i3geo.v_aldeas_uso86_p1
    OWNER TO postgres;


-- DROP VIEW i3geo.v_bloques_uso86_p1;

CREATE OR REPLACE VIEW i3geo.v_bloques_uso86_p1
 AS
 SELECT st_transform(st_setsrid(i.g_intersec, 32721), 4326) AS the_geom,
    i.objectid_par,
    i.objectid,
    i.categorias,
    i.uso,
    i.nombre,
    st_area(i.g_intersec) AS area
   FROM ( SELECT a.objectid AS objectid_par,
            b.objectid,
            b.categorias,
            b.uso,
            a.nombre,
            st_intersection(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision)) AS g_intersec
           FROM bya.bloques a,
            bya.uso86 b
          WHERE st_intersects(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision))) i
  WHERE st_area(i.g_intersec) > 0::double precision;

ALTER TABLE i3geo.v_bloques_uso86_p1
    OWNER TO postgres;


-- DROP VIEW i3geo.v_uso86_p1;

CREATE OR REPLACE VIEW i3geo.v_uso86_p1
 AS
 SELECT st_transform(st_setsrid(i.g_intersec, 32721), 4326) AS the_geom,
    i.objectid_par,
    i.objectid,
    i.categorias,
    i.uso,
    i.lote_n,
    st_area(i.g_intersec) AS area
   FROM ( SELECT a.objectid AS objectid_par,
            b.objectid,
            b.categorias,
            b.uso,
            a.lote_n,
            st_intersection(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision)) AS g_intersec
           FROM bya.parcelas a,
            bya.uso86 b
          WHERE st_intersects(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision))) i
  WHERE st_area(i.g_intersec) > 0::double precision;

ALTER TABLE i3geo.v_uso86_p1
    OWNER TO postgres;


-- DROP VIEW i3geo.v_uso86_p2;

CREATE OR REPLACE VIEW i3geo.v_uso86_p2
 AS
 SELECT st_setsrid(i.g_intersec, 32721) AS geom,
    i.objectid_par,
    i.objectid,
    i.categorias,
    i.uso,
    i.lote_n,
    i.id_colonia,
    st_area(i.g_intersec) AS area
   FROM ( SELECT a.objectid AS objectid_par,
            b.objectid,
            b.categorias,
            b.uso,
            a.lote_n,
            a.id_colonia,
            st_intersection(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision)) AS g_intersec
           FROM bya.parcelas a,
            bya.uso86 b
          WHERE st_intersects(st_snaptogrid(st_setsrid(a.geom, 32721), 0.001::double precision), st_snaptogrid(st_setsrid(b.geom, 32721), 0.001::double precision))) i
  WHERE st_area(i.g_intersec) > 0::double precision;

ALTER TABLE i3geo.v_uso86_p2
    OWNER TO postgres;


    