<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class finca_mapas_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
	
	/**
	 * finca_mapas
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view_all($tabla, $where = NULL)
	{
		$this->trigger_events('finca_mapas');

		// run each where that was passed
		
		$this->response = $this->db->get_where($this->tables[$tabla], $where)->num_rows();
		
		return $this;
	}


	public function concepto ($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
	{
		$query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

		if ($i_concepto == TRUE) {
			$query = $query . " AND CONCEPTO = '" . $i_concepto . "'";
		}

		if ($blanco == TRUE) {
			$query = $query . " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
		}
		if ($orderby) {
			$query = $query . " ORDER BY ".$orderby;
		}
		$this->response = $this->db->query($query);

		$_SESSION['last_query'] = $this->db->last_query();

		return $this;
	}

	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}


	/**
	 * finca_mapas
	 *
	 * @return object
	 * @author Jaime Rojas
	 **/

	public function view($tabla, $where = NULL)
	{
		$this->trigger_events('proyectos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);
		
		return $this;
	}

	/**
	 * create finca_mapas
	 *
	 * @author Jaime Rojas
	*/
	public function create_finca_mapas($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existing_proponente = $this->db->get_where($this->tables['finca_mapas'], $arraycampos)->num_rows();

		
		if($existing_proponente !== 0)
		{
			$this->ion_auth->set_error('finca_mapas_already_exists');
			return FALSE;
		}
		
		// insert the new group
		$this->db->insert($this->tables['finca_mapas'], $arraycampos);
		$finca_mapas_gid = $this->db->insert_id();

		// report success
		$this->set_message('finca_mapas_creation_successful');
		// return the brand new group id
		return $finca_mapas_gid;
	}

	
	
	/**
	 * update_finca_mapas
	 *
	 * @return bool
	 * @author Jaime Rojas
	 **/

    public function update_finca_mapas($proponente, $arraycampos)
	{
		$this->db->update($this->tables['finca_mapas'], $arraycampos, array('id_proponente' => $proponente));

        $this->ion_auth->set_message('finca_mapas_update_successful');

        return TRUE;
	}

//		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;


	/**
	 * eliminar_finca_mapas
	 * cuenta registros espaciales dependientes de finca_mapas.
	 * @return integer 
	 * @author Jaime Rojas Landivar
	 **/
    public function cnt_finca_mapas_reg_layers($proponente = null)
	{
		$total =  0; 
        $sq = "select sum(x.cnt) as total from (
        select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = ".$proponente." 
		) x;     
         ";

        //union select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = '".$proponente."' 
        //union select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = '".$proponente."'          

		$total = $this->db->query($sq)->row()->total;
		return $total; 
	}

	/**
	 * eliminar_finca_mapas
	 * elimina dependientes de la tabla finca_mapas
	 * @return bool
	 * @author Jaime Rojas Landivar
	 **/
    public function eliminar_finca_mapas($proponente)
	{
		$resultado =  true; 
        $sq = "select sum(x.cnt) as total from (
        select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = ".$proponente." 

		) x;     
         ";

        //union select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = '".$proponente."' 
        //union select 'Proyectos' tabla, count(*) cnt from ema.proyectos where id_proponente = '".$proponente."' 
         
		$total = $this->db->query($sq)->row()->total;

		if ($total == 0) {
			$sq = "delete from ema.finca_mapas where id_proponente = '".$proponente."';";			
			$del = $this->db->query($sq);
			$sq = "select count(*) as total from ema.finca_mapas where id_proponente = '".$proponente."'";
			$total = $this->db->query($sq)->row()->total;	
			if ($total == 0) {
				$resultado = true;
			}else{
				$resultado = false;
			}			

		}else{
			$resultado = false;
		}
		return $resultado; 
	}

	/*
	 * delete finca_mapas
	 * elimina finca_mapas 
	 * @return bool
	 * @author Jaime Rojas Lndivar
    */

    public function delete($tabla, $where)
	{
		$this->db->delete($this->tables[$tabla], $where);

        return TRUE;
	}


	public function f_existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT SEAM_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");")->row()->f_existe_grafico;

		return $resultado;
	}



	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros_all ($tabla = NULL)
	{

		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * eliminar_datos_tabla
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_datos_tabla($tabla = NULL)
	{
		
		$resultado = $this->db->query("SELECT ema.f_eliminar_datos_tabla('".$tabla."');");

		return $resultado;
	}
	

	/**
	 * actualizar_categorias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_categorias($i_colonia = NULL)
	{
		//$resultado = 0;
		/* Provoca un error -- sintaxis SQL falsa */
		$i_sql = "SELECT ema.actualizar_categorias('PROPONENTE_ALTERNATIVO',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query
		//$i_sql = "SELECT ema.actualizar_categorias(".$i_colonia.",'PROPONENTE_ACTUAL');";
		//$resultado = $this->db->query($i_sql); //run query		

		return $resultado;
	}	



	/**
	 * actualizar_finca_mapas
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_finca_mapas($i_tabla = NULL, $i_colonia = NULL)
	{
		$i_sql = "SELECT ema.actualizar_finca_mapas('".$i_tabla."',".$i_colonia.");";
		$resultado = $this->db->query($i_sql); //run query	
		return $resultado;
	}




	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas Landivar
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}
	

}