<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cliente_model extends CI_Model
{
    
    public function get_clientes($filters = [], $limit = 10, $offset = 0)
    {
        if (!empty($filters['cedularuc'])) {
            $this->db->like('cast(cedularuc as varchar)', $filters['cedularuc']);
        }
        if (!empty($filters['nombre'])) {
            $this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
        }
        if (!empty($filters['apellido'])) {
            $this->db->like('LOWER(apellido)', strtolower($filters['apellido']));
        }
        if (!empty($filters['email'])) {
            $this->db->like('LOWER(email)', strtolower($filters['email']));
        }
        if (!empty($filters['id_cliente'])) {
            $this->db->where('id_cliente', $filters['id_cliente']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        return $this->db->get('ema.cliente', $limit, $offset)->result_array();
    }

    public function count_clientes($filters = [])
    {
        if (!empty($filters['cedularuc'])) {
            $this->db->where('cedularuc', $filters['cedularuc']);
        }
        if (!empty($filters['nombre'])) {
            $this->db->like('LOWER(nombre)', strtolower($filters['nombre']));
        }
        if (!empty($filters['apellido'])) {
            $this->db->like('LOWER(apellido)', strtolower($filters['apellido']));
        }
        if (!empty($filters['email'])) {
            $this->db->like('LOWER(email)', strtolower($filters['email']));
        }
        if (!empty($filters['id_cliente'])) {
            $this->db->where('id_cliente', $filters['id_cliente']); // Asumo que es numérico, por lo que no necesita ajuste.
        }
        return $this->db->count_all_results('ema.cliente');
    }

    public function get_cliente($id)
    {
        return $this->db->get_where('ema.cliente', ['id_cliente' => $id])->row_array();
    }

    public function insert_cliente($data)
    {
        return $this->db->insert('ema.cliente', $data);
    }

    public function update_cliente($id, $data)
    {
        $this->db->where('id_cliente', $id);
        return $this->db->update('ema.cliente', $data);
    }

    public function delete_cliente($id)
    {
        $this->db->where('id_cliente', $id);
        return $this->db->delete('ema.cliente');
    }

    public function concepto($i_tipoconcepto, $blanco = FALSE, $orderby = FALSE, $i_concepto = FALSE)
    {
        $query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM public.CONCEPTOS WHERE TIPOCONCEPTO = '".$i_tipoconcepto."'";

        if ($i_concepto == TRUE) {
            $query .= " AND CONCEPTO = '" . $i_concepto . "'";
        }

        if ($blanco == TRUE) {
            $query .= " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
        }
        if ($orderby) {
            $query .= " ORDER BY ".$orderby;
        }

        // Ejecutar la consulta
        $result = $this->db->query($query);

        // Registrar la última consulta
        $_SESSION['last_query'] = $this->db->last_query();

        // Devolver el resultado como un arreglo
        return $result->result_array();
    }
}