<?php
class Distritos_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function get_distritos($filters = [], $limit = 10, $offset = 0) {
        if (!empty($filters)) {
            if (!empty($filters['id'])) {
                $this->db->where('id', $filters['id']);
            }
            if (!empty($filters['cod_snc'])) {
                $this->db->where('cod_snc', $filters['cod_snc']);
            }
            if (!empty($filters['nombre_dis_snc'])) {
                $this->db->like('nombre_dis_snc', $filters['nombre_dis_snc']);
            }
            if (!empty($filters['dpto'])) {
                $this->db->where('dpto', $filters['dpto']);
            }
            if (!empty($filters['distrito'])) {
                $this->db->where('distrito', $filters['distrito']);
            }
        }

        $this->db->limit($limit, $offset);
        return $this->db->get('ide.distritos')->result();
    }

    public function count_distritos($filters = []) {
        if (!empty($filters['id'])) {
            $this->db->where('id', $filters['id']);
        }
        if (!empty($filters['cod_snc'])) {
            $this->db->where('cod_snc', $filters['cod_snc']);
        }
        if (!empty($filters['nombre_dis_snc'])) {
            $this->db->like('nombre_dis_snc', $filters['nombre_dis_snc']);
        }
        if (!empty($filters['dpto'])) {
            $this->db->where('dpto', $filters['dpto']);
        }
        if (!empty($filters['distrito'])) {
            $this->db->where('distrito', $filters['distrito']);
        }

        return $this->db->count_all_results('ide.distritos');
    }

    public function get_distrito_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get('ide.distritos')->row_array();
    }

    public function create_distrito($data) {
        return $this->db->insert('ide.distritos', $data);
    }

    public function update_distrito($id, $data) {
        return $this->db->where('id', $id)->update('ide.distritos', $data);
    }

    public function delete_distrito($id) {
        return $this->db->where('id', $id)->delete('ide.distritos');
    }

    public function get_distritos_by_dpto($dpto) {
        $this->db->select('id, dist_desc');
        $this->db->where('dpto', $dpto);
        $this->db->order_by('dist_desc', 'ASC');
        return $this->db->get('ide.distritos')->result_array();
    }
    
}
?>
