<?php
class Barloc_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function get_barlocs($filters = [], $limit = 10, $offset = 0) {
        if (!empty($filters)) {
            if (!empty($filters['id'])) {
                $this->db->where('id', $filters['id']);
            }
            if (!empty($filters['dpto'])) {
                $this->db->where('dpto', $filters['dpto']);
            }
            if (!empty($filters['distrito'])) {
                $this->db->where('distrito', $filters['distrito']);
            }
            if (!empty($filters['bar_loc'])) {
                $this->db->where('bar_loc', $filters['bar_loc']);
            }
            if (!empty($filters['barlo_desc'])) {
                $this->db->like('barlo_desc', $filters['barlo_desc']);
            }
        }

        $this->db->limit($limit, $offset);
        return $this->db->get('ide.barloc')->result();
    }

    public function count_barlocs($filters = []) {
        if (!empty($filters['id'])) {
            $this->db->where('id', $filters['id']);
        }
        if (!empty($filters['dpto'])) {
            $this->db->where('dpto', $filters['dpto']);
        }
        if (!empty($filters['distrito'])) {
            $this->db->where('distrito', $filters['distrito']);
        }
        if (!empty($filters['bar_loc'])) {
            $this->db->where('bar_loc', $filters['bar_loc']);
        }
        if (!empty($filters['barlo_desc'])) {
            $this->db->like('barlo_desc', $filters['barlo_desc']);
        }

        return $this->db->count_all_results('ide.barloc');
    }

    public function get_barloc_by_id($id) {
        $this->db->where('id', $id);
        return $this->db->get('ide.barloc')->row_array();
    }

    public function create_barloc($data) {
        return $this->db->insert('ide.barloc', $data);
    }

    public function update_barloc($id, $data) {
        return $this->db->where('id', $id)->update('ide.barloc', $data);
    }

    public function delete_barloc($id) {
        return $this->db->where('id', $id)->delete('ide.barloc');
    }

    public function get_barloc_by_distrito($distrito) {
        $this->db->select('id, barlo_desc');
        $this->db->where('distrito', $distrito);
        $this->db->order_by('barlo_desc', 'ASC');
        return $this->db->get('ide.barloc')->result_array();
    }
    
}
?>
