<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Resoluciones extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Resoluciones_model');
        $this->load->helper('url');
        $this->load->library('pagination');
    }

    public function index($id_proyecto=NULL) {
        $filters = $this->input->get(); // Obtener filtros desde GET
        $filters['id_proyecto'] = $id_proyecto;
        $config['base_url'] = site_url('resoluciones/index' . $id_proyecto . '?' . http_build_query($filters));      
        $config['total_rows'] = $this->Resoluciones_model->count_resoluciones($filters);
        $config['per_page'] = 10;
        //$data['resoluciones'] = $this->Resoluciones_model->get_resoluciones($filters);

        $this->pagination->initialize($config);
        $nombre_proyecto = $this->Resoluciones_model->get_proyecto_nombre($id_proyecto);
        $data['resoluciones'] = $this->Resoluciones_model->get_resoluciones($filters, $config['per_page'], $this->uri->segment(4));
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['id_proyecto'] = $id_proyecto;
        $data['nombre_proyecto'] = $nombre_proyecto; 
       //$this->load->view('resoluciones/index', $data);
        $this->template->admin_render('resoluciones/index', array_merge($data, $this->data));
    }

    public function create($id_proyecto=NULL) {
    // Inicializar la variable declaraciones antes de la validación
    $where = [];
    if (!empty($id_proyecto)) {
        $where['id_proyecto'] = $id_proyecto; // Agregar filtro por id_proyecto
    }
    $a_declaraciones[''] = 'Seleccione la Declaracion';
    $d_declaraciones = $this->Resoluciones_model->dropdown_data('ema.declaraciones'); // Obtener datos de la BD
    
    foreach ($d_declaraciones as $r_declaracion) {
        $a_declaraciones[$r_declaracion['id_declaracion']] = $r_declaracion['id_declaracion'] . ' - ' . $r_declaracion['observacion'];
    }
    
    $this->data['declaraciones'] = $a_declaraciones;
    
    // Reglas de validación
    $this->form_validation->set_rules('id_declaracion', 'ID Declaración', 'required|numeric');
    $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
    $this->form_validation->set_rules('nro_resolucion', 'Número de Resolución', 'required|numeric|max_length[6]');
    $this->form_validation->set_rules('gestion_resolucion', 'Gestión Resolución', 'required|numeric|max_length[4]');
    $this->form_validation->set_rules('fecha_resolucion', 'Fecha Resolución', 'required');
    $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento AA');
    $this->form_validation->set_rules('estado', 'Estado', 'required|in_list[A,I]');
    $this->form_validation->set_rules('observacion', 'Observación', 'max_length[10000]');
    $this->form_validation->set_rules('sup_legal', 'Superficie Legal', 'numeric');

    // Ejecutar validación
    if ($this->form_validation->run() === FALSE) {
        // Si la validación falla, carga la vista con los errores
        $this->data['id_proyecto']  = $id_proyecto;
        $this->template->admin_render('resoluciones/create', array_merge($this->data));
    } else {
        // Si la validación pasa, guarda la resolución
        $data = [
            'id_declaracion' => $this->input->post('id_declaracion'),
            'id_proyecto' => $this->input->post('id_proyecto'),
            'nro_resolucion' => $this->input->post('nro_resolucion'),
            'gestion_resolucion' => $this->input->post('gestion_resolucion'),
            'fecha_resolucion' => $this->input->post('fecha_resolucion'),
            'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa'),
            'estado' => $this->input->post('estado'),
            'observacion' => $this->input->post('observacion'),
            'sup_legal' => $this->input->post('sup_legal'),
        ];

        // Insertar datos en la base de datos
        $this->Resoluciones_model->create_resolucion($data);
        redirect('resoluciones/index/'. $id_proyecto);
    }
}

    

    public function edit($id, $id_proyecto = NULL)
{
    // Obtener datos de la resolución por ID
    $data['resolucion'] = $this->Resoluciones_model->get_resolucion_by_id($id);

    if (!$data['resolucion']) {
        show_404(); // Si la resolución no existe, muestra un error
    }

    // Reglas de validación del formulario
    $this->form_validation->set_rules('id_declaracion', 'ID Declaración', 'required|numeric');
    $this->form_validation->set_rules('id_proyecto', 'ID Proyecto', 'required|numeric');
    $this->form_validation->set_rules('nro_resolucion', 'Número de Resolución', 'required|numeric|max_length[6]');
    $this->form_validation->set_rules('gestion_resolucion', 'Gestión Resolución', 'required|numeric|max_length[4]');
    $this->form_validation->set_rules('fecha_resolucion', 'Fecha Resolución', 'required');
    $this->form_validation->set_rules('fecha_prox_vto_aa', 'Fecha Próximo Vencimiento AA', 'required');
    $this->form_validation->set_rules('estado', 'Estado', 'required|in_list[A,I]');
    $this->form_validation->set_rules('observacion', 'Observación', 'max_length[10000]');

    if ($this->form_validation->run() === FALSE) {
        $this->data['lang'] = $this->lang->load('resoluciones/resoluciones', 'spanish');
        $this->template->admin_render('resoluciones/edit', array_merge($data, $this->data));
    } else {
        // Preparar los datos para actualizar
        $datos_actualizados = [
            'id_declaracion' => $this->input->post('id_declaracion') ?: null,
            'id_proyecto' => $this->input->post('id_proyecto') ?: null,
            'nro_resolucion' => $this->input->post('nro_resolucion') ?: null,
            'gestion_resolucion' => $this->input->post('gestion_resolucion') ?: null,
            'fecha_resolucion' => $this->input->post('fecha_resolucion') ?: null,
            'fecha_prox_vto_aa' => $this->input->post('fecha_prox_vto_aa') ?: null,
            'estado' => $this->input->post('estado') ?: null,
            'observacion' => $this->input->post('observacion') ?: null,
        ];

        // Log para depurar los datos enviados
        log_message('debug', 'Datos actualizados: ' . print_r($datos_actualizados, true));

        // Actualizar la resolución en la base de datos
        if ($this->Resoluciones_model->update_resolucion($id, $datos_actualizados)) {
            $this->session->set_flashdata('message', 'Resolución actualizada correctamente.');
            redirect('resoluciones/index/'.$id_proyecto);
        } else {
            log_message('error', 'Error al actualizar la resolución con ID: ' . $id);
            $this->session->set_flashdata('error', 'Error al actualizar la resolución.');
            redirect('resoluciones/edit/' . $id);
        }
    }
}


    public function delete($id,$id_proyecto=NULL) {
        $this->Resoluciones_model->delete_resolucion($id);
        redirect('resoluciones/index/'.$id_proyecto);
    }
}
