<?php
// application/controllers/Tumba.php

defined('BASEPATH') OR exit('No direct script access allowed');

class Tumba extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Tumba_model');
        $this->load->helper(array('form', 'url'));
        $this->load->library('upload');
    }

    // Cargar vista principal
    public function index() {
        $data['files'] = $this->Tumba_model->get_files_by_project(1); // Cambia el ID según el proyecto
        $this->load->view('tumba_view', $data);
    }

    // Subir archivos
    public function upload_file() {
        $config['upload_path']   = './uploads/';
        $config['allowed_types'] = 'pdf|xls|xlsx|doc|docx|jpg|jpeg|png|gif';
        $config['max_size']      = 131072; // 128 MB en KB
    
        // Crea el directorio si no existe
        if (!is_dir($config['upload_path'])) {
            mkdir($config['upload_path'], 0777, true);
        }
    
        $this->load->library('upload');
        $this->upload->initialize($config);
    
        $files = $_FILES;
        $count = count($_FILES['documento']['name']);
    
        for ($i = 0; $i < $count; $i++) {
            $_FILES['documento']['name']     = $files['documento']['name'][$i];
            $_FILES['documento']['type']     = $files['documento']['type'][$i];
            $_FILES['documento']['tmp_name'] = $files['documento']['tmp_name'][$i];
            $_FILES['documento']['error']    = $files['documento']['error'][$i];
            $_FILES['documento']['size']     = $files['documento']['size'][$i];
    
            if ($this->upload->do_upload('documento')) {
                $fileData = $this->upload->data();
                $data = array(
                    'id_proyecto'    => $this->input->post('id_proyecto'),
                    'tipo_documento' => $fileData['file_type'],
                    'url'            => base_url('uploads/' . $fileData['file_name']),
                    'estado'         => 1
                );
                $this->Tumba_model->insert_file($data);
            } else {
                $error = $this->upload->display_errors();
                $this->session->set_flashdata('error', 'Error al subir archivo: ' . $error);
                log_message('error', 'Error al subir archivo: ' . $error);
                redirect('tumba');
            }
        }
    
        $this->session->set_flashdata('success', '✅ Archivos subidos correctamente.');
        redirect('tumba');
    }
    

    // Eliminar archivo
    public function delete_file($id_archivo) {
        if ($this->Tumba_model->delete_file($id_archivo)) {
            $this->session->set_flashdata('success', 'Archivo eliminado correctamente.');
        } else {
            $this->session->set_flashdata('error', 'No se pudo eliminar el archivo.');
        }
        redirect('tumba');
    }
}
