<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Proyectos_evaluaciones extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Proyectos_evaluaciones_model');
        $this->load->library(['pagination', 'form_validation']);
    }

    public function index($id_proyecto = NULL) {
        $filters = $this->input->get();
        $filters['proyecto_id'] = $id_proyecto;

        $config['base_url'] = site_url('proyectos_evaluaciones/index/' . $id_proyecto) . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Proyectos_evaluaciones_model->count_proyectos_evaluaciones($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);
        $offset = (int) $this->input->get('per_page', TRUE);
        if ($offset < 0) {
            $offset = 0;
        }

        $data['proyectos_evaluaciones'] = $this->Proyectos_evaluaciones_model->get_proyectos_evaluaciones($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['proyecto_id'] = $id_proyecto;

        // Agregar título dinámico
        $data['pagetitle'] = 'Evaluaciones del Proyecto ' . ($id_proyecto ? "#$id_proyecto" : '');

        $this->template->admin_render('proyectos_evaluaciones/index', array_merge($data, $this->data));
    }

    

    public function create($id_proyecto = NULL) 
    {
        // Definir dropdown_estados por defecto
        $estados = $this->Proyectos_evaluaciones_model->concepto('PROYECTO_ESTADO', false, 'CONCEPTO');
        $dropdown_estados = ['' => 'Seleccione un Estado'];
        foreach ($estados as $estado) {
            $dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
        }        
    
        if ($this->input->post()) {
            $this->form_validation->set_rules('categoria', 'Categoría', 'required');
            
            $data['dropdown_estados'] = $dropdown_estados;
            
            if ($this->form_validation->run() === FALSE) {
                $this->data['id_proyecto'] = $id_proyecto;
                $this->template->admin_render('proyectos_evaluaciones/create', $this->data);
            } else {
                $data_insert = [
                    'proyecto_id'   => $id_proyecto ?: $this->input->post('proyecto_id'),
                    'categoria'     => $this->input->post('categoria'),
                    'estado'        => $this->input->post('estado'),
                    'si_no'         => $this->input->post('si_no'),
                    'fecha'         => $this->input->post('fecha'),
                    'observaciones' => $this->input->post('observaciones')
                ];
    
                if ($this->Proyectos_evaluaciones_model->create_proyecto_evaluacion($data_insert)) {
                    $this->session->set_flashdata('message', 'Evaluación creada correctamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al crear la evaluación.');
                }
    
                redirect('proyectos_evaluaciones/index/' . ($id_proyecto ?: $this->input->post('proyecto_id')));
            }
        } else {
            $data['dropdown_estados'] = $dropdown_estados;
            $this->data['id_proyecto'] = $id_proyecto;
            $this->template->admin_render('proyectos_evaluaciones/create', $this->data);
        }
    }
    
    
    public function edit($id, $id_proyecto = NULL) {
        $data['proyecto'] = $this->Proyectos_evaluaciones_model->get_proyecto_evaluacion_by_id($id);
        
        if (!$data['proyecto']) {
            show_404();
        }
    
        // ✅ Si $id_proyecto es NULL, lo obtenemos desde la base de datos
        if ($id_proyecto === NULL) {
            $id_proyecto = $data['proyecto']['proyecto_id'];  
        }
    
        $data['proyecto_id'] = $id_proyecto;

        // Obtener lista de estados desde el modelo
		$estados = $this->Proyectos_evaluaciones_model->concepto('PROYECTO_ESTADO', false, 'CONCEPTO');
		$dropdown_estados = ['' => 'Seleccione un Estado'];
		foreach ($estados as $estado) {
			$dropdown_estados[$estado['concepto']] = $estado['concepto'] . ' - ' . $estado['nombre'];
		}
		 
		$data['dropdown_estados'] = $dropdown_estados;
    
        if ($this->input->post()) {
            $this->form_validation->set_rules('categoria', 'Categoría', 'required');
    
            if ($this->form_validation->run() === FALSE) {
                $this->template->admin_render('proyectos_evaluaciones/edit', array_merge($data, $this->data));
            } else {
                $data_update = [
                    'categoria'     => $this->input->post('categoria'),
                    'estado'        => $this->input->post('estado'),
                    'si_no'         => $this->input->post('si_no'),
                    'fecha'         => $this->input->post('fecha'),
                    'observaciones' => $this->input->post('observaciones')
                ];
    
                if ($this->Proyectos_evaluaciones_model->update_proyecto_evaluacion($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Evaluación actualizada correctamente.');
                    
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar la evaluación.');
                }
    
                redirect('proyectos_evaluaciones/edit/' .$id. '/' . $id_proyecto);
            }
        } else {
            $this->template->admin_render('proyectos_evaluaciones/edit', array_merge($data, $this->data));
        }
    }

    public function views($id, $id_proyecto = NULL) {
        $data['proyecto'] = $this->Proyectos_evaluaciones_model->get_proyecto_evaluacion_by_id($id);
        
        if (!$data['proyecto']) {
            show_404();
        }
    
        // ✅ Si $id_proyecto es NULL, lo obtenemos desde la base de datos
        if ($id_proyecto === NULL) {
            $id_proyecto = $data['proyecto']['proyecto_id'];  
        }
    
        $data['proyecto_id'] = $id_proyecto;
    
        if ($this->input->post()) {
            $this->form_validation->set_rules('categoria', 'Categoría', 'required');
    
            if ($this->form_validation->run() === FALSE) {
                $this->template->admin_render('proyectos_evaluaciones/views', array_merge($data, $this->data));
            } else {
                $data_update = [
                    'categoria'     => $this->input->post('categoria'),
                    'estado'        => $this->input->post('estado'),
                    'si_no'         => $this->input->post('si_no'),
                    'fecha'         => $this->input->post('fecha'),
                    'observaciones' => $this->input->post('observaciones')
                ];
    
                if ($this->Proyectos_evaluaciones_model->update_proyecto_evaluacion($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Evaluación actualizada correctamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar la evaluación.');
                }
    
                redirect('proyectos_evaluaciones/index/' . $id_proyecto);
            }
        } else {
            $this->template->admin_render('proyectos_evaluaciones/views', array_merge($data, $this->data));
        }
    }
    

    public function delete($id, $id_proyecto = NULL) {
        if ($this->Proyectos_evaluaciones_model->delete_proyecto_evaluacion($id)) {
            $this->session->set_flashdata('message', 'Evaluación eliminada correctamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar la evaluación.');
        }
        redirect('proyectos_evaluaciones/index/' . $id_proyecto);
    }
}
?>
