<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Actividades extends Admin_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('Actividades_model');
        $this->load->library(['pagination', 'form_validation']);
    }

    public function index() {
        $filters = $this->input->get();

        if (isset($filters['per_page'])) {
            unset($filters['per_page']);
        }

        $config['base_url'] = site_url('actividades/index') . '?' . http_build_query($filters);
        $config['total_rows'] = $this->Actividades_model->count_actividades($filters);
        $config['per_page'] = 10;
        $config['page_query_string'] = TRUE;
        $config['query_string_segment'] = 'per_page';

        $this->pagination->initialize($config);

        $offset = (int) $this->input->get('per_page', TRUE);
        $offset = ($offset < 0) ? 0 : $offset;

        $data['actividades'] = $this->Actividades_model->get_actividades($filters, $config['per_page'], $offset);
        $data['pagination'] = $this->pagination->create_links();
        $data['filters'] = $filters;
        $data['pagetitle'] = 'Listado de Actividades';

        $this->template->admin_render('actividades/index', array_merge($data, $this->data));
    }

    public function create() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('descripcion', 'Descripción', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['pagetitle'] = 'Crear Actividad';
                $this->template->admin_render('actividades/create', array_merge($data, $this->data));
            } else {
                $data_insert = ['descripcion' => $this->input->post('descripcion')];

                if ($this->Actividades_model->create_actividad($data_insert)) {
                    $this->session->set_flashdata('message', 'Actividad creada exitosamente.');
                } else {
                    $this->session->set_flashdata('error', 'Error al crear la actividad.');
                }
                redirect('actividades');
            }
        } else {
            $data['pagetitle'] = 'Crear Actividad';
            $this->template->admin_render('actividades/create', array_merge($data, $this->data));
        }
    }

    public function edit($id) {
        $actividad = $this->Actividades_model->get_actividad_by_id($id);
        if (!$actividad) {
            show_404();
        }

        if ($this->input->post()) {
            $this->form_validation->set_rules('descripcion', 'Descripción', 'required');

            if ($this->form_validation->run() === FALSE) {
                $data['actividad'] = $actividad;
                $data['pagetitle'] = 'Editar Actividad';
                $this->template->admin_render('actividades/edit', array_merge($data, $this->data));
            } else {
                $data_update = ['descripcion' => $this->input->post('descripcion')];

                if ($this->Actividades_model->update_actividad($id, $data_update)) {
                    $this->session->set_flashdata('message', 'Actividad actualizada exitosamente.');
                    redirect('actividades');
                } else {
                    $this->session->set_flashdata('error', 'Error al actualizar la actividad.');
                    redirect('actividades/edit/' . $id);
                }
            }
        } else {
            $data['actividad'] = $actividad;
            $data['pagetitle'] = 'Editar Actividad';
            $this->template->admin_render('actividades/edit', array_merge($data, $this->data));
        }
    }

    public function delete($id) {
        if ($this->Actividades_model->delete_actividad($id)) {
            $this->session->set_flashdata('message', 'Actividad eliminada exitosamente.');
        } else {
            $this->session->set_flashdata('error', 'Error al eliminar la actividad.');
        }
        redirect('actividades');
    }
}
?>
