<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo 'Expediente '.$codigo_unico['value']; ?></h1>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <?php echo form_input($codigo_unico);?>
        <?php echo form_input($area);?>
        <div class="row">
            <div class="col-md-12">
                <?php
                if ($message) {
                    echo '<pre>';
                    echo '<h4><b>Mensaje:</b></h4>';
                    echo '<h5>' . $message . '</h5>';
                    echo '</pre>';
                }
                ?>
            </div>
        </div>
        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-ver_observacion'));?>
        <div class="row">
            <div class="col-sm-12">
                <div class="box box-option">
                    <div class="box-header with-border" style="text-align: center;">
                        <h2 class="box-title">Búsqueda de observaciones</h2>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <p style="float: left; margin-left: 93px;">Desde    --    hasta</p>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-3">
                                <div class="input-group">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <?php echo form_input($fecha_min);?>
                                    <?php echo form_input($fecha_max);?>
                                    <?php echo form_input($fecha_inicio);?>
                                    <?php echo form_input($fecha_fin);?>
                                    <?php echo form_input($rangoFecha);?>
                                </div>
                            </div>
                            <div class="col-sm-2">
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary ', 'content' =>   'Buscar por fecha')); ?>
                            </div>
                            <div class="col-sm-2">
                                <?php echo anchor('expedientes/expedientes/ver_exp_obs_detalle/'.$id.'/'.$area['value'], 'Mostrar todos', array('type' => 'button','class' => 'btn btn-primary ')); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo form_close(); ?>
        <?php foreach ($observaciones as $obs) :?> 
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <div class="col-sm-2">
                            <div class="form-group">
                                <label>Fecha Observación</label>
                                <?php $attribute = 'class="form-control text" readonly="true"';
                                    echo form_input('', formato_fecha_hora($obs['fecha']), $attribute); ?>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group">
                                <label>Obs. <?php echo htmlspecialchars($obs['nombre'], ENT_QUOTES, 'UTF-8'); ?>:</label>
                                <?php $attribute = 'class="form-control textarea" readonly="true"';
                                    echo form_textarea('', $obs['descripcion'], $attribute); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endforeach;?>
        <div id="export-content">
            <h3 style="text-align: center;">VALIDACIÓN GENERAL DE DOCUMENTOS</h3>
            <table class="respect">
                <tbody>
                    <tr>
                        <!--td><strong>Revisado por:</strong></td-->
                        <td><strong>Revisado por:</strong>&nbsp&nbsp<?php echo $expediente->dao_supervisor; ?></td>
                        <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                        <td><strong>Carpeta N°:</strong>&nbsp&nbsp<?php echo $expediente->notificacion; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Recibido por:</strong></td>
                        <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                        <td><strong>Nombre afectado:</strong>&nbsp&nbsp<?php echo $expediente->nombre_completo; ?></td>
                    </tr>
                    <tr>
                        <td><strong>Fecha de recepción:</strong></td>
                        <td>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</td>
                        <td><strong>Memorandum N°:&nbsp&nbsp</strong></td>
                    </tr>
                </tbody>
            </table>
            <br>
            <h3>Observaciones <?php echo $area['value'] == 'fin' ? 'al avance' : strtoupper($nombre_area); ?></h3>
            <?php foreach ($observaciones as $obs) :?> 
            <div class="row">
                <p><strong>Fecha Observación:</strong> <?php echo formato_fecha_hora($obs['fecha']); ?></p>
                <strong>Obs. <?php echo htmlspecialchars($obs['nombre'], ENT_QUOTES, 'UTF-8'); ?>:</strong>
                <p><?php echo htmlspecialchars($obs['descripcion'], ENT_QUOTES, 'UTF-8'); ?></p>
                <br>
            </div>
            <?php endforeach;?>
        </div>
        <button id="word-export" class="btn btn-primary ">Exportar a word</button>
        <?php echo '&nbsp;';?>
        <?php echo '&nbsp;';?>
        <?php echo anchor('expedientes/expedientes/ver_exp_obs/'.$id,     'Regresar', array('class' => 'btn btn-danger ', 'content' => 'Regresar')); ?>
    </section>
</div>
