}<?php
    defined('BASEPATH') or exit('No direct script access allowed');
    
    ?>
<div class="content-wrapper">
    <section class="content-header">
        <h1><?php echo 'Expediente '.$codigo_unico['value']; ?></h1>
        <?php echo $breadcrumb; ?>
    </section>
    <section class="content">
        <div class="row">
            <?php
                if ($message) {
                    echo '<pre>';
                    echo '<h4><b>Mensaje:</b></h4>';
                    echo '<h5>' . $message . '</h5>';
                    echo '</pre>';
                }
                ?>
        </div>
        <?php require 'info_expe.php' ?>
        <?php echo form_open(current_url(), array('class' => 'form-horizontal', 'id' => 'form-edit_expe_ubi'));?>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Características del expediente</h3>
                    </div>
                    <!-- Primer bloque -->
                    <div class="box-body">
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_fecha_entrada">Fecha de ingreso:</label>
                                <div class="col-sm-7">
                                    <?php if ($editable and ($habilitado['op'] or $habilitado['sis'])): ?>
                                    <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                        <?php echo form_input($ubi_fecha_entrada);?>
                                        <div class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </div>
                                    </div>
                                    <?php else : ?>
                                    <?php echo form_input($ubi_fecha_entrada);?>
                                    <?php endif ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_superficie_afectacion"><?php echo lang('expedientes_superficie_afectada'); ?></label>
                                <div class="col-sm-7"><?php echo form_input($ubi_superficie_afectacion); ?></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_superficie_titulo"><?php echo lang('expedientes_superficie_titulo'); ?></label>
                                <div class="col-sm-7"><?php echo form_input($ubi_superficie_titulo); ?></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_porcentaje_afectacion">Porcentaje de afectación (%):</label>
                                <div class="col-sm-7"><?php echo form_input($ubi_porcentaje_afectacion); ?></div>
                            </div>
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <div class="box box-option collapsed-box">
                                        <div class="box-header with-border">
                                            <h3 class="box-title">Historial de fechas de ingreso a UBI</h3>
                                            <div class="box-tools pull-right" >
                                                <!-- Collapse Button -->
                                                <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                                <i class="fa fa-plus"></i>
                                                </button>
                                            </div>
                                            <!-- /.box-tools -->
                                        </div>
                                        <!-- /.box-header -->
                                        <div style="display: none;" class="box-body">
                                            <?php
                                                $i = 0;
                                                if (isset($historial_fecha_ingreso)) : ?>
                                            <table class="table">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Fecha ingreso</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($historial_fecha_ingreso as $values) : 
                                                        $i = $i + 1; ?>
                                                    <tr>
                                                        <th scope="row"><?php echo $i; ?></th>
                                                        <td><?php echo htmlspecialchars(formato_fecha($values['fecha_ingreso']), ENT_QUOTES, 'UTF-8'); ?></td>
                                                    </tr>
                                                    <?php endforeach;?>
                                                </tbody>
                                            </table>
                                            <?php else : ?>
                                            <p>No se encuentran registros.</p>
                                            <?php endif; ?>
                                        </div>
                                        <!-- /.box-body -->
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="col-sm-12">
                                <div class="box box-option">
                                    <div class="box-body">
                                        <div class="col-sm-12">
                                            <div class="dynamic_field">
                                                <div class="form-group">
                                                    <div class="col-sm-3">
                                                        <label for="ubi_coordenada_x"><?php echo lang('expedientes_coordenada_e'); ?></label>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <label for="ubi_coordenada_y"><?php echo lang('expedientes_coordenada_n'); ?></label>
                                                    </div>
                                                    <div class="col-sm-5">
                                                        <label for="lindero"><?php echo lang('expedientes_lindero'); ?></label>
                                                    </div>
                                                    <div class="col-sm-1">
                                                            <i type="button" name="addMII2" id="addMII2" class="fa fa-plus-circle" style="font-size: 2em;"></i>
                                                    </div>
                                                </div>
                                                <?php if(isset($coordenadas)) : ?>
                                                <?php for ($i=0; $i < count($coordenadas); $i++) : ?>
                                                <div class="form-group">
                                                    <div class="col-sm-3">
                                                        <?php echo form_input($ubi_coordenada_x, $coordenadas[$i]['coordenada_e']); ?>
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <?php echo form_input($ubi_coordenada_y, $coordenadas[$i]['coordenada_n']); ?>
                                                    </div>
                                                    <div class="col-sm-5">
                                                        <?php echo form_input($lindero, isset($coordenadas[$i]['lindero']) ? $coordenadas[$i]['lindero'] : ''); ?>
                                                    </div>
                                                    <div class="col-sm-1"><i name="remove" class="fa fa-times btn_remover" style="font-size: 2em;"></i></div>
                                                </div>
                                                <?php endfor; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_lindero_norte">Lindero norte:</label>
                                <div class="col-sm-7"><?php echo form_input($ubi_lindero_norte); ?></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_lindero_sur">Lindero sur:</label>
                                <div class="col-sm-7"><?php echo form_input($ubi_lindero_sur); ?></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_lindero_este">Lindero este:</label>
                                <div class="col-sm-7"><?php echo form_input($ubi_lindero_este); ?></div>
                            </div>
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_lindero_oeste">Lindero oeste:</label>
                                <div class="col-sm-7"><?php echo form_input($ubi_lindero_oeste); ?></div>
                            </div>
                            </div> -->
                    </div>
                    <!-- Fin primer bloque --> 
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-header with-border">
                        <h3 class="box-title"> Revisión del expediente</h3>
                    </div>
                    <!-- Primer bloque -->
                    <div class="box-body">
                        <div class="col-sm-12">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="control-label col-sm-5" for="ubi_supervisor">Supervisor asignado:</label>
                                    <div class="col-sm-7"><?php echo form_input($ubi_supervisor); ?></div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label class="control-label col-sm-5" for="ubi_fecha_revision">Fecha de revisión:</label>
                                    <div class="col-sm-7">
                                        <?php if ($editable and ($habilitado['sup'] or $habilitado['sis'])): ?>
                                        <div class="input-group date" data-provide="datepicker" data-date-format="dd/mm/yyyy">
                                            <?php echo form_input($ubi_fecha_revision);?>
                                            <div class="input-group-addon">
                                                <i class="fa fa-calendar"></i>
                                            </div>
                                        </div>
                                        <?php else : ?>
                                        <?php echo form_input($ubi_fecha_revision);?>
                                        <?php endif ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <div class="col-sm-9">
                                        <label class="control-label">Observaciones:</label>
                                    </div>
                                    <?php if ($tiene_observaciones) : ?>
                                    <div class="col-sm-3">
                                        <?php echo anchor('expedientes/expedientes/ver_observacion/'.$id.'/ubi', '<i class="btn btn-xs bg-green color-palette">Ver observaciones</i>'); ?>
                                    </div>
                                    <?php endif ?>
                                </div>
                                <div class="form-group">
                                    <label for="observacion_plano_inmueble">Plano de inmueble:</label>
                                    <?php echo form_textarea($observacion_plano_inmueble); ?>
                                </div>
                                <div class="form-group">
                                    <label for="observacion_informe_pericial">Informe pericial:</label>
                                    <?php echo form_textarea($observacion_informe_pericial); ?>
                                </div>
                                <div class="form-group">
                                    <label for="observacion_planilla_superficie">Planilla de superficie:</label>
                                    <?php echo form_textarea($observacion_planilla_superficie); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Fin primer bloque --> 
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <div class="col-sm-6">
                            <!-- Sección botones -->
                            <div class="form-group">
                                <?php if ($editable) : ?>
                                <?php if ($habilitado['sup'] or $habilitado['sis']) : ?>
                                <button type="button" class="btn btn-primary " data-toggle="modal" data-target="#myModal">Guardar aprobado</button>              
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php if (!$habilitado['coor']) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '1','class' => 'btn btn-primary ', 'content' =>   'Guardar pendiente')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>
                                <?php endif; ?>
                                <?php if (!$editable and ($habilitado['coor'] or $habilitado['coor_UBI'])) : ?>
                                <?php echo form_button(array('name' => 'accion','type' => 'submit','value' => '3','class' => 'btn btn-success ', 'content' =>   'Habilitar edición')); ?>
                                <?php echo '&nbsp;';?>
                                <?php echo '&nbsp;';?>
                                <?php endif; ?>   
                                <?php echo anchor('expedientes/expedientes/', 'Regresar', array('class' => 'btn btn-danger ', 'content' => 'Regresar')); ?>       
                            </div>
                            <!-- Fin sección botones --> 
                        </div>
                        <div class="col-sm-6">
                            <div class="form-group">
                                <label class="control-label col-sm-5" for="ubi_fecha_aprobacion">Fecha de aprobación:</label>
                                <div class="col-sm-7">
                                    <?php echo form_input($ubi_fecha_aprobacion);?> 
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php require 'modal_aprobar.php' ?>
        <?php echo form_close();?>
    </section>
</div>