<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Tramos_model extends Ion_auth_model {
	
	public function __construct()
	{
		parent::__construct();
	}
	
	/**
	 * geocolonias
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view_all()
	{
		//$this->trigger_events('geocolonias');

		// run each where that was passed
		
		
		if (isset($this->_ion_where) && !empty($this->_ion_where))
		{
			foreach ($this->_ion_where as $where)
			{
				$this->db->where($where);
			}
			$this->_ion_where = array();
		}

		if (isset($this->_ion_limit) && isset($this->_ion_offset))
		{
			$this->db->limit($this->_ion_limit, $this->_ion_offset);

			$this->_ion_limit  = NULL;
			$this->_ion_offset = NULL;
		}
		else if (isset($this->_ion_limit))
		{
			$this->db->limit($this->_ion_limit);

			$this->_ion_limit  = NULL;
		}

		// set the order
		if (isset($this->_ion_order_by) && isset($this->_ion_order))
		{
			$this->db->order_by($this->_ion_order_by, $this->_ion_order);
		}

		$this->response = $this->db->get($this->tables['geocolonias']);
		
		return $this;
	}
 
	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);
		
		if ($where != NULL) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}

		$this->response = $this->db->order_by($order_by);
		$this->response = $this->db->get();
		//$this->response = $this->db->get_where($this->tables[$tabla],$where);

		return $this;
	}


	public function select_data($tabla = NULL, $where = NULL)
	{
		$this->response = $this->db->get_where($this->tables[$tabla],$where);

		//return $this;
	}


	/**
	 * Expedientes
	 *
	 * @return object
	 * @author Ben Edmunds
	 **/
	public function view($tabla = NULL, $where = NULL)
	{
		$this->trigger_events('tramos');

		$this->response = $this->db->get_where($this->tables[$tabla], $where);

		return $this;
	}

	/**
	 * existe_grafico
	 *
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function existe_grafico($exp = NULL, $gest = NULL)
	{
		$resultado = $this->db->query("SELECT MOPC_IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");");

		return $resultado;
	}


	/**
	 * existe_grafico_id_tramo
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_grafico_id_tramo($id_tramo = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_TRAMO(".$id_tramo.");");

		return $resultado;
	}


	/**
	 * f_existe_grafico_id_tramo
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function f_existe_grafico_id_tramo($id_tramo = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_ID_TRAMO(".$id_tramo.");")->row()->f_existe_grafico_id_tramo;

		return $resultado;
	}


	/**
	 * actualizar_shapes
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_shapes_tramo($id_proyecto=NULL, $id_tramo = NULL, $epsg = NULL)
	{

		$resultado = $this->db->query("SELECT ide.actualizar_shapes_tramo(".$id_proyecto.",".$id_tramo.",".$epsg.");");

		return $resultado;
	}

	/**
	 * actualizar_fd_unificacion
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function actualizar_fd_unificacion($id_proyecto=NULL)
	{

		$resultado = $this->db->query("SELECT ide.actualizar_fd_unificacion(".$id_proyecto.");");

		return $resultado;
	}


	/**
	 * eliminar_geometrias
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function eliminar_geometrias_tramo($id_tramos = NULL)
	{
		$resultado = $this->db->query("SELECT IDE.F_ELIMINAR_GEOMETRIAS_TRAMO(".$id_tramos.");");

		return $resultado;
	}



	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condici�n dada
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}
	
	public function buscar_geo($abuscar)
	{
        //usamos after para decir que empiece a buscar por
        //el principio de la cadena
        //ej SELECT poblacion from poblacion
        //WHERE poblacion LIKE '%$abuscar' limit 12
        //$this->db->select('geocolonias');

        //$this->db->like('poblacion',$abuscar,'after');

		$resultados = $this->db->get('geocoloniaS');

        //si existe alg�n resultado lo devolvemos
		if($resultados->num_rows() > 0)
		{

			return $resultados->result();

        //en otro caso devolvemos false
		}else{

			return FALSE;

		}
	}



	/**
	 * crear_tramo
	 *
	 * @return integer
	 * @author Gustavo López.
	*/
	public function crear_tramo($arraycampos = NULL)
	{
		// bail if the group name already exists
		$existe_tramo = $this->db->get_where($this->tables['tramos'], $arraycampos)->num_rows();

		
		if($existe_tramo !== 0)
		{
			$this->ion_auth->set_error('tramos_already_exists');
			return FALSE;
		}
		


		// insert the new expediente
		$this->db->insert($this->tables['tramos'], $arraycampos);
		$id_tramo = $this->db->query("SELECT MAX(id_tramo) max from public.tramos;")->row()->max;


		//$expe_id = $this->db->insert_id();

		// report success
		$this->ion_auth->set_message('tramos_creation_successful');
		// return the brand new group id
		return $id_tramo;
	}

	
	/**
	 * actualizar_expediente
	 *
	 * @return bool
	 * @author Diego Ferreira
	 **/
	public function actualizar_tramos($id_tramo = FALSE, $arraycampos = NULL)
	{

		$this->db->update($this->tables['tramos'], $arraycampos, array('id_tramo' => $id_tramo));

        $this->set_message('tramos_update_successful');

        return 'TRUE';
    }

    /**
	 * valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Diego Ferreira
	 **/
	public function valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		if ($arraywhere != NULL) {
			foreach ($arraywhere as $k => $v) {

				$this->db->where($k, $v);
			}
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}


	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_valor_campo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select($columna." campo");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->campo;
	}

	/**
	 * campo_valor_maximo
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function campo_valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get()->row()->max;
	}

	/**
	 * eliminar_expediente
	 *	Obtiene el valor m�ximo de una columna y tabla espec�fica
	 * @return int
	 * @author Jaime Rojas
	 **/
    public function eliminar_tramos($id_tramo)
    {
    	$this->db->delete($this->tables['tramos'],array('id' => $expe_id));
		return TRUE;
    }


    public function departamentos()
    {
    	$this->response = $this->db->get($this->tables['departamentos']);

    	return $this;
    }

    public function distritos()
    {
    	$this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
    	return $this;
    }

	//PAGINATION
    public function get_pagination($number_per_page)
    {
    	if ($this->uri->segment(5) == null | $this->uri->segment(5) == '') {

    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, 0);
    	}else
    	{
    		$this->response = $this->db->get($this->tables['geocolonias'],$number_per_page, $this->uri->segment(5));
    	}

    	return $this;
	}

	public function num_post()
	{			
		$number = $this->db->query("SELECT count(*) as number FROM indert.geocolonia")->row()->number; //r�pido
		return intval($number);
	}

    /**
     * actualizar_expediente
     *
     * @return bool
     * @author Jaime Rojas
     **/
    public function obtener_jerarquia_tramo($id_tramo)
    {


		$jerarquia = $this->db->query("SELECT coalesce(tipo_jerarquia,0) as jerarquia 
        FROM ide.v_tramos_con_padre2 where id_tramo = ".$id_tramo.
        " or id_tramo_padre = ".$id_tramo." limit 1" )->row()->jerarquia;
 
        //$this->set_message('expedientes_update_successful');
    	//if (isset($jerarquia)) {
        //	$jerarquia = 0;
		//}
        return $jerarquia;
    }
	public function es_padre($id_tramo)
    {


		$es_padre = $this->db->query("SELECT coalesce(id_tramo_padre,0) as id_tramo_padre 
        FROM ide.v_tramos_con_padre2 where id_tramo = ".$id_tramo )->row()->id_tramo_padre;
		/*$resultado = $this->db->query("SELECT coalesce(id_tramo_padre,0) as id_tramo_padre FROM ide.v_tramos_con_padre2 where id_tramo = ".$id_tramo.");");
		*/
		if($es_padre>0){
			$resultado=1; //es hijo
		}else{
			$resultado=0; //es padre
		}
      
        return $resultado;
    }




	public function mapabb($expe_id)
	{


			$i_sql = "select ";
			$i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
			$i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
			$i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
			$i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
			$i_sql = $i_sql. "from ";
			$i_sql = $i_sql. "(";

			$i_sql = $i_sql. "select ";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
			$i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
			$i_sql = $i_sql. " from ( ";
				
			$i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.MOPC_poligono ";
            $i_sql = $i_sql . "where expe_id=" . $expe_id . " ";
            $i_sql = $i_sql . "group by expe_id) as a) as t1 ";
            //$i_sql = $i_sql . ";";
			$i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;

	}
}