<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Users extends Admin_Controller {

	public function __construct()
	{ 
		parent::__construct();

		$this->load->model('users/users_model');
		$this->lang->load('users/users_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_users'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'USERS') {

			$_SESSION['arraywhere_users'] 		 = NULL;
			$_SESSION['arraywhere_users_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'USERS';
		}
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_users'), 'users/users');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	


/*
	id
	ip_address 
	username
	email
	active
	first_name
	last_name
	company
    phone 
    nick 
    dependencia 
    user_jefe_id 
    genero 

*/

			if ($_POST) { 


				if ($_POST['id']) 
				{
					if (is_numeric($_POST['id'])) {
						$arraywhere['id'] 					= $_POST['id'];
						$arraywherebusq['id'] 				= $_POST['id'];
					}
				}
				

				if ($_POST['ip_address']) 
				{
					$arraywhere['ip_address'] 					= $_POST['ip_address'];
					$arraywherebusq['ip_address like '] 		= '%'.$_POST['ip_address'].'%';
				}


				if ($_POST['username']) 
				{
					if (is_numeric($_POST['username'])) {
						$arraywhere['username'] 					= $_POST['username'];
						$arraywherebusq['username'] 				= $_POST['username'];
					}
				}
				

				if ($_POST['email']) 
				{
					$arraywhere['email'] 					= $_POST['email'];
					$arraywherebusq['lower(email) like '] 	= '%'.strtolower($_POST['email']).'%';
				}

				if ($_POST['active']) 
				{
					$arraywhere['active'] 					= $_POST['active'];
					$arraywherebusq['lower(active) like '] 	= '%'.strtolower($_POST['active']).'%';
				}

				if ($_POST['first_name']) 
				{
					$arraywhere['first_name'] 						= $_POST['first_name'];
					$arraywherebusq['lower(first_name) like '] 		= '%'.strtolower($_POST['first_name']).'%';
				}

				if ($_POST['last_name']) 
				{
					$arraywhere['last_name'] 						= $_POST['last_name'];
					$arraywherebusq['lower(last_name) like ']		= '%'.strtolower($_POST['last_name']).'%';
				}

				if ($_POST['company']) 
				{
					$arraywhere['company'] 						= $_POST['company'];
					$arraywherebusq['lower(company) like ']		= '%'.strtolower($_POST['company']).'%';
				}

				if ($_POST['phone']) 
				{
					$arraywhere['phone'] 					= $_POST['phone'];
					$arraywherebusq['lower(phone) like '] 	= '%'.strtolower($_POST['phone']).'%';
				}

				if ($_POST['nick']) 
				{
					$arraywhere['nick'] 					= $_POST['nick'];
					$arraywherebusq['lower(nick) like '] 	= '%'.strtolower($_POST['nick']).'%';
				}

				if ($_POST['dependencia']) 
				{
					$arraywhere['dependencia'] 					= $_POST['dependencia'];
					$arraywherebusq['lower(dependencia) like '] 	= '%'.strtolower($_POST['dependencia']).'%';
				}

				if ($_POST['user_jefe_id']) 
				{
					$arraywhere['user_jefe_id'] 					= $_POST['user_jefe_id'];
					$arraywherebusq['lower(user_jefe_id) like '] 	= '%'.strtolower($_POST['user_jefe_id']).'%';
				}

				if ($_POST['genero']) 
				{
					$arraywhere['genero'] 					= $_POST['genero'];
					$arraywherebusq['lower(genero) like '] 	= '%'.strtolower($_POST['genero']).'%';
				}

			

				$_SESSION['arraywhere_users'] = $arraywhere;
				$_SESSION['arraywhere_users_busqueda'] = $arraywherebusq;

				redirect('users/users/index/');				
			}

			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'users/users/index/',  // url completa de la pagina paginada
				'users',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_users_busqueda']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['users']	  	= $this->ion_auth_model->segmentador_paginas(
			//$users	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'users',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_users_busqueda']
 				)->result();
			// ----- Fin paginacion  

			
			foreach ($this->data['users'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {

						//$cant_pol = $this->users_model->f_existe_grafico_user_id($value->user_id);
						//$exp['existe_poligono'] = $cant_pol;
						$exp['existe_poligono'] = 1;


						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$exp['grupo_usuario'] = 'C';	
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$exp[$k] = $val;
				}
				$exps[] = (object)$exp;
			}

			if (isset($exps)) {
				$this->data['users'] = $exps;
			}else{
				$this->data['users'] = NULL;
			}
			
			//emite un mensaje si es que se eliminó un user
			if (isset($_SESSION['last_exp_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
				unset($_SESSION['last_exp_delete']);
			}

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			/* Load Template */
            $this->template->admin_render('users/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_users'] 			= NULL;
		$_SESSION['arraywhere_users_busqueda'] 	= NULL;
		
		redirect('users/users/index/');				
	}

	public function ver_exp($user_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['user_info']  = $this->users_model->view('exp', array('user_id' => $user_id))->result();
	        
			/* Load Template */
            $this->template->admin_render('users/ver_user', $this->data);
		}
	}

	public function expe_mantenimiento($user_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'users/users');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->users_model->view('exp', array('user_id' => $user_id))->row();

	        $user_id_user = $exp_datos->user_id_user;
	        $expe_gestion		= $exp_datos->expe_gestion;



			$expe_info  = $this->users_model->view('exp', array('user_id_user' => $user_id_user,'user_gestion' => $user_gestion))->result_array();

			$expe_info[0]["expe_tipo_ref_desc"] = $this->users_model->dropdown_data('conceptos', array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]))->row()->nombre;

			$expe_info[0]["expe_estado_desc"] = $this->users_model->dropdown_data('conceptos', array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' => $expe_info[0]["expe_estado"]))->row()->nombre;


			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_POLIGONO']		= $this->users_model->contador_registros('MOPC_POLIGONO', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_UACTUAL']		= $this->users_model->contador_registros('MOPC_UACTUAL', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_UALTER']		= $this->users_model->contador_registros('MOPC_UALTER', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_U86']			= $this->users_model->contador_registros('MOPC_U86', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_U04']			= $this->users_model->contador_registros('MOPC_U04', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_TSUELO']		= $this->users_model->contador_registros('MOPC_TSUELO', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_FINCAS']		= $this->users_model->contador_registros('MOPC_FINCAS', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_CAP_SUELO']	= $this->users_model->contador_registros('MOPC_CAP_SUELO', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_CLA_ECO']		= $this->users_model->contador_registros('MOPC_CLA_ECO', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_COMP_DEF']		= $this->users_model->contador_registros('MOPC_COMP_DEF', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_DEF_BOS']		= $this->users_model->contador_registros('MOPC_DEF_BOS', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			$datos_graficos[0]['MOPC_PROP_CERT']	= $this->users_model->contador_registros('MOPC_PROP_CERT', array('exp' => $user_id_user, 'gest' => $expe_gestion));
			/************* FIN CANTIDAD DATOS GRAFICOS ****************/

			$this->data['user_info'] 		= $user_info;
 
			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['user_id_user'] = array(
				'type'     => 'hidden',
				'name'     => 'user_id_user',
				'id'       => 'user_id_user',
				'value'    => $user_id_user
			);

			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'user_gestion',
				'id'       => 'user_gestion',
				'value'    => $user_gestion
			);

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('users/Mantenimiento', $this->data);
		}
	}

	public function create_users()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('users_create'), 'geocolonias/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		
		$this->form_validation->set_rules('id', 		'<b>Id</b>' , 		 'required');
		
		//$this->form_validation->set_rules('user_id_geomatica', 	'<b>ID Geomática</b>' ,  'required');
		
		if ($this->form_validation->run() == TRUE)
		{




/*
	id
	ip_address 
	username
	email
	active
	first_name
	last_name
	company
    phone 
    nick 
    dependencia 
    user_jefe_id 
    genero 

*/
			
				//show_error(2);
	        	if ($_POST['id']){
					$arraycampos['id'] 			= $_POST['id'];
				}

        		if ($_POST['ip_address']){
	        		$arraycampos['ip_address'] 		= $_POST['ip_address'];
	        	}

	        	if ($_POST['username']){
	        		$arraycampos['username'] 		= $_POST['username'];
	        	}

				if ($_POST['email']){
					$arraycampos['email'] 			= $_POST['email'];
				}

				if ($_POST['active']){
					$arraycampos['active'] 			= $_POST['active'];
				}

				if ($_POST['first_name']){
					$arraycampos['first_name'] 	= $_POST['first_name'];
				}
				

				if ($_POST['last_name']){
					$arraycampos['last_name'] 	= $_POST['last_name'];
				}

				if ($_POST['company']){
					$arraycampos['company'] 	= $_POST['company'];
		
				}

				if ($_POST['phone']){
					$arraycampos['phone'] 		= strtoupper($_POST['phone']);
				
				}
				
				if ($_POST['nick']){
					$arraycampos['nick'] 		= $_POST['nick'];
				}
				
				if ($_POST['dependencia']){
					$arraycampos['dependencia'] 		= $_POST['dependencia'];
				}
				
				if ($_POST['user_jefe_id']){
					$arraycampos['user_jefe_id'] 			= strtoupper($_POST['user_jefe_id']);
				
				}

				if ($_POST['genero']){
					$arraycampos['genero'] 			= strtoupper($_POST['genero']);
				
				}

			/*
			if ($_POST['user_id_user_ref']){
				$arraycampos['user_id_user_ref'] 	= $_POST['user_id_user_ref'];
				$cnt = $this->users_model->contador_registros ('exp', array('user_id_user' => $_POST['user_id_user'], 'expe_gestion' => $_POST['expe_gestion'], 'user_id_dependencia' => $_POST['user_id_dependencia']));
				if ($cnt>0) {
					$sq = $this->users_model->valor_maximo('exp', 'expe_secuencia', array('user_id_user' => $_POST['user_id_user'], 'expe_gestion' => $_POST['expe_gestion'], 'user_id_dependencia' => $_POST['user_id_dependencia']));
					if ($sq>=0) {
						$arraycampos['expe_secuencia'] 		= $sq+1;
					}else{
						$arraycampos['expe_secuencia'] 		= $sq+1;
					}
				}else{
					$arraycampos['expe_secuencia'] 		= 0;
				}
			}else{
				$arraycampos['expe_secuencia'] 		= 0;
			}


			if ($_POST['user_id_ref']){
				$arraycampos['user_id_ref'] 	= $_POST['user_id_ref'];
			}

			if ($_POST['expe_doc_proponente']){
				$arraycampos['expe_doc_proponente'] 	= $_POST['expe_doc_proponente'];
			}

			if ($_POST['expe_proponente']){
				$arraycampos['expe_proponente'] 		= strtoupper($_POST['expe_proponente']);
			}

			$sq = $this->users_model->obtener_nextval('ide.exp_user_id_geomatica');
			
			$arraycampos['user_id_geomatica'] 			= $sq;
			
			if ($_POST['expe_tipo_proyecto']){
				$arraycampos['expe_tipo_proyecto'] 		= $_POST['expe_tipo_proyecto'];
			}
			if ($_POST['expe_proyecto']){
				$arraycampos['expe_proyecto'] 			= strtoupper($_POST['expe_proyecto']);
			}
			if ($_POST['user_id_departamento']){
				$arraycampos['user_id_departamento'] 	= $_POST['user_id_departamento'];
			}
			if ($_POST['user_id_distrito']){
				$arraycampos['user_id_distrito'] 		= $_POST['user_id_distrito'];
			}
			if ($_POST['user_id_consultor']){
				$arraycampos['user_id_consultor'] 		= strtoupper($_POST['user_id_consultor']);
			}
			if ($_POST['expe_consultor_nom']){
				$arraycampos['expe_consultor_nom'] 		= strtoupper($_POST['expe_consultor_nom']);
			}
			if ($_POST['expe_entrada']){
				$arraycampos['expe_entrada'] 			= $_POST['expe_entrada'];
			}			

			$arraycampos['expe_usureg'] 				= $this->session->userdata('username');

			$arraycampos['expe_usuario'] 				= $this->session->userdata('username');
			
			$arraycampos['expe_fechareg'] 				= date("Y").'-'.date("m").'-'.date("d");
			
			if ($_POST['expe_observacion']){
				$arraycampos['expe_observacion'] 		= strtoupper($_POST['expe_observacion']);
			}
			if ($_POST['expe_tecnico']){
				$arraycampos['expe_tecnico'] 			= $_POST['expe_tecnico'];
			}
			if ($_POST['expe_fproceso_geo']){
				$arraycampos['expe_fproceso_geo'] 		= $_POST['expe_fproceso_geo'];
			}
			if ($_POST['expe_nota']){
				$arraycampos['expe_nota'] 				= $_POST['expe_nota'];
			}
			if ($_POST['expe_director']){
				$arraycampos['expe_director'] 			= strtoupper($_POST['expe_director']);
			}
			if ($_POST['expe_salida']){
				$arraycampos['expe_salida'] 			= $_POST['expe_salida'];
			}
			if ($_POST['expe_provdg']){
				$arraycampos['expe_provdg'] 			= $_POST['expe_provdg'];
			}
			/*
			if ($_POST['expe_fecha_licencia']){
				$arraycampos['expe_fecha_licencia'] 	= $_POST['expe_fecha_licencia'];
			}			
			if ($_POST['expe_nro_licencia']){
				$arraycampos['expe_nro_licencia'] 		= $_POST['expe_nro_licencia'];
			}			
			if ($_POST['expe_usuario']){
				$arraycampos['expe_usuario'] 			= strtoupper($_POST['expe_usuario']);
			}
			if ($_POST['expe_nro_archivo']){
				$arraycampos['expe_nro_archivo'] 		= $_POST['expe_nro_archivo'];
			}			
			if ($_POST['expe_fecha_cierre']){
				$arraycampos['expe_fecha_cierre'] 		= $_POST['expe_fecha_cierre'];
			}
			




			//
			if ($_POST['expe_bloqueo']){
				$arraycampos['expe_bloqueo'] 			= $_POST['expe_bloqueo'];
			}
			if ($_POST['expe_estado']){
				$arraycampos['expe_estado'] 			= $_POST['expe_estado'];
			}
			if ($_POST['expe_sup_legal']){
				$arraycampos['expe_sup_legal'] 			= $_POST['expe_sup_legal'];
			}

			*/
			$accion = 0;	
			if (isset($_POST['accion'])){
				$accion = intval($_POST['accion']);
			}else{
				$accion = 0;	
			}

			$user_create = $this->users_model->crear_user($arraycampos);

        	if ($user_create)
        	{

				if($accion===1){ /// ACCION PARA OBSERVAR 						

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id'].'</b>, Proyecto <b>'.$_POST['id'].'</b> creado exitósamente!');
					redirect('users/users/edit_user/'.$user_create);

				} else {

        			$this->session->set_flashdata('message', '¡Expediente <b>'.$_POST['id'].'</b>, Gestión <b>'.$_POST['id'].'</b> creado exitósamente!');
					redirect('users/users/edit_user/'.$user_create);
				}
			}
			else 
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));





/*
	id
	ip_address 
	username
	email
	active
	first_name
	last_name
	company
    phone 
    nick 
    dependencia 
    user_jefe_id 
    genero 

*/

			$this->data['id'] = array(
				'type'     => 'text',
				'name'     => 'id',
				'id'       => 'id',
				'value'    => $this->form_validation->set_value('id'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);				
			$this->data['ip_address'] = array(
				'type'     => 'text',
				'name'     => 'ip_address',
				'id'       => 'ip_address',
				'value'    => $this->form_validation->set_value('ip_address'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['username'] = array(
				'type'     => 'number',
				'name'     => 'username',
				'id'       => 'username',
				'value'    => $this->form_validation->set_value('username'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,4)'
			);
			$this->data['email'] = array(
				'type'     => 'text',
				'name'     => 'email',
				'id'       => 'email',
				'value'    => $this->form_validation->set_value('email'),
				'class'    => 'form-control'
			);
			$this->data['active'] = array(
				'type'     => 'text',
				'name'     => 'active',
				'id'       => 'active',
				'value'    => $this->form_validation->set_value('active'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);	
			$this->data['first_name'] = array(
				'type'     => 'number',
				'name'     => 'first_name',
				'id'       => 'first_name',
				'value'    => $this->form_validation->set_value('first_name'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,10)'
			);
			$this->data['last_name'] = array(
				'type'     => 'text',
				'name'     => 'last_name',
				'id'       => 'last_name',
				'value'    => $this->form_validation->set_value('last_name'),
				'class'    => 'form-control',
				'maxlength'=> '20'
			);
			$this->data['company'] = array(
				'type'     => 'text',
				'name'     => 'company',
				'id'       => 'company',
				'value'    => $this->form_validation->set_value('company'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['phone'] = array(
				'type'     => 'text',
				'name'     => 'phone',
				'id'       => 'phone',
				'value'    => $this->form_validation->set_value('phone'),
				'class'    => 'form-control',
            	'maxlength'=> '20',
				//'onkeyup'  => 'limit_dig(this.id,20)'
			);
			$this->data['nick'] = array(
				'type'     => 'text',
				'name'     => 'nick',
				'id'       => 'nick',
				'rows'     => '1',
				'value'    => $this->form_validation->set_value('nick'),
				'class'    => 'form-control',
				'maxlength'=> '255'
			);
			$this->data['dependencia'] = array(
				'type'     => 'text',
				'name'     => 'dependencia',
				'id'       => 'dependencia',
				'value'    => $this->form_validation->set_value('dependencia'),
				'class'    => 'form-control',
				'list'	   => 'user_id_consultor_list',
				'maxlength'=> '10'
			);
			$this->data['user_jefe_id'] = array(
				'type'     => 'text',
				'name'     => 'user_jefe_id',
				'id'       => 'user_jefe_id',
				'value'    => $this->form_validation->set_value('user_jefe_id'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			$this->data['genero'] = array(
				'type'     => 'text',
				'name'     => 'genero',
				'id'       => 'genero',
				'value'    => $this->form_validation->set_value('genero'),
				'class'    => 'form-control',
				'maxlength'=> '100'
			);
			
			
			/*
			$this->data['expe_fecha_licencia'] = array(
				'type'     => 'text',
				'name'     => 'expe_fecha_licencia',
				'id'       => 'expe_fecha_licencia',
				'value'    => $this->form_validation->set_value('expe_fecha_licencia'),
				'class'    => 'form-control',
				'readonly' => true
			);
			$this->data['expe_nro_licencia'] = array(
				'type'     => 'text',
				'name'     => 'expe_nro_licencia',
				'id'       => 'expe_nro_licencia',
				'value'    => $this->form_validation->set_value('expe_nro_licencia'),
				'class'    => 'form-control',
				'readonly' => true
			);			
			$this->data['expe_usuario'] = array(
				'type'     => 'text',
				'name'     => 'expe_usuario',
				'id'       => 'expe_usuario',
				'value'    => $this->form_validation->set_value('expe_usuario'),
				'class'    => 'form-control',
				'readonly' => true
			);
			$this->data['expe_nro_archivo'] = array(
				'type'     => 'text',
				'name'     => 'expe_nro_archivo',
				'id'       => 'expe_nro_archivo',
				'value'    => $this->form_validation->set_value('expe_nro_archivo'),
				'class'    => 'form-control',
				'readonly' => true
			);			
			$this->data['expe_fecha_cierre'] = array(
				'type'     => 'text',
				'name'     => 'expe_fecha_cierre',
				'id'       => 'expe_fecha_cierre',
				'value'    => $this->form_validation->set_value('expe_fecha_cierre'),
				'class'    => 'form-control',
				'readonly' => true
			);
			*/
		


			/*
			$dependencias[''] = 'Seleccione la dependencia';
			$dependencia = $this->users_model->dropdown_data('dependencias')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($dependencia as $dep) {
				$dependencias[$dep['depe_id']] = $dep['depe_codigo'].' - '.$dep['depe_nombre_abreviado'];
			}
			$this->data['user_id_dependencia'] = $dependencias;
			
			$dptos[''] = 'Seleccione el departamento';
			$departamentos = $this->users_model->dropdown_data('departamentos','','dpto_id_departamento')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($departamentos as $dpto) {
				$dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
			}
			$this->data['departamentos'] = $dptos;

			$tipoproyectos[''] = 'Tipo de proyecto';
			$tipoproyecto = $this->users_model->dropdown_data('tipo_proyecto','','tpro_tipo_proy')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($tipoproyecto as $tp) {
				$tipoproyectos[$tp['tpro_tipo_proy']] = $tp['tpro_tipo_proy'].' - '.$tp['tpro_nombre_tipo_proy'];
			}
			$this->data['tipoproyecto'] = $tipoproyectos;

			$consultor = $this->users_model->dropdown_data('consultores','','cstr_codigo_ctca')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($consultor as $cs) {
				$consultors[$cs['cstr_codigo_ctca']] = $cs['cstr_nombre_consultor'];
			}
			$this->data['consultor'] = $consultors;

			$tiporefs[''] = 'Tipo Ref.';
			$tiporef = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'TIPO_REF'),'concepto')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($tiporef as $tr) {
				$tiporefs[$tr['concepto']] = $tr['concepto'].' - '.$tr['nombre'];
			}
			$this->data['tipo_ref'] = $tiporefs;

			$bloqueos[''] = 'Bloqueo';
			$bloqueo = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'EXPE_BLOQUEO'),'concepto')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($bloqueo as $bl) {
				$bloqueos[$bl['concepto']] = $bl['concepto'].' - '.$bl['nombre'];
			}
			$this->data['expe_bloqueo'] = $bloqueos;
			*/
			
			/* Load Template */
			$this->template->admin_render('users/create_users', $this->data);
		}
	}

	public function edit_users($user_id)
	{

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin() OR ! $user_id OR empty($user_id))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_users_edit'), 'users/edit');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada
        $user = $this->users_model->view('users', array('id' => $user_id))->row();

        $this->data['id'] = $user_id;

        /* Validate form input */
        $this->form_validation->set_rules('id', '<b>Id User</b>' , 'required');

		
	


	// Campos USERS IDOM
/*
	id
	ip_address 
	username
	email
	active
	first_name
	last_name
	company
    phone 
    nick 
    dependencia 
    user_jefe_id 
    genero 

*/
		//Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST))
        {
        	if ($this->form_validation->run() == TRUE)
        	{
				if ($_POST['id']){
					$arraycampos['id'] 			= $_POST['id'];
				}

        		if ($_POST['ip_address']){
	        		$arraycampos['ip_address'] 		= $_POST['ip_address'];
	        	}

	        	if ($_POST['username']){
	        		$arraycampos['username'] 		= $_POST['username'];
	        	}

				if ($_POST['email']){
					$arraycampos['email'] 			= $_POST['email'];
				}

				if ($_POST['active']){
					$arraycampos['active'] 			= $_POST['active'];
				}

				if ($_POST['first_name']){
					$arraycampos['first_name'] 	= $_POST['first_name'];
				}
				

				if ($_POST['last_name']){
					$arraycampos['last_name'] 	= $_POST['last_name'];
				}

				if ($_POST['company']){
					$arraycampos['company'] 	= $_POST['company'];
		
				}

				if ($_POST['phone']){
					$arraycampos['phone'] 		= strtoupper($_POST['phone']);
				
				}
				
				if ($_POST['nick']){
					$arraycampos['nick'] 		= $_POST['nick'];
				}
				
				if ($_POST['dependencia']){
					$arraycampos['dependencia'] 		= $_POST['dependencia'];
				}
				
				if ($_POST['user_jefe_id']){
					$arraycampos['user_jefe_id'] 			= strtoupper($_POST['user_jefe_id']);
				
				}

				if ($_POST['genero']){
					$arraycampos['genero'] 			= strtoupper($_POST['genero']);
				
				}
				
			

				$accion = 0;	
				if (isset($_POST['accion'])){
					$accion = intval($_POST['accion']);
				}else{
					$accion = 0;	
				}
				


				$unique_exp = $this->users_model->view('users',array('id' => $_POST['id'],
																		'id_user' 	 => $_POST['id_user'],
																
																		)
															)->num_rows();

/*
				if ($unique_exp > 0) {
					$this->session->set_flashdata('message', 'Ya existe un user con = codigo + id_proyecto');
					redirect('users/users/edit_expe/'.$user_id);
				}
*/
						//echo $accion;
						//show_error(1);	


				$actualizar_user = $this->users_model->actualizar_user($user_id,$arraycampos);

				///////////////////////////////////////////////////////////
				///////////////////// ACCIONES POST ///////////////////////
				///////////////////////////////////////////////////////////
				/*

				if($accion===2){ /// ACCION PARA OBSERVAR 						

					$resul  = $this->users_model->actualizar_user($user_id, array('expe_estado' => 'O'));

				}else{
					if($accion===3){ /// ACCION PARA HABILITAR

						$resul  = $this->users_model->actualizar_user($user_id, array('expe_estado' => 'A'));

					}else{
						if($accion===4){ /// ACCION PARA DAR SALIDA

							$i_exp = $this->users_model->obtener_valor_campo('exp', 'user_id_user' , array('user_id' => $user_id ));

							$i_gest = $this->users_model->obtener_valor_campo('exp', 'expe_gestion' , array('user_id' => $user_id ));
							
							$i_user = $this->session->userdata('username');
							//echo $i_user;
							//show_error(1);

							if (!is_null($i_exp) AND $i_gest > 0) {
								if (grupo_usuario(18)) {

									//if ($expe_provdg == NULL) {
									if (is_null($expe_provdg)) {
										$provdg = 0;
									}else{
										$provdg = $expe_provdg;
									}

									if ($provdg == 0) {
										$i_max = $this->users_model->campo_valor_maximo('exp', 'expe_provdg' , array('expe_director' => $i_user ));

										$i_max = $i_max+1;

										$str 	= date_default_timezone_get();
										$fecha  = date("d/m/Y", strtotime($str));

										$salida = $this->users_model->actualizar_user($user_id, array(
											'expe_provdg'   => $i_max, 
											'expe_director' => $this->session->userdata('username'),
											'expe_salida'   => $fecha,
											'expe_estado'   => 'P'));

										if ($salida) {
											$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
											redirect('users/users/edit_expe/'.$user_id);
										}else{
											$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
											redirect('users/users/edit_expe/'.$user_id);
										}
									}else{
										$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
										redirect('users/users/edit_expe/'.$user_id);
									}
								}else{
									$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
									redirect('users/users/edit_expe/'.$user_id);
								}
							}else{
								redirect('users/users/edit_expe/'.$user_id);
							}

						}else{
							
						}
					}
				}
				*/
        		//if ($resul) 
        		if ($actualizar_user) 
        		{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
        			$this->session->set_flashdata('message', $this->lang->line('users_update_successful'));
					redirect('users/users/edit_user/'.$user_id);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		//$this->data['geocolonia']   = $geocolonia;

		//$readonly = $this->config->item('admin_group', 'ion_auth') === $geocolonia->col_desc ? 'readonly' : '';
		




		// Campos USERS IDOM
/*
	id
	ip_address 
	username
	email
	active
	first_name
	last_name
	company
    phone 
    nick 
    dependencia 
    user_jefe_id 
    genero 

*/


		//creando campos
		$this->data['id'] = array(
			'type'     => 'number',
			'name'     => 'id',
			'id'       => 'id',
			'value'    => $this->form_validation->set_value('id', $user->id),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);			
		$this->data['ip_address'] = array(
			'type'     => 'text',
			'name'     => 'ip_address',
			'id'       => 'ip_address',
			'value'    => $this->form_validation->set_value('ip_address', $user->ip_address),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['username'] = array(
			'type'     => 'number',
			'name'     => 'username',
			'id'       => 'username',
			'value'    => $this->form_validation->set_value('username', $user->username),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,4)'
		);
		$this->data['email'] = array(
			'type'     => 'text',
			'name'     => 'email',
			'id'       => 'email',
			'value'    => $this->form_validation->set_value('email', $user->email),
			'class'    => 'form-control'
		);

		$this->data['active'] = array(
			'type'     => 'text',
			'name'     => 'active',
			'id'       => 'active',
			'value'    => $this->form_validation->set_value('active', $user->active),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);	
		$this->data['first_name'] = array(
			'type'     => 'number',
			'name'     => 'first_name',
			'id'       => 'first_name',
			'value'    => $this->form_validation->set_value('first_name', $user->first_name),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);

		$this->data['last_name'] = array(
			'type'     => 'text',
			'name'     => 'last_name',
			'id'       => 'last_name',
			'value'    => $this->form_validation->set_value('last_name', $user->last_name),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		$this->data['company'] = array(
			'type'     => 'text',
			'name'     => 'company',
			'id'       => 'company',
			'value'    => $this->form_validation->set_value('company', $user->company),
			'class'    => 'form-control',
			'maxlength'=> '50'
		);
		$this->data['phone'] = array(
			'type'     => 'text',
			'name'     => 'phone',
			'id'       => 'phone',
			'value'    => $this->form_validation->set_value('phone', $user->phone),
			'class'    => 'form-control',
			'onkeyup'  => 'limit_dig(this.id,20)',
			'maxlength'=> '10'

		);
		$this->data['nick'] = array(
			'type'     => 'text',
			'name'     => 'nick',
			'id'       => 'nick',
			'rows'     => '1',
			'value'    => $this->form_validation->set_value('nick', $user->nick),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['dependencia'] = array(
			'type'     => 'text',
			'name'     => 'dependencia',
			'id'       => 'dependencia',
			'value'    => $this->form_validation->set_value('dependencia', $user->dependencia),
			'class'    => 'form-control',
			'maxlength'=> '10'
		);
		$this->data['user_jefe_id'] = array(
			'type'     => 'text',
			'name'     => 'user_jefe_id',
			'id'       => 'user_jefe_id',
			'value'    => $this->form_validation->set_value('user_jefe_id', $user->user_jefe_id),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		$this->data['genero'] = array(
			'type'     => 'text',
			'name'     => 'genero',
			'id'       => 'genero',
			'value'    => $this->form_validation->set_value('genero', $user->genero),
			'class'    => 'form-control',
			'maxlength'=> '20'
		);
		
		
		/*
		if ($this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' =>$user->expe_estado))->row()) {
			$expe_estado = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' =>$user->expe_estado))->row()->nombre;
		}else{
			$expe_estado = NULL;
		}
		*/
		
		

/*
		$dependencias[''] = 'Seleccione la dependencia';
		$dependencia = $this->users_model->dropdown_data('dependencias')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dependencia as $dep) {
			$dependencias[$dep['depe_id']] = $dep['depe_codigo'].' - '.$dep['depe_nombre_abreviado'];
		}
		$this->data['user_id_dependencia'] = $dependencias;
		$this->data['user_id_dependencia_sel'] = $user->user_id_dependencia;
		
		$dptos[''] = 'Seleccione el departamento';
		$departamentos = $this->users_model->dropdown_data('departamentos','','dpto_id_departamento')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($departamentos as $dpto) {
			$dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
		}
		$this->data['departamentos'] = $dptos;
		$this->data['departamentos_sel'] = $user->user_id_departamento;

		$dists[''] = 'Seleccione el distrito';
		$dist = $this->users_model->dropdown_data('distritos',array('dist_id_departamento' => $user->user_id_departamento),
																 'dist_id_ciudad'
																)->result_array();

		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($dist as $dt) {
			$dists[$dt['dist_id_ciudad']] = $dt['dist_id_ciudad'].' - '.$dt['dist_descripcion'];
		}
		$this->data['distritos'] = $dists;
		$this->data['distritos_sel'] = $user->user_id_distrito;



		$expes[''] = 'Seleccione Expediente';
		$expe = $this->users_model->dropdown_data('exp',array('user_id_user' => $user->user_id_user_ref),
																 'user_id'
																)->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($expe as $ex) {
			$expes[$ex['user_id']] = $ex['user_id_user'].'-'.$ex['expe_gestion'].'-'.$ex['user_id_dependencia'].'-'.$ex['expe_secuencia'];
			//echo $ex['user_id'].' '.$expes[$ex['user_id']];			
		}
		//show_error(1);		
		$this->data['expe'] = $expes;
		$this->data['expe_sel'] = $user->user_id_ref;



		$tipoproyectos[''] = 'Tipo de proyecto';
		$tipoproyecto = $this->users_model->dropdown_data('tipo_proyecto','','tpro_tipo_proy')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($tipoproyecto as $tp) {
			$tipoproyectos[$tp['tpro_tipo_proy']] = $tp['tpro_tipo_proy'].' - '.$tp['tpro_nombre_tipo_proy'];
		}
		$this->data['tipoproyecto'] = $tipoproyectos;
		$this->data['tipoproyecto_sel'] = $user->expe_tipo_proyecto;

		$consultor = $this->users_model->dropdown_data('consultores','','cstr_codigo_ctca')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($consultor as $cs) {
			$consultors[$cs['cstr_codigo_ctca']] = $cs['cstr_nombre_consultor'];
		}
		$this->data['consultor'] = $consultors;

		$tiporefs[''] = 'Tipo Ref.';
		$tiporef = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'TIPO_REF'),'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($tiporef as $tr) {
			$tiporefs[$tr['concepto']] = $tr['concepto'].' - '.$tr['nombre'];
		}
		$this->data['tipo_ref'] = $tiporefs;
		$this->data['tipo_ref_sel'] = $user->expe_tipo_ref;

		$bloqueos[''] = 'Bloqueo';
		$bloqueo = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'EXPE_BLOQUEO'),'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($bloqueo as $bl) {
			$bloqueos[$bl['concepto']] = $bl['concepto'].' - '.$bl['nombre'];
		}
		$this->data['expe_bloqueo'] = $bloqueos;
		$this->data['expe_bloqueo_sel'] = $user->expe_bloqueo;

*/
		/*$estados[''] = 'Estado';
		$estado = $this->users_model->dropdown_data('conceptos',array('tipoconcepto' => 'EXPE_ESTADO'),'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estado as $es) {
			$estados[$es['concepto']] = $es['concepto'].' - '.$es['nombre'];
		}
		$this->data['expe_estado'] = $estados;
		$this->data['expe_estado_sel'] = $user->expe_estado;*/
		
		/* Load Template */

		$this->template->admin_render('users/edit_user', $this->data);
	}
  
	public function tiene_salida()
	{
		$user_id = $_POST['user_id'];

		$user = $this->users_model->view('exp', array('user_id' => $user_id, 'user_estado' => 'P'))->row();

		if ($user) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_grafico()
	{
		$id_user 	= $_POST['id_user'];
		$gestion 		= $_POST['gestion'];

		$user = $this->users_model->existe_grafico($id_user, $gestion)->row()->f_existe_grafico;
		
		echo $user;
	}
  

	public function existe_grafico_user_id()
	{
		$user_id 	= $_POST['user_id'];

		$user = $this->users_model->existe_grafico_user_id($user_id)->row()->f_existe_grafico_user_id;
		
		echo $user;
	}


	public function existe_exp()
	{
		$exp 		= $_POST['exp'];
		$gestion 	= $_POST['gest'];

		$user = $this->users_model->dropdown_data('exp', array('user_id_user' => $exp, 'user_gestion' => $gestion))->num_rows();

		if ($user > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}

	public function existe_exp_uk()
	{
		
        












































































		$codigo 		= $_POST['codigo'];
		$id_proyecto 	= $_POST['id_proyecto'];

		$expe = $this->users_model->dropdown_data('users', array('codigo' => $codigo, 
			                                                          'id_proyecto' => $id_proyecto
			                                                          ))->num_rows();

		if ($expe > 0) {
			echo 'SI';
		}else{
			echo 'NO';
		}
	}


	public function reingreso_exp()
	{
		$exp 	= $_POST['exp'];
		$gest 	= $_POST['gest'];

		$user_id = $this->users_model->dropdown_data('exp', array('user_id_user' => $exp, 'expe_gestion' => $gest))->row()->user_id;

		echo $user_id;

		//$reingreso  = $this->users_model->actualizar_user($user_id, array('user_id_user_ref' => $exp, 'user_id' => ));

		
		//redirect('users/users/edit_expe/'.$user_id);
	}

	public function dar_salida_user($user_id, $user_id_user, $expe_gestion, $expe_provdg = NULL)
	{

		$i_exp 		= $user_id_user;
		$i_gest 	= $user_gestion;


					$i_user = $this->session->userdata('username');
					//echo $i_user;
					//show_error(1);



		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {


				//if ($expe_provdg == NULL) {
				if (is_null($user_provdg)) {
					$provdg = 0;
				}else{
					$provdg = $user_provdg;
				}

				if ($provdg == 0) {
					$i_max = $this->users_model->campo_valor_maximo('exp', 'user_provdg' , array('user_director' => $i_user ));

					$i_max = $i_max+1;

					$str 	= date_default_timezone_get();
					$fecha  = date("d/m/Y", strtotime($str));

					$salida = $this->users_model->actualizar_user($user_id, array('user_provdg'   => $i_max, 
																					 		  'user_director' => $this->session->userdata('username'),
																					 		  'user_salida'   => $fecha,
																					 		  'user_estado'   => 'P'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitósamente!');
						redirect('users/users/edit_user/'.$user_id);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
						redirect('users/users/edit_user/'.$user_id);
					}
				}else{
					$this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
					redirect('users/users/edit_user/'.$user_id);
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				redirect('users/users/edit_user/'.$user_id);
			}
		}else{
			redirect('users/users/edit_user/'.$user_id);
		}
	}

	public function anular_salida_user($user_id) 
	{

		//echo($user_id);
		$expe = $this->users_model->dropdown_data('exp', array('user_id' => $user_id))->result();


		//echo '<option value="">Seleccione el distrito</option>';

		foreach ($expe as $value) {
			$i_exp 		 = $value->user_id_user;
			$i_gest 	 = $value->user_gestion;
			$i_provdg = $value->user_provdg;
		}

		if (!is_null($i_exp) AND $i_gest > 0) {
			if (grupo_usuario(18)) {

				if ($i_provdg == NULL) {
					$provdg = 0;
				}else{
					$provdg = $i_provdg;
				}

				if ($provdg != 0) {
					
					$salida = $this->users_model->actualizar_user($user_id, array('user_provdg'   => NULL, 
																					 		  'user_director' => '',
																					 		  'user_salida'   => NULL,
																					 		  'user_estado'   => 'A'));
					if ($salida) {
						$this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitósamente!');
						redirect('users/users/edit_user/'.$user_id);
					}else{
						$this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
						//redirect('users/users/edit_expe/'.$user_id);
						redirect('users/users/index/');				
					}
				}
			}else{
				$this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
				//redirect('users/users/index/'.$user_id);
				redirect('users/users/index/');				
			}
		}else{
			//redirect('users/users/index/'.$user_id);
			redirect('users/users/index/');				
		}
	}


	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	public function form_user()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_users'), 'geocolonias/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */
		$this->form_validation->set_rules('col_cod', 'lang:geocolonia_col_cod' , 'required');
		$this->form_validation->set_rules('col_desc','lang:geocolonia_col_desc', 'required');

		if ($this->form_validation->run() == TRUE)
		{
			$arraycampos = array('dpto_cod' 	=> $_POST['dpto_cod'],
								 'dist_cod' 	=> $_POST['dist_cod'],
								 'id_codgeo' 	=> $_POST['id_codgeo'],
								 'col_cod' 		=> $_POST['col_cod'],
								 'col_desc' 	=> strtoupper($_POST['col_desc']),
								);

			$new_geocolonia_id = $this->geocolonias_model->create_geocolonia($arraycampos);
			if ($new_geocolonia_id)
			{
				$this->session->set_flashdata('message', $this->ion_auth->messages());

				redirect('man_espacial/geocolonias/geocolonias');
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['dpto_cod'] = array(
				'name'  => 'dpto_cod',
				'id'    => 'dpto_cod',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('dpto_cod')
				);
			$this->data['dist_cod'] = array(
				'name'  => 'dist_cod',
				'id'    => 'dist_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('dist_cod')
				);
			$this->data['col_cod'] = array(
				'name'  => 'col_cod',
				'id'    => 'col_cod',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_cod')
				);
			$this->data['id_codgeo'] = array(
				'name'  => 'id_codgeo',
				'id'    => 'id_codgeo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('id_codgeo'),
				'readonly' => true,
				);
			$this->data['col_desc'] = array(
				'name'  => 'col_desc',
				'id'    => 'col_desc',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('col_desc')
				);

			$dptos[''] = 'Seleccione el departamento';
			$departamentos = $this->users_model->dropdown_data('departamentos','','dpto_id_departamento')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($departamentos as $dpto) {
				$dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
			}
			$this->data['departamentos'] = $dptos;
			
			///* Load Template */
			$this->template->admin_render('users/form_user', $this->data);
		}
	}

	public function trae_distritos()
	{
		$dpto 	   = $_POST['user_id_departamento'];

		$distritos = $this->users_model->dropdown_data('distritos',array('dist_id_departamento' => $dpto), 'dist_id_ciudad')->result();

		echo '<option value="">Seleccione el distrito</option>';
		foreach ($distritos as $value) {
			echo '<option value="' . $value->dist_id_ciudad . '">' . $value->dist_id_ciudad . ' - ' . $value->dist_descripcion . '</option>';
		}

		//echo json_encode($distritos);
	}

	public function trae_expe_ref()
	{
		$expe 	   = $_POST['user_id_user_ref'];

		$expes = $this->users_model->dropdown_data('exp',array('user_id_user_ref' => $expe), 'user_id')->result();

		echo '<option value="">Seleccione Expediente</option>';
		foreach ($expes as $value) {

			$expes[$ex['user_id']] = $ex['user_id_user'].'-'.$ex['user_gestion'].'-'.$ex['user_id_dependencia'].'-'.$ex['user_secuencia'];

			echo '<option value="' . $value->user_id . '">' . $value->user_id_user . '-' . $value->user_gestion . '-' . $value->user_id_dependencia . '-' . $value->user_secuencia .  '</option>';
		}

		//echo json_encode($distritos);
	}

	public function delete()
	{
		$delete  = $this->users_model->eliminar_user($_POST['user_id']);
		//$this->session->set_flashdata('message', '¡El user <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!');

		$_SESSION['last_exp_delete'] = '¡El user <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

		echo 'SI';
		//redirect('users/users/index');
	}

	public function verparcela ($user_id , $user_gest) {

        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?exp=" . $user_id;
        	$i_jameuge = $i_jameuge . "&gest=" . $user_gest;

			redirect($i_jameuge);
	}

	public function verparcela_user_id ($user_id ) {

        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?user_id=" . $user_id;

			redirect($i_jameuge);
	}

}