<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Tramos extends Admin_Controller {

	public function __construct()
	{ 
		parent::__construct();

		$this->load->model('tramos/tramos_model');
		$this->lang->load('tramos/tramos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_tramos'));
		$this->data['pagetitle'] = $this->page_title->show();

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'TRAMOS') {

			$_SESSION['arraywhere_tramos'] 		 = NULL;
			$_SESSION['arraywhere_tramos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'TRAMOS';
		}
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_tramos'), 'tramos/tramos');
	}

	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	

			if ($_POST) { 
				if ($_POST['id_tramo']) 
				{
					if (is_numeric($_POST['id_tramo'])) {
						$arraywhere['id_tramo'] 					= $_POST['id_tramo'];
						$arraywherebusq['id_tramo'] 				= $_POST['id_tramo'];
					}
				}
				if ($_POST['id_proyecto']) 
				{
					if (is_numeric($_POST['id_proyecto'])) {
						$arraywhere['id_proyecto'] 					= $_POST['id_proyecto'];
						$arraywherebusq['id_proyecto'] 				= $_POST['id_proyecto'];
					}
				}
				if ($_POST['cod_geografico']) 
				{
					$arraywhere['cod_geografico'] 					= $_POST['cod_geografico'];
					$arraywherebusq['cod_geografico like '] 		= '%'.$_POST['cod_geografico'].'%';
				}
				if ($_POST['nombre']) 
				{
					$arraywhere['nombre'] 					= $_POST['nombre'];
					$arraywherebusq['nombre like '] 		= '%'.$_POST['nombre'].'%';
				}
				if ($_POST['fecha']) 
				{
					$arraywhere['fecha'] 					= $_POST['fecha'];
					$arraywherebusq['lower(fecha) like '] 	= '%'.strtolower($_POST['fecha']).'%';
				}
				if ($_POST['hora']) 
				{
					$arraywhere['hora'] 					= $_POST['hora'];
					$arraywherebusq['lower(hora) like '] 	= '%'.strtolower($_POST['hora']).'%';
				}
				if ($_POST['usuario']) 
				{
					$arraywhere['usuario'] 						= $_POST['usuario'];
					$arraywherebusq['lower(usuario) like '] 		= '%'.strtolower($_POST['usuario']).'%';
				}
				$_SESSION['arraywhere_tramos'] = $arraywhere;
				$_SESSION['arraywhere_tramos_busqueda'] = $arraywherebusq;

				redirect('tramos/tramos/index/');				
			}
			 // ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'tramos/tramos/index/',  // url completa de la pagina paginada
				'tramos',		            // scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_tramos_busqueda']
				);
			$this->data['pagination'] 		= $mi_paginacion['pagination'];
			$this->data['tramos']	  	= $this->ion_auth_model->segmentador_paginas(
			//$tramos	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'tramos',					    // el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_tramos_busqueda']
 				)->result();
			// ----- Fin paginacion  
			foreach ($this->data['tramos'] as $key => $value) {
				$i = 0;
				foreach ($value as $k => $val) {
					$i = $i + 1;
					if ($i == 1) {
						//$cant_pol = $this->tramos_model->f_existe_grafico_expe_id($value->expe_id);
						//$exp['existe_poligono'] = $cant_pol;
						$exp['existe_poligono'] = 1;
						//if (grupo_usuario(17) or grupo_usuario(27)) {
							$exp['grupo_usuario'] = 'C';	
						//}else{
						//	$exp['grupo_usuario'] = 'N';
						//}
					}
					$exp[$k] = $val;
				}
				$exps[] = (object)$exp;
			}
			if (isset($exps)) {
				$this->data['tramos'] = $exps;
			}else{
				$this->data['tramos'] = NULL;
			}
			//emite un mensaje si es que se eliminó un expediente
			if (isset($_SESSION['last_exp_delete'])) {
				$this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
				unset($_SESSION['last_exp_delete']);
			}
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			/* Load Template */
            $this->template->admin_render('tramos/index', $this->data);
		}
	}

	public function reset_busqueda()
	{
		$_SESSION['arraywhere_tramos'] 			= NULL;
		$_SESSION['arraywhere_tramos_busqueda'] 	= NULL;
		
		redirect('tramos/tramos/index/');				
	}

	public function ver_exp($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

			$this->data['expe_info']  = $this->tramos_model->view('exp', array('expe_id' => $expe_id))->result();
	        
			/* Load Template */
            $this->template->admin_render('tramos/ver_expediente', $this->data);
		}
	}

	public function create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('tramos_create'), 'tramos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		/* Validate form input */

		//$this->form_validation->set_rules('nombre', 'lang:tramos_nombre'. 'required');
		
		$this->form_validation->set_rules('nombre', 	'<b>Nombre</b>' ,  'required');
		
		if ($this->form_validation->run() == TRUE)
		{
			
				//show_error(2);
        		/*
	        	if ($_POST['id_tramo']){
					$arraycampos['id_tramo'] 			= $_POST['id_tramo'];
				}
                */

        		if ($_POST['cod_geografico']){
	        		$arraycampos['cod_geografico'] 		= $_POST['cod_geografico'];
	        	}

	        	if ($_POST['nombre']){
	        		$arraycampos['nombre'] 				= $_POST['nombre'];
	        	}
				/*
				if ($_POST['fecha']){
					$arraycampos['fecha'] 				= $_POST['fecha'];
				}

				if ($_POST['hora']){
					$arraycampos['hora'] 				= $_POST['hora'];
				}

				if ($_POST['usuario']){
					$arraycampos['usuario'] 			= $_POST['usuario'];
				}				
        
				if ($_POST['tramo_padre']){
					$arraycampos['tramo_padre'] 		= $_POST['tramo_padre'];
				}
                */
        		        
				
				if ($_POST['id_proyecto']){
					$arraycampos['id_proyecto'] 		= $_POST['id_proyecto'];
				}
    
        		//echo $arraycampos;
        		//show_error(2);
        
	            $accion = 0;	
    	        if (isset($_POST['accion'])){
        	        $accion = intval($_POST['accion']);
            	}else{
                	$accion = 0;	
            	}

            $tramos_create = $this->tramos_model->crear_tramo($arraycampos);


            if ($tramos_create)
            {

                if($accion===1){ /// ACCION PARA OBSERVAR 						

                    $this->session->set_flashdata('message', '¡Tramo <b>'.$_POST['nombre'].'</b>, ID tramo <b>'.$_POST['nombre'].'</b> creado exitósamente!');
                    redirect('tramos/tramos/create');

                } else {

                    //redirect('tramos/tramos/create/'.$tramos_create);
                    redirect('tramos/tramos/create');
                }
            }
			else 
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
            /*
			$this->data['id_tramo'] = array(
				'type'     => 'text',
				'name'     => 'id_tramo',
				'id'       => 'id_tramo',
				'value'    => $this->form_validation->set_value('id_tramo'),
				'class'    => 'form-control',
				'maxlength'=> '10',
				'readonly' => TRUE
			);
            */
			$this->data['id_proyecto'] = array(
				'type'     => 'text',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $this->form_validation->set_value('id_proyecto'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['cod_geografico'] = array(
				'type'     => 'text',
				'name'     => 'cod_geografico',
				'id'       => 'cod_geografico',
				'value'    => $this->form_validation->set_value('cod_geografico'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);
			$this->data['nombre'] = array(
				'type'     => 'text',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $this->form_validation->set_value('nombre'),
				'class'    => 'form-control',
			);
        /*
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'value'    => $this->form_validation->set_value('fecha'),
				'class'    => 'form-control'
			);
			$this->data['hora'] = array(
				'type'     => 'text',
				'name'     => 'hora',
				'id'       => 'hora',
				'value'    => $this->form_validation->set_value('hora'),
				'class'    => 'form-control',
				'maxlength'=> '10'
			);	
			$this->data['usuario'] = array(
				'type'     => 'text',
				'name'     => 'usuario',
				'id'       => 'usuario',
				'value'    => $this->form_validation->set_value('usuario'),
				'class'    => 'form-control',
				'onkeyup'  => 'limit_dig(this.id,10)'
			);
            */
			$proyectos[''] = 'Selecciona el proyecto';
            $proyecto = $this->tramos_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;

            $tramos[''] = 'Selecciona el Tramo Padre';
			$this->data['tramo'] = $tramos;
			
			/*
			$tramos[''] = 'Selecciona el Tramo Padre';
            $tramo = $this->tramos_model->dropdown_data('tramos')->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['id_tramo'].' - '.$item['nombre'];
            }
            $this->data['tramo'] = $tramos;
			*/
			
			$this->template->admin_render('tramos/create_tramos', $this->data);
		}
	}



	public function edit_tramo($id_tramo)
	{
//OR ! isset($id_tramo)
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin()  OR empty($id_tramo))
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('menu_tramos_edit'), 'tramos/edit_tramo');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada
        $tramo = $this->tramos_model->view('tramos', array('id_tramo' => $id_tramo))->row();

        $this->data['id_tramo'] = $id_tramo;

        /* Validate form input */
       $this->form_validation->set_rules('nombre', '<b>Tramo</b>' , 'required');

		//Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST))
        {
        	if ($this->form_validation->run() == TRUE)
        	{
			if ($_POST['tramo_padre']){
					$arraycampos['tramo_padre'] 			= $_POST['tramo_padre'];
				}

        		if ($_POST['id_proyecto']){
	        		$arraycampos['id_proyecto'] 			= $_POST['id_proyecto'];
	        	}
				
				if ($_POST['cod_geografico']){
	        		$arraycampos['cod_geografico'] 			= $_POST['cod_geografico'];
	        	}

	        	if ($_POST['nombre']){
	        		$arraycampos['nombre'] 					= $_POST['nombre'];
	        	}

				if ($_POST['fecha']){
					$arraycampos['fecha'] 					= $_POST['fecha'];
				}

				if ($_POST['hora']){
					$arraycampos['hora'] 					= $_POST['hora'];
				}

				if ($_POST['usuario']){
					$arraycampos['usuario'] 				= $_POST['usuario'];
				}
				
				$accion = 0;	
				if (isset($_POST['accion'])){
					$accion = intval($_POST['accion']);
				}else{
					$accion = 0;	
				}

				$unique_exp = $this->tramos_model->view('tramos',array('id_tramo' => $id_tramo))->num_rows();

				$actualizar_tramos = $this->tramos_model->actualizar_tramos($id_tramo,$arraycampos);

        		//if ($resul) 
        		if ($actualizar_tramos) 
        		{
					//una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
        			$this->session->set_flashdata('message', $this->lang->line('tramos_update_successful'));
					redirect('tramos/tramos/edit_tramo/'.$id_tramo);
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}

				//aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
				//redirect('man_espacial/geocolonias/geocolonias', 'refresh'); 
			}
		}

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			
		//creando campos
		$this->data['id_tramo'] = array(
			'type'     => 'hidden',
			'name'     => 'id_tramo',
			'id'       => 'id_tramo',
			'value'    => $this->form_validation->set_value('id_tramo', $tramo->id_tramo),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);
		$this->data['id_proyecto'] = array(
			'type'     => 'hidden',
			'name'     => 'id_proyecto',
			'id'       => 'id_proyecto',
			'value'    => $this->form_validation->set_value('id_proyecto', $tramo->id_proyecto),
			'class'    => 'form-control',
			'maxlength'=> '10',
			'readonly' => TRUE
		);			
		$this->data['cod_geografico'] = array(
			'type'     => 'text',
			'name'     => 'cod_geografico',
			'id'       => 'cod_geografico',
			'value'    => $this->form_validation->set_value('cod_geografico', $tramo->cod_geografico),
			'class'    => 'form-control',
			'maxlength'=> '10'

		);			
		$this->data['nombre'] = array(
			'type'     => 'text',
			'name'     => 'nombre',
			'id'       => 'nombre',
			'value'    => $this->form_validation->set_value('nombre', $tramo->nombre),
			'class'    => 'form-control',
			'maxlength'=> '100'
		
		);
		$this->data['fecha'] = array(
			'type'     => 'text',
			'name'     => 'fecha',
			'id'       => 'fecha',
			'value'    => $this->form_validation->set_value('fecha', formato_fecha($tramo->fecha)),
			'class'    => 'form-control'
		);

		$this->data['hora'] = array(
			'type'     => 'text',
			'name'     => 'hora',
			'id'       => 'hora',
			'value'    => $this->form_validation->set_value('hora', $tramo->hora),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);	
		$this->data['usuario'] = array(
			'type'     => 'text',
			'name'     => 'usuario',
			'id'       => 'usuario',
			'value'    => $this->form_validation->set_value('usuario', $tramo->usuario),
			'class'    => 'form-control',
			'maxlength'=> '30'
		);

		$proyectos[''] = 'Selecciona el proyecto';
		$proyecto = $this->tramos_model->dropdown_data('proyectos')->result_array();
		foreach ($proyecto as $item) {
			$proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
		}
		$this->data['proyecto'] = $proyectos;
		$this->data['proyecto_sel'] = $tramo->id_proyecto;

		$tramos[''] = 'Selecciona el tramo padre';
		$tramo_item = $this->tramos_model->dropdown_data('tramos', array('id_proyecto' => $tramo->id_proyecto))->result_array();
		foreach ($tramo_item as $item) {
			$tramos[$item['id_tramo']] = $item['cod_geografico'].' - '.$item['nombre'].' - '.$item['id_proyecto'];
		}
		$this->data['tramo_padre'] = $tramos;
		$this->data['tramo_padre_sel'] = $tramo->tramo_padre;
			
		
		/*
		$tramos[''] = 'Seleccione el tramo';
            $tramo = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $expediente->id_proyecto,'tramo_padre =' => null))->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $subtramo = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $expediente->id_tramo, 'id_proyecto' => $expediente->id_proyecto))->result_array();
            foreach ($subtramo as $item) {
                $subtramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['subtramo'] = $subtramos;
			$this->data['subtramo_sel'] = $expediente->id_subtramo;
			
			$departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;


		*/
		 


		
		/* Load Template */

		$this->template->admin_render('tramos/edit_tramos', $this->data);
	}
  



	public function existe_grafico()
	{
		$id_expediente 	= $_POST['id_expediente'];
		$gestion 		= $_POST['gestion'];

		$expe = $this->tramos_model->existe_grafico($id_expediente, $gestion)->row()->f_existe_grafico;
		
		echo $expe;
	}
  

	public function existe_grafico_expe_id()
	{
		$expe_id 	= $_POST['expe_id'];

		$expe = $this->tramos_model->existe_grafico_expe_id($expe_id)->row()->f_existe_grafico_expe_id;
		
		echo $expe;
	}





	public function call_bat()
	{
		$cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
	}


	
	public function delete()
	{
		$delete  = $this->tramos_model->eliminar_expediente($_POST['expe_id']);
		//$this->session->set_flashdata('message', '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!');

		$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

		echo 'SI';
		//redirect('tramos/tramos/index');
	}

	

}
