<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Users_censo extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('proyectos/proyectos_model');
		$this->lang->load('proyectos/proyectos_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];


		
		if ($_SESSION['id_modulo'] != 'users_censo') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'users_censo') {
				
				$_SESSION['arraywhere_users_censo'] = NULL;
				$_SESSION['arraywhere_users_censo_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'users_censo';

			$_SESSION['errores_proyectos'] = NULL;
			is_array($_SESSION['errores_proyectos']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'proyectos/proyectos/index');
	}

	public function users_censo_index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
    	
    	//$_SESSION['url_sub_anterior'] = 'https://mopc.gov.py/sge/index.php/proyectos/users_censo/users_censo_index';

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('users_censo_titulo'), 'proyectos/users_censo/users_censo_index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->data['users_censo'] = $this->proyectos_model->viewlist_abm('users_censo', $_SESSION['identificador'])->result();

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('//message')));

		/* Load Template */
		$this->template->admin_render('proyectos/users_censo_index', $this->data);
	}

	public function users_censo_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('users_censo_tiutlo'), 'users_censo/users_censo_create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$max   = $this->proyectos_model->valor_maximo_2('users_censo', 'occ', array('proyec_id' => $_SESSION['identificador']))->row()->max;
    																							
    
		$max   = $max + 1;
		$users_censo = $this->proyectos_model->view('users_censo', array('proyec_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		$this->form_validation->set_rules('users_censo', 'lang:users_censo_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
		if ($_POST)
		{

			$arraycamposinsert['proyec_id']  = (string)$_SESSION['identificador'];
			//$arraycamposinsert['user_id']  = (string)$_SESSION['identificador'];


			$arraycamposinsert['occ']         						= $max;
		
			//if ($_POST['user_id']) {
			//	$arraycamposinsert['user_id']         				= $_POST['user_id'];
			//}

			if ($_POST['proyec_id']) {
				$arraycamposinsert['proyec_id']  					= $_POST['proyec_id'];
			}

			if ($_POST['user_codigo']) {
				$arraycamposinsert['user_codigo']         			= $_POST['user_codigo'];
			}

			if ($_POST['user_nombre']) {
				$arraycamposinsert['user_nombre']         			= $_POST['user_nombre'];
			}	    
        				      
			if ($_POST['tipo']) 
			{
				$arraycamposinsert['tipo']        				= $_POST['tipo'];
				if (trim($_POST['tipo']) == '') {
					$arraycamposinsert['tipo']   = NULL;
				} else {
					$arraycamposinsert['tipo']   = (int)$_POST['tipo'];
				}				
			}	    
        				      
			if ($_POST['estado']) 
			{
				$arraycamposinsert['estado']        				= $_POST['estado'];
				if (trim($_POST['estado']) == '') {
					$arraycamposinsert['estado']   = NULL;
				} else {
					$arraycamposinsert['estado']   = (int)$_POST['estado'];
				}				
			}



			$create_users_censo = $this->proyectos_model->crear_registro('users_censo', $arraycamposinsert);

			/*
			$str = date_default_timezone_get();
			$fecha_procesado_4 = date("d/m/Y", strtotime($str));
			$arraycampos3 = array('proceso' 		   => 'A03'
				//,'mapear' 			   => $reg02->mapear
				,'procesado_4'		   => 1
				,'fecha_procesado_4'	   => $fecha_procesado_4
					
			);
			*/					
			/*****************************************************************/
			
			redirect('proyectos/users_censo/users_censo_index');
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

/* 
user_id
proyec_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
*/	
			$this->data['user_id'] = array(
				'name'  => 'user_id',
				'id'    => 'user_id',
				'type'  => 'text',
				'class' => 'form-control',
                //'value' => $this->form_validation->set_value('user_id'),
				'value'   => $this->form_validation->set_value('user_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['proyec_id'] = array(
				'name'  => 'proyec_id',
				'id'    => 'proyec_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('proyec_id'),
				'value'   => $this->form_validation->set_value('proyec_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['occ'] = array(
				'name'  => 'occ',
				'id'    => 'occ',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('occ'),
				'value'   => $this->form_validation->set_value('occ', trim($max)), 			
				'maxlength' => 20,
				'readonly' => 'true'
				);
			$this->data['user_codigo'] = array(
				'name'  => 'user_codigo',
				//'pattern'  => '^([1-9][0-9]{0,2})?$',
				'id'    => 'user_codigo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('user_codigo'),
				'maxlength' => 2
				);
			$this->data['user_nombre'] = array(
				'name'  => 'user_nombre',
				'id'    => 'user_nombre',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('user_nombre'),
				'maxlength' => 100
				);

			$tipo = $this->proyectos_model->concepto('TIPO_USUARIO_CENSO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($tipo as $pf) {
				$tipos[$pf['concepto']] = $pf['concepto'].' - '.$pf['nombre'];
			}
			$this->data['tipo'] = $tipos;
			
			$estado = $this->proyectos_model->concepto('ESTADO_CENSO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($estado as $pf) {
				$estados[$pf['concepto']] = $pf['concepto'].' - '.$pf['nombre'];
			}
			$this->data['estado'] = $estados;
        
				
			/*
			$p02_filtro = $this->reg01_model->concepto('P02_FILTRO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($p02_filtro as $p02f) {
				$p02_fs[$p02f['concepto']] = $p02f['concepto'].' - '.$p02f['nombre'];
			}
			$this->data['p02_filtro'] = $p02_fs;
			*/

			/* Load Template */
			$this->template->admin_render('proyectos/users_censo_create', $this->data);
		}
	}

	public function users_censo_edit($proyec_id, $occ, $modo_cuest)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('users_censo_proyec_id'), 'proyectos/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$where_proyec_id['proyec_id'] = $proyec_id;
		$where_proyec_id['occ'] = $occ;

		$_SESSION['identificador'] = $proyec_id;

		$users_censo = $this->proyectos_model->view('users_censo',$where_proyec_id )->row();


		//declara el indice del array si es que no existe
		/*if (is_array($_SESSION['errores_proyectos']) && !array_key_exists('users_censo_proyec_id' , $_SESSION['errores_proyectos'])) {
			$_SESSION['errores_proyectos']['users_censo_proyec_id'] = NULL;     
		}*/

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->proyectos_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->proyectos_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		//$errores = $this->proyectos_model->obtener_errores($_SESSION['identificador'], '3')->result_array();
/*
		foreach ($errores as $value) {

			$concepto = $this->proyectos_model->concepto('PROYECTOS_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}
*/
		if (isset($error)) {
			$_SESSION['errores_proyectos']['users_censo_proyec_id'] = $error;
		}else{
			$_SESSION['errores_proyectos']['users_censo_proyec_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

    /* 
user_id
proyec_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
    */

		if ($_POST) {

			/*
			if ($_POST['user_id']) 
			{
				$arraycampos['user_id']                             = $_POST['user_id'];
			}

			if ($_POST['proyec_id'])
			{
				$arraycampos['proyec_id']   					        = $_POST['proyec_id'];
			}
			
			if ($_POST['occ']) 
			{
				$arraycampos['occ']             				        = $_POST['occ'];
			}
			*/

			if ($_POST['user_codigo']) 
			{
				$arraycampos['user_codigo']							= $_POST['user_codigo'];
			}

			if ($_POST['user_nombre']) 
			{
				$arraycampos['user_nombre']							= $_POST['user_nombre'];
			}	          

			if ($_POST['tipo']) 
			{
				$arraycampos['tipo']        				= $_POST['tipo'];
				if (trim($_POST['tipo']) == '') {
					$arraycampos['tipo']   = NULL;
				} else {
					$arraycampos['tipo']   = (int)$_POST['tipo'];
				}				
			}	          

			if ($_POST['estado']) 
			{
				$arraycampos['estado']        				= $_POST['estado'];
				if (trim($_POST['estado']) == '') {
					$arraycampos['estado']   = NULL;
				} else {
					$arraycampos['estado']   = (int)$_POST['estado'];
				}				
			}

			$update_reg = $this->proyectos_model->actualizar_registro(array('proyec_id' => $proyec_id,'occ' => $users_censo->occ), 'users_censo', $arraycampos);

			
			//obtiene los errores de la tabla
			$errores = $this->proyectos_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->proyectos_model->concepto('PROYECTOS_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_proyectos']['users_censo'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('proyectos/users_censo/users_censo_edit/'.$proyec_id.'/'.$occ.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
user_id
proyec_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
*/

		$this->data['user_id'] = array(
			'type'    => 'text',
			'name'    => 'user_id',
			'id'      => 'user_id',
			'value'   => $this->form_validation->set_value('users_censo_user_id', trim($users_censo->user_id)),
			'class'   => 'form-control',	
			'readonly' => 'true'		
			);
		$this->data['proyec_id'] = array(
			'type'  => 'text',
			'name'  => 'proyec_id',
			'id'    => 'proyec_id',
			'value' => $this->form_validation->set_value('users_censo_proyec_id', trim($users_censo->proyec_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['occ'] = array(
			'type'  => 'text',
			'name'  => 'occ',
			'id'    => 'occ',
			'value' => $this->form_validation->set_value('users_censo_occ', trim($users_censo->occ)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['user_codigo'] = array(
			'type'  => 'text',
			'name'  => 'user_codigo',
			'id'    => 'user_codigo',
			'value' => $this->form_validation->set_value('users_censo_user_codigo', trim($users_censo->user_codigo)),
			'class' => 'form-control',
            'maxlength'=> '2'
		);
		$this->data['user_nombre'] = array(
			'type'  => 'text',
			'name'  => 'user_nombre',
			'id'    => 'user_nombre',
			'value' => $this->form_validation->set_value('users_censo_user_nombre', trim($users_censo->user_nombre)),
			'class' => 'form-control',
            'maxlength'=> '100'
		);
		$this->data['tipo'] = array(
			'type'  => 'text',
			'name'  => 'tipo',
			'id'    => 'tipo',
			'value' => $this->form_validation->set_value('users_censo_tipo', trim($users_censo->tipo)),
			'class' => 'form-control',
            'maxlength'=> '1'
		);
		$this->data['estado'] = array(
			'type'  => 'text',
			'name'  => 'estado',
			'id'    => 'estado',
			'value' => $this->form_validation->set_value('users_censo_estado', trim($users_censo->estado)),
			'class' => 'form-control',
            'maxlength'=> '1'
		);
    
   		$tipo = $this->proyectos_model->concepto('TIPO_USUARIO_CENSO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($tipo as $af) 
		{
			$tipos[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['tipo'] = $tipos;

		if (ctype_space($users_censo->tipo)) {
			$this->data['tipo_sel'] = '  ';
		}else{
			$this->data['tipo_sel'] = (int)$users_censo->tipo;
		} 
    
       	$estado = $this->proyectos_model->concepto('ESTADO_CENSO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estado as $af) 
		{
			$estados[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['estado'] = $estados;

		if (ctype_space($users_censo->estado)) {
			$this->data['estado_sel'] = '  ';
		}else{
			$this->data['estado_sel'] = (int)$users_censo->estado;
		}
    

		/* Load Template */
		$this->template->admin_render('proyectos/users_censo', $this->data);
    
    
	}



    public function delete($proyec_id = null,$occ = null)
    {
       /* $documentos = $this->expedientes_model->view('documentos_dgsa', array('proyec_id' => $proyec_id))->result_array();

        if (!empty($documentos)) {
            $this->eliminar_archivos($expe_id, $documentos);
        }*/
        
        $delete  = $this->proyectos_model->eliminar_users_censo($proyec_id, $occ);
        $this->session->set_flashdata('message', '¡El registro se eliminó correctamente!');

        //$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

        //echo 'SI';
        redirect('proyectos/users_censo/users_censo_index/'.$proyec_id.'/'.$occ.'/E');
    }
}
//Llave de finalizacion de la clase<?php