<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento_dgsa extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('proyectos/proyectos_model');
		$this->lang->load('proyectos/proyectos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_proyectos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'PROYECTOS') {

			$_SESSION['arraywhere_proyectos'] 		 = NULL;
			$_SESSION['arraywhere_proyectos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'PROYECTOS';
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_proyectos'), 'proyectos/proyectos');
	}

	public function proyecto_mantenimiento_dgsa($id_proyec)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
        	$_SESSION['identificador'] 		 = $id_proyec;
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'proyectos/proyectos');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $proy_datos = $this->proyectos_model->view('proyectos', array('id_proyecto' => $id_proyec))->row();

  /*
  id_proyecto
  numero_contrato
  anyo_contrato
  expediente
  consultora
  descripcion
  contratista
  presupuesto
  tipo_moneda
  fecha_orden_proceder
  plazo_ejecucion
  plazo_ejecucion_catastral
  fecha_hora_insercion
  observaciones
  usuario

*/
			$id_proyecto 				= $proy_datos->id_proyecto;
			$numero_contrato 			= $proy_datos->numero_contrato;
			$anyo_contrato 				= $proy_datos->anyo_contrato;
			$expediente  				= $proy_datos->expediente;
			$consultora  				= $proy_datos->consultora;
			$descripcion  				= $proy_datos->descripcion;
			$contratista  				= $proy_datos->contratista;
			$presupuesto  				= $proy_datos->presupuesto;
			$tipo_moneda  				= $proy_datos->tipo_moneda;
			$fecha_orden_proceder  		= $proy_datos->fecha_orden_proceder;
			$plazo_ejecucion  			= $proy_datos->plazo_ejecucion;
			$plazo_ejecucion_catastral  = $proy_datos->plazo_ejecucion_catastral;
			$fecha_hora_insercion  		= $proy_datos->fecha_hora_insercion;
			$observaciones  			= $proy_datos->observaciones;
			$usuario  					= $proy_datos->usuario;


	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
        
        
        	$proyec_info  = $this->proyectos_model->view('proyectos', array('id_proyecto' => $id_proyec))->result_array();
        

			/************* CANTIDADES TOTALES DE DATOS GRAFICOS IMPORTADOS EN LA BAS DE DATOS ****************/ 
      
			$datos_graficos[0]['MOPC_DGSA_TERRENOS']	= $this->proyectos_model->contador_registros('dgsa_terrenos', array('id_proyec' => $id_proyec));
			$datos_graficos[0]['MOPC_DGSA_PUNTOS']		= $this->proyectos_model->contador_registros('dgsa_puntos', array('id_proyec' => $id_proyec));
        
            //$datos_graficos[0]['MOPC_DGSA_TERRENOS']	= $this->proyectos_model->contador_registros('terrenos_ci', array('id_proyec' => $id_proyec));
			/************* FIN CANTIDAD DATOS GRAFICOS ****************/        
        
			//echo 'MOPC_DGSA_TERRENOS: '.$datos_graficos[0]['MOPC_DGSA_TERRENOS'];
        	//echo 'id_proyec: '.$id_proyec;
        
			//show_error('TEMPORALMENTE INACTIVO');

			$this->data['proyec_info'] 		= $proyec_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['id_proyecto'] = array(
				'type'     => 'hidden',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $id_proyecto
			);

			$this->data['numero_contrato'] = array(
				'type'     => 'hidden',
				'name'     => 'numero_contrato',
				'id'       => 'numero_contrato',
				'value'    => $numero_contrato
			);

			$this->data['anyo_contrato'] = array(
				'type'     => 'hidden',
				'name'     => 'anyo_contrato',
				'id'       => 'anyo_contrato',
				'value'    => $anyo_contrato
			);


			$resultado= exec("/dir_intercambio/exp_mopc_dgsa_proyec_tabla_a_shp.sh postgres 2l2f1nt22022i ".trim($id_proyecto));

			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ?
				$this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Load Template */
            $this->template->admin_render('proyectos/mantenimiento_dgsa', $this->data);
		}
	}
/*HASTA AQUI 220319*/

	public function eliminar_geometrias_proyecto($id_proyecto = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');


		$resultado = $this->proyectos_model->eliminar_geometrias_proyecto($id_proyecto);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);

	}

	public function eliminar_fd_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->proyectos_model->eliminar_fd_proyecto($id_proyecto);

		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);
	}

	public function eliminar_progre_proyecto($id_proyecto = NULL)
	{
		$resultado = $this->proyectos_model->eliminar_progre_proyecto($id_proyecto);

		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);
	}

	public function eliminar_dgsa_terrenos($id_proyecto = NULL)
	{
		$resultado = $this->proyectos_model->eliminar_dgsa_terrenos($id_proyecto);

		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);
	}

	public function eliminar_dgsa_puntos($id_proyecto = NULL)
	{
		$resultado = $this->proyectos_model->eliminar_dgsa_puntos($id_proyecto);

		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);
	}

	public function download_proyecto($id_proyec = NULL)
	{

        //exec('\dir_intercambio\exp_mopc_expropia_proyec_tabla_a_shp.sh sge 2l2f1nt22022i '.trim($id_proyecto).');
        /*$resultado = exec("/dir_intercambio/exp_mopc_expropia_proyec_tabla_a_shp.sh sge 2l2f1nt22022i ".trim($id_tramo));

        $download_file = "mopc_proyecto_shp".$id_proyecto.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
		}*/
		
		$resultado= exec("/dir_intercambio/exp_mopc_dgsa_proyec_tabla_a_shp.sh sge 2l2f1nt22022i ".trim($id_proyec));
		
		redirect('proyectos/Mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyec);

	}

	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('proyectos/mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$_POST['id_proyecto']);
		}

		$id_proyecto 	 = $_POST['id_proyecto'];
		$numero_contrato = $_POST['numero_contrato'];
		$anyo_contrato 	 = $_POST['anyo_contrato'];

		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}
		$id_epsg = 32721;

		// pregunta sin existen datos graficos del proyecto.
		$proyecto = $this->proyectos_model->existe_grafico_id_proyecto($id_proyecto)->row()->f_existe_grafico_id_proyecto;

		if ($proyecto>5) {
			$this->session->set_flashdata('message', 'EL PROYECTO YA TIENE DATOS ESPACIALES!');
			redirect('proyectos/mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$_POST['id_proyec']);
		}
		else {
			//WINDOWS
			//exec('cmd /c "'.trim('rd /Q/S C:\dir_intercambio\proyectos\proyecto ').trim($id_proyecto).'"');
			//exec('cmd /c "'.trim('md C:\dir_intercambio\proyectos\proyecto ').trim($id_proyecto).'"');		
			//$ruta_dest = trim('C:\dir_intercambio\proyectos\proyecto ').trim($id_proyecto).trim('\ ');

			//LINUX
			exec('rm -R /dir_intercambio/proyectos/proyecto'.trim($id_proyecto));
            exec(trim('mkdir /dir_intercambio/proyectos/proyecto ').trim($id_proyecto));
			exec(trim('chmod 777 /dir_intercambio/proyectos/proyecto ').trim($id_proyecto));
			exec(trim('chmod 777 /dir_intercambio/proyectos/proyecto ').trim($id_proyecto).'/*');
			$ruta_dest = trim('/dir_intercambio/proyectos/proyecto ').trim($id_proyecto).trim('/ ');
			//echo 'id_proyec: '.$id_proyec;
			//show_error('TEMPORALMENTE INACTIVO');
			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					default:
						$i = $i + 1;
						break;

				}
			}

			
			//WINDOWS
			//exec('cmd /c "C:\dir_intercambio\imp_mopc_expropia_proyectos_shp_a_tabla.bat '.trim($id_proyecto).' '.$id_epsg.'"');
			//LINUX
			//$comando='/dir_intercambio/imp_mopc_expropia_proyectos_shp_a_tabla.sh '.trim($id_proyecto).' '.$id_epsg;
			exec('/dir_intercambio/imp_mopc_dgsa_proyectos_shp_a_tabla.sh '.trim($id_proyecto).' '.$id_epsg);
			//$mensaje= $id_proyecto;
			//$this->session->set_flashdata('message', $mensaje. ' '. $resultado. ' '. $id_epsg);
			//exec('/usr/pgsql-9.6/bin/shp2pgsql -s 19 -c -W LATIN1 /dir_intercambio/proyectos/proyecto"$1"/terrenos.shp temporal.py_terrenos'.trim($id_proyecto).' > /dir_intercambio/proyectos/proyecto'.trim($id_proyecto).'/terrenos.sql');
			//exec('/usr/pgsql-9.6/bin/psql -h 172.16.55.135 -d expropiacion -p 5432 -U postgres -w -f /dir_intercambio/proyectos/proyecto'.trim($id_proyecto).'/terrenos.sql');
			
			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
				$actu = $this->proyectos_model->actualizar_shapes_proyecto_dgsa($id_proyecto, $id_epsg)->row()->actualizar_shapes_proyecto_dgsa;
			} elseif ($accion == 2) {
				$id_epsg = 32720;
			} elseif ($accion == 3) {
				$id_epsg = 4326;
			} else  {
				$id_epsg = 32721;
			}
			if ($accion == 4) {
				echo 'Accion: '.$accion;
				show_error('TEMPORALMENTE INACTIVO');
				$id_epsg = 32721;
				//$actu = $this->proyectos_model->actualizar_shapes_progre($id_proyecto, $id_epsg)->row()->actualizar_shapes_progre;
			} else  {
				$id_epsg = 32721;
			}

			
			


			
/*
resultado=0 -- Sin errores.
resultado=1 -- no existe la tabla temporal.fd 
resultado=2 -- no realiza importación en ide.franja_dominio_pol
resultado=3 -- no existe la tabla temporal.fc 
resultado=4 -- no se realiza importacion en ide.franja_construccion
*/

			if ($actu==2 or $actu==4) {
				$mensaje = $this->proyectos_model->mensaje_error($id_proyecto)->row()->descrip_error;
				//echo 'id_proyec: '.$mensaje;
			//	show_error('TEMPORALMENTE INACTIVO');
				$this->session->set_flashdata('message', $mensaje);
				redirect('proyectos/mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);
			}
			else {
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3>');

				redirect('proyectos/mantenimiento_dgsa/proyecto_mantenimiento_dgsa/'.$id_proyecto);

			}
		}
	}

	public function vergrafico ($id_proyec=NULL) {

        	//$i_jameuge = "http://172.16.55.134:8065/sgeMap/index.html?id_proyec=" . $id_proyec; //WINDOWS
        	$i_jamap = "http://134.255.178.19/sgeMap/index.html?id_proyec=" . $id_proyec; //LINUX
        	$i_jamap = $i_jamap . "&tipo_consulta=mopc_proyectos_id_proyec";

			redirect($i_jamap);
	}

}
