<?php
defined('BASEPATH') or exit('No direct script access allowed');
define("MEDIA_FOLDER", "/dir_sginmo/archivos/");
//define("MEDIA_FOLDER", "c:\dir_intercambio\archivos\ ");


class Expedientes extends Admin_Controller
{

    public function __construct()
    {
        parent::__construct();

        $this->load->model('expedientes/expedientes_model');
        $this->lang->load('expedientes/expedientes_lang');

        /* Titulo de la pagina :: Common */
        $this->page_title->push(lang('menu_expedientes'));
        $this->data['pagetitle'] = $this->page_title->show();
        $this->load->helper('download');

        //verificación de módulo para el reset de las variables de sessión utilizadas en la misma
        $_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];
        if ($_SESSION['id_modulo'] != 'EXPEDIENTES') {
            $_SESSION['arraywhere_expedientes']          = null;
            $_SESSION['arraycampos']                     = null;
            $_SESSION['arraywhere_expedientes_busqueda'] = null;
            $_SESSION['id_modulo'] = 'EXPEDIENTES';

            $_SESSION['errores_expedientes'] = NULL;
            is_array($_SESSION['errores_expedientes']);            
        }


        /* Breadcrumbs :: Common */
        $this->breadcrumbs->unshift(1, lang('menu_expedientes'), 'expedientes/expedientes');
    }

    public function index()
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
        	$users = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
            if ($_POST) {
                if ($_POST['id']) {
                    $arraywhere['id']                        = $_POST['id'];
                    $arraywherebusq['CAST(id AS TEXT)  like']       = '%'.$_POST['id'].'%';
                }
                /* if ($_POST['ubicacion']) {
                	$arraywhere['ubicacion']                        = $_POST['ubicacion'];
                   	$arraywherebusq['upper(ubicacion) like ']         = '%'.strtoupper($_POST['ubicacion']).'%';
                }    */ 
            	
                /* if ($_POST['des_codigo_unico']) {
                    $arraywhere['des_codigo_unico']                   = $_POST['des_codigo_unico'];
                    if (strtoupper($_POST['des_codigo_unico']) == 'R27') {
                        $arraywherebusq['des_codigo_unico like ']         = '%_'.strtoupper($_POST['des_codigo_unico']);
                    } else {
                        $arraywherebusq['des_codigo_unico like ']         = '%'.strtoupper($_POST['des_codigo_unico']).'%';
                    }
                } */
                
                if ($_POST['codigo']) {
                    $arraywhere['codigo'] = $_POST['codigo'];
                    $arraywherebusq['lower(codigo) like '] = '%'.strtolower($_POST['codigo']).'%';
                }
         

                if ($_POST['nombre_sede']) {
                    $arraywhere['nombre_sede'] = $_POST['nombre_sede'];
                    $arraywherebusq['lower(nombre_sede) like '] = '%'.strtolower($_POST['nombre_sede']).'%';
                }
         
                /* if ($_POST['seg_estado']) {
                    $arraywhere['seg_estado']                   = $_POST['seg_estado'];
                    $arraywherebusq['lower(seg_estado) like ']         = '%'.strtolower($_POST['seg_estado']).'%';
                } */
                if ($_POST['distrito']) {
                    $arraywhere['des_distrito']                   = $_POST['distrito'];
                    $arraywherebusq['lower(des_distrito) like ']         = '%'.strtolower($_POST['distrito']).'%';
                }
                if ($_POST['dpto']) {
                    $arraywhere['des_dpto']                   = $_POST['dpto'];
                    $arraywherebusq['lower(des_dpto) like ']         = '%'.strtolower($_POST['dpto']).'%';
                }

                /* if ($_POST['tramo']) {
                    $arraywhere['des_tramo']                    = $_POST['tramo'];
                    $arraywherebusq['des_tramo like ']   = '%'.strtoupper($_POST['tramo']).'%';
                } */

                /* if ($_POST['franja_dominio']) {
                    $arraywhere['franja_dominio']                    = $_POST['franja_dominio'];
                    $arraywherebusq['franja_dominio like ']   = '%'.strtoupper($_POST['franja_dominio']).'%';
                } */
                if ($_POST['tipo_afectacion']) {
                    $arraywhere['des_tipo_afectacion']                    = $_POST['tipo_afectacion'];
                    $arraywherebusq['lower(des_tipo_afectacion) like ']   = strtolower($_POST['tipo_afectacion']).'%';
                }
               
                if ($_POST['nombre_completo']) {
                    $arraywhere['nombre_completo']                        = $_POST['nombre_completo'];
                    $arraywherebusq['lower(nombre_completo) like ']       = '%'.strtolower($_POST['nombre_completo']).'%';
                }

                if ($_POST['cta_cte_padron']) {
                    $arraywhere['cta_cte_padron']                        = $_POST['cta_cte_padron'];
                    $arraywherebusq['lower(cta_cte_padron) like ']       = '%'.strtolower($_POST['cta_cte_padron']).'%';
                }

                if ($_POST['finca_matricula']) {
                    $arraywhere['finca_matricula']                        = $_POST['finca_matricula'];
                    $arraywherebusq['lower(finca_matricula) like ']       = '%'.strtolower($_POST['finca_matricula']).'%';
                }
                /* if ($_POST['codigo_meu']) {
                    $arraywhere['codigo_meu']                        = $_POST['codigo_meu'];
                    $arraywherebusq['CAST(codigo_meu AS TEXT)  like']       = $_POST['codigo_meu'].'%';
                } */

                if ($users->institucion != 1) {
                    $arraywhere['institucion']                               = $users->institucion;
                    $arraywherebusq['CAST(institucion AS TEXT)  like']       = $users->institucion.'%';
                }

                $_SESSION['arraywhere_expedientes'] = $arraywhere;
                $_SESSION['arraywhere_expedientes_busqueda'] = $arraywherebusq;

                redirect('expedientes/expedientes/index/');
            }

                if ($users->institucion != 1) {
                    $arraywhere['institucion']                               = $users->institucion;
                    $arraywherebusq['CAST(institucion AS TEXT)  like']       = $users->institucion.'%';
                    $_SESSION['arraywhere_expedientes'] = $arraywhere;
                    $_SESSION['arraywhere_expedientes_busqueda'] = $arraywherebusq;  
                }

             // ----- Paginacion Generica
            $mi_paginacion = $this->ion_auth->paginacion_generica(
                12,                         // resultados por por_pagina,
                4,                          // segmento uri a leer,
                5,                          // cantidad_enlaces,
                base_url(). 'index.php/expedientes/expedientes/index/',  // url completa de la pagina paginada
                'v_expedientes',                  // scheme y nombre de la tabla, para la consulta
                $_SESSION['arraywhere_expedientes_busqueda']
            );

            $this->data['pagination']       = $mi_paginacion['pagination'];

            $this->data['expedientes']      = $this->ion_auth_model->segmentador_paginas(
                //$expedientes      = $this->ion_auth_model->segmentador_paginas(
                $mi_paginacion['per_page'],     // resultados por pagina
                4,                              // segmento uri a leer
                'v_expedientes',                      // el nombre de la tabla a consultar $nombre_tabla
                $_SESSION['arraywhere_expedientes_busqueda'],
                'v_expedientes.id',
                'DESC'
            )->result();
            // ----- Fin paginacion


            foreach ($this->data['expedientes'] as $key => $value) {
                $i = 0;
                foreach ($value as $k => $val) {
                    $i = $i + 1;
                    if ($i == 1) {
                        //$cant_pol = $this->expedientes_model->f_existe_grafico_expe_id($value->expe_id);
                        //$exp['existe_poligono'] = $cant_pol;
                        $exp['existe_poligono'] = 1;
                        if (grupo_usuario(17) or grupo_usuario(27)) {
                            $exp['grupo_usuario'] = 'C';
                        } else {
                            $exp['grupo_usuario'] = 'N';
                        }
                    }
                    $exp[$k] = $val;
                }
                $exps[] = (object)$exp;
            }

            if (isset($exps)) {
                $this->data['expedientes'] = $exps;
            } else {
                $this->data['expedientes'] = null;
            }

            //emite un mensaje si es que se eliminó un expediente
            if (isset($_SESSION['last_exp_delete'])) {
                $this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
                unset($_SESSION['last_exp_delete']);
            }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['habilitado_sis'] 				= grupo_usuario(3);
            $this->data['habilitado_gen'] 				= grupo_usuario(4);
            $this->data['habilitado_finan'] 			= grupo_usuario(5);
            $this->data['habilitado_coor_ubi'] 			= grupo_usuario(16);
            $this->data['habilitado_coor_dao'] 			= grupo_usuario(17);
            $this->data['habilitado_coor_daj'] 			= grupo_usuario(18);
            $this->data['habilitado_coor'] 				= grupo_usuario(31);
            $this->data['habilitado_ubi']['op'] 		= grupo_usuario(32);
            $this->data['habilitado_ubi']['sup'] 		= grupo_usuario(33);
            $this->data['habilitado_dao']['op'] 		= grupo_usuario(34);
            $this->data['habilitado_dao']['sup'] 		= grupo_usuario(35);
            $this->data['habilitado_daj']['op'] 		= grupo_usuario(36);
            $this->data['habilitado_daj']['sup'] 		= grupo_usuario(37);
            $this->data['habilitado_coor_sup'] 			= grupo_usuario(40);
            $this->data['oculta_dao'] 					= grupo_usuario(19);
        	$this->data['habilitado_cc'] 				= grupo_usuario(38);
            $this->data['habilitado_gab'] 		    	= grupo_usuario(42);
        	$this->data['restringir_ver_expediente']	= grupo_usuario(15);
            

            /* Load Template */
            $this->template->admin_render('expedientes/index', $this->data);
        }
    }


    public function consulta()
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            if ($_POST) {

                if ($_POST['id']) {
                    $arraywhere['id']                        = $_POST['id'];
                    $arraywherebusq['CAST(id AS TEXT)  like']       = '%'.$_POST['id'].'%';
                }
                /*
                if ($_POST['expedientes_id']) {
                    $arraywhere['expedientes_id']                        = $_POST['expedientes_id'];
                    $arraywherebusq['CAST(expedientes_id AS TEXT)  like']       = $_POST['expedientes_id'].'%';
                }
                */
                if ($_POST['des_codigo_unico']) {
                    $arraywhere['des_codigo_unico']                   = $_POST['des_codigo_unico'];
                    if (strtoupper($_POST['des_codigo_unico']) == 'R27') {
                        $arraywherebusq['des_codigo_unico like ']         = '%_'.strtoupper($_POST['des_codigo_unico']);
                    } else {
                        $arraywherebusq['des_codigo_unico like ']         = '%'.strtoupper($_POST['des_codigo_unico']).'%';
                    }
                }

                /*if ($_POST['codigo_dbi']) {
                    $arrayCodigo = [];
                    $arraywhere['codigo_dbi']                        = $_POST['codigo_dbi'];
                    $arraywherebusq['lower(codigo_dbi) like ']       = '%'.strtolower($_POST['codigo_dbi']).'%';
                }*/

                if ($_POST['seg_estado']) {
                    $arraywhere['seg_estado']                   = $_POST['seg_estado'];
                    $arraywherebusq['lower(seg_estado) like ']         = '%'.strtolower($_POST['seg_estado']).'%';
                }

                if ($_POST['distrito']) {
                    $arraywhere['des_distrito']                   = $_POST['distrito'];
                    $arraywherebusq['lower(des_distrito) like ']         = '%'.strtolower($_POST['distrito']).'%';
                }

                if ($_POST['tramo']) {
                    $arraywhere['des_tramo']                    = $_POST['tramo'];
                    $arraywherebusq['des_tramo like ']   = '%'.strtoupper($_POST['tramo']).'%';
                }

                if ($_POST['franja_dominio']) {
                    $arraywhere['franja_dominio']                    = $_POST['franja_dominio'];
                    $arraywherebusq['franja_dominio like ']   = '%'.strtoupper($_POST['franja_dominio']).'%';
                }
                if ($_POST['tipo_afectacion']) {
                    $arraywhere['des_tipo_afectacion']                    = $_POST['tipo_afectacion'];
                    $arraywherebusq['lower(des_tipo_afectacion) like ']   = strtolower($_POST['tipo_afectacion']).'%';
                }
               
                if ($_POST['nombre_completo']) {
                    $arraywhere['nombre_completo']                        = $_POST['nombre_completo'];
                    $arraywherebusq['lower(nombre_completo) like ']       = '%'.strtolower($_POST['nombre_completo']).'%';
                }

                if ($_POST['codigo_meu']) {
                    $arraywhere['codigo_meu']                        = $_POST['codigo_meu'];
                    $arraywherebusq['CAST(codigo_meu AS TEXT)  like']       = $_POST['codigo_meu'].'%';
                }

                $_SESSION['arraywhere_expedientes'] = $arraywhere;
                $_SESSION['arraywhere_expedientes_busqueda'] = $arraywherebusq;

                redirect('expedientes/expedientes/consulta/');
            }

             // ----- Paginacion Generica
            $mi_paginacion = $this->ion_auth->paginacion_generica(
                12,                         // resultados por por_pagina,
                4,                          // segmento uri a leer,
                5,                          // cantidad_enlaces,
                base_url(). 'expedientes/expedientes/consulta/',  // url completa de la pagina paginada
                'v_expedientes',                  // scheme y nombre de la tabla, para la consulta
                $_SESSION['arraywhere_expedientes_busqueda']
            );

            $this->data['pagination']       = $mi_paginacion['pagination'];

            $this->data['expedientes']      = $this->ion_auth_model->segmentador_paginas(
                //$expedientes      = $this->ion_auth_model->segmentador_paginas(
                $mi_paginacion['per_page'],     // resultados por pagina
                4,                              // segmento uri a leer
                'v_expedientes',                      // el nombre de la tabla a consultar $nombre_tabla
                $_SESSION['arraywhere_expedientes_busqueda'],
                'v_expedientes.id',
                'DESC'
            )->result();
            // ----- Fin paginacion

            foreach ($this->data['expedientes'] as $key => $value) {
                $i = 0;
                foreach ($value as $k => $val) {
                    $i = $i + 1;
                    if ($i == 1) {
                        //$cant_pol = $this->expedientes_model->f_existe_grafico_expe_id($value->expe_id);
                        //$exp['existe_poligono'] = $cant_pol;
                        $exp['existe_poligono'] = 1;


                        if (grupo_usuario(17) or grupo_usuario(27)) {
                            $exp['grupo_usuario'] = 'C';
                        } else {
                            $exp['grupo_usuario'] = 'N';
                        }
                    }
                    $exp[$k] = $val;
                }
                $exps[] = (object)$exp;
            }

            if (isset($exps)) {
                $this->data['expedientes'] = $exps;
            } else {
                $this->data['expedientes'] = null;
            }

            //emite un mensaje si es que se eliminó un expediente
            if (isset($_SESSION['last_exp_delete'])) {
                $this->session->set_flashdata('message', $_SESSION['last_exp_delete']);
                unset($_SESSION['last_exp_delete']);
            }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            /* Breadcrumbs */
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['habilitado_sis'] = grupo_usuario(3);
            $this->data['habilitado_gen'] = grupo_usuario(4);
            $this->data['habilitado_finan'] = grupo_usuario(5);
            $this->data['habilitado_coor_ubi'] = grupo_usuario(16);
            $this->data['habilitado_coor_dao'] = grupo_usuario(17);
            $this->data['habilitado_coor_daj'] = grupo_usuario(18);
            $this->data['habilitado_coor'] = grupo_usuario(31);
            $this->data['habilitado_ubi']['op'] = grupo_usuario(32);
            $this->data['habilitado_ubi']['sup'] = grupo_usuario(33);
            $this->data['habilitado_dao']['op'] = grupo_usuario(34);
            $this->data['habilitado_dao']['sup'] = grupo_usuario(35);
            $this->data['habilitado_daj']['op'] = grupo_usuario(36);
            $this->data['habilitado_daj']['sup'] = grupo_usuario(37);
            $this->data['oculta_dao'] = grupo_usuario(19);

            /* Load Template */
            $this->template->admin_render('expedientes/consulta', $this->data);
        }
    }



    public function reset_busqueda()
    {
        $_SESSION['arraywhere_expedientes']             = null;
        $_SESSION['arraywhere_expedientes_busqueda']    = null;

        redirect('expedientes/expedientes/index/');
    }

    public function ver_exp($expe_id)
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
            $this->data['id'] = $expe_id;
            $this->data['codigo'] = $expediente->des_codigo_unico;

            $coordenadas = $this->expedientes_model->view('coordenadas', array('id_expediente' => $expe_id))->result_array();
            if (!empty($coordenadas)) {
                for ($i=0; $i < count($coordenadas); $i++) {
                    $coors[$i]['coordenada_e'] = str_replace(".", ",", $coordenadas[$i]['coordenada_e']);
                    $coors[$i]['coordenada_n'] = str_replace(".", ",", $coordenadas[$i]['coordenada_n']);
                    $coors[$i]['lindero'] = $coordenadas[$i]['lindero'];
                }
                $this->data['coordenadas'] = $coors;
            }
            
            $archivos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => true))->result_array();
            $otros = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => false))->result_array();
                   
            $this->data['archivos'] = $archivos;
            $this->data['otros'] = $otros;

            if (isset($expediente->id_proyecto)) {
                $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
                $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
            }

            if (isset($expediente->id_tramo)) {
                $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
                $this->data['descripcion']['tramo'] = $tramo->nombre;
            }

            if (isset($expediente->id_departamento)) {
                $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
                if (isset($departamento)) {
                    $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
                } else {
                    $this->data['descripcion']['departamento'] = ' ';
                }
            }

            if (isset($expediente->id_distrito)) {
                $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
                if (isset($distrito)) {
                    $this->data['descripcion']['distrito'] = $distrito->dist_desc;
                } else {
                    $this->data['descripcion']['distrito'] = ' ';
                }
            }

            if (isset($expediente->id_tipo_afectacion)) {
                $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
                $this->data['descripcion']['afeccion'] = $afeccion->nombre;
            }

            if (isset($expediente->id_condicion_dominio)) {
                $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
                $this->data['descripcion']['dominio'] = $dominio->nombre;
            }

            if (isset($expediente->dao_indemnizacion_escogida)) {
                if ($expediente->dao_indemnizacion_escogida == '1') {
                    $expediente->dao_indemnizacion_escogida = 'Avalúo para porcentaje afectado del terreno';
                } else {
                    $expediente->dao_indemnizacion_escogida = 'Avalúo por el total del terreno';
                }
                
                # code...
            } else {
                $expediente->dao_indemnizacion_escogida = '';
            }
            

            $this->data['expediente']  = $expediente;

            $this->data['id_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'id_pdf',
                'id'       => 'id_pdf',
                'value'    => $expediente->id
            );
            $this->data['codigo_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_pdf',
                'id'       => 'codigo_pdf',
                'value'    => $expediente->des_codigo_unico
            );
            $this->data['id_proyecto'] = array(
                'type'     => 'hidden',
                'name'     => 'id_proyecto',
                'id'       => 'id_proyecto',
                'value'    => $expediente->id_proyecto
            );

            $this->data['oculta_dao'] = grupo_usuario(19);

            /* Load Template */
            $this->template->admin_render('expedientes/ver_expediente', $this->data);
        }
    }

    //obtener distritos
    public function get_distritos_por_departamento()
    {
        if ($this->input->is_ajax_request()) {
            $id_departamento = $this->input->post('id_departamento');
            $distritos = $this->expedientes_model->get_distritos($id_departamento);

            $output = ['' => 'Seleccione un distrito'];
            foreach ($distritos as $d) {
                $output[$d['id']] = $d['dist_desc'];
            }

            echo json_encode($output);
        } else {
            show_404();
        }
    }


    public function create()
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('expedientes_create'), 'expedientes/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        /* $this->form_validation->set_rules('id_proyecto', '<b>Proyecto</b>', 'required');
        $this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required');
        $this->form_validation->set_rules('id_tipo_afectacion', '<b>Tipo de afectación</b>', 'required');
        $this->form_validation->set_rules('id_condicion_dominio', '<b>Condición de dominio</b>', 'required'); */
        $this->form_validation->set_rules('id_departamento', '<b>Departamento</b>', 'required');
        $this->form_validation->set_rules('id_distrito', '<b>Distrito</b>', 'required');
        //$this->form_validation->set_rules('lado', '<b>Lado</b>', 'required');


        
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                /*if ($_POST['codigo_dbi']) {
                    $arraycampos['codigo_dbi']      = $_POST['codigo_dbi'];
                }*/

                if ($_POST['codigo']) {
                    $arraycampos['codigo']      = $_POST['codigo'];
                }

                if ($_POST['fecha_ingreso']) {
                    $arraycampos['fecha_ingreso']      = $_POST['fecha_ingreso'];
                }

                /* if ($_POST['codigo_meu']) {
                    $arraycampos['codigo_meu']             = $_POST['codigo_meu'];
                }

                if ($_POST['daj_fecha_meu']) {
                    $arraycampos['daj_fecha_meu']             = $_POST['daj_fecha_meu'];
                } */

                /* if ($_POST['desafectado'] && ($_POST['desafectado'] == 'SI')) {
                    $arraycampos['desafectado'] = 'SI';
                } else {
                    $arraycampos['desafectado'] = 'NO';
                } */

                /* if ($_POST['entrada_maquina'] && ($_POST['entrada_maquina'] == 'SI')) {
                    $arraycampos['entrada_maquina'] = 'SI';
                } else {
                    $arraycampos['entrada_maquina'] = 'NO';
                } */

                if ($_POST['id_proyecto']) {
                    $arraycampos['id_proyecto']             = $_POST['id_proyecto'];
                }

                /* if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']           = $_POST['id_tramo'];
                } */

                /* if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                } */

                /* if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                } */

                /* if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                } */
                
                /* if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                } */

                /* if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                } */

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                }

                /* if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                } */

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                }

                if ($_POST['nombre_completo']) {
                    $arraycampos['nombre_completo']       = $_POST['nombre_completo'];
                }

                /* if ($_POST['cedula_identidad']) {
                    $arraycampos['cedula_identidad']       = $_POST['cedula_identidad'];
                } */

                /* if ($_POST['tiene_otros_doc'] && ($_POST['tiene_otros_doc'] == 'SI')) {
                    $arraycampos['tiene_otros_doc'] = 'SI';
                } else {
                    $arraycampos['tiene_otros_doc'] = 'NO';
                } */

                if ($_POST['tiene_cotejo'] && ($_POST['tiene_cotejo'] == 'SI')) {
                    $arraycampos['tiene_cotejo'] = 'SI';
                } else {
                    $arraycampos['tiene_cotejo'] = 'NO';
                } 

                if ($_POST['tiene_mensura_judicial'] && ($_POST['tiene_mensura_judicial'] == 'SI')) {
                    $arraycampos['tiene_mensura_judicial'] = 'SI';
                } else {
                    $arraycampos['tiene_mensura_judicial'] = 'NO';
                } 
                

                if ($_POST['impuesto_al_dia'] && ($_POST['impuesto_al_dia'] == 'SI')) {
                    $arraycampos['impuesto_al_dia'] = 'SI';
                } else {
                    $arraycampos['impuesto_al_dia'] = 'NO';
                } 
            
                /* if ($_POST['fecha_nacimiento']) {
                    $arraycampos['fecha_nacimiento']       = $_POST['fecha_nacimiento'];
                } */

                /* if ($_POST['telefono']) {
                    $arraycampos['telefono']    = $_POST['telefono'];
                } */

                if ($_POST['cta_cte_catastral']) {
                    $arraycampos['cta_cte_catastral']  = $_POST['cta_cte_catastral'];
                }

                if ($_POST['padron']) {
                    $arraycampos['padron']  = $_POST['padron'];
                }

                if ($_POST['finca']) {
                    $arraycampos['finca']   = $_POST['finca'];
                } 

                if ($_POST['matricula']) {
                    $arraycampos['matricula']   = $_POST['matricula'];
                }

                if ($_POST['numero_escritura']) {
                    $arraycampos['numero_escritura'] = $_POST['numero_escritura'];
                }
                
                if ($_POST['escritura_publica']) {
                    $arraycampos['escritura_publica'] = $_POST['escritura_publica'];
                }
                
                if ($_POST['numero_titulo']) {
                    $arraycampos['numero_titulo'] = $_POST['numero_titulo'];
                }
                
                if ($_POST['superficie_legal']) {
                    $arraycampos['superficie_legal'] = str_replace(",", ".", $_POST['superficie_legal']); // Por si viene con coma decimal
                }
                
                if ($_POST['folio']) {
                    $arraycampos['folio'] = $_POST['folio'];
                }
                
                if ($_POST['fecha_inscripcion']) {
                    $arraycampos['fecha_inscripcion'] = $_POST['fecha_inscripcion'];
                }
                
                if ($_POST['juez']) {
                    $arraycampos['juez'] = $_POST['juez'];
                }
                
                if ($_POST['escribano']) {
                    $arraycampos['escribano'] = $_POST['escribano'];
                }

                /* if ($_POST['ubi_coordenada_e'] and $_POST['ubi_coordenada_n']) {
                        $arraycampos['ubi_coordenada_e'] = str_replace(",", ".", $_POST['ubi_coordenada_e']);
                        $arraycampos['ubi_coordenada_n'] = str_replace(",", ".", $_POST['ubi_coordenada_n']);
                } */

                /* if ($_POST['ubi_coordenada_x'] and $_POST['ubi_coordenada_y']) {
                    for ($i=0; $i < count($_POST['ubi_coordenada_x']); $i++) {
                        $coordenadas[$i]['E'] = str_replace(",", ".", $_POST['ubi_coordenada_x']);
                        $coordenadas[$i]['N'] = str_replace(",", ".", $_POST['ubi_coordenada_y']);
                    }
                } */

                /* if ($_POST['observacion_caratula']) {
                    $observaciones['observacion_caratula']['valor'] = $_POST['observacion_caratula'];
                    $observaciones['observacion_caratula']['nombre'] = 'caratula';
                } */

                /* if ($_POST['observacion_cedula']) {
                    $observaciones['observacion_cedula']['valor'] = $_POST['observacion_cedula'];
                    $observaciones['observacion_cedula']['nombre'] = 'cedula_identidad';
                } */

                /* if (! empty($_POST['lado'])) {
                    $arraycampos['lado'] = $_POST['lado'];
            
                } */

                /* if ($_POST['observacion_autorizacion']) {
                    $observaciones['observacion_autorizacion']['valor'] = $_POST['observacion_autorizacion'];
                    $observaciones['observacion_autorizacion']['nombre'] = 'autorizacion';
                } */


                $_SESSION['arraywhere_expedientes']          = null;
                $_SESSION['arraywhere_expedientes_busqueda'] = null;

                $_SESSION['arraycampos']          = $arraycampos;


                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                if ($_POST['codigo'] and $_POST['id_proyecto']) {
                    $unique_exp = $this->expedientes_model->view('expedientes', array('codigo' => $_POST['codigo'], 'id_proyecto' => $_POST['id_proyecto']))->num_rows();


                    if ($unique_exp > 0) {
                        $this->session->set_flashdata('message', 'Ya existe una carpeta con el mismo codigo.');
                        redirect('expedientes/expedientes/create');
                    } else {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$_POST['id_proyecto'];
                    }
                }
                
                $_SESSION['arraycampos']          = $arraycampos;

                $expe_create = $this->expedientes_model->crear_expediente($arraycampos);

                if ($expe_create and isset($coordenadas)) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_create, $coordenadas);
                }

                if ($expe_create and isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_create, $observaciones, 'gen');
                }

                if (!$expe_create) {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                } else {
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">EXPEDIENTE CREADO EXITOSAMENTE</span>');
                        redirect('expedientes/expedientes/create');
                }
            }
        } else {
            /*
            if (isset($arraycampos)) {

            } else {
                $arraycampos  $_SESSION['arraycampos'];
            }
            */
        }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', date('d/m/Y')),
            'class'    => 'form-control',
            'required' => 'true'
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi'),
            'class'    => 'form-control',
            'required' => 'true',
            );*/
            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            //'pattern'  => '^([A-Z][0-9]{0,4})?$',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo'),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
            $this->data['codigo_dgsa'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dgsa',
            //'pattern'  => '^([A-Z][0-9]{0,4})?$',
            'id'       => 'codigo_dgsa',
            'value'    => $this->form_validation->set_value('codigo_dgsa'),
            'class'    => 'form-control',
            'maxlength'=> '12'
            );    
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu'),
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'value'    => $this->form_validation->set_value('daj_fecha_meu'),
            'class'    => 'form-control',
            );
            $this->data['desafectado'] = array(
                    'type'     => 'radio',
                    'name'     => 'desafectado',
                    'id'       => 'desafectado',
                    'value_s'  => 'SI',
                    'value_n'  => 'NO',
                    'class'    => 'form-control'
            );
        
            $this->data['desafectado']['checked_s'] = false;
            $this->data['desafectado']['checked_n'] = true;

            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['entrada_maquina']['checked_s'] = false;
            $this->data['entrada_maquina']['checked_n'] = true;

            $this->data['tiene_cotejo'] = array(
                'type'     => 'radio',
                'name'     => 'tiene_cotejo',
                'id'       => 'tiene_cotejo',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['tiene_cotejo']['checked_s'] = false;
            $this->data['tiene_cotejo']['checked_n'] = true;

            $this->data['tiene_mensura_judicial'] = array(
                'type'     => 'radio',
                'name'     => 'tiene_mensura_judicial',
                'id'       => 'tiene_mensura_judicial',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['tiene_mensura_judicial']['checked_s'] = false;
            $this->data['tiene_mensura_judicial']['checked_n'] = true;
            
            $this->data['impuesto_al_dia'] = array(
                'type'     => 'radio',
                'name'     => 'impuesto_al_dia',
                'id'       => 'impuesto_al_dia',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['impuesto_al_dia']['checked_s'] = false;
            $this->data['impuesto_al_dia']['checked_n'] = true;
            
            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['urgente']['checked_s'] = false;
            $this->data['urgente']['checked_n'] = true;

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_e',
            'value'    => $this->form_validation->set_value('ubi_coordenada_e'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_n',
            'value'    => $this->form_validation->set_value('ubi_coordenada_n'),
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'value'    => $this->form_validation->set_value('ubi_coordenada_x'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'value'    => $this->form_validation->set_value('ubi_coordenada_y'),
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['franja_dominio'] = array(
                'type'     => 'radio',
                'name'     => 'franja_dominio',
                'id'       => 'franja_dominio',
                'value_fc'  => 'FC',
                'value_fd'  => 'FD',
                'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = true;
            $this->data['franja_dominio']['checked_fd'] = false;




            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;

            $tramos[''] = 'Seleccione el tramo';
            $this->data['tramo'] = $tramos;

            /* $subtramos[''] = 'Seleccione el subtramo';
            $this->data['subtramo'] = $subtramos; */

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = true;
            $this->data['franja_dominio']['checked_fd'] = false;

            $this->data['lado'] = array(
                'type'     => 'radio',
                'name'     => 'lado',
                'id'       => 'lado',
                'value_i'  => 'IZQUIERDO',
                'value_d'  => 'DERECHO',
                'value_p'  => 'PENDIENTE',
            	//'value'    => $this->form_validation->set_value('lado', $expediente->lado),
                'class'    => 'form-control'
            );


            if (isset($expediente->lado)) {
                switch ($expediente->lado) {
                    case 'IZQUIERDO':
                        $this->data['lado']['checked_i'] = true;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    case 'DERECHO':
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = true;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    default:
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = true;
                        break;
                }
            } else {
                $this->data['lado']['checked_i'] = false;
                $this->data['lado']['checked_d'] = false;
                $this->data['lado']['checked_p'] = true;
            }


            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion'),
            'class'    => 'form-control',
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;

            $distritos[''] = 'Seleccione el distrito';
            $this->data['distrito'] = $distritos;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar'),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('tipo_afectacion')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;

            $dominios[''] = 'Seleccione el tipo de ocupacion';
            $dominio = $this->expedientes_model->dropdown_data('tipo_ocupacion')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad'),
            'class'    => 'form-control',
            );
    
            $this->data['tiene_otros_doc'] = array(
                'type'     => 'radio',
                'name'     => 'tiene_otros_doc',
                'id'       => 'tiene_otros_doc',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['tiene_otros_doc']['checked_s'] = false;
            $this->data['tiene_otros_doc']['checked_n'] = true;
    
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'value'    => $this->form_validation->set_value('fecha_nacimiento'),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono'),
            'class'    => 'form-control'
            );
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron'),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula'),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );
            $this->data['numero_escritura'] = array(
                'type'     => 'text',
                'name'     => 'numero_escritura',
                'id'       => 'numero_escritura',
                'value'    => $this->form_validation->set_value('numero_escritura'),
                'class'    => 'form-control'
            );
            
            $this->data['escritura_publica'] = array(
                'type'     => 'text',
                'name'     => 'escritura_publica',
                'id'       => 'escritura_publica',
                'value'    => $this->form_validation->set_value('escritura_publica'),
                'class'    => 'form-control'
            );
            
            $this->data['numero_titulo'] = array(
                'type'     => 'text',
                'name'     => 'numero_titulo',
                'id'       => 'numero_titulo',
                'value'    => $this->form_validation->set_value('numero_titulo'),
                'class'    => 'form-control'
            );
            
            $this->data['superficie_legal'] = array(
                'type'     => 'text',
                'name'     => 'superficie_legal',
                'id'       => 'superficie_legal',
                'value'    => $this->form_validation->set_value('superficie_legal'),
                'class'    => 'form-control'
            );
            
            $this->data['folio'] = array(
                'type'     => 'text',
                'name'     => 'folio',
                'id'       => 'folio',
                'value'    => $this->form_validation->set_value('folio'),
                'class'    => 'form-control'
            );
            
            $this->data['fecha_inscripcion'] = array(
                'type'     => 'text',
                'name'     => 'fecha_inscripcion',
                'id'       => 'fecha_inscripcion',
                'value'    => $this->form_validation->set_value('fecha_inscripcion'),
                'class'    => 'form-control'
            );
            
            $this->data['juez'] = array(
                'type'     => 'text',
                'name'     => 'juez',
                'id'       => 'juez',
                'value'    => $this->form_validation->set_value('juez'),
                'class'    => 'form-control'
            );
            
            $this->data['escribano'] = array(
                'type'     => 'text',
                'name'     => 'escribano',
                'id'       => 'escribano',
                'value'    => $this->form_validation->set_value('escribano'),
                'class'    => 'form-control'
            );

        /* Load Template */
            $this->template->admin_render('expedientes/create_expe', $this->data);
    }

    public function create_desa()
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('expedientes_create'), 'expedientes/create_expe_desa');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('id_proyecto', '<b>Proyecto</b>', 'required');
        $this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required');
        $this->form_validation->set_rules('id_tipo_afectacion', '<b>Tipo de afectación</b>', 'required');
        $this->form_validation->set_rules('id_condicion_dominio', '<b>Condición de dominio</b>', 'required');
        $this->form_validation->set_rules('id_departamento', '<b>Departamento</b>', 'required');
        $this->form_validation->set_rules('id_distrito', '<b>Distrito</b>', 'required');
        //$this->form_validation->set_rules('lado', '<b>Lado</b>', 'required');


        
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                /*if ($_POST['codigo_dbi']) {
                    $arraycampos['codigo_dbi']      = $_POST['codigo_dbi'];
                }*/

                if ($_POST['codigo']) {
                    $arraycampos['codigo']      = $_POST['codigo'];
                }

                if ($_POST['fecha_ingreso']) {
                    $arraycampos['fecha_ingreso']      = $_POST['fecha_ingreso'];
                }

                if ($_POST['codigo_meu']) {
                    $arraycampos['codigo_meu']             = $_POST['codigo_meu'];
                }

                if ($_POST['daj_fecha_meu']) {
                    $arraycampos['daj_fecha_meu']             = $_POST['daj_fecha_meu'];
                }

                if ($_POST['desafectado'] && ($_POST['desafectado'] == 'SI')) {
                    $arraycampos['desafectado'] = 'SI';
                } else {
                    $arraycampos['desafectado'] = 'NO';
                }

                if ($_POST['entrada_maquina'] && ($_POST['entrada_maquina'] == 'SI')) {
                    $arraycampos['entrada_maquina'] = 'SI';
                } else {
                    $arraycampos['entrada_maquina'] = 'NO';
                }

                if ($_POST['id_proyecto']) {
                    $arraycampos['id_proyecto']             = $_POST['id_proyecto'];
                }

                if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']           = $_POST['id_tramo'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                }

                if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                }

                if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                }

                if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                }

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                }

                if ($_POST['nombre_completo']) {
                    $arraycampos['nombre_completo']       = $_POST['nombre_completo'];
                }

                if ($_POST['cedula_identidad']) {
                    $arraycampos['cedula_identidad']       = $_POST['cedula_identidad'];
                }

                if ($_POST['fecha_nacimiento']) {
                    $arraycampos['fecha_nacimiento']       = $_POST['fecha_nacimiento'];
                }

                if ($_POST['telefono']) {
                    $arraycampos['telefono']    = $_POST['telefono'];
                }

                if ($_POST['cta_cte_catastral']) {
                    $arraycampos['cta_cte_catastral']  = $_POST['cta_cte_catastral'];
                }

                if ($_POST['padron']) {
                    $arraycampos['padron']  = $_POST['padron'];
                }

                if ($_POST['finca']) {
                    $arraycampos['finca']   = $_POST['finca'];
                } 

                if ($_POST['matricula']) {
                    $arraycampos['matricula']   = $_POST['matricula'];
                }

                if ($_POST['ubi_coordenada_e'] and $_POST['ubi_coordenada_n']) {
                        $arraycampos['ubi_coordenada_e'] = str_replace(",", ".", $_POST['ubi_coordenada_e']);
                        $arraycampos['ubi_coordenada_n'] = str_replace(",", ".", $_POST['ubi_coordenada_n']);
                }

                if ($_POST['ubi_coordenada_x'] and $_POST['ubi_coordenada_y']) {
                    for ($i=0; $i < count($_POST['ubi_coordenada_x']); $i++) {
                        $coordenadas[$i]['E'] = str_replace(",", ".", $_POST['ubi_coordenada_x']);
                        $coordenadas[$i]['N'] = str_replace(",", ".", $_POST['ubi_coordenada_y']);
                    }
                }

                if (! empty($_POST['lado'])) {
                    $arraycampos['lado'] = $_POST['lado'];
            
                }

                if ($_POST['observacion_caratula']) {
                    $observaciones['observacion_caratula']['valor'] = $_POST['observacion_caratula'];
                    $observaciones['observacion_caratula']['nombre'] = 'caratula';
                }

                if ($_POST['observacion_cedula']) {
                    $observaciones['observacion_cedula']['valor'] = $_POST['observacion_cedula'];
                    $observaciones['observacion_cedula']['nombre'] = 'cedula_identidad';
                }



                if ($_POST['observacion_autorizacion']) {
                    $observaciones['observacion_autorizacion']['valor'] = $_POST['observacion_autorizacion'];
                    $observaciones['observacion_autorizacion']['nombre'] = 'autorizacion';
                }


                $_SESSION['arraywhere_expedientes']          = null;
                $_SESSION['arraywhere_expedientes_busqueda'] = null;

                $_SESSION['arraycampos']          = $arraycampos;


                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                if ($_POST['codigo'] and $_POST['id_proyecto']) {
                    $unique_exp = $this->expedientes_model->view('expedientes', array('codigo' => $_POST['codigo'], 'id_proyecto' => $_POST['id_proyecto']))->num_rows();


                    if ($unique_exp > 0) {
                        $this->session->set_flashdata('message', 'Ya existe una carpeta con el mismo codigo.');
                        redirect('expedientes/expedientes/create_desa');
                    } else {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$_POST['id_proyecto'];
                    }
                }
                
                $_SESSION['arraycampos']          = $arraycampos;

                $expe_create = $this->expedientes_model->crear_expediente($arraycampos);

                if ($expe_create and isset($coordenadas)) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_create, $coordenadas);
                }

                if ($expe_create and isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_create, $observaciones, 'gen');
                }

                if (!$expe_create) {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                } else {
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">EXPEDIENTE CREADO EXITOSAMENTE</span>');
                        redirect('expedientes/expedientes/create_desa');
                }
            }
        } else {
            /*
            if (isset($arraycampos)) {

            } else {
                $arraycampos  $_SESSION['arraycampos'];
            }
            */
        }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', date('d/m/Y')),
            'class'    => 'form-control',
            'required' => 'true'
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi'),
            'class'    => 'form-control',
            'required' => 'true',
            );*/
            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            //'pattern'  => '^([A-Z][0-9]{0,4})?$',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo'),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu'),
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'value'    => $this->form_validation->set_value('daj_fecha_meu'),
            'class'    => 'form-control',
            );
            $this->data['desafectado'] = array(
                    'type'     => 'radio',
                    'name'     => 'desafectado',
                    'id'       => 'desafectado',
                    'value_s'  => 'SI',
                    'value_n'  => 'NO',
                    'class'    => 'form-control'
            );
        
            $this->data['desafectado']['checked_s'] = false;
            $this->data['desafectado']['checked_n'] = true;

            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['entrada_maquina']['checked_s'] = false;
            $this->data['entrada_maquina']['checked_n'] = true;


            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
        
            $this->data['urgente']['checked_s'] = false;
            $this->data['urgente']['checked_n'] = true;

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_e',
            'value'    => $this->form_validation->set_value('ubi_coordenada_e'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_n',
            'value'    => $this->form_validation->set_value('ubi_coordenada_n'),
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'value'    => $this->form_validation->set_value('ubi_coordenada_x'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'value'    => $this->form_validation->set_value('ubi_coordenada_y'),
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['franja_dominio'] = array(
                'type'     => 'radio',
                'name'     => 'franja_dominio',
                'id'       => 'franja_dominio',
                'value_fc'  => 'FC',
                'value_fd'  => 'FD',
                'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = true;
            $this->data['franja_dominio']['checked_fd'] = false;
            
            $this->data['lado'] = array(
                'type'     => 'radio',
                'name'     => 'lado',
                'id'       => 'lado',
                'value_i'  => 'IZQUIERDO',
                'value_d'  => 'DERECHO',
                'value_p'  => 'PENDIENTE',
            	//'value'    => $this->form_validation->set_value('lado', $expediente->lado),
                'class'    => 'form-control'
            );


            if (isset($expediente->lado)) {
                switch ($expediente->lado) {
                    case 'IZQUIERDO':
                        $this->data['lado']['checked_i'] = true;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    case 'DERECHO':
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = true;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    default:
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = true;
                        break;
                }
            } else {
                $this->data['lado']['checked_i'] = false;
                $this->data['lado']['checked_d'] = false;
                $this->data['lado']['checked_p'] = true;
            }


            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;

            $tramos[''] = 'Seleccione el tramo';
            $this->data['tramo'] = $tramos;

            $subtramos[''] = 'Seleccione el subtramo';
            $this->data['subtramo'] = $subtramos;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = true;
            $this->data['franja_dominio']['checked_fd'] = false;

            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion'),
            'class'    => 'form-control',
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;

            $distritos[''] = 'Seleccione el distrito';
            $this->data['distrito'] = $distritos;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar'),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('tipo_afectacion')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;

            $dominios[''] = 'Seleccione el tipo de ocupacion';
            $dominio = $this->expedientes_model->dropdown_data('tipo_ocupacion')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo'),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad'),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'value'    => $this->form_validation->set_value('fecha_nacimiento'),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono'),
            'class'    => 'form-control'
            );
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron'),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula'),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

        /* Load Template */
            $this->template->admin_render('expedientes/create_expe_desa', $this->data);
    }


    public function reportemapas($expe_id = null)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('expedientes_create'), 'expedientes/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        if (isset($expe_id) or ! $expe_id == null) {
            $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        } else {
            $expediente = $this->expedientes_model->view_registro_null('v_expedientes')->row();
            $expediente->id_tipo_afectacion = 0;
            $expediente->id_condicion_dominio = 0;
        }
        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('id_proyecto', '<b>Proyecto</b>', 'required');
        //$this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required');
        //$this->form_validation->set_rules('id_tipo_afectacion', '<b>Tipo de afectación</b>', 'required');
        //$this->form_validation->set_rules('id_condicion_dominio', '<b>Condición de dominio</b>', 'required');
        //$this->form_validation->set_rules('id_departamento', '<b>Departamento</b>', 'required');
        //$this->form_validation->set_rules('id_distrito', '<b>Distrito</b>', 'required');
        
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                $arraywhere = null;


                if ($_POST['desafectado'] ) {
                    $arraycampos['desafectado'] = $_POST['desafectado'];
                    $arraywhere['desafectado'] = $_POST['desafectado'];
                } else {
                    $arraycampos['desafectado'] = 'TO';
                    $arraywhere['desafectado'] = 'TO';
                }

                if ($_POST['entrada_maquina'] ) {
                    $arraycampos['entrada_maquina'] = $_POST['entrada_maquina'];
                    $arraywhere['entrada_maquina'] = $_POST['entrada_maquina'];
                } else {
                    $arraycampos['entrada_maquina'] = 'TO';
                    $arraywhere['entrada_maquina'] = 'TO';
                }
                if ($_POST['urgente'] ) {
                    $arraycampos['urgente'] = $_POST['urgente'];
                    $arraywhere['urgente'] = $_POST['urgente'];
                } else {
                    $arraycampos['urgente'] = 'TO';
                    $arraywhere['urgente'] = 'TO';
                }
                if ($_POST['id_proyecto']) {
                    $arraycampos['id_proyecto']  = $_POST['id_proyecto'];
                    $arraywhere['id_proyecto']  = $_POST['id_proyecto'];
                }

                if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']     = $_POST['id_tramo'];
                    $arraywhere['id_tramo']     = $_POST['id_tramo'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                    $arraywhere['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                    $arraywhere['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                    $arraywhere['franja_dominio'] = $_POST['franja_dominio'];
                }

                if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                    $arraywhere['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                    $arraywhere['progresiva_final']  = $_POST['progresiva_final'];
                }

                /*if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }*/

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                    $arraywhere['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                    $arraywhere['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                    $arraywhere['lugar']   = $_POST['lugar'];
                }

                if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                    $arraywhere['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                } else {
                    $arraycampos['id_tipo_afectacion']     = 0;
                    $arraywhere['id_tipo_afectacion']     = 0;
                }

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                    $arraywhere['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                } else {
                    $arraycampos['id_condicion_dominio']     = 0;
                    $arraywhere['id_condicion_dominio']     = 0;
                }
                

                $_SESSION['arraywhere_expedientes']          = null;
                $_SESSION['arraywhere_expedientes_busqueda'] = null;
                $_SESSION['arraycampos']          = $arraycampos;
                $_SESSION['arraywhere']           = $arraywhere;
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }
                if ($_POST['codigo'] and $_POST['id_proyecto']) {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$_POST['id_proyecto'];
                }                
                $_SESSION['arraycampos']          = $arraycampos;

                if ($accion==1) {
                    //http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_A4_listado_afectados_tramo.php?id_tramo=2&usr=1
                    //$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimir/mopc_A4_plano_individual.php?";
                    
                $i_jameuge = "https://www.mopc.py/sgeReport/ferramentas/imprimir/mopc_gl_A4_listado2_afectados_tramo.php?";
                    //$i_jameuge = $i_jameuge . "mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_A4_plano_individual.map";
                    $i=0;
                    foreach ($arraywhere as $k => $v) {
                        $i=$i+1;
                        if ($i==1) {
                            $i_jameuge = $i_jameuge . $k."=".$v;
                        } else {   
                            $i_jameuge = $i_jameuge . "&".$k."=".$v;
                        }                      
                    } 
                    $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                    //$i_jameuge = $i_jameuge . "&hoja=".$hoja;         
                    //$i_jameuge = $i_jameuge . "&par_escala=".$par_escala;   
                    //$i_jameuge = $i_jameuge . "&genera_per=N";  
                        /*
                        echo '<pre>';
                        print_r($i_jameuge);
                        echo '</pre>';
                        show_error(1);
                        */
                    redirect($i_jameuge);
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 1</span>');
                        redirect('expedientes/expedientes/reportemapas/'.$expe_id);                    
                } else {
                    if ($accion==2) {


                        $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_a3_mapa_tramo_afectacion.php?mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_gl_a3_tramo_afectacion.map&interface=googlemaps";                      
                        $i=0;
                        foreach ($arraywhere as $k => $v) {
                            $i=$i+1;
                                $i_jameuge = $i_jameuge . "&".$k."=".$v;                     
                        } 
                        $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                        redirect($i_jameuge);


                        $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 2</span>');
                        redirect('expedientes/expedientes/reportemapas/'.$expe_id);                        
                    } else {
                        if ($accion==3) {

                            $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_a3_mapa_tramo_afectacion_det.php?mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_gl_a3_tramo_afectacion.map&interface=googlemaps";                      
                            $i=0;

                            foreach ($arraywhere as $k => $v) {
                                $i=$i+1;
                                    $i_jameuge = $i_jameuge . "&".$k."=".$v;                     
                            } 
                            $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                            redirect($i_jameuge);

                            $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 3</span>');
                            redirect('expedientes/expedientes/reportemapas/'.$expe_id);                            
                    
                        } else {
                           if ($accion==4) {

                                $i_jameuge = "http://172.16.55.134/sge/fpdf/reportes/mopc_gl_A4_report_exp_proceso_dbi.php?id_proyecto=".$id_proyecto. "&usr=".$_SESSION['user_id'];                      
                                $i=0;
    
                                foreach ($arraywhere as $k => $v) {
                                    $i=$i+1;
                                        $i_jameuge = $i_jameuge .$k."=".$v;                     
                                } 
                                $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                                redirect($i_jameuge);
    
                                $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 4</span>');
                                redirect('expedientes/expedientes/reportemapas/'.$expe_id);                            
                        
                            } else {
                                $expe_generado = true;
                            }
                        }                      
                    }
                }
                $expe_generado = true;              

                if (!$expe_generado) {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                } else {
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">REPORTE GENERADO EXITOSAMENTE</span>');
                        redirect('expedientes/expedientes/reportemapas/'.$expe_id);
                }
            }
        } else {
            $sinaccion = false; 
        }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', date('d/m/Y')),
            //'value'    => $this->form_validation->set_value('fecha_ingreso', formato_fecha($expediente->fecha_ingreso)),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi'),
            'class'    => 'form-control',
            'required' => 'true',
            );*/
            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            'pattern'  => '^([A-Z]{0,2}[0-9]{0,4})?$',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo'),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu'),
            'class'    => 'form-control'
            );

            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'value'    => $this->form_validation->set_value('daj_fecha_meu'),
            'class'    => 'form-control',
            );
            $this->data['desafectado'] = array(
                    'type'     => 'radio',
                    'name'     => 'desafectado',
                    'id'       => 'desafectado',
                    'value_s'  => 'SI',
                    'value_n'  => 'NO',
                    'value_t'  => 'TO',
                    'class'    => 'form-control'
            );
        
            $this->data['desafectado']['checked_s'] = false;
            $this->data['desafectado']['checked_n'] = false;
            $this->data['desafectado']['checked_t'] = true;

            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'value_t'  => 'TO',
                'class'    => 'form-control'
            );
        
            $this->data['entrada_maquina']['checked_s'] = false;
            $this->data['entrada_maquina']['checked_n'] = false;
            $this->data['entrada_maquina']['checked_t'] = true;


            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'value_t'  => 'TO',
                'class'    => 'form-control'
            );
        
            $this->data['urgente']['checked_s'] = false;
            $this->data['urgente']['checked_n'] = false;
            $this->data['urgente']['checked_t'] = true;

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_e',
            'value'    => $this->form_validation->set_value('ubi_coordenada_e'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_n',
            'value'    => $this->form_validation->set_value('ubi_coordenada_n'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'value'    => $this->form_validation->set_value('ubi_coordenada_x'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'value'    => $this->form_validation->set_value('ubi_coordenada_y'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'value_ft'  => 'FT',
                    'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = false;
            $this->data['franja_dominio']['checked_fd'] = false;
            $this->data['franja_dominio']['checked_ft'] = true;

            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion'),
            'class'    => 'form-control',
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar'),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('v_tipos_afectacion_todos')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;
            $this->data['tipo_afectacion_sel'] = $expediente->id_tipo_afectacion;

            $dominios[''] = 'Seleccione condicion de dominio';
            $dominio = $this->expedientes_model->dropdown_data('v_tipos_ocupacion_todos')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;
            $this->data['condicion_dominio_sel'] = $expediente->id_condicion_dominio;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad'),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'value'    => $this->form_validation->set_value('fecha_nacimiento'),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono'),
            'class'    => 'form-control'
            );
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron'),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula'),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

        /* Load Template */
            $this->template->admin_render('expedientes/reportemapas', $this->data);
    }

    public function reporteprueba($expe_id = null)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('expedientes_create'), 'expedientes/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        //if (isset($expe_id) or ! $expe_id == null) {
        //    $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        //} else {
            $expediente = $this->expedientes_model->view_registro_null('v_expedientes')->row();
            $expediente->id_tipo_afectacion = 0;
            $expediente->id_condicion_dominio = 0;
            $expediente->n_hoja = 1;
            $expediente->id_proyecto = 0;
            $expediente->id_tramo = 0;
            $expediente->id_subtramo = 0; 
            $expediente->id_departamento = null;
            $expediente->id_distrito = null;
            $expediente->id_tipo_afectacion = 0;   
            $expediente->total_hojas = 1;   
            $expediente->id_condicion_dominio = 0; 
      
        //}
        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('rm1_id_proyecto', '<b>Proyecto</b>', 'required');
        //$this->form_validation->set_rules('id_tramo',    '<b>Tramo</b>',    'required');
        //$this->form_validation->set_rules('id_tipo_afectacion', '<b>Tipo de afectación</b>', 'required');
        //$this->form_validation->set_rules('id_condicion_dominio', '<b>Condición de dominio</b>', 'required');
        //$this->form_validation->set_rules('id_departamento', '<b>Departamento</b>', 'required');
        //$this->form_validation->set_rules('id_distrito', '<b>Distrito</b>', 'required');
        
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                $arraywhere = null;

                if ($_POST['desafectado'] ) {
                    $arraycampos['desafectado'] = $_POST['desafectado'];
                    $arraywhere['desafectado'] = $_POST['desafectado'];
                } else {
                    $arraycampos['desafectado'] = 'TO';
                    $arraywhere['desafectado'] = 'TO';
                }

                if ($_POST['entrada_maquina'] ) {
                    $arraycampos['entrada_maquina'] = $_POST['entrada_maquina'];
                    $arraywhere['entrada_maquina'] = $_POST['entrada_maquina'];
                } else {
                    $arraycampos['entrada_maquina'] = 'TO';
                    $arraywhere['entrada_maquina'] = 'TO';
                }

                if ($_POST['urgente'] ) {
                    $arraycampos['urgente'] = $_POST['urgente'];
                    $arraywhere['urgente'] = $_POST['urgente'];
                } else {
                    $arraycampos['urgente'] = 'TO';
                    $arraywhere['urgente'] = 'TO';
                }
                if ($_POST['rm1_id_proyecto']) {
                    $arraycampos['id_proyecto']  = $_POST['rm1_id_proyecto'];
                    $arraywhere['id_proyecto']  = $_POST['rm1_id_proyecto'];
                }

                if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']     = $_POST['id_tramo'];
                    $arraywhere['id_tramo']     = $_POST['id_tramo'];
                }

                if ($_POST['total_hojas']) {
                    $arraycampos['total_hojas']     = $_POST['total_hojas'];
                    $arraywhere['total_hojas']     = $_POST['total_hojas'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                    $arraywhere['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                    $arraywhere['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                    $arraywhere['franja_dominio'] = $_POST['franja_dominio'];
                }

                /*if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                    $arraywhere['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                    $arraywhere['progresiva_final']  = $_POST['progresiva_final'];
                }

                if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }*/

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                    $arraywhere['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                    $arraywhere['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                    $arraywhere['lugar']   = $_POST['lugar'];
                }

                if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                    $arraywhere['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                } else {
                    $arraycampos['id_tipo_afectacion']     = 0;
                    $arraywhere['id_tipo_afectacion']     = 0;
                }

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                    $arraywhere['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                } else {
                    $arraycampos['id_condicion_dominio']     = 0;
                    $arraywhere['id_condicion_dominio']     = 0;
                }
        
                $_SESSION['arraywhere_expedientes']          = null;
                $_SESSION['arraywhere_expedientes_busqueda'] = null;
                $_SESSION['arraycampos']          = $arraycampos;
                $_SESSION['arraywhere']           = $arraywhere;
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }
                if ($_POST['codigo'] and $_POST['id_proyecto']) {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$_POST['id_proyecto'];
                }                
                $_SESSION['arraycampos']          = $arraycampos;

                if ($accion==1) {
                    //http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_A4_listado_afectados_tramo.php?id_tramo=2&usr=1
                    //$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimir/mopc_A4_plano_individual.php?";
                    $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_A4_listado2_afectados_tramo.php?";
                    //$i_jameuge = $i_jameuge . "mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_A4_plano_individual.map";
                    $i=0;
                    foreach ($arraywhere as $k => $v) {
                        $i=$i+1;
                        if ($i==1) {
                            $i_jameuge = $i_jameuge . $k."=".$v;
                        } else {   
                            $i_jameuge = $i_jameuge . "&".$k."=".$v;
                        }                      
                    } 
                    $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                    //$i_jameuge = $i_jameuge . "&hoja=".$hoja;         
                    //$i_jameuge = $i_jameuge . "&par_escala=".$par_escala;   
                    //$i_jameuge = $i_jameuge . "&genera_per=N";  
                        /*
                        echo '<pre>';
                        print_r($i_jameuge);
                        echo '</pre>';
                        show_error(1);
                        */
                    redirect($i_jameuge);
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 1</span>');
                        redirect('expedientes/expedientes/reporteprueba/'.$expe_id);                    
                } else {
                    if ($accion==2) {


                        $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_a3_mapa_tramo_afectacion2.php?mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_gl_a3_tramo_afectacion2.map&interface=googlemaps";                      
                        $i=0;
                        foreach ($arraywhere as $k => $v) {
                            $i=$i+1;
                                $i_jameuge = $i_jameuge . "&".$k."=".$v;                     
                        } 
                        $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];

            $expediente->id_proyecto = 0;
            $expediente->id_tramo = 0;
            $expediente->id_subtramo = 0;

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;


                        redirect($i_jameuge);


                        $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 2</span>');
                        redirect('expedientes/expedientes/reporteprueba/'.$expe_id);                        
                    } else {
                        if ($accion==3) {

                            $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_a3_mapa_tramo_afectacion_det.php?mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_gl_a3_tramo_afectacion.map&interface=googlemaps";                      
                            $i=0;

                            foreach ($arraywhere as $k => $v) {
                                $i=$i+1;
                                    $i_jameuge = $i_jameuge . "&".$k."=".$v;                     
                            } 
                            $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                            redirect($i_jameuge);

                            $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 3</span>');
                            redirect('expedientes/expedientes/reporteprueba/'.$expe_id);                            
                    
                        } else {
                           if ($accion==4) {

                                $i_jameuge = "http://172.16.55.134:8060/i3geo/ferramentas/imprimir/mopc_gl_a3_mapa_tramo_afectacion_det.php?mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_gl_a3_tramo_afectacion.map&interface=googlemaps";                      
                                $i=0;
    
                                foreach ($arraywhere as $k => $v) {
                                    $i=$i+1;
                                        $i_jameuge = $i_jameuge . "&".$k."=".$v;                     
                                } 
                                $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
                                redirect($i_jameuge);
    
                                $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">ACCION 4</span>');
                                redirect('expedientes/expedientes/reporteprueba/'.$expe_id);                            
                        
                            } else {
                                $expe_generado = true;
                            }
                        }                      
                    }
                }
                $expe_generado = true;              

                if (!$expe_generado) {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                } else {
                    $this->session->set_flashdata('message', '<span id="botonCodigo" type="button" data-toggle="modal" data-target="#modalCodigo">REPORTE GENERADO EXITOSAMENTE</span>');
                        redirect('expedientes/expedientes/reporteprueba/'.$expe_id);
                }
            }
        } else {

            /*
            if (isset($arraycampos)) {

            } else {
                $arraycampos  $_SESSION['arraycampos'];
            }
            */
        }

            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', date('d/m/Y')),
            //'value'    => $this->form_validation->set_value('fecha_ingreso', formato_fecha($expediente->fecha_ingreso)),
            'class'    => 'form-control'
            //,'required' => 'true'
            );

            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            //'pattern'  => '^([A-Z][0-9]{0,4})?$',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo'),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu'),
            'class'    => 'form-control'
            );

            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'value'    => $this->form_validation->set_value('daj_fecha_meu'),
            'class'    => 'form-control',
            );
            $this->data['desafectado'] = array(
                    'type'     => 'radio',
                    'name'     => 'desafectado',
                    'id'       => 'desafectado',
                    'value_s'  => 'SI',
                    'value_n'  => 'NO',
                    'value_t'  => 'TO',
                    'class'    => 'form-control'
            );
        
            $this->data['desafectado']['checked_s'] = false;
            $this->data['desafectado']['checked_n'] = false;
            $this->data['desafectado']['checked_t'] = true;

            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'value_t'  => 'TO',
                'class'    => 'form-control'
            );
        
            $this->data['entrada_maquina']['checked_s'] = false;
            $this->data['entrada_maquina']['checked_n'] = false;
            $this->data['entrada_maquina']['checked_t'] = true;


            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'value_t'  => 'TO',
                'class'    => 'form-control'
            );
        
            $this->data['urgente']['checked_s'] = false;
            $this->data['urgente']['checked_n'] = false;
            $this->data['urgente']['checked_t'] = true;

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_e',
            'value'    => $this->form_validation->set_value('ubi_coordenada_e'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'id'       => 'ubi_coordenada_n',
            'value'    => $this->form_validation->set_value('ubi_coordenada_n'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'value'    => $this->form_validation->set_value('ubi_coordenada_x'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'value'    => $this->form_validation->set_value('ubi_coordenada_y'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'value_ft'  => 'FT',
                    'class'    => 'form-control'
            );
        
            $this->data['franja_dominio']['checked_fc'] = false;
            $this->data['franja_dominio']['checked_fd'] = false;
            $this->data['franja_dominio']['checked_ft'] = true;

            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion'),
            'class'    => 'form-control',
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar'),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('v_tipos_afectacion_todos')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;
            $this->data['tipo_afectacion_sel'] = $expediente->id_tipo_afectacion;


            $a_hojas[''] = 'Seleccione cantidad de hojas';
            $d_hojas = $this->expedientes_model->dropdown_data('v_reportemapas_n_hojas')->result_array();
            foreach ($d_hojas as $item) {
                $a_hojas[$item['n_hoja']] = $item['n_hoja'].' - '.$item['nombre'];
            }
            $this->data['hojas'] = $a_hojas;
            $this->data['hojas_sel'] = $expediente->n_hoja;




            $dominios[''] = 'Seleccione condicion de dominio';
            $dominio = $this->expedientes_model->dropdown_data('v_tipos_ocupacion_todos')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;
            $this->data['condicion_dominio_sel'] = $expediente->id_condicion_dominio;
           
            

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo'),
            'class'    => 'form-control'
            //,'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad'),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'value'    => $this->form_validation->set_value('fecha_nacimiento'),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono'),
            'class'    => 'form-control'
            );
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron'),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca'),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula'),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

        /* Load Template */
            $this->template->admin_render('expedientes/reporteprueba', $this->data);
    }


    public function importar_expediente()
    {
        $id             = $_POST['id_pdf'];
        $codigo         = $_POST['codigo_pdf'];
        $id_proyecto    = $_POST['id_proyecto'];

        $accion = 0;
        if (isset($_POST['accion'])) {
            $accion = intval($_POST['accion']);
        } else {
            $accion = 0;
        }

    	//LINUX
        $ruta_dest = MEDIA_FOLDER.$codigo.'/';

		//WINDOWS
        //$ruta_dest = trim(MEDIA_FOLDER).str_replace(' ','',$codigo.'\ ');

        if ($accion== 9) {
            if (isset($_FILES['expediente_pdf'])) {
                $array_archivos = rearrange($_FILES['expediente_pdf']);
                foreach ($array_archivos as $archivo) {
                    if (empty($archivo['name'])) {
                        break;
                    }

                    $nompdf = str_replace(' ', '_', $archivo['name']);
                    $ruta_completa = $codigo.'/'.$nompdf;
                    //$ruta_completa = $codigo.str_replace(' ','','\ '.$nompdf);
                
                    mkdir($ruta_dest);
                    copy($archivo['tmp_name'], $ruta_dest.$nompdf);

                    $documentos = $this->expedientes_model->guardar_archivo($id, $codigo, $nompdf, $ruta_completa, true);
                }
            }

            if (isset($_FILES['otros'])) {
                $array_archivos = rearrange($_FILES['otros']);
                foreach ($array_archivos as $archivo) {
                    if (empty($archivo['name'])) {
                        break;
                    }

                    $nompdf = str_replace(' ', '_', $archivo['name']);
                    $ruta_completa = $codigo.'/'.$nompdf;
                    //$ruta_completa = $codigo.str_replace(' ','','\ '.$nompdf);
                    //echo $ruta_dest;
                
                    mkdir($ruta_dest);
                    copy($archivo['tmp_name'], $ruta_dest.$nompdf);

                    $documentos = $this->expedientes_model->guardar_archivo($id, $codigo, $nompdf, $ruta_completa, false);
                }
            }
                
            $this->session->set_flashdata('message', 'Guardado');
            redirect('expedientes/expedientes/edit_expe/'.$id);
        }
    }

    public function ver_archivo($id)
    {

        $documento = $this->expedientes_model->view('documentos_sge', array('id' => $id))->row();

    	//LINUX
        //$ruta_dest = $str_replace(' ','',str_replace('\ ','/ ',MEDIA_FOLDER.'\ '.$documento->ruta_completa)));

    	//$ruta_dest = trim(MEDIA_FOLDER).str_replace('\ ','/',$documento->ruta_completa);
    	$ruta_dest = MEDIA_FOLDER.$documento->ruta_completa;
        //echo $ruta_dest;
    	//exit; 
        
    	//WINDOWS
    	//$ruta_dest = trim(MEDIA_FOLDER).str_replace(' ','',str_replace('/','\ ',$documento->ruta_completa));
  		//$ruta_archivo = trim(MEDIA_FOLDER).str_replace(' ','',str_replace('/','\ ',$documento->ruta_completa));


        header("Content-Length: " . filesize($ruta_dest));
        header("Content-type: application/pdf");
        header("Content-disposition: inline; filename=".basename($ruta_dest));
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        $filepath = readfile($ruta_dest);
    }



    public function download_expe($id,$id_expediente)
    {

        $documento = $this->expedientes_model->view('documentos_sge', array('id' => $id))->row();

    	//LINUX
        //este es el original $ruta_dest = MEDIA_FOLDER.$documento->ruta_completa;
        // ESTE FUNCIONO HOY EN 2021/11/11
        $ruta_dest = MEDIA_FOLDER.str_replace(' ','',$documento->ruta_completa);
    	//$ruta_dest = MEDIA_FOLDER.$documento->ruta_completa;
    
    	//WINDOWS
        //$ruta_dest = trim(MEDIA_FOLDER).str_replace(' ','',str_replace('/','\ ',$documento->ruta_completa));

                        //echo $ruta_dest;
                        //show_error(1);
               
        if (realpath($ruta_dest)) {
            $data = file_get_contents($ruta_dest);
            force_download($documento->archivo, $data);
        } else {
            $this->session->set_flashdata('message', 'No existe un archivo para descargar');
            redirect('expedientes/expedientes/edit_expe/'.$id_expediente);
        }

        //redirect('expedientes/expedientes/edit_expe/'.$id);
    }

    public function delete_expe($codigo, $id)
    {
        $documento = $this->expedientes_model->view('documentos_sge', array('id' => $id))->row();

        //$dir = MEDIA_FOLDER.$codigo.'/';
        $ruta_archivo = MEDIA_FOLDER.$documento->ruta_completa;
        //echo $ruta_archivo;
    	//exit; 
        

        //$ruta_archivo = trim(MEDIA_FOLDER).str_replace(' ','',str_replace('/','\ ',$documento->ruta_completa));

        if (realpath($ruta_archivo)) {
            unlink($ruta_archivo);
            $eliminar_archivo = $this->expedientes_model->eliminar_archivo($id);

            $this->session->set_flashdata('message', 'Archivo eliminado');
            redirect('expedientes/expedientes/edit_expe/'.$documento->id_expediente);
        } else {
            $eliminar_archivo = $this->expedientes_model->eliminar_archivo($id);
            $this->session->set_flashdata('message', 'No existe el archivo');
            redirect('expedientes/expedientes/edit_expe/'.$documento->id_expediente);
        }
    }

    public function eliminar_archivos($expe_id, $documentos)
    {
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
         
        foreach ($documentos as $doc) {
            $dir = MEDIA_FOLDER.$expediente->des_codigo_unico.'/';
            $ruta_archivo = MEDIA_FOLDER.$doc['ruta_completa'];

            if (realpath($ruta_archivo)) {
                unlink($ruta_archivo);
                $eliminar_archivo = $this->expedientes_model->eliminar_archivo($doc['id']);
            }
        }
    }


    public function edit_expe($expe_id, $area = null)
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        $coordenadas = $this->expedientes_model->view('coordenadas', array('id_expediente' => $expe_id), array('column' => 'nro', 'direction' => 'ASC'))->result_array();
        
        if (!empty($coordenadas)) {
            for ($i=0; $i < count($coordenadas); $i++) {
                $coors[$i]['coordenada_e'] = str_replace(".", ",", $coordenadas[$i]['coordenada_e']);
                $coors[$i]['coordenada_n'] = str_replace(".", ",", $coordenadas[$i]['coordenada_n']);
            }
            $this->data['coordenadas'] = $coors;
        }

        $this->data['id'] = $expe_id;
        $this->data['habilitado'] = grupo_usuario(4);


        $archivos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => true))->result_array();
        $otros = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => false))->result_array();
               
        $this->data['archivos'] = $archivos;
        $this->data['otros'] = $otros;

        
        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('codigo', '<b>Código</b>', 'required');
        /* $this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required'); */
            

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                /*if ($_POST['codigo_dbi']) {
                    $arraycampos['codigo_dbi']      = $_POST['codigo_dbi'];
                }*/

                if ($_POST['codigo']) {
                    $arraycampos['codigo']      = $_POST['codigo'];
                }

            /* if ($_POST['codigo_dgsa']) {
                    $arraycampos['codigo_dgsa']      = $_POST['codigo_dgsa'];
                }
            */
                if ($_POST['fecha_ingreso']) {
                    $arraycampos['fecha_ingreso']      = $_POST['fecha_ingreso'];
                }

                /* if ($_POST['codigo_meu']) {
                    $arraycampos['codigo_meu']             = $_POST['codigo_meu'];
                }

                if ($_POST['daj_fecha_meu']) {
                    $arraycampos['daj_fecha_meu']             = $_POST['daj_fecha_meu'];
                }

                if ($_POST['desafectado'] && ($_POST['desafectado'] == 'SI')) {
                    $arraycampos['desafectado'] = 'SI';
                } else {
                    $arraycampos['desafectado'] = 'NO';
                }

                if ($_POST['entrada_maquina'] && ($_POST['entrada_maquina'] == 'SI')) {
                    $arraycampos['entrada_maquina'] = 'SI';
                } else {
                    $arraycampos['entrada_maquina'] = 'NO';
                } */

                if ($_POST['tiene_cotejo'] && ($_POST['tiene_cotejo'] == 'SI')) {
                    $arraycampos['tiene_cotejo'] = 'SI';
                } else {
                    $arraycampos['tiene_cotejo'] = 'NO';
                } 

                if ($_POST['tiene_mensura_judicial'] && ($_POST['tiene_mensura_judicial'] == 'SI')) {
                    $arraycampos['tiene_mensura_judicial'] = 'SI';
                } else {
                    $arraycampos['tiene_mensura_judicial'] = 'NO';
                } 

                if ($_POST['impuesto_al_dia'] && ($_POST['impuesto_al_dia'] == 'SI')) {
                    $arraycampos['impuesto_al_dia'] = 'SI';
                } else {
                    $arraycampos['impuesto_al_dia'] = 'NO';
                } 

                if ($_POST['urgente'] && ($_POST['urgente'] == 'SI')) {
                    $arraycampos['urgente'] = 'SI';
                } else {
                    $arraycampos['urgente'] = 'NO';
                }

                /*
                if ($_POST['ubi_coordenada_e'] and $_POST['ubi_coordenada_n']) {
                        $arraycampos['ubi_coordenada_e'] = str_replace(",", ".", $_POST['ubi_coordenada_e']);
                        $arraycampos['ubi_coordenada_n'] = str_replace(",", ".", $_POST['ubi_coordenada_n']);
                }

                if ($_POST['ubi_coordenada_x'] and $_POST['ubi_coordenada_y']) {
                    for ($i=0; $i < count($_POST['ubi_coordenada_x']); $i++) {
                        $coors_nuevo[$i]['E'] = str_replace(",", ".", $_POST['ubi_coordenada_x']);
                        $coors_nuevo[$i]['N'] = str_replace(",", ".", $_POST['ubi_coordenada_y']);
                        $coors_nuevo[$i]['nro'] = $i+1;
                    }
                }
                */
                /* if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']           = $_POST['id_tramo'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                }

                if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                }

                if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }
                */
                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                }

                /* if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                } */

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                }

                if ($_POST['nombre_completo']) {
                    $arraycampos['nombre_completo']       = $_POST['nombre_completo'];
                }

                /* if ($_POST['cedula_identidad']) {
                    $arraycampos['cedula_identidad']       = $_POST['cedula_identidad'];
                } */

                /*if ($_POST['tiene_otros_doc']) {
                    $arraycampos['tiene_otros_doc']       = $_POST['tiene_otros_doc'];
                }*/
            
                /* if ($_POST['tiene_otros_doc'] && ($_POST['tiene_otros_doc'] == 'SI')) {
                    $arraycampos['tiene_otros_doc'] = 'SI';
                } else {
                    $arraycampos['tiene_otros_doc'] = 'NO';
                }   */          


                /* if ($_POST['fecha_nacimiento']) {
                    $arraycampos['fecha_nacimiento']       = $_POST['fecha_nacimiento'];
                }
                */
                /* if ($_POST['telefono']) {
                    $arraycampos['telefono']    = $_POST['telefono'];
                } */

                if ($_POST['cta_cte_catastral']) {
                    $arraycampos['cta_cte_catastral']  = $_POST['cta_cte_catastral'];
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }                    
                } else {
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }
                } 

                if ($_POST['padron']) {
                    $arraycampos['padron']  = $_POST['padron'];
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }                    
                } else {
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }
                } 

                if ($_POST['finca']) {
                    $arraycampos['finca']   = $_POST['finca'];
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } else {
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } 
                if ($_POST['matricula']) {
                    $arraycampos['matricula']   = $_POST['matricula'];
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }                    
                } else {
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }
                } 

                /* if ($_POST['lado'] && ($_POST['lado'] == 'IZQUIERDO')) {
                    $arraycampos['lado'] = 'IZQUIERDO';
                } else if($_POST['lado'] && ($_POST['lado'] == 'DERECHO')){
                    $arraycampos['lado'] = 'DERECHO';
                } else {
                    $arraycampos['lado'] = 'PENDIENTE';
                }
                */
                /* if ($_POST['observacion_caratula']) {
                    $observaciones['observacion_caratula']['valor'] = $_POST['observacion_caratula'];
                    $observaciones['observacion_caratula']['nombre'] = 'caratula';
                }

                if ($_POST['observacion_cedula']) {
                    $observaciones['observacion_cedula']['valor'] = $_POST['observacion_cedula'];
                    $observaciones['observacion_cedula']['nombre'] = 'cedula_identidad';
                }

                if ($_POST['observacion_autorizacion']) {
                    $observaciones['observacion_autorizacion']['valor'] = $_POST['observacion_autorizacion'];
                    $observaciones['observacion_autorizacion']['nombre'] = 'autorizacion';
                }
            */
                if ($_POST['codigo'] && ($_POST['codigo'] !== $expediente->codigo)) {
                    $unique_exp = $this->expedientes_model->view('expedientes', array('codigo' => $_POST['codigo'], 'id_proyecto' => $expediente->id_proyecto))->num_rows();


                    if ($unique_exp > 0) {
                        $this->session->set_flashdata('message', 'Ya existe una carpeta con el mismo código.');
                        redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                    } else {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$expediente->id_proyecto;
                    }
                }

                if ($_POST['numero_escritura']) {
                    $arraycampos['numero_escritura'] = $_POST['numero_escritura'];
                }
                if ($_POST['escritura_publica']) {
                    $arraycampos['escritura_publica'] = $_POST['escritura_publica'];
                }
                if ($_POST['numero_titulo']) {
                    $arraycampos['numero_titulo'] = $_POST['numero_titulo'];
                }
                if ($_POST['superficie_legal']) {
                    $arraycampos['superficie_legal'] = $_POST['superficie_legal'];
                }
                if ($_POST['folio']) {
                    $arraycampos['folio'] = $_POST['folio'];
                }
                if ($_POST['fecha_inscripcion']) {
                    $arraycampos['fecha_inscripcion'] = $_POST['fecha_inscripcion'];
                }
                if ($_POST['juez']) {
                    $arraycampos['juez'] = $_POST['juez'];
                }
                if ($_POST['escribano']) {
                    $arraycampos['escribano'] = $_POST['escribano'];
                }
                

                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);

                if ($actualizar_expediente) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_id, $coors_nuevo, $coordenadas);
                }

                if ($actualizar_expediente and isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'gen');
                }

                if ($actualizar_expediente) {
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                }
            }
        }
        
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['id_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'id_pdf',
                'id'       => 'id_pdf',
                'value'    => $expediente->id
            );
            $this->data['codigo_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_pdf',
                'id'       => 'codigo_pdf',
                'value'    => $expediente->des_codigo_unico
            );
            $this->data['id_proyecto'] = array(
                'type'     => 'hidden',
                'name'     => 'id_proyecto',
                'id'       => 'id_proyecto',
                'value'    => $expediente->id_proyecto
            );
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi', $expediente->codigo_dbi),
            'required' => 'true',
            'class'    => 'form-control'
            );*/
    		//'pattern'  => '^([A-Z][0-9]{0,4})?$',
    
            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo', $expediente->codigo),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
  
            $this->data['codigo_dgsa'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dgsa',
            'id'       => 'codigo_dgsa',
            'value'    => $this->form_validation->set_value('codigo_dgsa', $expediente->codigo_dgsa),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
    
            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', formato_fecha($expediente->fecha_ingreso)),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu', $expediente->codigo_meu),
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu']['value'] = $this->form_validation->set_value('daj_fecha_meu', isset($expediente->daj_fecha_meu) ? formato_fecha($expediente->daj_fecha_meu) : '');
            $this->data['desafectado'] = array(
                'type'     => 'radio',
                'name'     => 'desafectado',
                'id'       => 'desafectado',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
            if ($expediente->desafectado == 'SI') {
                $this->data['desafectado']['checked_s'] = true;
                $this->data['desafectado']['checked_n'] = false;
            } else {
                $this->data['desafectado']['checked_s'] = false;
                $this->data['desafectado']['checked_n'] = true;
            }
            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            if ($expediente->entrada_maquina == 'NO') {
                $this->data['entrada_maquina']['checked_s'] = false;
                $this->data['entrada_maquina']['checked_n'] = true;
            } else {
                $this->data['entrada_maquina']['checked_s'] = true;
                $this->data['entrada_maquina']['checked_n'] = false;
            }

            $this->data['tiene_cotejo'] = [
                'name' => 'tiene_cotejo',
                'value_s' => 'SI',
                'value_n' => 'NO',
                'checked_s' => (isset($expediente->tiene_cotejo) && $expediente->tiene_cotejo == 'SI'),
                'checked_n' => (!isset($expediente->tiene_cotejo) || $expediente->tiene_cotejo == 'NO')
            ];
            
            $this->data['tiene_mensura_judicial'] = [
                'name' => 'tiene_mensura_judicial',
                'value_s' => 'SI',
                'value_n' => 'NO',
                'checked_s' => (isset($expediente->tiene_mensura_judicial) && $expediente->tiene_mensura_judicial == 'SI'),
                'checked_n' => (!isset($expediente->tiene_mensura_judicial) || $expediente->tiene_mensura_judicial == 'NO')
            ];
            
            $this->data['impuesto_al_dia'] = [
                'name' => 'impuesto_al_dia',
                'value_s' => 'SI',
                'value_n' => 'NO',
                'checked_s' => (isset($expediente->impuesto_al_dia) && $expediente->impuesto_al_dia == 'SI'),
                'checked_n' => (!isset($expediente->impuesto_al_dia) || $expediente->impuesto_al_dia == 'NO')
            ];

            

            

            $this->data['lado'] = array(
                'type'     => 'radio',
                'name'     => 'lado',
                'id'       => 'lado',
                'value_i'  => 'IZQUIERDO',
                'value_d'  => 'DERECHO',
                'value_p'  => 'PENDIENTE',
            	//'value'    => $this->form_validation->set_value('lado', $expediente->lado),
                'class'    => 'form-control'
            );

            if (isset($expediente->lado)) {
                switch ($expediente->lado) {
                    case 'IZQUIERDO':
                        $this->data['lado']['checked_i'] = true;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    case 'DERECHO':
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = true;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    default:
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = true;
                        break;
                }
            } else {
                $this->data['lado']['checked_i'] = false;
                $this->data['lado']['checked_d'] = false;
                $this->data['lado']['checked_p'] = true;
            };
            


            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            if ($expediente->urgente == 'NO') {
                $this->data['urgente']['checked_s'] = false;
                $this->data['urgente']['checked_n'] = true;
            } else {
                $this->data['urgente']['checked_s'] = true;
                $this->data['urgente']['checked_n'] = false;
            }

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_e)),
            'id'       => 'ubi_coordenada_e',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_n)),
            'id'       => 'ubi_coordenada_n',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $tramo = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $expediente->id_proyecto,'tramo_padre =' => null))->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $subtramo = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $expediente->id_tramo, 'id_proyecto' => $expediente->id_proyecto))->result_array();
            foreach ($subtramo as $item) {
                $subtramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'class'    => 'form-control'
            );
            
            if ($expediente->franja_dominio == 'FC') {
                $this->data['franja_dominio']['checked_fc'] = true;
                $this->data['franja_dominio']['checked_fd'] = false;
            } else {
                $this->data['franja_dominio']['checked_fc'] = false;
                $this->data['franja_dominio']['checked_fd'] = true;
            }
            
            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial', $expediente->progresiva_inicial),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final', $expediente->progresiva_final),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion', $expediente->notificacion),
            'class'    => 'form-control'
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar', $expediente->lugar),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('tipo_afectacion')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;
            $this->data['tipo_afectacion_sel'] = $expediente->id_tipo_afectacion;

            $dominios[''] = 'Seleccione el tipo de ocupacion';
            $dominio = $this->expedientes_model->dropdown_data('tipo_ocupacion')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;
            $this->data['condicion_dominio_sel'] = $expediente->id_condicion_dominio;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo', $expediente->nombre_completo),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad', $expediente->cedula_identidad),
            'class'    => 'form-control',
            );
    
            $this->data['tiene_otros_doc'] = array(
                'type'     => 'radio',
                'name'     => 'tiene_otros_doc',
                'id'       => 'tiene_otros_doc',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
            if ($expediente->tiene_otros_doc == 'NO') {
                $this->data['tiene_otros_doc']['checked_s'] = false;
                $this->data['tiene_otros_doc']['checked_n'] = true;
            } else {
                $this->data['tiene_otros_doc']['checked_s'] = true;
                $this->data['tiene_otros_doc']['checked_n'] = false;
            }    
            /*
            $this->data['tiene_otros_doc'] = array(
            'type'     => 'text',
            'name'     => 'tiene_otros_doc',
            'id'       => 'tiene_otros_doc',
            'value'    => $this->form_validation->set_value('tiene_otros_doc', $expediente->tiene_otros_doc),
            'class'    => 'form-control',
            );
            */            
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono', $expediente->telefono),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento']['value'] = $this->form_validation->set_value('fecha_nacimiento', isset($expediente->fecha_nacimiento) ? formato_fecha($expediente->fecha_nacimiento) : '');
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral', $expediente->cta_cte_catastral),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron', $expediente->padron),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca', $expediente->finca),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula', $expediente->matricula),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

            $this->data['numero_escritura'] = array(
                'type'     => 'text',
                'name'     => 'numero_escritura',
                'id'       => 'numero_escritura',
                'value'    => $this->form_validation->set_value('numero_escritura', $expediente->numero_escritura),
                'class'    => 'form-control'
            );
            
            $this->data['escritura_publica'] = array(
                'type'     => 'text',
                'name'     => 'escritura_publica',
                'id'       => 'escritura_publica',
                'value'    => $this->form_validation->set_value('escritura_publica', $expediente->escritura_publica),
                'class'    => 'form-control'
            );
            
            $this->data['numero_titulo'] = array(
                'type'     => 'text',
                'name'     => 'numero_titulo',
                'id'       => 'numero_titulo',
                'value'    => $this->form_validation->set_value('numero_titulo', $expediente->numero_titulo),
                'class'    => 'form-control'
            );
            
            $this->data['superficie_legal'] = array(
                'type'     => 'text',
                'name'     => 'superficie_legal',
                'id'       => 'superficie_legal',
                'value'    => $this->form_validation->set_value('superficie_legal', $expediente->superficie_legal),
                'class'    => 'form-control'
            );
            
            $this->data['folio'] = array(
                'type'     => 'text',
                'name'     => 'folio',
                'id'       => 'folio',
                'value'    => $this->form_validation->set_value('folio', $expediente->folio),
                'class'    => 'form-control'
            );
            
            $this->data['fecha_inscripcion'] = array(
                'type'     => 'text',
                'name'     => 'fecha_inscripcion',
                'id'       => 'fecha_inscripcion',
                'value'    => $this->form_validation->set_value('fecha_inscripcion', formato_fecha($expediente->fecha_inscripcion)),
                'class'    => 'form-control'
            );
            
            $this->data['juez'] = array(
                'type'     => 'text',
                'name'     => 'juez',
                'id'       => 'juez',
                'value'    => $this->form_validation->set_value('juez', $expediente->juez),
                'class'    => 'form-control'
            );
            
            $this->data['escribano'] = array(
                'type'     => 'text',
                'name'     => 'escribano',
                'id'       => 'escribano',
                'value'    => $this->form_validation->set_value('escribano', $expediente->escribano),
                'class'    => 'form-control'
            );

            $observaciones = $this->expedientes_model->view('exp_observ', array('expediente_id' => $expe_id, 'area' => 'gen'))->result_array();

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_meu = $this->expedientes_model->view('historial_meu', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_meu)) {
                $this->data['historial_meu'] = $historial_meu;
            }

            $historial_notificacion = $this->expedientes_model->view('historial_notificacion', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_notificacion)) {
                $this->data['historial_notificacion'] = $historial_notificacion;
            }
            
            $this->template->admin_render('expedientes/edit_expe', $this->data);
    }

    public function edit_expe_desa($expe_id, $area = null)
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit_expe_desa');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        $coordenadas = $this->expedientes_model->view('coordenadas', array('id_expediente' => $expe_id), array('column' => 'nro', 'direction' => 'ASC'))->result_array();
        
        if (!empty($coordenadas)) {
            for ($i=0; $i < count($coordenadas); $i++) {
                $coors[$i]['coordenada_e'] = str_replace(".", ",", $coordenadas[$i]['coordenada_e']);
                $coors[$i]['coordenada_n'] = str_replace(".", ",", $coordenadas[$i]['coordenada_n']);
            }
            $this->data['coordenadas'] = $coors;
        }

        $this->data['id'] = $expe_id;
        $this->data['habilitado'] = grupo_usuario(4);


        $archivos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => true))->result_array();
        $otros = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => false))->result_array();
               
        $this->data['archivos'] = $archivos;
        $this->data['otros'] = $otros;

        
        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required');
            

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                /*if ($_POST['codigo_dbi']) {
                    $arraycampos['codigo_dbi']      = $_POST['codigo_dbi'];
                }*/

                if ($_POST['codigo']) {
                    $arraycampos['codigo']      = $_POST['codigo'];
                }
              
                if ($_POST['fecha_ingreso']) {
                    $arraycampos['fecha_ingreso']      = $_POST['fecha_ingreso'];
                }

                if ($_POST['codigo_meu']) {
                    $arraycampos['codigo_meu']             = $_POST['codigo_meu'];
                }

                if ($_POST['daj_fecha_meu']) {
                    $arraycampos['daj_fecha_meu']             = $_POST['daj_fecha_meu'];
                }

                if ($_POST['desafectado'] && ($_POST['desafectado'] == 'SI')) {
                    $arraycampos['desafectado'] = 'SI';
                } else {
                    $arraycampos['desafectado'] = 'NO';
                }

                if ($_POST['entrada_maquina'] && ($_POST['entrada_maquina'] == 'SI')) {
                    $arraycampos['entrada_maquina'] = 'SI';
                } else {
                    $arraycampos['entrada_maquina'] = 'NO';
                }

                if ($_POST['urgente'] && ($_POST['urgente'] == 'SI')) {
                    $arraycampos['urgente'] = 'SI';
                } else {
                    $arraycampos['urgente'] = 'NO';
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']            = $_POST['lugar'];
                }
    
                if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']           = $_POST['id_tramo'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                }

                if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                }

                if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                }

                if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                }

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                }

                if ($_POST['nombre_completo']) {
                    $arraycampos['nombre_completo']       = $_POST['nombre_completo'];
                }

                if ($_POST['cedula_identidad']) {
                    $arraycampos['cedula_identidad']       = $_POST['cedula_identidad'];
                }

                if ($_POST['fecha_nacimiento']) {
                    $arraycampos['fecha_nacimiento']       = $_POST['fecha_nacimiento'];
                }

                if ($_POST['telefono']) {
                    $arraycampos['telefono']    = $_POST['telefono'];
                }

                if ($_POST['cta_cte_catastral']) {
                    $arraycampos['cta_cte_catastral']  = $_POST['cta_cte_catastral'];
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }                    
                } else {
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }
                } 

                if ($_POST['padron']) {
                    $arraycampos['padron']  = $_POST['padron'];
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }                    
                } else {
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }
                } 

                if ($_POST['finca']) {
                    $arraycampos['finca']   = $_POST['finca'];
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } else {
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } 
                if ($_POST['matricula']) {
                    $arraycampos['matricula']   = $_POST['matricula'];
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }                    
                } else {
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }
                } 

                if ($_POST['lado'] && ($_POST['lado'] == 'IZQUIERDO')) {
                    $arraycampos['lado'] = 'IZQUIERDO';
                } else if($_POST['lado'] && ($_POST['lado'] == 'DERECHO')){
                    $arraycampos['lado'] = 'DERECHO';
                } else {
                    $arraycampos['lado'] = 'PENDIENTE';
                }

                if ($_POST['observacion_caratula']) {
                    $observaciones['observacion_caratula']['valor'] = $_POST['observacion_caratula'];
                    $observaciones['observacion_caratula']['nombre'] = 'caratula';
                }

                if ($_POST['observacion_cedula']) {
                    $observaciones['observacion_cedula']['valor'] = $_POST['observacion_cedula'];
                    $observaciones['observacion_cedula']['nombre'] = 'cedula_identidad';
                }

                if ($_POST['observacion_autorizacion']) {
                    $observaciones['observacion_autorizacion']['valor'] = $_POST['observacion_autorizacion'];
                    $observaciones['observacion_autorizacion']['nombre'] = 'autorizacion';
                }

                if ($_POST['codigo'] && ($_POST['codigo'] !== $expediente->codigo)) {
                    $unique_exp = $this->expedientes_model->view('expedientes', array('codigo' => $_POST['codigo'], 'id_proyecto' => $expediente->id_proyecto))->num_rows();


                    if ($unique_exp > 0) {
                        $this->session->set_flashdata('message', 'Ya existe una carpeta con el mismo código.');
                        redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                    } else {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$expediente->id_proyecto;
                    }
                }

                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);

                if ($actualizar_expediente) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_id, $coors_nuevo, $coordenadas);
                }

                if ($actualizar_expediente and isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'gen');
                }

                if ($actualizar_expediente) {
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/edit_expe_desa/'.$expe_id);
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe_desa/'.$expe_id);
                }
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['id_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'id_pdf',
                'id'       => 'id_pdf',
                'value'    => $expediente->id
            );
            $this->data['codigo_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_pdf',
                'id'       => 'codigo_pdf',
                'value'    => $expediente->des_codigo_unico
            );
            $this->data['id_proyecto'] = array(
                'type'     => 'hidden',
                'name'     => 'id_proyecto',
                'id'       => 'id_proyecto',
                'value'    => $expediente->id_proyecto
            );
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi', $expediente->codigo_dbi),
            'required' => 'true',
            'class'    => 'form-control'
            );*/
    		//'pattern'  => '^([A-Z][0-9]{0,4})?$',
    
            $this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo', $expediente->codigo),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
    
            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', formato_fecha($expediente->fecha_ingreso)),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu', $expediente->codigo_meu),
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu']['value'] = $this->form_validation->set_value('daj_fecha_meu', isset($expediente->daj_fecha_meu) ? formato_fecha($expediente->daj_fecha_meu) : '');
            $this->data['desafectado'] = array(
                'type'     => 'radio',
                'name'     => 'desafectado',
                'id'       => 'desafectado',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
            if ($expediente->desafectado == 'SI') {
                $this->data['desafectado']['checked_s'] = true;
                $this->data['desafectado']['checked_n'] = false;
            } else {
                $this->data['desafectado']['checked_s'] = false;
                $this->data['desafectado']['checked_n'] = true;
            }
            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            $this->data['lado'] = array(
                'type'     => 'radio',
                'name'     => 'lado',
                'id'       => 'lado',
                'value_i'  => 'IZQUIERDO',
                'value_d'  => 'DERECHO',
                'value_p'  => 'PENDIENTE',
            	//'value'    => $this->form_validation->set_value('lado', $expediente->lado),
                'class'    => 'form-control'
            );

            if (isset($expediente->lado)) {
                switch ($expediente->lado) {
                    case 'IZQUIERDO':
                        $this->data['lado']['checked_i'] = true;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    case 'DERECHO':
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = true;
                        $this->data['lado']['checked_p'] = false;
                        break;
                    default:
                        $this->data['lado']['checked_i'] = false;
                        $this->data['lado']['checked_d'] = false;
                        $this->data['lado']['checked_p'] = true;
                        break;
                }
            } else {
                $this->data['lado']['checked_i'] = false;
                $this->data['lado']['checked_d'] = false;
                $this->data['lado']['checked_p'] = true;
            };
            

            if ($expediente->entrada_maquina == 'NO') {
                $this->data['entrada_maquina']['checked_s'] = false;
                $this->data['entrada_maquina']['checked_n'] = true;
            } else {
                $this->data['entrada_maquina']['checked_s'] = true;
                $this->data['entrada_maquina']['checked_n'] = false;
            }

            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            if ($expediente->urgente == 'NO') {
                $this->data['urgente']['checked_s'] = false;
                $this->data['urgente']['checked_n'] = true;
            } else {
                $this->data['urgente']['checked_s'] = true;
                $this->data['urgente']['checked_n'] = false;
            }

            $this->data['franja_dominio'] = array(
                'type'     => 'radio',
                'name'     => 'franja_dominio',
                'id'       => 'franja_dominio',
                'value_fc'  => 'FC',
                'value_fd'  => 'FD',
                'class'    => 'form-control'
            );
        
            if ($expediente->franja_dominio == 'FC') {
                $this->data['franja_dominio']['checked_fc'] = true;
                $this->data['franja_dominio']['checked_fd'] = false;
            } else {
                $this->data['franja_dominio']['checked_fc'] = false;
                $this->data['franja_dominio']['checked_fd'] = true;
            };
        

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_e)),
            'id'       => 'ubi_coordenada_e',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_n)),
            'id'       => 'ubi_coordenada_n',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $tramo = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $expediente->id_proyecto,'tramo_padre =' => null))->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $subtramo = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $expediente->id_tramo, 'id_proyecto' => $expediente->id_proyecto))->result_array();
            foreach ($subtramo as $item) {
                $subtramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'class'    => 'form-control'
            );
            
            if ($expediente->franja_dominio == 'FC') {
                $this->data['franja_dominio']['checked_fc'] = true;
                $this->data['franja_dominio']['checked_fd'] = false;
            } else {
                $this->data['franja_dominio']['checked_fc'] = false;
                $this->data['franja_dominio']['checked_fd'] = true;
            }
            
            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial', $expediente->progresiva_inicial),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final', $expediente->progresiva_final),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion', $expediente->notificacion),
            'class'    => 'form-control'
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar', $expediente->lugar),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('tipo_afectacion')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;
            $this->data['tipo_afectacion_sel'] = $expediente->id_tipo_afectacion;

            $dominios[''] = 'Seleccione el tipo de ocupacion';
            $dominio = $this->expedientes_model->dropdown_data('tipo_ocupacion')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;
            $this->data['condicion_dominio_sel'] = $expediente->id_condicion_dominio;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo', $expediente->nombre_completo),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad', $expediente->cedula_identidad),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono', $expediente->telefono),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento']['value'] = $this->form_validation->set_value('fecha_nacimiento', isset($expediente->fecha_nacimiento) ? formato_fecha($expediente->fecha_nacimiento) : '');
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral', $expediente->cta_cte_catastral),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron', $expediente->padron),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca', $expediente->finca),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula', $expediente->matricula),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->view('exp_observ', array('expediente_id' => $expe_id, 'area' => 'gen'))->result_array();

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_meu = $this->expedientes_model->view('historial_meu', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_meu)) {
                $this->data['historial_meu'] = $historial_meu;
            }

            $historial_notificacion = $this->expedientes_model->view('historial_notificacion', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_notificacion)) {
                $this->data['historial_notificacion'] = $historial_notificacion;
            }
            
            $this->template->admin_render('expedientes/edit_expe_desa', $this->data);
    }

    
    public function edit_expe2($expe_id, $area = null)
    {

        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        $coordenadas = $this->expedientes_model->view('coordenadas', array('id_expediente' => $expe_id), array('column' => 'nro', 'direction' => 'ASC'))->result_array();
        
        if (!empty($coordenadas)) {
            for ($i=0; $i < count($coordenadas); $i++) {
                $coors[$i]['coordenada_e'] = str_replace(".", ",", $coordenadas[$i]['coordenada_e']);
                $coors[$i]['coordenada_n'] = str_replace(".", ",", $coordenadas[$i]['coordenada_n']);
            }
            $this->data['coordenadas'] = $coors;
        }

        $this->data['id'] = $expe_id;
        $this->data['habilitado'] = grupo_usuario(4);


        $archivos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => true))->result_array();
        $otros = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id, 'expediente_pdf' => false))->result_array();
               
        $this->data['archivos'] = $archivos;
        $this->data['otros'] = $otros;

        
        /* Validate form input */
        //$this->form_validation->set_rules('codigo_dbi', '<b>Código DBI</b>', 'required');
        $this->form_validation->set_rules('id_tramo', '<b>Tramo</b>', 'required');
            

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                /*if ($_POST['codigo_dbi']) {
                    $arraycampos['codigo_dbi']      = $_POST['codigo_dbi'];
                }*/

                if ($_POST['codigo']) {
                    $arraycampos['codigo']      = $_POST['codigo'];
                }
              
                if ($_POST['fecha_ingreso']) {
                    $arraycampos['fecha_ingreso']      = $_POST['fecha_ingreso'];
                }

                if ($_POST['codigo_meu']) {
                    $arraycampos['codigo_meu']             = $_POST['codigo_meu'];
                }

                if ($_POST['daj_fecha_meu']) {
                    $arraycampos['daj_fecha_meu']             = $_POST['daj_fecha_meu'];
                }

                if ($_POST['desafectado'] && ($_POST['desafectado'] == 'SI')) {
                    $arraycampos['desafectado'] = 'SI';
                } else {
                    $arraycampos['desafectado'] = 'NO';
                }

                if ($_POST['entrada_maquina'] && ($_POST['entrada_maquina'] == 'SI')) {
                    $arraycampos['entrada_maquina'] = 'SI';
                } else {
                    $arraycampos['entrada_maquina'] = 'NO';
                }

                if ($_POST['urgente'] && ($_POST['urgente'] == 'SI')) {
                    $arraycampos['urgente'] = 'SI';
                } else {
                    $arraycampos['urgente'] = 'NO';
                }
/*
                if ($_POST['ubi_coordenada_e'] and $_POST['ubi_coordenada_n']) {
                        $arraycampos['ubi_coordenada_e'] = str_replace(",", ".", $_POST['ubi_coordenada_e']);
                        $arraycampos['ubi_coordenada_n'] = str_replace(",", ".", $_POST['ubi_coordenada_n']);
                }

                if ($_POST['ubi_coordenada_x'] and $_POST['ubi_coordenada_y']) {
                    for ($i=0; $i < count($_POST['ubi_coordenada_x']); $i++) {
                        $coors_nuevo[$i]['E'] = str_replace(",", ".", $_POST['ubi_coordenada_x']);
                        $coors_nuevo[$i]['N'] = str_replace(",", ".", $_POST['ubi_coordenada_y']);
                        $coors_nuevo[$i]['nro'] = $i+1;
                    }
                }
*/
                if ($_POST['id_tramo']) {
                    $arraycampos['id_tramo']           = $_POST['id_tramo'];
                }

                if ($_POST['id_subtramo']) {
                    $arraycampos['id_subtramo'] = $_POST['id_subtramo'];
                } else {
                    $arraycampos['id_subtramo'] = null;
                }

                if ($_POST['franja_dominio']) {
                    $arraycampos['franja_dominio'] = $_POST['franja_dominio'];
                }

                if ($_POST['progresiva_inicial']) {
                    $arraycampos['progresiva_inicial']   = $_POST['progresiva_inicial'];
                }
                
                if ($_POST['progresiva_final']) {
                    $arraycampos['progresiva_final']  = $_POST['progresiva_final'];
                }

                if ($_POST['notificacion']) {
                    $arraycampos['notificacion']            = $_POST['notificacion'];
                }

                if ($_POST['id_departamento']) {
                    $arraycampos['id_departamento']    = $_POST['id_departamento'];
                }

                if ($_POST['id_distrito']) {
                    $arraycampos['id_distrito']    = $_POST['id_distrito'];
                }

                if ($_POST['lugar']) {
                    $arraycampos['lugar']   = $_POST['lugar'];
                }

                if ($_POST['id_tipo_afectacion']) {
                    $arraycampos['id_tipo_afectacion']     = $_POST['id_tipo_afectacion'];
                }

                if ($_POST['id_condicion_dominio']) {
                    $arraycampos['id_condicion_dominio']   = $_POST['id_condicion_dominio'];
                }

                if ($_POST['nombre_completo']) {
                    $arraycampos['nombre_completo']       = $_POST['nombre_completo'];
                }

                if ($_POST['cedula_identidad']) {
                    $arraycampos['cedula_identidad']       = $_POST['cedula_identidad'];
                }

                if ($_POST['fecha_nacimiento']) {
                    $arraycampos['fecha_nacimiento']       = $_POST['fecha_nacimiento'];
                }

                if ($_POST['telefono']) {
                    $arraycampos['telefono']    = $_POST['telefono'];
                }

                if ($_POST['cta_cte_catastral']) {
                    $arraycampos['cta_cte_catastral']  = $_POST['cta_cte_catastral'];
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }                    
                } else {
                    if ($_POST['cta_cte_catastral'] == '') {
                       $arraycampos['cta_cte_catastral']   = NULL;
                    }
                } 

                if ($_POST['padron']) {
                    $arraycampos['padron']  = $_POST['padron'];
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }                    
                } else {
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }
                } 

                if ($_POST['finca']) {
                    $arraycampos['finca']   = $_POST['finca'];
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } else {
                    if ($_POST['finca'] == '') {
                       $arraycampos['finca']   = NULL;
                    }
                } 
                if ($_POST['matricula']) {
                    $arraycampos['matricula']   = $_POST['matricula'];
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }                    
                } else {
                    if ($_POST['matricula'] == '') {
                       $arraycampos['matricula']   = NULL;
                    }
                } 

                if ($_POST['observacion_caratula']) {
                    $observaciones['observacion_caratula']['valor'] = $_POST['observacion_caratula'];
                    $observaciones['observacion_caratula']['nombre'] = 'caratula';
                }

                if ($_POST['observacion_cedula']) {
                    $observaciones['observacion_cedula']['valor'] = $_POST['observacion_cedula'];
                    $observaciones['observacion_cedula']['nombre'] = 'cedula_identidad';
                }

                if ($_POST['observacion_autorizacion']) {
                    $observaciones['observacion_autorizacion']['valor'] = $_POST['observacion_autorizacion'];
                    $observaciones['observacion_autorizacion']['nombre'] = 'autorizacion';
                }

                if ($_POST['codigo'] && ($_POST['codigo'] !== $expediente->codigo)) {
                    $unique_exp = $this->expedientes_model->view('expedientes', array('codigo' => $_POST['codigo'], 'id_proyecto' => $expediente->id_proyecto))->num_rows();
                    if ($unique_exp > 0) {
                        $this->session->set_flashdata('message', 'Ya existe una carpeta con el mismo código.');
                        redirect('expedientes/expedientes/edit_expe2/'.$expe_id);
                    } else {
                        $arraycampos['codigo_unico']   = $_POST['codigo'].'_'.$expediente->id_proyecto;
                    }
                }

                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);

                if ($actualizar_expediente) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_id, $coors_nuevo, $coordenadas);
                }

                if ($actualizar_expediente and isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'gen');
                }

                if ($actualizar_expediente) {
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/edit_expe2/'.$expe_id);
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe2/'.$expe_id);
                }
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['id_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'id_pdf',
                'id'       => 'id_pdf',
                'value'    => $expediente->id
            );
            $this->data['codigo_pdf'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_pdf',
                'id'       => 'codigo_pdf',
                'value'    => $expediente->des_codigo_unico
            );
            $this->data['id_proyecto'] = array(
                'type'     => 'hidden',
                'name'     => 'id_proyecto',
                'id'       => 'id_proyecto',
                'value'    => $expediente->id_proyecto
            );
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            /*$this->data['codigo_dbi'] = array(
            'type'     => 'text',
            'name'     => 'codigo_dbi',
            'id'       => 'codigo_dbi',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'value'    => $this->form_validation->set_value('codigo_dbi', $expediente->codigo_dbi),
            'required' => 'true',
            'class'    => 'form-control'
            );*/
            //'pattern'  => '^([A-Z][0-9]{0,4})?$',
    		$this->data['codigo'] = array(
            'type'     => 'text',
            'name'     => 'codigo',            
            'id'       => 'codigo',
            'value'    => $this->form_validation->set_value('codigo', $expediente->codigo),
            'class'    => 'form-control',
            'maxlength'=> '10'
            );
            $this->data['fecha_ingreso'] = array(
            'type'     => 'text',
            'name'     => 'fecha_ingreso',
            'id'       => 'fecha_ingreso',
            'value'    => $this->form_validation->set_value('fecha_ingreso', formato_fecha($expediente->fecha_ingreso)),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['codigo_meu'] = array(
            'type'     => 'text',
            'name'     => 'codigo_meu',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'codigo_meu',
            'value'    => $this->form_validation->set_value('codigo_meu', $expediente->codigo_meu),
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_meu',
            'id'       => 'daj_fecha_meu',
            'class'    => 'form-control'
            );
            $this->data['daj_fecha_meu']['value'] = $this->form_validation->set_value('daj_fecha_meu', isset($expediente->daj_fecha_meu) ? formato_fecha($expediente->daj_fecha_meu) : '');
            $this->data['desafectado'] = array(
                'type'     => 'radio',
                'name'     => 'desafectado',
                'id'       => 'desafectado',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );
            if ($expediente->desafectado == 'SI') {
                $this->data['desafectado']['checked_s'] = true;
                $this->data['desafectado']['checked_n'] = false;
            } else {
                $this->data['desafectado']['checked_s'] = false;
                $this->data['desafectado']['checked_n'] = true;
            }
            $this->data['entrada_maquina'] = array(
                'type'     => 'radio',
                'name'     => 'entrada_maquina',
                'id'       => 'entrada_maquina',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            if ($expediente->entrada_maquina == 'NO') {
                $this->data['entrada_maquina']['checked_s'] = false;
                $this->data['entrada_maquina']['checked_n'] = true;
            } else {
                $this->data['entrada_maquina']['checked_s'] = true;
                $this->data['entrada_maquina']['checked_n'] = false;
            }

            $this->data['urgente'] = array(
                'type'     => 'radio',
                'name'     => 'urgente',
                'id'       => 'urgente',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'class'    => 'form-control'
            );

            if ($expediente->urgente == 'NO') {
                $this->data['urgente']['checked_s'] = false;
                $this->data['urgente']['checked_n'] = true;
            } else {
                $this->data['urgente']['checked_s'] = true;
                $this->data['urgente']['checked_n'] = false;
            }

            $this->data['ubi_coordenada_e'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_e',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_e)),
            'id'       => 'ubi_coordenada_e',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_n'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_n',
            'pattern'  => '^\s*-?[0-9]{1,10}\s*(\,\d{0,4})?$',
            'value'    => $this->form_validation->set_value('codigo_meu', str_replace(".", ",", $expediente->ubi_coordenada_n)),
            'id'       => 'ubi_coordenada_n',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'class'    => 'form-control',
            'required' => 'true'
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'class'    => 'form-control',
            'required' => 'true'
            );

            $proyectos[''] = 'Seleccione el proyecto';
            $proyecto = $this->expedientes_model->dropdown_data('proyectos')->result_array();
            foreach ($proyecto as $item) {
                $proyectos[$item['id_proyecto']] = $item['codigo_proyecto'].' - '.$item['descripcion'];
            }
            $this->data['proyecto'] = $proyectos;
            $this->data['proyecto_sel'] = $expediente->id_proyecto;

            $tramos[''] = 'Seleccione el tramo';
            $tramo = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $expediente->id_proyecto,'tramo_padre =' => null))->result_array();
            foreach ($tramo as $item) {
                $tramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['tramo'] = $tramos;
            $this->data['tramo_sel'] = $expediente->id_tramo;

            $subtramos[''] = 'Seleccione el subtramo';
            $subtramo = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $expediente->id_tramo, 'id_proyecto' => $expediente->id_proyecto))->result_array();
            foreach ($subtramo as $item) {
                $subtramos[$item['id_tramo']] = $item['nombre'];
            }
            $this->data['subtramo'] = $subtramos;
            $this->data['subtramo_sel'] = $expediente->id_subtramo;

            $this->data['franja_dominio'] = array(
                    'type'     => 'radio',
                    'name'     => 'franja_dominio',
                    'id'       => 'franja_dominio',
                    'value_fc'  => 'FC',
                    'value_fd'  => 'FD',
                    'class'    => 'form-control'
            );
            
            if ($expediente->franja_dominio == 'FC') {
                $this->data['franja_dominio']['checked_fc'] = true;
                $this->data['franja_dominio']['checked_fd'] = false;
            } else {
                $this->data['franja_dominio']['checked_fc'] = false;
                $this->data['franja_dominio']['checked_fd'] = true;
            }
            
            $this->data['progresiva_inicial'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_inicial',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_inicial',
            'value'    => $this->form_validation->set_value('progresiva_inicial', $expediente->progresiva_inicial),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['progresiva_final'] = array(
            'type'     => 'text',
            'name'     => 'progresiva_final',
            'placeholder'  =>  'xxx+xxx',
            'pattern'  => '^\d{0,3}(\+\d{0,3})?$',
            'id'       => 'progresiva_final',
            'value'    => $this->form_validation->set_value('progresiva_final', $expediente->progresiva_final),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['notificacion'] = array(
            'type'     => 'text',
            'name'     => 'notificacion',
            'id'       => 'notificacion',
            'value'    => $this->form_validation->set_value('notificacion', $expediente->notificacion),
            'class'    => 'form-control'
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito;

            $this->data['lugar'] = array(
            'type'     => 'text',
            'name'     => 'lugar',
            'id'       => 'lugar',
            'value'    => $this->form_validation->set_value('lugar', $expediente->lugar),
            'class'    => 'form-control'
            );

            $afectaciones[''] = 'Seleccione el tipo de afectacion';
            $afectacion = $this->expedientes_model->dropdown_data('tipo_afectacion')->result_array();
            foreach ($afectacion as $tip) {
                $afectaciones[$tip['id_tipo_afeccion']] = $tip['id_tipo_afeccion'].' - '.$tip['nombre'];
            }
            $this->data['tipo_afectacion'] = $afectaciones;
            $this->data['tipo_afectacion_sel'] = $expediente->id_tipo_afectacion;

            $dominios[''] = 'Seleccione el tipo de ocupacion';
            $dominio = $this->expedientes_model->dropdown_data('tipo_ocupacion')->result_array();
            foreach ($dominio as $item) {
                $dominios[$item['id_tipo_ocupacion']] = $item['id_tipo_ocupacion'].' - '.$item['nombre'];
            }
            $this->data['condicion_dominio'] = $dominios;
            $this->data['condicion_dominio_sel'] = $expediente->id_condicion_dominio;

            $this->data['nombre_completo'] = array(
            'type'     => 'text',
            'name'     => 'nombre_completo',
            'id'       => 'nombre_completo',
            'value'    => $this->form_validation->set_value('nombre_completo', $expediente->nombre_completo),
            'class'    => 'form-control',
            'required' => 'true'
            );
            $this->data['cedula_identidad'] = array(
            'type'     => 'text',
            'name'     => 'cedula_identidad',
            'id'       => 'cedula_identidad',
            'value'    => $this->form_validation->set_value('cedula_identidad', $expediente->cedula_identidad),
            'class'    => 'form-control',
            );
            $this->data['telefono'] = array(
            'type'     => 'text',
            'name'     => 'telefono',
            'id'       => 'telefono',
            'value'    => $this->form_validation->set_value('telefono', $expediente->telefono),
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento'] = array(
            'type'     => 'text',
            'name'     => 'fecha_nacimiento',
            'id'       => 'fecha_nacimiento',
            'class'    => 'form-control',
            );
            $this->data['fecha_nacimiento']['value'] = $this->form_validation->set_value('fecha_nacimiento', isset($expediente->fecha_nacimiento) ? formato_fecha($expediente->fecha_nacimiento) : '');
            $this->data['cta_cte_catastral'] = array(
            'type'     => 'text',
            'name'     => 'cta_cte_catastral',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'cta_cte_catastral',
            'value'    => $this->form_validation->set_value('cta_cte_catastral', $expediente->cta_cte_catastral),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron'] = array(
            'type'     => 'text',
            'name'     => 'padron',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'padron',
            'value'    => $this->form_validation->set_value('padron', $expediente->padron),
            'class'    => 'form-control'
            );
            $this->data['finca'] = array(
            'type'     => 'text',
            'name'     => 'finca',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'finca',
            'value'    => $this->form_validation->set_value('finca', $expediente->finca),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['matricula'] = array(
            'type'     => 'text',
            'name'     => 'matricula',
            'id'       => 'matricula',
            'value'    => $this->form_validation->set_value('matricula', $expediente->matricula),
            'class'    => 'form-control',
            );
            $this->data['observacion_caratula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_caratula',
            'id'       => 'observacion_caratula',
            'value'    => $this->form_validation->set_value('observacion_caratula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_cedula'] = array(
            'type'     => 'text',
            'name'     => 'observacion_cedula',
            'id'       => 'observacion_cedula',
            'value'    => $this->form_validation->set_value('observacion_cedula'),
            'class'    => 'form-control textarea'
            );
            $this->data['observacion_autorizacion'] = array(
            'type'     => 'text',
            'name'     => 'observacion_autorizacion',
            'id'       => 'observacion_autorizacion',
            'value'    => $this->form_validation->set_value('observacion_autorizacion'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->view('exp_observ', array('expediente_id' => $expe_id, 'area' => 'gen'))->result_array();

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_meu = $this->expedientes_model->view('historial_meu', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_meu)) {
                $this->data['historial_meu'] = $historial_meu;
            }

            $historial_notificacion = $this->expedientes_model->view('historial_notificacion', array('expediente_id' => $expe_id))->result_array();
            if (!empty($historial_notificacion)) {
                $this->data['historial_notificacion'] = $historial_notificacion;
            }
            
            $this->template->admin_render('expedientes/edit_expe2', $this->data);
    }


    public function edit_expe_ubi($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
    
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $coordenadas = $this->expedientes_model->view('coordenadas', array('id_expediente' => $expe_id), array('column' => 'nro', 'direction' => 'ASC'))->result_array();
        
        if (!empty($coordenadas)) {
            for ($i=0; $i < count($coordenadas); $i++) {
                $coors[$i]['coordenada_e'] = str_replace(".", ",", $coordenadas[$i]['coordenada_e']);
                $coors[$i]['coordenada_n'] = str_replace(".", ",", $coordenadas[$i]['coordenada_n']);
                $coors[$i]['lindero'] = $coordenadas[$i]['lindero'];
            }
            $this->data['coordenadas'] = $coors;
        }

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_UBI'] = grupo_usuario(16);
        $this->data['habilitado']['op'] = grupo_usuario(32);
        $this->data['habilitado']['sup'] = grupo_usuario(33);

        $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(32);
        $supervisor = grupo_usuario(33);

        $editable = $expediente->editable_ubi;
        
        if ($editable == 't') {
            $editable = true;
        } else {
            $editable = false;
        }
        $this->data['editable'] = $editable;

        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
            //$this->data['descripcion']['departamento'] = utf8_decode($departamento->dpto_desc);
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }
        
        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
        
        /* Validate form input */
        
        $this->form_validation->set_rules('ubi_fecha_entrada', '<b>Fecha entrada</b>', 'required');
        
        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                if ($_POST['ubi_fecha_entrada']) {
                    $arraycampos['ubi_fecha_entrada']            = $_POST['ubi_fecha_entrada'];
                }

                if ($_POST['ubi_superficie_afectacion']) {
                    $arraycampos['ubi_superficie_afectacion']            = str_replace(",", ".", $_POST['ubi_superficie_afectacion']);
                } else {
                    $arraycampos['ubi_superficie_afectacion'] = null;
                }

                if ($_POST['ubi_superficie_titulo']) {
                    $arraycampos['ubi_superficie_titulo']            = str_replace(",", ".", $_POST['ubi_superficie_titulo']);
                } else {
                    $arraycampos['ubi_superficie_titulo'] = null;
                }

                if ($_POST['ubi_porcentaje_afectacion']) {
                    $arraycampos['ubi_porcentaje_afectacion']   = $_POST['ubi_porcentaje_afectacion'];
                } else {
                    $arraycampos['ubi_porcentaje_afectacion'] = null;
                }

                if ($_POST['ubi_coordenada_x'] and $_POST['ubi_coordenada_y']) {
                    for ($i=0; $i < count($_POST['ubi_coordenada_x']); $i++) {
                        $coors_nuevo[$i]['E'] = str_replace(",", ".", $_POST['ubi_coordenada_x']);
                        $coors_nuevo[$i]['N'] = str_replace(",", ".", $_POST['ubi_coordenada_y']);
                        $coors_nuevo[$i]['nro'] = $i+1;
                    }
                }

                if ($_POST['lindero']) {
                    for ($i=0; $i < count($coors_nuevo); $i++) {
                        if (!empty($_POST['lindero'][$i])) {
                            $linderos[$i]['lindero'] = $_POST['lindero'][$i];
                        } else {
                            $linderos[$i]['lindero'] = null;
                        }
                    }
                }

                /*if ($_POST['ubi_lindero_norte']) {
                    $arraycampos['ubi_lindero_norte']            = $_POST['ubi_lindero_norte'];
                }

                if ($_POST['ubi_lindero_sur']) {
                    $arraycampos['ubi_lindero_sur']            = $_POST['ubi_lindero_sur'];
                }

                if ($_POST['ubi_lindero_este']) {
                    $arraycampos['ubi_lindero_este']            = $_POST['ubi_lindero_este'];
                }

                if ($_POST['ubi_lindero_oeste']) {
                    $arraycampos['ubi_lindero_oeste']            = $_POST['ubi_lindero_oeste'];
                }*/

                if ($supervisor) {
                    if ($_POST['ubi_supervisor']) {
                        $arraycampos['ubi_supervisor']          = $_POST['ubi_supervisor'];
                    }

                    if ($_POST['ubi_fecha_revision']) {
                        $arraycampos['ubi_fecha_revision']            = $_POST['ubi_fecha_revision']." ".date('H:i');
                    }

                    if ($_POST['ubi_fecha_aprobacion']) {
                        $arraycampos['ubi_fecha_aprobacion'] = $_POST['ubi_fecha_aprobacion'];
                    }

                    if ($_POST['observacion_plano_inmueble']) {
                        $observaciones['observacion_plano_inmueble']['valor'] = $_POST['observacion_plano_inmueble'];
                        $observaciones['observacion_plano_inmueble']['nombre'] = 'plano_inmueble';
                    }

                    if ($_POST['observacion_informe_pericial']) {
                        $observaciones['observacion_informe_pericial']['valor'] = $_POST['observacion_informe_pericial'];
                        $observaciones['observacion_informe_pericial']['nombre'] = 'informe_pericial';
                    }

                    if ($_POST['observacion_planilla_superficie']) {
                        $observaciones['observacion_planilla_superficie']['valor'] = $_POST['observacion_planilla_superficie'];
                        $observaciones['observacion_planilla_superficie']['nombre'] = 'planilla_superficie';
                    }
                }
                
                
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                if ($accion == '1') {
                    $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                } else if ($accion == '2') {
                    $aprobar_expediente = $this->expedientes_model->aprobar_expediente($expe_id, $arraycampos, 'ubi');
                } else if ($accion == '3') {
                    $habilitar_expediente = $this->expedientes_model->habilitar_expediente($expe_id, $arraycampos, 'ubi');
                }

                if (isset($coors_nuevo)) {
                    $guardar_coordenadas = $this->expedientes_model->guardar_coordenadas($expe_id, $coors_nuevo, $coordenadas);
                }

                if (isset($linderos)) {
                    $guardar_linderos = $this->expedientes_model->guardar_linderos($expe_id, $linderos);
                }
                
                if (isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'ubi');
                }

                
                if ($actualizar_expediente or $aprobar_expediente or $habilitar_expediente) {
                    //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/');
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe_ubi/'.$expe_id);
                }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['ubi_fecha_entrada'] = array(
            'type'     => 'text',
            'name'     => 'ubi_fecha_entrada',
            'id'       => 'ubi_fecha_entrada',
            'class'    => 'form-control',
            );
            $this->data['ubi_fecha_entrada']['value'] = $this->form_validation->set_value('ubi_fecha_entrada', isset($expediente->ubi_fecha_entrada) ? (formato_fecha($expediente->ubi_fecha_entrada)) : ($operador ? date('d/m/Y') : ''));
            
            $this->data['ubi_superficie_afectacion'] = array(
            'type'     => 'text',
            'name'     => 'ubi_superficie_afectacion',
            'pattern'  => '^\d*(\,\d{0,4})?$',
            'id'       => 'ubi_superficie_afectacion',
            'value'    => $this->form_validation->set_value('ubi_superficie_afectacion', isset($expediente->ubi_superficie_afectacion) ? str_replace(".",",", (float)$expediente->ubi_superficie_afectacion) : null),
            'class'    => 'form-control'
            );
            
            $this->data['ubi_superficie_titulo'] = array(
            'type'     => 'text',
            'name'     => 'ubi_superficie_titulo',
            'pattern'  => '^\d*(\,\d{0,4})?$',
            'id'       => 'ubi_superficie_titulo',
            'value'    => $this->form_validation->set_value('ubi_superficie_titulo', isset($expediente->ubi_superficie_titulo) ? str_replace(".",",", (float)$expediente->ubi_superficie_titulo) : null),
            'class'    => 'form-control'
            );
            
            $this->data['ubi_porcentaje_afectacion'] = array(
            'type'     => 'text',
            'name'     => 'ubi_porcentaje_afectacion',
            'id'       => 'ubi_porcentaje_afectacion',
            'value'    => $this->form_validation->set_value('ubi_porcentaje_afectacion', isset($expediente->ubi_porcentaje_afectacion) ? (float)$expediente->ubi_porcentaje_afectacion : null),
            'class'    => 'form-control'
            );
            $this->data['ubi_coordenada_x'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_x[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_x',
            'class'    => 'form-control',
            );
            
            $this->data['ubi_coordenada_y'] = array(
            'type'     => 'text',
            'name'     => 'ubi_coordenada_y[]',
            'pattern'  => '^\s*-?[0-9]{1,7}\s*(\,\d{0,5})?$',
            'id'       => 'ubi_coordenada_y',
            'class'    => 'form-control',
            );
            $this->data['lindero'] = array(
            'type'     => 'text',
            'name'     => 'lindero[]',
            'id'       => 'lindero',
            'class'    => 'form-control',
            );
            
            $this->data['ubi_supervisor'] = array(
            'type'     => 'text',
            'name'     => 'ubi_supervisor',
            'id'       => 'ubi_supervisor',
            'value'    =>  $this->form_validation->set_value('ubi_supervisor', $expediente->ubi_supervisor),
            'class'    => 'form-control',
            );
            if (!isset($expediente->ubi_supervisor) && $supervisor) {
                $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                $this->data['ubi_supervisor']['value'] = $this->form_validation->set_value('ubi_supervisor', $usuario->first_name.' '.$usuario->last_name);
            }
            
            $this->data['ubi_fecha_revision'] = array(
            'type'     => 'text',
            'name'     => 'ubi_fecha_revision',
            'id'       => 'ubi_fecha_revision',
            'class'    => 'form-control'
            );
            $this->data['ubi_fecha_revision']['value'] = $this->form_validation->set_value('ubi_fecha_revision', isset($expediente->ubi_fecha_revision) ? (formato_fecha($expediente->ubi_fecha_revision)) : ($supervisor ? date('d/m/Y') : ''));
            
            $this->data['observacion_plano_inmueble'] = array(
            'type'     => 'text',
            'name'     => 'observacion_plano_inmueble',
            'id'       => 'observacion_plano_inmueble',
            'value'    => $this->form_validation->set_value('observacion_plano_inmueble'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_informe_pericial'] = array(
            'type'     => 'text',
            'name'     => 'observacion_informe_pericial',
            'id'       => 'observacion_informe_pericial',
            'value'    => $this->form_validation->set_value('observacion_informe_pericial'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_planilla_superficie'] = array(
            'type'     => 'text',
            'name'     => 'observacion_planilla_superficie',
            'id'       => 'observacion_planilla_superficie',
            'value'    => $this->form_validation->set_value('observacion_planilla_superficie'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['ubi_fecha_aprobacion'] = array(
            'type'     => 'text',
            'name'     => 'ubi_fecha_aprobacion',
            'id'       => 'ubi_fecha_aprobacion',
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['ubi_fecha_aprobacion']['value'] = $this->form_validation->set_value('ubi_fecha_aprobacion', isset($expediente->ubi_fecha_aprobacion) ? formato_fecha($expediente->ubi_fecha_aprobacion) : '');

            $observaciones = $this->expedientes_model->view('exp_observ', array('expediente_id' => $expe_id, 'area' => 'ubi'))->result_array();

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_fecha_ingreso = $this->expedientes_model->view('historial_fecha_ingreso', array('expediente_id' => $expe_id, 'area' => 'UBI'))->result_array();
            if (!empty($historial_fecha_ingreso)) {
                $this->data['historial_fecha_ingreso'] = $historial_fecha_ingreso;
            }
 
            if ($coordinador or $supervisor or !$editable) {
                $this->data['ubi_fecha_entrada']['readonly'] = true;
            }

            if ($coordinador or !$editable) {
                $this->data['ubi_superficie_afectacion']['readonly'] = true;
                $this->data['ubi_superficie_titulo']['readonly'] = true;
                $this->data['ubi_porcentaje_afectacion']['readonly'] = true;
                $this->data['ubi_lindero_norte']['readonly'] = true;
                $this->data['ubi_lindero_sur']['readonly'] = true;
                $this->data['ubi_lindero_este']['readonly'] = true;
                $this->data['ubi_lindero_oeste']['readonly'] = true;
            }

            if ($coordinador or !$editable) {
                $this->data['ubi_supervisor']['readonly'] = true;
                $this->data['ubi_fecha_revision']['readonly'] = true;
                $this->data['observacion_plano_inmueble']['readonly'] = true;
                $this->data['observacion_informe_pericial']['readonly'] = true;
                $this->data['observacion_planilla_superficie']['readonly'] = true;
            }

            $this->template->admin_render('expedientes/edit_expe_ubi', $this->data);
    }

    public function edit_expe_dao($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3); 
        $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_DAO'] = grupo_usuario(17);
        $this->data['habilitado']['op'] = grupo_usuario(34);
        $this->data['habilitado']['sup'] = grupo_usuario(35);
	    $this->data['habilitado']['coorsup'] = grupo_usuario(40);

    	$coordinadorsup = grupo_usuario(40);
        $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(34);
        $supervisor = grupo_usuario(35);

        $editableDAO = $expediente->editable_dao;

        if ($editableDAO == 't') {
            $editableDAO = true;
        } else {
            $editableDAO = false;
        }

		/*
            echo print_r($coordinador.'-'.$supervisor.'-'.$operador.'-');
    
            show_error('TEMPORALMENTE INACTIVO');
		*/



        $this->data['editableDAO'] = $editableDAO;
    
        $this->data['editableUBI'] = $expediente->editable_ubi;


        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
        


        /* Validate form input */
        
        $this->form_validation->set_rules('dao_ingreso_verificacion', '<b>Fecha entrada</b>', 'required');
        

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                if ($_POST['dao_ingreso_verificacion']) {
                    $arraycampos['dao_ingreso_verificacion']    = $_POST['dao_ingreso_verificacion'];
                }

                if ($_POST['dao_terreno']) {
                    $arraycampos['dao_terreno']            = str_replace(".", "", $_POST['dao_terreno']);
                } else {
                    $arraycampos['dao_terreno']             = null;
                }

                if ($_POST['dao_gastos_transferencia']) {
                    $arraycampos['dao_gastos_transferencia']            = str_replace(".", "", $_POST['dao_gastos_transferencia']);
                } else {
                    $arraycampos['dao_gastos_transferencia']             = null;
                }

                if ($_POST['dao_mejoras_agroforestales']) {
                    $arraycampos['dao_mejoras_agroforestales']   = str_replace(".", "", $_POST['dao_mejoras_agroforestales']);
                } else {
                    $arraycampos['dao_mejoras_agroforestales']             = null;
                }

                if ($_POST['dao_mejoras_edilicias']) {
                    $arraycampos['dao_mejoras_edilicias']    = str_replace(".", "", $_POST['dao_mejoras_edilicias']);
                } else {
                    $arraycampos['dao_mejoras_edilicias']             = null;
                }
                    
                if ($_POST['dao_total_mejoras']) {
                    $arraycampos['dao_total_mejoras']   = str_replace(".", "", $_POST['dao_total_mejoras']);
                } else {
                    $arraycampos['dao_total_mejoras']             = null;
                }

                if ($_POST['dao_total_notificacion']) {
                    $arraycampos['dao_total_notificacion']          = str_replace(".", "", $_POST['dao_total_notificacion']);
                } else {
                    $arraycampos['dao_total_notificacion']             = null;
                }

                if ($_POST['dao_terreno2']) {
                    $arraycampos['dao_terreno2']            = str_replace(".", "", $_POST['dao_terreno2']);
                } else {
                    $arraycampos['dao_terreno2']             = null;
                }

                if ($_POST['dao_gastos_transferencia2']) {
                    $arraycampos['dao_gastos_transferencia2']            = str_replace(".", "", $_POST['dao_gastos_transferencia2']);
                } else {
                    $arraycampos['dao_gastos_transferencia2']             = null;
                }

                if ($_POST['dao_mejoras_agroforestales2']) {
                    $arraycampos['dao_mejoras_agroforestales2']   = str_replace(".", "", $_POST['dao_mejoras_agroforestales2']);
                } else {
                    $arraycampos['dao_mejoras_agroforestales2']             = null;
                }

                if ($_POST['dao_mejoras_edilicias2']) {
                    $arraycampos['dao_mejoras_edilicias2']    = str_replace(".", "", $_POST['dao_mejoras_edilicias2']);
                } else {
                    $arraycampos['dao_mejoras_edilicias2']             = null;
                }
                    
                if ($_POST['dao_total_mejoras2']) {
                    $arraycampos['dao_total_mejoras2']   = str_replace(".", "", $_POST['dao_total_mejoras2']);
                } else {
                    $arraycampos['dao_total_mejoras2']             = null;
                }

                if ($_POST['dao_total_notificacion2']) {
                    $arraycampos['dao_total_notificacion2']          = str_replace(".", "", $_POST['dao_total_notificacion2']);
                } else {
                    $arraycampos['dao_total_notificacion2']             = null;
                }

                if ($supervisor) {
                    if ($_POST['dao_supervisor']) {
                        $arraycampos['dao_supervisor']            = $_POST['dao_supervisor'];
                    }

                    if ($_POST['dao_fecha_verificacion']) {
                        $arraycampos['dao_fecha_verificacion']            = $_POST['dao_fecha_verificacion']." ".date('H:i');
                    }

                    if ($_POST['dao_fecha_aprobacion']) {
                        $arraycampos['dao_fecha_aprobacion'] = $_POST['dao_fecha_aprobacion'];
                    }

                    if ($_POST['observacion_plano_mejoras']) {
                        $observaciones['observacion_plano_mejoras']['valor'] = $_POST['observacion_plano_mejoras'];
                        $observaciones['observacion_plano_mejoras']['nombre'] = 'plano_mejoras';
                    }

                    if ($_POST['observacion_planilla_terreno']) {
                        $observaciones['observacion_planilla_terreno']['valor'] = $_POST['observacion_planilla_terreno'];
                        $observaciones['observacion_planilla_terreno']['nombre'] = 'planilla_terreno';
                    }

                    if ($_POST['observacion_gastos_transferencia']) {
                        $observaciones['observacion_gastos_transferencia']['valor'] = $_POST['observacion_gastos_transferencia'];
                        $observaciones['observacion_gastos_transferencia']['nombre'] = 'gastos_transferencia';
                    }

                    if ($_POST['observacion_planilla_forestal']) {
                        $observaciones['observacion_planilla_forestal']['valor'] = $_POST['observacion_planilla_forestal'];
                        $observaciones['observacion_planilla_forestal']['nombre'] = 'planilla_forestal';
                    }

                    if ($_POST['observacion_avaluo_conformidad']) {
                        $observaciones['observacion_avaluo_conformidad']['valor'] = $_POST['observacion_avaluo_conformidad'];
                        $observaciones['observacion_avaluo_conformidad']['nombre'] = 'avaluo_conformidad';
                    }
                }
                
                      
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                if ($accion == '1') {
                    $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                } else if ($accion == '2') {
                    $aprobar_expediente = $this->expedientes_model->aprobar_expediente($expe_id, $arraycampos, 'dao');
                } else if ($accion == '3') {
                    $habilitar_expediente = $this->expedientes_model->habilitar_expediente($expe_id, $arraycampos, 'dao');
                }
                
                if (isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'dao');
                }

                //if ($resul)
                if ($actualizar_expediente or $aprobar_expediente or $habilitar_expediente) {
                    //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/');
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe_dao/'.$expe_id);
                }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['dao_ingreso_verificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_ingreso_verificacion',
            'id'       => 'dao_ingreso_verificacion',
            'class'    => 'form-control',
            );

            $this->data['dao_ingreso_verificacion']['value'] = $this->form_validation->set_value('dao_ingreso_verificacion', isset($expediente->dao_ingreso_verificacion) ? (formato_fecha($expediente->dao_ingreso_verificacion)) : ($operador ? date('d/m/Y') : ''));
            
            $this->data['dao_terreno'] = array(
            'type'     => 'text',
            'name'     => 'dao_terreno',
            'id'       => 'dao_terreno',
            'value'    => $this->form_validation->set_value('dao_terreno', formatear_moneda($expediente->dao_terreno)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_gastos_transferencia'] = array(
            'type'     => 'text',
            'name'     => 'dao_gastos_transferencia',
            'id'       => 'dao_gastos_transferencia',
            'value'    => $this->form_validation->set_value('dao_gastos_transferencia', formatear_moneda($expediente->dao_gastos_transferencia)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_mejoras_agroforestales'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_agroforestales',
            'id'       => 'dao_mejoras_agroforestales',
            'value'    => $this->form_validation->set_value('dao_mejoras_agroforestales', formatear_moneda($expediente->dao_mejoras_agroforestales)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_mejoras_edilicias'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_edilicias',
            'id'       => 'dao_mejoras_edilicias',
            'value'    => $this->form_validation->set_value('dao_mejoras_edilicias', formatear_moneda($expediente->dao_mejoras_edilicias)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_total_mejoras'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_mejoras',
            'id'       => 'dao_total_mejoras',
            'value'    => $this->form_validation->set_value('dao_total_mejoras', formatear_moneda($expediente->dao_total_mejoras)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_total_notificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion',
            'id'       => 'dao_total_notificacion',
            'value'    => $this->form_validation->set_value('dao_total_notificacion', formatear_moneda($expediente->dao_total_notificacion)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_terreno2'] = array(
            'type'     => 'text',
            'name'     => 'dao_terreno2',
            'id'       => 'dao_terreno2',
            'value'    => $this->form_validation->set_value('dao_terreno2', formatear_moneda($expediente->dao_terreno2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_gastos_transferencia2'] = array(
            'type'     => 'text',
            'name'     => 'dao_gastos_transferencia2',
            'id'       => 'dao_gastos_transferencia2',
            'value'    => $this->form_validation->set_value('dao_gastos_transferencia2', formatear_moneda($expediente->dao_gastos_transferencia2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_mejoras_agroforestales2'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_agroforestales2',
            'id'       => 'dao_mejoras_agroforestales2',
            'value'    => $this->form_validation->set_value('dao_mejoras_agroforestales2', formatear_moneda($expediente->dao_mejoras_agroforestales2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_mejoras_edilicias2'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_edilicias2',
            'id'       => 'dao_mejoras_edilicias2',
            'value'    => $this->form_validation->set_value('dao_mejoras_edilicias2', formatear_moneda($expediente->dao_mejoras_edilicias2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_total_mejoras2'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_mejoras2',
            'id'       => 'dao_total_mejoras2',
            'value'    => $this->form_validation->set_value('dao_total_mejoras2', formatear_moneda($expediente->dao_total_mejoras2)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_total_notificacion2'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion2',
            'id'       => 'dao_total_notificacion2',
            'value'    => $this->form_validation->set_value('dao_total_notificacion2', formatear_moneda($expediente->dao_total_notificacion2)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_supervisor'] = array(
            'type'     => 'text',
            'name'     => 'dao_supervisor',
            'id'       => 'dao_supervisor',
            'value'    =>  $this->form_validation->set_value('dao_supervisor', $expediente->dao_supervisor),
            'class'    => 'form-control',
            );
            if (!isset($expediente->dao_supervisor) && $supervisor) {
                $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                $this->data['dao_supervisor']['value'] = $this->form_validation->set_value('dao_supervisor', $usuario->first_name.' '.$usuario->last_name);
            }
            
            $this->data['dao_fecha_verificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_fecha_verificacion',
            'id'       => 'dao_fecha_verificacion',
            'class'    => 'form-control'
            );
            $this->data['dao_fecha_verificacion']['value'] = $this->form_validation->set_value('dao_fecha_verificacion', isset($expediente->dao_fecha_verificacion) ? (formato_fecha($expediente->dao_fecha_verificacion)) : ($supervisor ? date('d/m/Y') : ''));
            
       
            $this->data['dao_fecha_aprobacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_fecha_aprobacion',
            'id'       => 'dao_fecha_aprobacion',
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_fecha_aprobacion']['value'] = $this->form_validation->set_value('dao_fecha_aprobacion', isset($expediente->dao_fecha_aprobacion) ? formato_fecha($expediente->dao_fecha_aprobacion) : '');
            $this->data['observacion_plano_mejoras'] = array(
            'type'     => 'text',
            'name'     => 'observacion_plano_mejoras',
            'id'       => 'observacion_plano_mejoras',
            'value'    => $this->form_validation->set_value('observacion_plano_mejoras'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_planilla_terreno'] = array(
            'type'     => 'text',
            'name'     => 'observacion_planilla_terreno',
            'id'       => 'observacion_planilla_terreno',
            'value'    => $this->form_validation->set_value('observacion_planilla_terreno'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_gastos_transferencia'] = array(
            'type'     => 'text',
            'name'     => 'observacion_gastos_transferencia',
            'id'       => 'observacion_gastos_transferencia',
            'value'    => $this->form_validation->set_value('observacion_gastos_transferencia'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_planilla_forestal'] = array(
            'type'     => 'text',
            'name'     => 'observacion_planilla_forestal',
            'id'       => 'observacion_planilla_forestal',
            'value'    => $this->form_validation->set_value('observacion_planilla_forestal'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_avaluo_conformidad'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avaluo_conformidad',
            'id'       => 'observacion_avaluo_conformidad',
            'value'    => $this->form_validation->set_value('observacion_avaluo_conformidad'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'dao');

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_fecha_ingreso = $this->expedientes_model->view('historial_fecha_ingreso', array('expediente_id' => $expe_id, 'area' => 'DAO'))->result_array();
    /*
            if (!empty($historial_fecha_ingreso)) {
                $this->data['historial_fecha_ingreso'] = $historial_fecha_ingreso;
            }

            if ($coordinador or $supervisor or !$editableDAO) {
                $this->data['dao_ingreso_verificacion']['readonly'] = true;
            }

            if ($coordinador or !$editableDAO) {
                $this->data['dao_terreno']['readonly'] = true;
                $this->data['dao_gastos_transferencia']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales']['readonly'] = true;
                $this->data['dao_mejoras_edilicias']['readonly'] = true;
                $this->data['dao_terreno2']['readonly'] = true;
                $this->data['dao_gastos_transferencia2']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales2']['readonly'] = true;
                $this->data['dao_mejoras_edilicias2']['readonly'] = true;
            }

   //         echo print_r($coordinador, $operador, $editableDAO );
   //         show_error('TEMPORALMENTE INACTIVO');

            if ($operador or $coordinador or !$editableDAO) {
                $this->data['dao_supervisor']['readonly'] = true;
                $this->data['dao_fecha_verificacion']['readonly'] = true;
                $this->data['observacion_plano_mejoras']['readonly'] = true;
                $this->data['observacion_planilla_terreno']['readonly'] = true;
                $this->data['observacion_gastos_transferencia']['readonly'] = true;
                $this->data['observacion_planilla_forestal']['readonly'] = true;
                $this->data['observacion_avaluo_conformidad']['readonly'] = true;
            }
*/
            /*if ($supervisor) {
                $this->data['observacion_plano_mejoras']['readonly'] = false;
                $this->data['observacion_planilla_terreno']['readonly'] = false;
                $this->data['observacion_gastos_transferencia']['readonly'] = false;
                $this->data['observacion_planilla_forestal']['readonly'] = false;
                $this->data['observacion_avaluo_conformidad']['readonly'] = false;
            }*/
    
    		// Realizado por Jaime Rojas 

            if (!empty($historial_fecha_ingreso)) {
                $this->data['historial_fecha_ingreso'] = $historial_fecha_ingreso;
            }

            if (($coordinador or $supervisor or !$editableDAO) 
                and (!$coordinadorsup) 
            ) {
                $this->data['dao_ingreso_verificacion']['readonly'] = true;
            }

            if (($coordinador or !$editableDAO) 
                and (!$coordinadorsup) 
            ) {
                $this->data['dao_terreno']['readonly'] = true;
                $this->data['dao_gastos_transferencia']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales']['readonly'] = true;
                $this->data['dao_mejoras_edilicias']['readonly'] = true;
                $this->data['dao_terreno2']['readonly'] = true;
                $this->data['dao_gastos_transferencia2']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales2']['readonly'] = true;
                $this->data['dao_mejoras_edilicias2']['readonly'] = true;
            }

            if (($operador or $coordinador or !$editableDAO) 
                and (!$coordinadorsup) 
            ) {
                $this->data['dao_supervisor']['readonly'] = true;
                $this->data['dao_fecha_verificacion']['readonly'] = true;
                $this->data['observacion_plano_mejoras']['readonly'] = true;
                $this->data['observacion_planilla_terreno']['readonly'] = true;
                $this->data['observacion_gastos_transferencia']['readonly'] = true;
                $this->data['observacion_planilla_forestal']['readonly'] = true;
                $this->data['observacion_avaluo_conformidad']['readonly'] = true;
            }
    
            $this->template->admin_render('expedientes/edit_expe_dao', $this->data);
    }


    public function edit_expe_dao2($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3); 
        $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_DAO'] = grupo_usuario(17);
        $this->data['habilitado']['op'] = grupo_usuario(34);
        $this->data['habilitado']['sup'] = grupo_usuario(35);

        $coordonadorDAO = grupo_usuario(17);
        $operador = grupo_usuario(34);
        $supervisor = grupo_usuario(35);

        $editableDAO = $expediente->editable_dao;

        if ($editableDAO == 't') {
            $editableDAO = true;
        } else {
            $editableDAO = false;
        }

        $this->data['editableDAO'] = $editableDAO;
    
        $this->data['editableUBI'] = $expediente->editable_ubi;


        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
        


        /* Validate form input */
        
        $this->form_validation->set_rules('dao_ingreso_verificacion', '<b>Fecha entrada</b>', 'required');
        

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                if ($_POST['dao_ingreso_verificacion']) {
                    $arraycampos['dao_ingreso_verificacion']    = $_POST['dao_ingreso_verificacion'];
                }

                if ($_POST['dao_terreno']) {
                    $arraycampos['dao_terreno']            = str_replace(".", "", $_POST['dao_terreno']);
                } else {
                    $arraycampos['dao_terreno']             = null;
                }

                if ($_POST['dao_gastos_transferencia']) {
                    $arraycampos['dao_gastos_transferencia']            = str_replace(".", "", $_POST['dao_gastos_transferencia']);
                } else {
                    $arraycampos['dao_gastos_transferencia']             = null;
                }

                if ($_POST['dao_mejoras_agroforestales']) {
                    $arraycampos['dao_mejoras_agroforestales']   = str_replace(".", "", $_POST['dao_mejoras_agroforestales']);
                } else {
                    $arraycampos['dao_mejoras_agroforestales']             = null;
                }

                if ($_POST['dao_mejoras_edilicias']) {
                    $arraycampos['dao_mejoras_edilicias']    = str_replace(".", "", $_POST['dao_mejoras_edilicias']);
                } else {
                    $arraycampos['dao_mejoras_edilicias']             = null;
                }
                    
                if ($_POST['dao_total_mejoras']) {
                    $arraycampos['dao_total_mejoras']   = str_replace(".", "", $_POST['dao_total_mejoras']);
                } else {
                    $arraycampos['dao_total_mejoras']             = null;
                }

                if ($_POST['dao_total_notificacion']) {
                    $arraycampos['dao_total_notificacion']          = str_replace(".", "", $_POST['dao_total_notificacion']);
                } else {
                    $arraycampos['dao_total_notificacion']             = null;
                }

                if ($_POST['dao_terreno2']) {
                    $arraycampos['dao_terreno2']            = str_replace(".", "", $_POST['dao_terreno2']);
                } else {
                    $arraycampos['dao_terreno2']             = null;
                }

                if ($_POST['dao_gastos_transferencia2']) {
                    $arraycampos['dao_gastos_transferencia2']            = str_replace(".", "", $_POST['dao_gastos_transferencia2']);
                } else {
                    $arraycampos['dao_gastos_transferencia2']             = null;
                }

                if ($_POST['dao_mejoras_agroforestales2']) {
                    $arraycampos['dao_mejoras_agroforestales2']   = str_replace(".", "", $_POST['dao_mejoras_agroforestales2']);
                } else {
                    $arraycampos['dao_mejoras_agroforestales2']             = null;
                }

                if ($_POST['dao_mejoras_edilicias2']) {
                    $arraycampos['dao_mejoras_edilicias2']    = str_replace(".", "", $_POST['dao_mejoras_edilicias2']);
                } else {
                    $arraycampos['dao_mejoras_edilicias2']             = null;
                }
                    
                if ($_POST['dao_total_mejoras2']) {
                    $arraycampos['dao_total_mejoras2']   = str_replace(".", "", $_POST['dao_total_mejoras2']);
                } else {
                    $arraycampos['dao_total_mejoras2']             = null;
                }

                if ($_POST['dao_total_notificacion2']) {
                    $arraycampos['dao_total_notificacion2']          = str_replace(".", "", $_POST['dao_total_notificacion2']);
                } else {
                    $arraycampos['dao_total_notificacion2']             = null;
                }

                if ($supervisor) {
                    if ($_POST['dao_supervisor']) {
                        $arraycampos['dao_supervisor']            = $_POST['dao_supervisor'];
                    }

                    if ($_POST['dao_fecha_verificacion']) {
                        $arraycampos['dao_fecha_verificacion']            = $_POST['dao_fecha_verificacion']." ".date('H:i');
                    }

                    if ($_POST['dao_fecha_aprobacion']) {
                        $arraycampos['dao_fecha_aprobacion'] = $_POST['dao_fecha_aprobacion'];
                    }

                    if ($_POST['observacion_plano_mejoras']) {
                        $observaciones['observacion_plano_mejoras']['valor'] = $_POST['observacion_plano_mejoras'];
                        $observaciones['observacion_plano_mejoras']['nombre'] = 'plano_mejoras';
                    }

                    if ($_POST['observacion_planilla_terreno']) {
                        $observaciones['observacion_planilla_terreno']['valor'] = $_POST['observacion_planilla_terreno'];
                        $observaciones['observacion_planilla_terreno']['nombre'] = 'planilla_terreno';
                    }

                    if ($_POST['observacion_gastos_transferencia']) {
                        $observaciones['observacion_gastos_transferencia']['valor'] = $_POST['observacion_gastos_transferencia'];
                        $observaciones['observacion_gastos_transferencia']['nombre'] = 'gastos_transferencia';
                    }

                    if ($_POST['observacion_planilla_forestal']) {
                        $observaciones['observacion_planilla_forestal']['valor'] = $_POST['observacion_planilla_forestal'];
                        $observaciones['observacion_planilla_forestal']['nombre'] = 'planilla_forestal';
                    }

                    if ($_POST['observacion_avaluo_conformidad']) {
                        $observaciones['observacion_avaluo_conformidad']['valor'] = $_POST['observacion_avaluo_conformidad'];
                        $observaciones['observacion_avaluo_conformidad']['nombre'] = 'avaluo_conformidad';
                    }
                }
                
                      
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }

                if ($accion == '1') {
                    $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                } else if ($accion == '2') {
                    $aprobar_expediente = $this->expedientes_model->aprobar_expediente($expe_id, $arraycampos, 'dao');
                } else if ($accion == '3') {
                    $habilitar_expediente = $this->expedientes_model->habilitar_expediente($expe_id, $arraycampos, 'dao');
                }
                
                if (isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'dao');
                }

                //if ($resul)
                if ($actualizar_expediente or $aprobar_expediente or $habilitar_expediente) {
                    //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/');
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe_dao2/'.$expe_id);
                }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['dao_ingreso_verificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_ingreso_verificacion',
            'id'       => 'dao_ingreso_verificacion',
            'class'    => 'form-control',
            );

            $this->data['dao_ingreso_verificacion']['value'] = $this->form_validation->set_value('dao_ingreso_verificacion', isset($expediente->dao_ingreso_verificacion) ? (formato_fecha($expediente->dao_ingreso_verificacion)) : ($operador ? date('d/m/Y') : ''));
            
            $this->data['dao_terreno'] = array(
            'type'     => 'text',
            'name'     => 'dao_terreno',
            'id'       => 'dao_terreno',
            'value'    => $this->form_validation->set_value('dao_terreno', formatear_moneda($expediente->dao_terreno)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_gastos_transferencia'] = array(
            'type'     => 'text',
            'name'     => 'dao_gastos_transferencia',
            'id'       => 'dao_gastos_transferencia',
            'value'    => $this->form_validation->set_value('dao_gastos_transferencia', formatear_moneda($expediente->dao_gastos_transferencia)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_mejoras_agroforestales'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_agroforestales',
            'id'       => 'dao_mejoras_agroforestales',
            'value'    => $this->form_validation->set_value('dao_mejoras_agroforestales', formatear_moneda($expediente->dao_mejoras_agroforestales)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_mejoras_edilicias'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_edilicias',
            'id'       => 'dao_mejoras_edilicias',
            'value'    => $this->form_validation->set_value('dao_mejoras_edilicias', formatear_moneda($expediente->dao_mejoras_edilicias)),
            'class'    => 'form-control monto'
            );
            
            $this->data['dao_total_mejoras'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_mejoras',
            'id'       => 'dao_total_mejoras',
            'value'    => $this->form_validation->set_value('dao_total_mejoras', formatear_moneda($expediente->dao_total_mejoras)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_total_notificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion',
            'id'       => 'dao_total_notificacion',
            'value'    => $this->form_validation->set_value('dao_total_notificacion', formatear_moneda($expediente->dao_total_notificacion)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_terreno2'] = array(
            'type'     => 'text',
            'name'     => 'dao_terreno2',
            'id'       => 'dao_terreno2',
            'value'    => $this->form_validation->set_value('dao_terreno2', formatear_moneda($expediente->dao_terreno2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_gastos_transferencia2'] = array(
            'type'     => 'text',
            'name'     => 'dao_gastos_transferencia2',
            'id'       => 'dao_gastos_transferencia2',
            'value'    => $this->form_validation->set_value('dao_gastos_transferencia2', formatear_moneda($expediente->dao_gastos_transferencia2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_mejoras_agroforestales2'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_agroforestales2',
            'id'       => 'dao_mejoras_agroforestales2',
            'value'    => $this->form_validation->set_value('dao_mejoras_agroforestales2', formatear_moneda($expediente->dao_mejoras_agroforestales2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_mejoras_edilicias2'] = array(
            'type'     => 'text',
            'name'     => 'dao_mejoras_edilicias2',
            'id'       => 'dao_mejoras_edilicias2',
            'value'    => $this->form_validation->set_value('dao_mejoras_edilicias2', formatear_moneda($expediente->dao_mejoras_edilicias2)),
            'class'    => 'form-control monto2'
            );
            
            $this->data['dao_total_mejoras2'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_mejoras2',
            'id'       => 'dao_total_mejoras2',
            'value'    => $this->form_validation->set_value('dao_total_mejoras2', formatear_moneda($expediente->dao_total_mejoras2)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_total_notificacion2'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion2',
            'id'       => 'dao_total_notificacion2',
            'value'    => $this->form_validation->set_value('dao_total_notificacion2', formatear_moneda($expediente->dao_total_notificacion2)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_supervisor'] = array(
            'type'     => 'text',
            'name'     => 'dao_supervisor',
            'id'       => 'dao_supervisor',
            'value'    =>  $this->form_validation->set_value('dao_supervisor', $expediente->dao_supervisor),
            'class'    => 'form-control',
            );
            if (!isset($expediente->dao_supervisor) && $supervisor) {
                $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                $this->data['dao_supervisor']['value'] = $this->form_validation->set_value('dao_supervisor', $usuario->first_name.' '.$usuario->last_name);
            }
            
            $this->data['dao_fecha_verificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_fecha_verificacion',
            'id'       => 'dao_fecha_verificacion',
            'class'    => 'form-control'
            );
            $this->data['dao_fecha_verificacion']['value'] = $this->form_validation->set_value('dao_fecha_verificacion', isset($expediente->dao_fecha_verificacion) ? (formato_fecha($expediente->dao_fecha_verificacion)) : ($supervisor ? date('d/m/Y') : ''));
            
       
            $this->data['dao_fecha_aprobacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_fecha_aprobacion',
            'id'       => 'dao_fecha_aprobacion',
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_fecha_aprobacion']['value'] = $this->form_validation->set_value('dao_fecha_aprobacion', isset($expediente->dao_fecha_aprobacion) ? formato_fecha($expediente->dao_fecha_aprobacion) : '');
            $this->data['observacion_plano_mejoras'] = array(
            'type'     => 'text',
            'name'     => 'observacion_plano_mejoras',
            'id'       => 'observacion_plano_mejoras',
            'value'    => $this->form_validation->set_value('observacion_plano_mejoras'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_planilla_terreno'] = array(
            'type'     => 'text',
            'name'     => 'observacion_planilla_terreno',
            'id'       => 'observacion_planilla_terreno',
            'value'    => $this->form_validation->set_value('observacion_planilla_terreno'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_gastos_transferencia'] = array(
            'type'     => 'text',
            'name'     => 'observacion_gastos_transferencia',
            'id'       => 'observacion_gastos_transferencia',
            'value'    => $this->form_validation->set_value('observacion_gastos_transferencia'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_planilla_forestal'] = array(
            'type'     => 'text',
            'name'     => 'observacion_planilla_forestal',
            'id'       => 'observacion_planilla_forestal',
            'value'    => $this->form_validation->set_value('observacion_planilla_forestal'),
            'class'    => 'form-control textarea'
            );

            $this->data['observacion_avaluo_conformidad'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avaluo_conformidad',
            'id'       => 'observacion_avaluo_conformidad',
            'value'    => $this->form_validation->set_value('observacion_avaluo_conformidad'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'dao');

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }

            $historial_fecha_ingreso = $this->expedientes_model->view('historial_fecha_ingreso', array('expediente_id' => $expe_id, 'area' => 'DAO'))->result_array();
            if (!empty($historial_fecha_ingreso)) {
                $this->data['historial_fecha_ingreso'] = $historial_fecha_ingreso;
            }

            if ($coordonadorDAO or $supervisor or !$editableDAO) {
                $this->data['dao_ingreso_verificacion']['readonly'] = true;
            }
/*
            echo print_r($operador.'; '.$coordonadorDAO.'; '.$editableDAO.'; ');
            show_error('TEMPORALMENTE INACTIVO');
*/
            if (!$editableDAO and !(!$operador or !$supervisor or !$coordonadorDAO)) {
                $this->data['dao_terreno']['readonly'] = true;
                $this->data['dao_gastos_transferencia']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales']['readonly'] = true;
                $this->data['dao_mejoras_edilicias']['readonly'] = true;
                $this->data['dao_terreno2']['readonly'] = true;
                $this->data['dao_gastos_transferencia2']['readonly'] = true;
                $this->data['dao_mejoras_agroforestales2']['readonly'] = true;
                $this->data['dao_mejoras_edilicias2']['readonly'] = true;
            }

            if ($operador or $coordonadorDAO or !$editableDAO) {
                echo print_r($operador.'; '.$supervisor.'; '.$coordonadorDAO.'; '.$editableDAO.'; ');
            show_error('TEMPORALMENTE INACTIVO');

                
                if(!$supervisor or !$coordonadorDAO or !$operador){
             
            
                    $this->data['dao_supervisor']['readonly'] = true;
                    $this->data['dao_fecha_verificacion']['readonly'] = true;
                    $this->data['observacion_plano_mejoras']['readonly'] = true;
                    $this->data['observacion_planilla_terreno']['readonly'] = true;
                    $this->data['observacion_gastos_transferencia']['readonly'] = true;
                    $this->data['observacion_planilla_forestal']['readonly'] = true;
                    $this->data['observacion_avaluo_conformidad']['readonly'] = true;
                }
            }

            $this->template->admin_render('expedientes/edit_expe_dao2', $this->data);
    }


    public function edit_expe_daj($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
        

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_DAJ'] = grupo_usuario(18);
        $this->data['habilitado']['op'] = grupo_usuario(36);
        $this->data['habilitado']['sup'] = grupo_usuario(37);
        $this->data['habilitado']['coorsup'] = grupo_usuario(40);

        $coordinadorsup = grupo_usuario(40);
        $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(36);
        $supervisor = grupo_usuario(37);

        $editable = $expediente->editable_daj;

        if ($editable == 't') {
            $editable = true;
        } else {
            $editable = false;
        }
        $this->data['editable'] = $editable;

        $this->data['editableUBI'] = $expediente->editable_ubi;

        $this->data['editableDAO'] = $expediente->editable_dao;
         
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
        


        /* Validate form input */
        
        $this->form_validation->set_rules('daj_fecha_entrada', '<b>Fecha entrada</b>', 'required');
        

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($this->form_validation->run() == true) {
                if ($_POST['daj_fecha_entrada']) {
                    $arraycampos['daj_fecha_entrada']           = $_POST['daj_fecha_entrada'];
                }

                if ($_POST['daj_documentos_adicionales']) {
                    $arraycampos['daj_documentos_adicionales']           = $_POST['daj_documentos_adicionales'];
                }

                if ($supervisor) {
                    if ($_POST['daj_supervisor']) {
                        $arraycampos['daj_supervisor']           = $_POST['daj_supervisor'];
                    }

                    if ($_POST['daj_fecha_revision']) {
                        $arraycampos['daj_fecha_revision']        = $_POST['daj_fecha_revision']." ".date('H:i');
                    }

                    if ($_POST['daj_fecha_aprobacion']) {
                        $arraycampos['daj_fecha_aprobacion']        = $_POST['daj_fecha_aprobacion'];
                    }

                    if ($_POST['observacion_condicion_dominio']) {
                        $observaciones['observacion_condicion_dominio']['valor'] = $_POST['observacion_condicion_dominio'];
                        $observaciones['observacion_condicion_dominio']['nombre'] = 'condicion_dominio';
                    }

                    if ($_POST['observacion_documentacion_faltante']) {
                        $observaciones['observacion_documentacion_faltante']['valor'] = $_POST['observacion_documentacion_faltante'];
                        $observaciones['observacion_documentacion_faltante']['nombre'] = 'documentacion_faltante';
                    }

                    if ($_POST['observacion_notificacion_avaluo']) {
                        $observaciones['observacion_notificacion_avaluo']['valor'] = $_POST['observacion_notificacion_avaluo'];
                        $observaciones['observacion_notificacion_avaluo']['nombre'] = 'notificacion_avaluo';
                    }

                    if ($_POST['observacion_conformidad_afectado']) {
                        $observaciones['observacion_conformidad_afectado']['valor'] = $_POST['observacion_conformidad_afectado'];
                        $observaciones['observacion_conformidad_afectado']['nombre'] = 'conformidad_afectado';
                    }
                }
  
                $accion = 0;
                if (isset($_POST['accion'])) {
                    $accion = intval($_POST['accion']);
                } else {
                    $accion = 0;
                }
      
                /*$unique_exp = $this->expedientes_model->view('expedientes',array('codigo' => $_POST['codigo'],
                                                                        'id_proyecto'    => $_POST['id_proyecto']
                                                                        )
                                                            )->num_rows();*/


                /*if ($unique_exp > 0) {
                    $this->session->set_flashdata('message', 'Ya existe un expediente con el mismo codigo.');
                    redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                }*/

                        //echo $accion;
                        //show_error(1);

                if ($accion == '1') {
                    $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                } else if ($accion == '2') {
                    $aprobar_expediente = $this->expedientes_model->aprobar_expediente($expe_id, $arraycampos, 'daj');
                } else if ($accion == '3') {
                    $habilitar_expediente = $this->expedientes_model->habilitar_expediente($expe_id, $arraycampos, 'daj');
                }
                
                if (isset($observaciones)) {
                    $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'daj');
                }

                if (isset($_POST['documentos'])) {
                    $documentos = $_POST['documentos'];
                    $guardar_documento = $this->expedientes_model->guardar_documento($expe_id, $documentos);
                }

                //if ($resul)
                if ($actualizar_expediente or $aprobar_expediente or $habilitar_expediente) {
                    //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                    $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                    redirect('expedientes/expedientes/');
                } else {
                    $this->session->set_flashdata('message', $this->ion_auth->errors());
                    redirect('expedientes/expedientes/edit_expe_daj/'.$expe_id);
                }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
            }
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['daj_fecha_entrada'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_entrada',
            'id'       => 'daj_fecha_entrada',
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['daj_fecha_entrada']['value'] = $this->form_validation->set_value('daj_fecha_entrada', isset($expediente->daj_fecha_entrada) ? (formato_fecha($expediente->daj_fecha_entrada)) : date('d/m/Y'));
            
            $this->data['daj_documentos_adicionales'] = array(
            'type'     => 'text',
            'name'     => 'daj_documentos_adicionales',
            'id'       => 'daj_documentos_adicionales',
            'value'    => $this->form_validation->set_value('daj_documentos_adicionales', $expediente->daj_documentos_adicionales),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            
            $this->data['daj_supervisor'] = array(
            'type'     => 'text',
            'name'     => 'daj_supervisor',
            'id'       => 'daj_supervisor',
            'value'    =>  $this->form_validation->set_value('daj_supervisor', $expediente->daj_supervisor),
            'class'    => 'form-control',
            );
            if (!isset($expediente->daj_supervisor) && $supervisor) {
                $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                $this->data['daj_supervisor']['value'] = $this->form_validation->set_value('daj_supervisor', $usuario->first_name.' '.$usuario->last_name);
            }
            
            $this->data['daj_fecha_revision'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_revision',
            'id'       => 'daj_fecha_revision',
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['daj_fecha_revision']['value'] = $this->form_validation->set_value('daj_fecha_revision', isset($expediente->daj_fecha_revision) ? (formato_fecha($expediente->daj_fecha_revision)) : ($supervisor ? date('d/m/Y') : ''));
            
            $this->data['daj_fecha_aprobacion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_aprobacion',
            'id'       => 'daj_fecha_aprobacion',
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['daj_fecha_aprobacion']['value'] = $this->form_validation->set_value('daj_fecha_aprobacion', isset($expediente->daj_fecha_aprobacion) ? formato_fecha($expediente->daj_fecha_aprobacion) : '');
            
            $this->data['observacion_condicion_dominio'] = array(
            'type'     => 'text',
            'name'     => 'observacion_condicion_dominio',
            'id'       => 'observacion_condicion_dominio',
            'value'    => $this->form_validation->set_value('observacion_condicion_dominio'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_documentacion_faltante'] = array(
            'type'     => 'text',
            'name'     => 'observacion_documentacion_faltante',
            'id'       => 'observacion_documentacion_faltante',
            'value'    => $this->form_validation->set_value('observacion_documentacion_faltante'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_notificacion_avaluo'] = array(
            'type'     => 'text',
            'name'     => 'observacion_notificacion_avaluo',
            'id'       => 'observacion_notificacion_avaluo',
            'value'    => $this->form_validation->set_value('observacion_notificacion_avaluo'),
            'class'    => 'form-control textarea'
            );
            
            $this->data['observacion_conformidad_afectado'] = array(
            'type'     => 'text',
            'name'     => 'observacion_conformidad_afectado',
            'id'       => 'observacion_conformidad_afectado',
            'value'    => $this->form_validation->set_value('observacion_conformidad_afectado'),
            'class'    => 'form-control textarea'
            );
            
            $documentos = $this->expedientes_model->view('tipos_documentos')->result_array();
            $documentos_sel = $this->expedientes_model->view('documentos', array('expediente_id' => $expe_id))->result_array();
            $this->data['documentos'] = $documentos;
            $this->data['documentos_sel'] = $documentos_sel;

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'daj');

            if (!empty($observaciones)) {
                 $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
            
            $historial_fecha_ingreso = $this->expedientes_model->view('historial_fecha_ingreso', array('expediente_id' => $expe_id, 'area' => 'DAJ'))->result_array();
            
            
            if (!empty($historial_fecha_ingreso)) {
              /*  echo print_r(empty($historial_fecha_ingreso));
                show_error('TEMPORALMENTE INACTIVO');*/
            
                $this->data['historial_fecha_ingreso'] = $historial_fecha_ingreso;
            }

            if ($coordinador or !$editable) {
                $this->data['daj_fecha_entrada']['readonly'] = true;
            }

            if ($coordinador or !$editable) {
                $this->data['daj_documentos_adicionales']['readonly'] = true;
            }

            if ($operador or $coordinador or !$editable) {
                $this->data['daj_supervisor']['readonly'] = true;
                $this->data['daj_fecha_revision']['readonly'] = true;
                $this->data['observacion_condicion_dominio']['readonly'] = true;
                $this->data['observacion_documentacion_faltante']['readonly'] = true;
                $this->data['observacion_notificacion_avaluo']['readonly'] = true;
                $this->data['observacion_conformidad_afectado']['readonly'] = true;
            }

            $this->template->admin_render('expedientes/edit_expe_daj', $this->data);
    }

    public function seg_dao($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(34);

        $operador = grupo_usuario(34);
        $supervisor = grupo_usuario(35);
        $coordinador = grupo_usuario(31);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
            

        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['dao_fecha_recepcion_notificacion_avaluo']) {
                    $arraycampos['dao_fecha_recepcion_notificacion_avaluo']     = $_POST['dao_fecha_recepcion_notificacion_avaluo'];
            }

            if ($_POST['dao_notificacion2']) {
                $arraycampos['dao_notificacion2']     = $_POST['dao_notificacion2'];
            }

            if ($_POST['dao_indemnizacion_escogida']) {
                $arraycampos['dao_indemnizacion_escogida']     = $_POST['dao_indemnizacion_escogida'];
            }

            if ($_POST['dao_eleccion_escogida']) {
                $arraycampos['dao_eleccion_escogida']     = $_POST['dao_eleccion_escogida'];
            }

            if ($_POST['dao_firmado_conformidad']) {
                $arraycampos['dao_firmado_conformidad'] = $_POST['dao_firmado_conformidad'];
            }

            if ($_POST['dao_aplica_conformidad']) {
                $arraycampos['dao_aplica_conformidad']            = $_POST['dao_aplica_conformidad'];
            }

            if ($_POST['dao_aplica_conformidad_ocupante']) {
                $arraycampos['dao_aplica_conformidad_ocupante']            = $_POST['dao_aplica_conformidad_ocupante'];
            } else {
                $arraycampos['dao_aplica_conformidad_ocupante']            = null;
            }

            if ($_POST['dao_observacion_ocupante']) {
                $arraycampos['dao_observacion_ocupante']            = $_POST['dao_observacion_ocupante'];
            } else {
                $arraycampos['dao_observacion_ocupante']            = null;
            }

            if ($_POST['dao_total_conformidad']) {
                $arraycampos['dao_total_conformidad']            = str_replace(".", "", $_POST['dao_total_conformidad']);
            } else {
                $arraycampos['dao_total_conformidad']            = null;
            }
                      
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }

                /*$unique_exp = $this->expedientes_model->view('expedientes',array('codigo' => $_POST['codigo'],
                                                                        'id_proyecto'    => $_POST['id_proyecto']
                                                                        )
                                                            )->num_rows();*/


                /*if ($unique_exp > 0) {
                    $this->session->set_flashdata('message', 'Ya existe un expediente con el mismo codigo.');
                    redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                }*/

                        //echo $accion;
                        //show_error(1);

                
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                

                //if ($resul)
            if ($actualizar_expediente) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_dao/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_dao/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['dao_fecha_recepcion_notificacion_avaluo'] = array(
            'type'     => 'text',
            'name'     => 'dao_fecha_recepcion_notificacion_avaluo',
            'id'       => 'dao_fecha_recepcion_notificacion_avaluo',
            'class'    => 'form-control',
            );
            $this->data['dao_fecha_recepcion_notificacion_avaluo']['value'] = $this->form_validation->set_value('dao_fecha_recepcion_notificacion_avaluo', isset($expediente->dao_fecha_recepcion_notificacion_avaluo) ? formato_fecha($expediente->dao_fecha_recepcion_notificacion_avaluo) : '');
            
            $this->data['dao_notificacion2'] = array(
            'type'     => 'text',
            'name'     => 'dao_notificacion2',
            'id'       => 'dao_notificacion2',
            'class'    => 'form-control',
            );
            $this->data['dao_notificacion2']['value'] = $this->form_validation->set_value('dao_notificacion2', formato_fecha($expediente->dao_notificacion2));
            
            if (isset($expediente->dao_notificacion2) && !isset($expediente->dao_firmado_conformidad)) {
                $str1 =  calculate_limit_day($expediente->dao_notificacion2);
                $str2 =  strtotime(date('Y-m-d'));
                $diff_fecha = $str1 - $str2;
                if ($diff_fecha < 0) {
                     $this->data['tiempo_restante'] = -1;
                } else if ($diff_fecha == 0) {
                    $this->data['tiempo_restante'] = 0;
                } else {
                    $fecha_1 = date('Y-m-d', $str1);
                    $fecha_2 = date('Y-m-d');
                    $calculated = number_of_working_days($fecha_2, $fecha_1);
                    $this->data['tiempo_restante'] = $calculated;
                }
            }
    
            $eleccionEscogida = array (
              '' =>  'Seleccione la opción',
              'PR' => 'Pendiente de respuesta',
              'IN' => 'Indemnización',
              'RU' => 'Reubicación',
              'RE' => 'Retiro Voluntario'
            );
            
            $this->data['dao_eleccion_escogida'] = $eleccionEscogida;

            if (isset($expediente->dao_eleccion_escogida)) {
                $this->data['dao_eleccion_escogida_sel'] = $expediente->dao_eleccion_escogida;
            } else {
                $this->data['dao_eleccion_escogida_sel'] = '';
            }
            

            $this->data['dao_indemnizacion_escogida'] = array(
            'type'     => 'radio',
            'name'     => 'dao_indemnizacion_escogida',
            'id'       => 'dao_indemnizacion_escogida',
            'value_1'  => '1',
            'value_2'  => '2',
            'class'    => 'form-control'
            );
            if (isset($expediente->dao_indemnizacion_escogida)) {
                if ($expediente->dao_indemnizacion_escogida == '1') {
                    $this->data['dao_indemnizacion_escogida']['checked_1'] = true;
                    $this->data['dao_indemnizacion_escogida']['checked_2'] = false;
                } else {
                    $this->data['dao_indemnizacion_escogida']['checked_1'] = false;
                    $this->data['dao_indemnizacion_escogida']['checked_2'] = true;
                }
            } else {
                $this->data['dao_indemnizacion_escogida']['checked_1'] = false;
                $this->data['dao_indemnizacion_escogida']['checked_2'] = false;
            }

            $this->data['dao_firmado_conformidad'] = array(
            'type'     => 'text',
            'name'     => 'dao_firmado_conformidad',
            'id'       => 'dao_firmado_conformidad',
            'class'    => 'form-control',
            );
            $this->data['dao_firmado_conformidad']['value'] = $this->form_validation->set_value('dao_firmado_conformidad', isset($expediente->dao_firmado_conformidad) ? formato_fecha($expediente->dao_firmado_conformidad) : '');
            
            $this->data['dao_aplica_conformidad'] = array(
            'type'     => 'radio',
            'name'     => 'dao_aplica_conformidad',
            'id'       => 'dao_aplica_conformidad',
            'value_s'  => 'SI',
            'value_n'  => 'NO',
            'value_p' => 'PENDIENTE',
            'class'    => 'form-control'
            );
            if (isset($expediente->dao_aplica_conformidad)) {
                switch ($expediente->dao_aplica_conformidad) {
                    case 'SI':
                        $this->data['dao_aplica_conformidad']['checked_s'] = true;
                        $this->data['dao_aplica_conformidad']['checked_n'] = false;
                        $this->data['dao_aplica_conformidad']['checked_p'] = false;
                        break;
                    case 'NO':
                        $this->data['dao_aplica_conformidad']['checked_s'] = false;
                        $this->data['dao_aplica_conformidad']['checked_n'] = true;
                        $this->data['dao_aplica_conformidad']['checked_p'] = false;
                        break;
                    default:
                        $this->data['dao_aplica_conformidad']['checked_s'] = false;
                        $this->data['dao_aplica_conformidad']['checked_n'] = false;
                        $this->data['dao_aplica_conformidad']['checked_p'] = true;
                        break;
                }
            } else {
                $this->data['dao_aplica_conformidad']['checked_s'] = false;
                $this->data['dao_aplica_conformidad']['checked_n'] = false;
                $this->data['dao_aplica_conformidad']['checked_p'] = true;
            }
            $this->data['dao_aplica_conformidad_ocupante'] = array(
            'type'     => 'radio',
            'name'     => 'dao_aplica_conformidad_ocupante',
            'id'       => 'dao_aplica_conformidad_ocupante',
            'value_s'  => 'SI',
            'value_n'  => 'NO',
            'value_p'  => null,
            'class'    => 'form-control'
            );
            if (isset($expediente->dao_aplica_conformidad_ocupante)) {
                switch ($expediente->dao_aplica_conformidad_ocupante) {
                    case 'SI':
                        $this->data['dao_aplica_conformidad_ocupante']['checked_s'] = true;
                        $this->data['dao_aplica_conformidad_ocupante']['checked_n'] = false;
                        $this->data['dao_aplica_conformidad_ocupante']['checked_p'] = false;
                        break;
                    case 'NO':
                        $this->data['dao_aplica_conformidad_ocupante']['checked_s'] = false;
                        $this->data['dao_aplica_conformidad_ocupante']['checked_n'] = true;
                        $this->data['dao_aplica_conformidad_ocupante']['checked_p'] = false;
                        break;
                }
            } else {
                $this->data['dao_aplica_conformidad_ocupante']['checked_s'] = false;
                $this->data['dao_aplica_conformidad_ocupante']['checked_n'] = false;
                $this->data['dao_aplica_conformidad_ocupante']['checked_p'] = true;
            }
            $this->data['dao_observacion_ocupante'] = array(
            'type'     => 'text',
            'name'     => 'dao_observacion_ocupante',
            'id'       => 'dao_observacion_ocupante',
            'value'    => $this->form_validation->set_value('dao_observacion_ocupante', $expediente->dao_observacion_ocupante),
            'class'    => 'form-control textarea'
            );
            $this->data['dao_total_conformidad'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_conformidad',
            'id'       => 'dao_total_conformidad',
            'value'    => $this->form_validation->set_value('dao_total_conformidad', formatear_moneda($expediente->dao_total_conformidad)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );

            $this->data['dao_total_notificacion'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion',
            'id'       => 'dao_total_notificacion',
            'value'    => $this->form_validation->set_value('dao_total_notificacion', formatear_moneda($expediente->dao_total_notificacion)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );
            $this->data['dao_total_notificacion2'] = array(
            'type'     => 'text',
            'name'     => 'dao_total_notificacion2',
            'id'       => 'dao_total_notificacion2',
            'value'    => $this->form_validation->set_value('dao_total_notificacion2', formatear_moneda($expediente->dao_total_notificacion2)),
            'class'    => 'form-control',
            'readonly' => 'true'
            );

            if ($supervisor or $coordinador) {
                $this->data['dao_fecha_recepcion_notificacion_avaluo']['readonly'] = true;
                $this->data['dao_notificacion2']['readonly'] = true;
                $this->data['dao_firmado_conformidad']['readonly'] = true;
            }
            
            $this->template->admin_render('expedientes/seg_dao', $this->data);
    }

    public function seg_daj($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;

        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(36);
        $this->data['habilitado']['sup'] = grupo_usuario(37);
        $this->data['habilitado_coor'] = grupo_usuario(31);
        $this->data['habilitado']['coorsup'] = grupo_usuario(40);


        $operador = grupo_usuario(36);
        $supervisor = grupo_usuario(37);
        $coordinador = grupo_usuario(31);
        $coordinadorsup = grupo_usuario(40);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $expediente;
    	$arraycampos['id'] =  $expe_id;

        
        //Se produce cuando el usuario da click en el submit
        //if (isset($_POST) && ! empty($_POST)) {
    	if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['daj_nro_dbi']) {
                    $arraycampos['daj_nro_dbi']                         = $_POST['daj_nro_dbi'];
            }

            if ($_POST['daj_nro_dictamen']) {
                    $arraycampos['daj_nro_dictamen']                  = $_POST['daj_nro_dictamen'];
            }
        
            if ($_POST['daj_fecha_dictamen']) {
                    $arraycampos['daj_fecha_dictamen']                  = $_POST['daj_fecha_dictamen'];
            }
            

            if ($_POST['daj_fecha_borrador_resolucion']) {
                $arraycampos['daj_fecha_borrador_resolucion']           = $_POST['daj_fecha_borrador_resolucion'];
            }

            if ($_POST['daj_nro_resolucion']) {
                    $arraycampos['daj_nro_resolucion']                  = $_POST['daj_nro_resolucion'];
            }

            if ($_POST['daj_fecha_resolucion']) {
                $arraycampos['daj_fecha_resolucion']                    = $_POST['daj_fecha_resolucion'];
            }

            if ($_POST['daj_fecha_notificacion_resolucion']) {
                    $arraycampos['daj_fecha_notificacion_resolucion']   = $_POST['daj_fecha_notificacion_resolucion'];
            }

            if ($_POST['daj_nro_memo_dbi_p_rectificar']) {
                    $arraycampos['daj_nro_memo_dbi_p_rectificar']       = $_POST['daj_nro_memo_dbi_p_rectificar'];
            }

            if ($_POST['daj_fecha_memo_dbi_p_rectificar']) {
                $arraycampos['daj_fecha_memo_dbi_p_rectificar']         = $_POST['daj_fecha_memo_dbi_p_rectificar'];
            }
        
            if ($_POST['daj_nro_resolucion_rectific']) {
                    $arraycampos['daj_nro_resolucion_rectific']         = $_POST['daj_nro_resolucion_rectific'];
            }

            if ($_POST['daj_fecha_resolucion_rectific']) {
                $arraycampos['daj_fecha_resolucion_rectific']           = $_POST['daj_fecha_resolucion_rectific'];
            }
    
        
			/*
            if ($_POST['daj_contrasenha_cexter']) {
                $arraycampos['daj_contrasenha_cexter']                  = $_POST['daj_contrasenha_cexter'];
            }
            */

            if ($_POST['daj_nro_decreto']) {
                $arraycampos['daj_nro_decreto']                         = $_POST['daj_nro_decreto'];
            }

            if ($_POST['daj_fecha_decreto']) {
                $arraycampos['daj_fecha_decreto']                       = $_POST['daj_fecha_decreto'];
            }
        
            //if ($_POST['daj_codigo_cexter']) {
            //    $arraycampos['daj_codigo_cexter']                       = $_POST['daj_codigo_cexter'];
            //}
        
        	// Adicionado por Jaime Rojas Landivar
            if ($_POST['daj_nro_memo_daj_seg']) {
                $arraycampos['daj_nro_memo_daj_seg']                    = $_POST['daj_nro_memo_daj_seg'];
            }

            if ($_POST['daj_fecha_daj_seg']) {
                $arraycampos['daj_fecha_daj_seg']                       = $_POST['daj_fecha_daj_seg'];
            }  
        	//-------------------------------- By JRL
        
            if ($_POST['daj_nro_memo_para_decreto']) {
                $arraycampos['daj_nro_memo_para_decreto']               = $_POST['daj_nro_memo_para_decreto'];
            } 
        
            if ($_POST['daj_fecha_memo_para_decreto']) {
                $arraycampos['daj_fecha_memo_para_decreto']             = $_POST['daj_fecha_memo_para_decreto'];
            }

            if ($_POST['daj_fecha_notificacion_decreto']) {
                $arraycampos['daj_fecha_notificacion_decreto']          = $_POST['daj_fecha_notificacion_decreto'];
            }
        
        	// Adicionado por Jaime Rojas Landivar
            if ($_POST['daj_nro_memo_recti_dbi']) {
                $arraycampos['daj_nro_memo_recti_dbi']                    = $_POST['daj_nro_memo_recti_dbi'];
            }

            if ($_POST['daj_fecha_recti_dbi']) {
                $arraycampos['daj_fecha_recti_dbi']                       = $_POST['daj_fecha_recti_dbi'];
            }  
        	//-------------------------------- By JRL   

            // Adicionado por Jaime Rojas Landivar
            if ($_POST['daj_nro_decreto_recti']) {
                $arraycampos['daj_nro_decreto_recti']                    = $_POST['daj_nro_decreto_recti'];
            }

            if (! empty($_POST['daj_fecha_decreto_recti'])) {
                    $arraycampos['daj_fecha_decreto_recti']     = $_POST['daj_fecha_decreto_recti'];
            } else {
                    $arraycampos['daj_fecha_decreto_recti']     = null;    
            }        
        
            if (! empty($_POST['daj_orden_caratula'])) {
                $arraycampos['daj_orden_caratula'] = $_POST['daj_orden_caratula'];
        
            }             
        	//-------------------------------- By JRL  

        
			/*
            if ($_POST['daj_nro_dictamen_pgr']) {
                $arraycampos['daj_nro_dictamen_pgr']                    = $_POST['daj_nro_dictamen_pgr'];
            }
            */
			/*
            if ($_POST['daj_nro_nota_pgr']) {
                $arraycampos['daj_nro_nota_pgr']                        = $_POST['daj_nro_nota_pgr'];
            }
            */
			/*
            if ($_POST['daj_fecha_entrega_a_pgr']) {
                $arraycampos['daj_fecha_entrega_a_pgr']                 = $_POST['daj_fecha_entrega_a_pgr'];
            }
            */

            if ($_POST['daj_nro_memo_dbi_a_pgr']) {
                $arraycampos['daj_nro_memo_dbi_a_pgr']                  = $_POST['daj_nro_memo_dbi_a_pgr'];
            }

            if ($_POST['daj_fecha_memo_dbi_a_pgr']) {
                $arraycampos['daj_fecha_memo_dbi_a_pgr']                = $_POST['daj_fecha_memo_dbi_a_pgr'];
            }


            if ($_POST['daj_nro_memo_dbi_daj']) {
                    $arraycampos['daj_nro_memo_dbi_daj']       			= $_POST['daj_nro_memo_dbi_daj'];
            }

            if ($_POST['daj_fecha_memo_dbi']) {
                $arraycampos['daj_fecha_memo_dbi']         				= $_POST['daj_fecha_memo_dbi'];
            }
        
            if ($_POST['daj_nro_dictamen_daj_pgr']) {
                    $arraycampos['daj_nro_dictamen_daj_pgr']         	= $_POST['daj_nro_dictamen_daj_pgr'];
            }

            if ($_POST['daj_fecha_dictamen_daj']) {
                $arraycampos['daj_fecha_dictamen_daj']           		= $_POST['daj_fecha_dictamen_daj'];
            }
            

                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }

        	//echo $arraycampos;
            //echo print_r('; '.$expe_id.':'.$arraycampos['id'])  ; 
            //show_error('TEMPORALMENTE INACTIVO');        
        
            $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                
            if ($actualizar_expediente) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_daj/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_daj/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );


            $this->data['daj_nro_dbi'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dbi',
            'pattern'  => '^([1-9][0-9]{0,20})?$',
            'id'       => 'daj_nro_dbi',
            'value'    => $this->form_validation->set_value('daj_nro_dbi', $expediente->daj_nro_dbi),
            'class'    => 'form-control'
            );
    
            $this->data['daj_fecha_borrador_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_borrador_resolucion',
            'id'       => 'daj_fecha_borrador_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_borrador_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_borrador_resolucion', isset($expediente->daj_fecha_borrador_resolucion) ? formato_fecha($expediente->daj_fecha_borrador_resolucion) : '');

            $this->data['daj_nro_dictamen'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dictamen',
            'id'       => 'daj_nro_dictamen',
            'value'    => $this->form_validation->set_value('daj_nro_dictamen', $expediente->daj_nro_dictamen),
            'class'    => 'form-control',
            //'readonly' => 'true'
            );      
    
            $this->data['daj_fecha_dictamen'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_dictamen',
            'id'       => 'daj_fecha_dictamen',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_dictamen']['value'] = $this->form_validation->set_value('daj_fecha_dictamen', isset($expediente->daj_fecha_dictamen) ? formato_fecha($expediente->daj_fecha_dictamen) : '');
            

            $this->data['daj_nro_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_resolucion',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_resolucion',
            'value'    => $this->form_validation->set_value('daj_nro_resolucion', $expediente->daj_nro_resolucion),
            'class'    => 'form-control'
            );
            
            $this->data['daj_nro_memo_dbi_p_rectificar'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_memo_dbi_p_rectificar',
            'id'       => 'daj_nro_memo_dbi_p_rectificar',
            'value'    => $this->form_validation->set_value('daj_nro_memo_dbi_p_rectificar', $expediente->daj_nro_memo_dbi_p_rectificar),
            'class'    => 'form-control',
            //'readonly' => 'true'
            );      
    
            $this->data['daj_fecha_memo_dbi_p_rectificar'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_memo_dbi_p_rectificar',
            'id'       => 'daj_fecha_memo_dbi_p_rectificar',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_memo_dbi_p_rectificar']['value'] = $this->form_validation->set_value('daj_fecha_memo_dbi_p_rectificar', isset($expediente->daj_fecha_memo_dbi_p_rectificar) ? formato_fecha($expediente->daj_fecha_memo_dbi_p_rectificar) : '');

    
            $this->data['daj_nro_resolucion_rectific'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_resolucion_rectific',
            'id'       => 'daj_nro_resolucion_rectific',
            'value'    => $this->form_validation->set_value('daj_nro_resolucion_rectific', $expediente->daj_nro_resolucion_rectific),
            //'class'    => 'form-control',
            'readonly' => 'true'
            );      
    
            $this->data['daj_fecha_resolucion_rectific'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_resolucion_rectific',
            'id'       => 'daj_fecha_resolucion_rectific',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_resolucion_rectific']['value'] = $this->form_validation->set_value('daj_fecha_resolucion_rectific', isset($expediente->daj_fecha_resolucion_rectific) ? formato_fecha($expediente->daj_fecha_resolucion_rectific) : '');
                     
    
            $this->data['daj_nro_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_resolucion',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_resolucion',
            'value'    => $this->form_validation->set_value('daj_nro_resolucion', $expediente->daj_nro_resolucion),
            'class'    => 'form-control'
            );
            
            $this->data['daj_fecha_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_resolucion',
            'id'       => 'daj_fecha_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_resolucion', isset($expediente->daj_fecha_resolucion) ? formato_fecha($expediente->daj_fecha_resolucion) : '');
           
            $this->data['daj_fecha_notificacion_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_notificacion_resolucion',
            'id'       => 'daj_fecha_notificacion_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_notificacion_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_notificacion_resolucion', isset($expediente->daj_fecha_notificacion_resolucion) ? formato_fecha($expediente->daj_fecha_notificacion_resolucion) : '');
           
    
    /*
            $this->data['daj_codigo_cexter'] = array(
            'type'     => 'text',
            'name'     => 'daj_codigo_cexter',
            'id'       => 'daj_codigo_cexter',
            'value'    => $this->form_validation->set_value('daj_codigo_cexter', $expediente->daj_codigo_cexter),
            'class'    => 'form-control'
            );

            $this->data['daj_contrasenha_cexter'] = array(
            'type'     => 'text',
            'name'     => 'daj_contrasenha_cexter',
            'id'       => 'daj_contrasenha_cexter',
            'value'    => $this->form_validation->set_value('daj_contrasenha_cexter', $expediente->daj_contrasenha_cexter),
            'class'    => 'form-control'
            );
      */      
    		// Adicionado por Jaime Rojas
            $this->data['daj_nro_memo_daj_seg'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_daj_seg',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_daj_seg',
                'value'    => $this->form_validation->set_value('daj_nro_memo_daj_seg', $expediente->daj_nro_memo_daj_seg),
                'class'    => 'form-control'
            );

            $this->data['daj_fecha_daj_seg'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_daj_seg',
                'id'       => 'daj_fecha_daj_seg',
                'class'    => 'form-control',
                );
            $this->data['daj_fecha_daj_seg']['value'] = $this->form_validation->set_value('daj_fecha_daj_seg', isset($expediente->daj_fecha_daj_seg) ? formato_fecha($expediente->daj_fecha_memo_para_decreto) : '');
            //--------------------------- By JRL     
    
    
            $this->data['daj_nro_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_decreto',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_decreto',
            'value'    => $this->form_validation->set_value('daj_nro_decreto', $expediente->daj_nro_decreto),
            'class'    => 'form-control'
            );

            $this->data['daj_nro_memo_para_decreto'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_para_decreto',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_para_decreto',
                'value'    => $this->form_validation->set_value('daj_nro_memo_para_decreto', $expediente->daj_nro_memo_para_decreto),
                'class'    => 'form-control'
            );

            $this->data['daj_fecha_memo_para_decreto'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_memo_para_decreto',
                'id'       => 'daj_fecha_memo_para_decreto',
                'class'    => 'form-control',
                );
            $this->data['daj_fecha_memo_para_decreto']['value'] = $this->form_validation->set_value('daj_fecha_memo_para_decreto', isset($expediente->daj_fecha_memo_para_decreto) ? formato_fecha($expediente->daj_fecha_memo_para_decreto) : '');
                
            
            $this->data['daj_fecha_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_decreto',
            'id'       => 'daj_fecha_decreto',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_decreto']['value'] = $this->form_validation->set_value('daj_fecha_decreto', isset($expediente->daj_fecha_decreto) ? formato_fecha($expediente->daj_fecha_decreto) : '');
            
            $this->data['daj_fecha_notificacion_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_notificacion_decreto',
            'id'       => 'daj_fecha_notificacion_decreto',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_notificacion_decreto']['value'] = $this->form_validation->set_value('daj_fecha_notificacion_decreto', isset($expediente->daj_fecha_notificacion_decreto) ? formato_fecha($expediente->daj_fecha_notificacion_decreto) : '');

    
    		// Adicionado por Jaime Rojas
            $this->data['daj_nro_memo_recti_dbi'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_recti_dbi',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_recti_dbi',
                'value'    => $this->form_validation->set_value('daj_nro_memo_recti_dbi', $expediente->daj_nro_memo_recti_dbi),
                'class'    => 'form-control'
            );

            $this->data['daj_fecha_recti_dbi'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_recti_dbi',
                'id'       => 'daj_fecha_recti_dbi',
                'class'    => 'form-control',
                );
            $this->data['daj_fecha_recti_dbi']['value'] = $this->form_validation->set_value('daj_fecha_recti_dbi', isset($expediente->daj_fecha_recti_dbi) ? formato_fecha($expediente->daj_fecha_recti_dbi) : '');

            $this->data['daj_nro_decreto_recti'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_decreto_recti',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_decreto_recti',
                'value'    => $this->form_validation->set_value('daj_nro_decreto_recti', $expediente->daj_nro_decreto_recti),
                'class'    => 'form-control'
            );
    

            $this->data['daj_fecha_decreto_recti'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_decreto_recti',
                'id'       => 'daj_fecha_decreto_recti',
                'class'    => 'form-control',
                );
            $this->data['daj_fecha_decreto_recti']['value'] = $this->form_validation->set_value('daj_fecha_decreto_recti', isset($expediente->daj_fecha_decreto_recti) ? formato_fecha($expediente->daj_fecha_decreto_recti) : '');
     
           //--------------------------- By JRL        
    
    
    
            $this->data['daj_nro_dictamen_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dictamen_pgr',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_dictamen_pgr',
            'value'    => $this->form_validation->set_value('daj_nro_dictamen_pgr', $expediente->daj_nro_dictamen_pgr),
            'class'    => 'form-control'
            );
            
            $this->data['daj_nro_nota_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_nota_pgr',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_nota_pgr',
            'value'    => $this->form_validation->set_value('daj_nro_nota_pgr', $expediente->daj_nro_nota_pgr),
            'class'    => 'form-control'
            );
            
            $this->data['daj_fecha_entrega_a_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_entrega_a_pgr',
            'id'       => 'daj_fecha_entrega_a_pgr',
            'class'    => 'form-control',
            );
            
            $this->data['daj_nro_memo_dbi_a_pgr'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_dbi_a_pgr',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_dbi_a_pgr',
                'value'    => $this->form_validation->set_value('daj_nro_memo_dbi_a_pgr', $expediente->daj_nro_memo_dbi_a_pgr),
                'class'    => 'form-control'
            );
            $this->data['daj_fecha_memo_dbi_a_pgr'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_memo_dbi_a_pgr',
                'id'       => 'daj_fecha_memo_dbi_a_pgr',
                'class'    => 'form-control',
            );
      		$this->data['daj_fecha_memo_dbi_a_pgr']['value'] = $this->form_validation->set_value('daj_fecha_memo_dbi_a_pgr', isset($expediente->daj_fecha_memo_dbi_a_pgr) ? formato_fecha($expediente->daj_fecha_memo_dbi_a_pgr) : '');

            $this->data['daj_nro_memo_dbi_daj'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_dbi_daj',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_dbi_daj',
                'value'    => $this->form_validation->set_value('daj_nro_memo_dbi_daj', $expediente->daj_nro_memo_dbi_daj),
                'class'    => 'form-control'
            );
            $this->data['daj_fecha_memo_dbi'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_memo_dbi',
                'id'       => 'daj_fecha_memo_dbi',
                'class'    => 'form-control',
            );
      		$this->data['daj_fecha_memo_dbi']['value'] = $this->form_validation->set_value('daj_fecha_memo_dbi', isset($expediente->daj_fecha_memo_dbi) ? formato_fecha($expediente->daj_fecha_memo_dbi) : '');
     
            $this->data['daj_nro_dictamen_daj_pgr'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_dictamen_daj_pgr',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_dictamen_daj_pgr',
                'value'    => $this->form_validation->set_value('daj_nro_dictamen_daj_pgr', $expediente->daj_nro_dictamen_daj_pgr),
                'class'    => 'form-control'
            );
            $this->data['daj_fecha_dictamen_daj'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_dictamen_daj',
                'id'       => 'daj_fecha_dictamen_daj',
                'class'    => 'form-control',
            );
      		$this->data['daj_fecha_dictamen_daj']['value'] = $this->form_validation->set_value('daj_fecha_dictamen_daj', isset($expediente->daj_fecha_dictamen_daj) ? formato_fecha($expediente->daj_fecha_dictamen_daj) : '');
    
    		// Adicionado por Jaime Rojas
            $this->data['daj_orden_caratula'] = array(
                'type'     => 'radio',
                'name'     => 'daj_orden_caratula',
                'id'       => 'daj_orden_caratula',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
                'readonly' => 'true',
            	'value'    => $this->form_validation->set_value('daj_orden_caratula', $expediente->daj_orden_caratula),
                'class'    => 'form-control'
            );    
    
        	if ($this->data['daj_orden_caratula']['value'] == 'SI') {
                $this->data['daj_orden_caratula']['checked_n'] = false;
                $this->data['daj_orden_caratula']['checked_s'] = true;
            } else {
                $this->data['daj_orden_caratula']['checked_n'] = true;
                $this->data['daj_orden_caratula']['checked_s'] = false;                      
            }                                                        
             //--------------------------- By JRL   
    
            $this->data['daj_fecha_entrega_a_pgr']['value'] = $this->form_validation->set_value('daj_fecha_entrega_a_pgr', isset($expediente->daj_fecha_entrega_a_pgr) ? formato_fecha($expediente->daj_fecha_entrega_a_pgr) : '');
            $this->data['daj_fecha_memo_dbi_a_pgr']['value'] = $this->form_validation->set_value('daj_fecha_memo_dbi_a_pgr', isset($expediente->daj_fecha_memo_dbi_a_pgr) ? formato_fecha($expediente->daj_fecha_memo_dbi_a_pgr) : '');
            
            if ((!$operador and !$supervisor and !$coordinador)) {
                $this->data['daj_nro_dictamen']['readonly'] = true;
                $this->data['daj_fecha_dictamen']['readonly'] = true;
            	$this->data['daj_nro_dbi']['readonly'] = true;
            	$this->data['daj_fecha_borrador_resolucion']['readonly'] = true;
                $this->data['daj_nro_resolucion']['readonly'] = true;
                $this->data['daj_fecha_resolucion']['readonly'] = true;
                $this->data['daj_fecha_notificacion_resolucion']['readonly'] = true;
                $this->data['daj_codigo_cexter']['readonly'] = true;
                $this->data['daj_contrasenha_cexter']['readonly'] = true;
                $this->data['daj_nro_decreto']['readonly'] = true;
                $this->data['daj_nro_memo_para_decreto']['readonly'] = true;
                $this->data['daj_fecha_memo_para_decreto']['readonly'] = true;
                $this->data['daj_fecha_decreto']['readonly'] = true;
                $this->data['daj_fecha_notificacion_decreto']['readonly'] = true;
                $this->data['daj_nro_dictamen_pgr']['readonly'] = true;
                $this->data['daj_nro_nota_pgr']['readonly'] = true;
                $this->data['daj_fecha_entrega_a_pgr']['readonly'] = true;
                $this->data['daj_nro_memo_dbi_a_pgr']['readonly'] = true;
                $this->data['daj_fecha_memo_dbi_a_pgr']['readonly'] = true;

             	$this->data['daj_nro_memo_daj_seg']['readonly'] = true;
    			$this->data['daj_fecha_daj_seg']['readonly'] = true;
    			$this->data['daj_nro_memo_recti_dbi']['readonly'] = true;
    			$this->data['daj_fecha_recti_dbi']['readonly'] = true;
    			$this->data['daj_nro_decreto_recti']['readonly'] = true;
    			$this->data['daj_fecha_decreto_recti']['readonly'] = true;
    			$this->data['daj_orden_caratula']['readonly'] = true;

             	$this->data['daj_nro_memo_dbi_seg']['readonly'] = true;
    			$this->data['daj_fecha_dbi_seg']['readonly'] = true;
    			$this->data['daj_nro_memo_dbi_p_rectificar']['readonly'] = true;
    			$this->data['daj_fecha_memo_dbi_p_rectificar']['readonly'] = true;
    			$this->data['daj_nro_resolucion_rectific']['readonly'] = true;
    			$this->data['daj_fecha_resolucion_rectific']['readonly'] = true;
    			$this->data['daj_nro_memo_dbi_daj']['readonly'] = true;
    			$this->data['daj_fecha_memo_dbi']['readonly'] = true;
    			$this->data['daj_nro_dictamen_daj_pgr']['readonly'] = true;
   				$this->data['daj_fecha_dictamen_daJ']['readonly'] = true;
            }

            $this->template->admin_render('expedientes/seg_daj', $this->data);
    }

    public function seg_daj2($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;

        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(36);
        $this->data['habilitado']['sup'] = grupo_usuario(37);
        $this->data['habilitado_coor'] = grupo_usuario(31);


        $operador = grupo_usuario(36);
        $supervisor = grupo_usuario(37);
        $coordinador = grupo_usuario(31);

        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $expediente;

        
        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['daj_nro_dbi']) {
                    $arraycampos['daj_nro_dbi']                         = $_POST['daj_nro_dbi'];
            }

            if ($_POST['daj_fecha_dictamen']) {
                    $arraycampos['daj_fecha_dictamen']                  = $_POST['daj_fecha_dictamen'];
            }

            if ($_POST['daj_fecha_borrador_resolucion']) {
                $arraycampos['daj_fecha_borrador_resolucion']           = $_POST['daj_fecha_borrador_resolucion'];
            }

            if ($_POST['daj_nro_resolucion']) {
                    $arraycampos['daj_nro_resolucion']                  = $_POST['daj_nro_resolucion'];
            }

            if ($_POST['daj_fecha_resolucion']) {
                $arraycampos['daj_fecha_resolucion']                    = $_POST['daj_fecha_resolucion'];
            }

            if ($_POST['daj_fecha_notificacion_resolucion']) {
                    $arraycampos['daj_fecha_notificacion_resolucion']   = $_POST['daj_fecha_notificacion_resolucion'];
            }

            if ($_POST['daj_codigo_cexter']) {
                $arraycampos['daj_codigo_cexter']                       = $_POST['daj_codigo_cexter'];
            }

            if ($_POST['daj_contrasenha_cexter']) {
                $arraycampos['daj_contrasenha_cexter']                  = $_POST['daj_contrasenha_cexter'];
            }

            if ($_POST['daj_nro_decreto']) {
                $arraycampos['daj_nro_decreto']                         = $_POST['daj_nro_decreto'];
            }

            if ($_POST['daj_fecha_decreto']) {
                $arraycampos['daj_fecha_decreto']                       = $_POST['daj_fecha_decreto'];
            }

            if ($_POST['daj_nro_memo_para_decreto']) {
                $arraycampos['daj_nro_memo_para_decreto']               = $_POST['daj_nro_memo_para_decreto'];
            }

            if ($_POST['daj_fecha_memo_para_decreto']) {
                $arraycampos['daj_fecha_memo_para_decreto']             = $_POST['daj_fecha_memo_para_decreto'];
            }

            if ($_POST['daj_fecha_notificacion_decreto']) {
                $arraycampos['daj_fecha_notificacion_decreto']          = $_POST['daj_fecha_notificacion_decreto'];
            }

            if ($_POST['daj_nro_dictamen_pgr']) {
                $arraycampos['daj_nro_dictamen_pgr']                    = $_POST['daj_nro_dictamen_pgr'];
            }

            if ($_POST['daj_nro_nota_pgr']) {
                $arraycampos['daj_nro_nota_pgr']                        = $_POST['daj_nro_nota_pgr'];
            }

            if ($_POST['daj_fecha_entrega_a_pgr']) {
                $arraycampos['daj_fecha_entrega_a_pgr']                 = $_POST['daj_fecha_entrega_a_pgr'];
            }

            if ($_POST['daj_nro_memo_dbi_a_pgr']) {
                $arraycampos['daj_nro_memo_dbi_a_pgr']                  = $_POST['daj_nro_memo_dbi_a_pgr'];
            }

            if ($_POST['daj_fecha_memo_dbi_a_pgr']) {
                $arraycampos['daj_fecha_memo_dbi_a_pgr']                = $_POST['daj_fecha_memo_dbi_a_pgr'];
            }
                      
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }

                
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
                
            if ($actualizar_expediente) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_daj2/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_daj2/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['daj_nro_dictamen'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dictamen',
            'id'       => 'daj_nro_dictamen',
            'value'    => $this->form_validation->set_value('daj_nro_dictamen', $expediente->daj_nro_dictamen),
            'class'    => 'form-control',
            'readonly' => 'true'
            );

            $this->data['daj_nro_dbi'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dbi',
            'pattern'  => '^([1-9][0-9]{0,20})?$',
            'id'       => 'daj_nro_dbi',
            'value'    => $this->form_validation->set_value('daj_nro_dbi', $expediente->daj_nro_dbi),
            'class'    => 'form-control'
            );
            
            $this->data['daj_fecha_dictamen'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_dictamen',
            'id'       => 'daj_fecha_dictamen',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_dictamen']['value'] = $this->form_validation->set_value('daj_fecha_dictamen', isset($expediente->daj_fecha_dictamen) ? formato_fecha($expediente->daj_fecha_dictamen) : '');
            
            $this->data['daj_fecha_borrador_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_borrador_resolucion',
            'id'       => 'daj_fecha_borrador_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_borrador_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_borrador_resolucion', isset($expediente->daj_fecha_borrador_resolucion) ? formato_fecha($expediente->daj_fecha_borrador_resolucion) : '');

            $this->data['daj_nro_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_resolucion',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_resolucion',
            'value'    => $this->form_validation->set_value('daj_nro_resolucion', $expediente->daj_nro_resolucion),
            'class'    => 'form-control'
            );
            
            $this->data['daj_fecha_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_resolucion',
            'id'       => 'daj_fecha_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_resolucion', isset($expediente->daj_fecha_resolucion) ? formato_fecha($expediente->daj_fecha_resolucion) : '');
            
            $this->data['daj_fecha_notificacion_resolucion'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_notificacion_resolucion',
            'id'       => 'daj_fecha_notificacion_resolucion',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_notificacion_resolucion']['value'] = $this->form_validation->set_value('daj_fecha_notificacion_resolucion', isset($expediente->daj_fecha_notificacion_resolucion) ? formato_fecha($expediente->daj_fecha_notificacion_resolucion) : '');
            
            $this->data['daj_codigo_cexter'] = array(
            'type'     => 'text',
            'name'     => 'daj_codigo_cexter',
            'id'       => 'daj_codigo_cexter',
            'value'    => $this->form_validation->set_value('daj_codigo_cexter', $expediente->daj_codigo_cexter),
            'class'    => 'form-control'
            );

            $this->data['daj_contrasenha_cexter'] = array(
            'type'     => 'text',
            'name'     => 'daj_contrasenha_cexter',
            'id'       => 'daj_contrasenha_cexter',
            'value'    => $this->form_validation->set_value('daj_contrasenha_cexter', $expediente->daj_contrasenha_cexter),
            'class'    => 'form-control'
            );
            
            $this->data['daj_nro_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_decreto',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_decreto',
            'value'    => $this->form_validation->set_value('daj_nro_decreto', $expediente->daj_nro_decreto),
            'class'    => 'form-control'
            );

            $this->data['daj_nro_memo_para_decreto'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_para_decreto',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_para_decreto',
                'value'    => $this->form_validation->set_value('daj_nro_memo_para_decreto', $expediente->daj_nro_memo_para_decreto),
                'class'    => 'form-control'
            );

            $this->data['daj_fecha_memo_para_decreto'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_memo_para_decreto',
                'id'       => 'daj_fecha_memo_para_decreto',
                'class'    => 'form-control',
                );
            $this->data['daj_fecha_memo_para_decreto']['value'] = $this->form_validation->set_value('daj_fecha_memo_para_decreto', isset($expediente->daj_fecha_memo_para_decreto) ? formato_fecha($expediente->daj_fecha_memo_para_decreto) : '');
                
            
            $this->data['daj_fecha_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_decreto',
            'id'       => 'daj_fecha_decreto',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_decreto']['value'] = $this->form_validation->set_value('daj_fecha_decreto', isset($expediente->daj_fecha_decreto) ? formato_fecha($expediente->daj_fecha_decreto) : '');
            
            $this->data['daj_fecha_notificacion_decreto'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_notificacion_decreto',
            'id'       => 'daj_fecha_notificacion_decreto',
            'class'    => 'form-control',
            );
            $this->data['daj_fecha_notificacion_decreto']['value'] = $this->form_validation->set_value('daj_fecha_notificacion_decreto', isset($expediente->daj_fecha_notificacion_decreto) ? formato_fecha($expediente->daj_fecha_notificacion_decreto) : '');
            
            $this->data['daj_nro_dictamen_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_dictamen_pgr',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_dictamen_pgr',
            'value'    => $this->form_validation->set_value('daj_nro_dictamen_pgr', $expediente->daj_nro_dictamen_pgr),
            'class'    => 'form-control'
            );
            
            $this->data['daj_nro_nota_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_nro_nota_pgr',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'daj_nro_nota_pgr',
            'value'    => $this->form_validation->set_value('daj_nro_nota_pgr', $expediente->daj_nro_nota_pgr),
            'class'    => 'form-control'
            );
            
            $this->data['daj_fecha_entrega_a_pgr'] = array(
            'type'     => 'text',
            'name'     => 'daj_fecha_entrega_a_pgr',
            'id'       => 'daj_fecha_entrega_a_pgr',
            'class'    => 'form-control',
            );
            
            $this->data['daj_nro_memo_dbi_a_pgr'] = array(
                'type'     => 'text',
                'name'     => 'daj_nro_memo_dbi_a_pgr',
                'pattern'  => '^([1-9][0-9]{0,10})?$',
                'id'       => 'daj_nro_memo_dbi_a_pgr',
                'value'    => $this->form_validation->set_value('daj_nro_memo_dbi_a_pgr', $expediente->daj_nro_memo_dbi_a_pgr),
                'class'    => 'form-control'
            );
            $this->data['daj_fecha_memo_dbi_a_pgr'] = array(
                'type'     => 'text',
                'name'     => 'daj_fecha_memo_dbi_a_pgr',
                'id'       => 'daj_fecha_memo_dbi_a_pgr',
                'class'    => 'form-control',
            );
            
            $this->data['daj_fecha_entrega_a_pgr']['value'] = $this->form_validation->set_value('daj_fecha_entrega_a_pgr', isset($expediente->daj_fecha_entrega_a_pgr) ? formato_fecha($expediente->daj_fecha_entrega_a_pgr) : '');
            $this->data['daj_fecha_memo_dbi_a_pgr']['value'] = $this->form_validation->set_value('daj_fecha_memo_dbi_a_pgr', isset($expediente->daj_fecha_memo_dbi_a_pgr) ? formato_fecha($expediente->daj_fecha_memo_dbi_a_pgr) : '');
            
            if (!$operador and !$supervisor and !$coordinador) {
                $this->data['daj_nro_dictamen']['readonly'] = true;
                $this->data['daj_fecha_dictamen']['readonly'] = true;
                $this->data['daj_nro_resolucion']['readonly'] = true;
                $this->data['daj_fecha_resolucion']['readonly'] = true;
                $this->data['daj_fecha_notificacion_resolucion']['readonly'] = true;
                $this->data['daj_codigo_cexter']['readonly'] = true;
                $this->data['daj_contrasenha_cexter']['readonly'] = true;
                $this->data['daj_nro_decreto']['readonly'] = true;
                $this->data['daj_nro_memo_para_decreto']['readonly'] = true;
                $this->data['daj_fecha_memo_para_decreto']['readonly'] = true;
                $this->data['daj_fecha_decreto']['readonly'] = true;
                $this->data['daj_fecha_notificacion_decreto']['readonly'] = true;
                $this->data['daj_nro_dictamen_pgr']['readonly'] = true;
                $this->data['daj_nro_nota_pgr']['readonly'] = true;
                $this->data['daj_fecha_entrega_a_pgr']['readonly'] = true;
                $this->data['daj_nro_memo_dbi_a_pgr']['readonly'] = true;
                $this->data['daj_fecha_memo_dbi_a_pgr']['readonly'] = true;
                
            }

            $this->template->admin_render('expedientes/seg_daj2', $this->data);
    }

    public function seg_ubi($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();
        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_UBI'] = grupo_usuario(16);
        $this->data['habilitado']['op'] = grupo_usuario(32);
        $this->data['habilitado']['sup'] = grupo_usuario(33);

        $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(32);
        $supervisor = grupo_usuario(33);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }
/*
        if (isset($expediente->id_departamento_afectacion)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento_afectacion))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito_afectacion)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento_afectacion, 'distrito' => $expediente->id_distrito_afectacion))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }
*/
        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit
   
        if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['ubi_nro_nota_dbi_snc']) {
                    $arraycampos['ubi_nro_nota_dbi_snc']     = $_POST['ubi_nro_nota_dbi_snc'];
            }
            if ($_POST['ubi_fecha_nota_dbi_snc']) {
                    $arraycampos['ubi_fecha_nota_dbi_snc']   = $_POST['ubi_fecha_nota_dbi_snc'];
            }
            if ($_POST['ubi_nro_exp_snc']) {
                    $arraycampos['ubi_nro_exp_snc']      = $_POST['ubi_nro_exp_snc'];
            }
            if ($_POST['ubi_fecha_entrada_snc']) {
                $arraycampos['ubi_fecha_entrada_snc']    = $_POST['ubi_fecha_entrada_snc'];
            }
            if ($_POST['ubi_fecha_salida_snc']) {
                $arraycampos['ubi_fecha_salida_snc']     = $_POST['ubi_fecha_salida_snc'];
            } 

                if ($_POST['ctacte_afectacion']) {
                    $arraycampos['ctacte_afectacion']  = $_POST['ctacte_afectacion'];
                    if ($_POST['ctacte_afcetacion'] == '') {
                       $arraycampos['ctacte_afcetacion']   = NULL;
                    }                    
                } else {
                    if ($_POST['ctacte_afectacion'] == '') {
                       $arraycampos['ctacte_afectacion']   = NULL;
                    }
                } 

                if ($_POST['padron_afectacion']) {
                    $arraycampos['padron_afectacion']  = $_POST['padron_afectacion'];
                    if ($_POST['padron_afectacion'] == '') {
                       $arraycampos['padron_afectacion']   = NULL;
                    }                    
                } else {
                    if ($_POST['padron'] == '') {
                       $arraycampos['padron']   = NULL;
                    }
                }        

                if ($_POST['id_departamento_afectacion']) {
                    $arraycampos['id_departamento_afectacion']    = $_POST['id_departamento_afectacion'];
                }

                if ($_POST['id_distrito_afectacion']) {
                    $arraycampos['id_distrito_afectacion']    = $_POST['id_distrito_afectacion'];
                }
        
                if ($_POST['ubi_superficie_afectacion_ce']) {
                    $arraycampos['ubi_superficie_afectacion_ce']            = str_replace(",", ".", $_POST['ubi_superficie_afectacion_ce']);
                //} else {
                //    $arraycampos['ubi_superficie_afectacion'] = null;
                }        
        
            if ($_POST['observacion_avance']) {
                $observaciones['observacion_avance']['valor'] = $_POST['observacion_avance'];
                $observaciones['observacion_avance']['nombre'] = 'avance';
            }   
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_ubi/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_ubi/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
   
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['ubi_nro_nota_dbi_snc'] = array(
            'type'     => 'text',
            'name'     => 'ubi_nro_nota_dbi_snc',
            'id'       => 'ubi_nro_nota_dbi_snc',
            'value'    => $this->form_validation->set_value('ubi_nro_nota_dbi_snc', $expediente->ubi_nro_nota_dbi_snc),
            'class'    => 'form-control'
            );

            $this->data['ubi_fecha_nota_dbi_snc'] = array(
                'type'     => 'text',
                'name'     => 'ubi_fecha_nota_dbi_snc',
                'id'       => 'ubi_fecha_nota_dbi_snc',
                'class'    => 'form-control',
            );
    
            $this->data['ubi_fecha_nota_dbi_snc']['value'] = $this->form_validation->set_value('ubi_fecha_nota_dbi_snc', isset($expediente->ubi_fecha_nota_dbi_snc) ? formato_fecha($expediente->ubi_fecha_nota_dbi_snc) : '');
            
            $this->data['ubi_nro_exp_snc'] = array(
                'type'     => 'text',
                'name'     => 'ubi_nro_exp_snc',
                'id'       => 'ubi_nro_exp_snc',
                'value'    => $this->form_validation->set_value('ubi_nro_exp_snc', $expediente->ubi_nro_exp_snc),
                'class'    => 'form-control'
            );
    
            $this->data['ubi_fecha_entrada_snc'] = array(
                'type'     => 'text',
                'name'     => 'ubi_fecha_entrada_snc',
                'id'       => 'ubi_fecha_entrada_snc',
                'class'    => 'form-control',
                );
            $this->data['ubi_fecha_entrada_snc']['value'] = $this->form_validation->set_value('ubi_fecha_entrada_snc', isset($expediente->ubi_fecha_entrada_snc) ? formato_fecha($expediente->ubi_fecha_entrada_snc) : '');
            
            $this->data['ubi_fecha_salida_snc'] = array(
                'type'     => 'text',
                'name'     => 'ubi_fecha_salida_snc',
                'id'       => 'ubi_fecha_salida_snc',
                'class'    => 'form-control',
            );
    
            $this->data['ubi_fecha_salida_snc']['value'] = $this->form_validation->set_value('ubi_fecha_salida_snc', isset($expediente->ubi_fecha_salida_snc) ? formato_fecha($expediente->ubi_fecha_salida_snc) : '');
           
            $this->data['ctacte_afectacion'] = array(
            'type'     => 'text',
            'name'     => 'ctacte_afectacion',
            'placeholder' => 'xx-xxxx-xx',
            'pattern'  => '^\d{0,2}(\-\d{0,4})?(\-\d{0,2})?$',
            'id'       => 'ctacte_afectacion',
            'value'    => $this->form_validation->set_value('ctacte_afectacion', $expediente->ctacte_afectacion),
            'class'    => 'form-control',
            'maxlength'=> '255'
            );
            $this->data['padron_afectacion'] = array(
            'type'     => 'text',
            'name'     => 'padron_afectacion',
            'pattern'  => '^([1-9][0-9]{0,19})?$',
            'id'       => 'padron_afectacion',
            'value'    => $this->form_validation->set_value('padron_afectacion', $expediente->padron_afectacion),
            'class'    => 'form-control'
            );
    
            $this->data['ubi_superficie_afectacion_ce'] = array(
            'type'     => 'text',
            'name'     => 'ubi_superficie_afectacion_ce',
            'pattern'  => '^\d*(\,\d{0,4})?$',
            'id'       => 'ubi_superficie_afectacion_ce',
            'value'    => $this->form_validation->set_value('ubi_superficie_afectacion_ce', isset($expediente->ubi_superficie_afectacion_ce) ? str_replace(".",",", (float)$expediente->ubi_superficie_afectacion_ce) : null),
            'class'    => 'form-control'
            );    
    
            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $departamentos[''] = 'Seleccione el departamento';
            $departamento = $this->expedientes_model->dropdown_data('departamentos')->result_array();
            foreach ($departamento as $dep) {
                $departamentos[$dep['dpto']] = $dep['dpto'].' - '.$dep['dpto_desc'];
            }
            $this->data['departamento'] = $departamentos;
            $this->data['departamento_sel'] = $expediente->id_departamento_afectacion;

            $distritos[''] = 'Seleccione el distrito';
            $distrito = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $expediente->id_departamento_afectacion))->result_array();
            foreach ($distrito as $dist) {
                $distritos[$dist['distrito']] = $dist['distrito'].' - '.$dist['dist_desc'];
            }
            $this->data['distrito'] = $distritos;
            $this->data['distrito_sel'] = $expediente->id_distrito_afectacion;
    
            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'ubi');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
/*
            echo print_r($coordinador.'; '.$operador.'; '.$supervisor);
            show_error('TEMPORALMENTE INACTIVO');
             
            if (!$supervisor) {
                $this->data['ubi_nro_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_fecha_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_nro_exp_snc']['readonly'] = true;
                $this->data['ubi_fecha_entrada_snc']['readonly'] = true;
                $this->data['ubi_fecha_salida_snc']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
            
*/            
            $this->template->admin_render('expedientes/seg_ubi', $this->data);
    }

    public function seg_gab($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
/*         $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_UBI'] = grupo_usuario(16);
        $this->data['habilitado']['op'] = grupo_usuario(32);*/
        $this->data['habilitado']['sup'] = grupo_usuario(33); 
        $this->data['habilitado']['op'] = grupo_usuario(42);

        /* $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(32); 
        $supervisor = grupo_usuario(33);*/
        $operador = grupo_usuario(42);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit
   
        if (isset($_POST) && ! empty($_POST)) {
            if (! empty($_POST['gab_fecha_entrada'])) {
                $arraycampos['gab_fecha_entrada']     = $_POST['gab_fecha_entrada'];
            } else {
                    $arraycampos['gab_fecha_entrada']     = null;
            }
            if (! empty($_POST['gab_fecha_salida'])) {
                $arraycampos['gab_fecha_salida']     = $_POST['gab_fecha_salida'];
            } else {
                   $arraycampos['gab_fecha_salida']     = null;
            }
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            /*if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }*/
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_gab/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_gab/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
   
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['gab_fecha_entrada'] = array(
            'type'     => 'text',
            'name'     => 'gab_fecha_entrada',
            'id'       => 'gab_fecha_entrada',
            //'value'    => $this->form_validation->set_value('gab_fecha_entrada', $expediente->gab_fecha_entrada), 
            'class'    => 'form-control',
            );
            $this->data['gab_fecha_entrada']['value'] = $this->form_validation->set_value('gab_fecha_entrada', isset($expediente->gab_fecha_entrada) ? formato_fecha($expediente->gab_fecha_entrada) : '');
    
            $this->data['gab_fecha_salida'] = array(
            'type'     => 'text',
            'name'     => 'gab_fecha_salida',
            'id'       => 'gab_fecha_salida',
            //'value'    => $this->form_validation->set_value('gab_fecha_salida', $expediente->gab_fecha_salida), 
            'class'    => 'form-control',
            );
            $this->data['gab_fecha_salida']['value'] = $this->form_validation->set_value('gab_fecha_salida', isset($expediente->gab_fecha_salida) ? formato_fecha($expediente->gab_fecha_salida) : '');
    
            /*$this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'ubi');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }*/
/*
            echo print_r($coordinador.'; '.$operador.'; '.$supervisor);
            show_error('TEMPORALMENTE INACTIVO');
             
            if (!$supervisor) {
                $this->data['ubi_nro_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_fecha_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_nro_exp_snc']['readonly'] = true;
                $this->data['ubi_fecha_entrada_snc']['readonly'] = true;
                $this->data['ubi_fecha_salida_snc']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
            
*/            
            $this->template->admin_render('expedientes/seg_gab', $this->data);
    }

    public function seg_gab_desa($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
/*         $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_UBI'] = grupo_usuario(16);
        $this->data['habilitado']['op'] = grupo_usuario(32);*/
        $this->data['habilitado']['sup'] = grupo_usuario(33); 
        $this->data['habilitado']['op'] = grupo_usuario(42);

        /* $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(32); 
        $supervisor = grupo_usuario(33);*/
        $operador = grupo_usuario(42);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit
   
        if (isset($_POST) && ! empty($_POST)) {
            if (! empty($_POST['gab_fecha_entrada'])) {
                $arraycampos['gab_fecha_entrada']     = $_POST['gab_fecha_entrada'];
            } else {
                    $arraycampos['gab_fecha_entrada']     = null;
            }
            if (! empty($_POST['gab_fecha_salida'])) {
                $arraycampos['gab_fecha_salida']     = $_POST['gab_fecha_salida'];
            } else {
                   $arraycampos['gab_fecha_salida']     = null;
            }
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_gab/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_gab/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
   
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['gab_fecha_entrada'] = array(
            'type'     => 'text',
            'name'     => 'gab_fecha_entrada',
            'id'       => 'gab_fecha_entrada',
            //'value'    => $this->form_validation->set_value('gab_fecha_entrada', $expediente->gab_fecha_entrada), 
            'class'    => 'form-control',
            );
            $this->data['gab_fecha_entrada']['value'] = $this->form_validation->set_value('gab_fecha_entrada', isset($expediente->gab_fecha_entrada) ? formato_fecha($expediente->gab_fecha_entrada) : '');
    
            $this->data['gab_fecha_salida'] = array(
            'type'     => 'text',
            'name'     => 'gab_fecha_salida',
            'id'       => 'gab_fecha_salida',
            //'value'    => $this->form_validation->set_value('gab_fecha_salida', $expediente->gab_fecha_salida), 
            'class'    => 'form-control',
            );
            $this->data['gab_fecha_salida']['value'] = $this->form_validation->set_value('gab_fecha_salida', isset($expediente->gab_fecha_salida) ? formato_fecha($expediente->gab_fecha_salida) : '');
    
            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'ubi');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
/*
            echo print_r($coordinador.'; '.$operador.'; '.$supervisor);
            show_error('TEMPORALMENTE INACTIVO');
             
            if (!$supervisor) {
                $this->data['ubi_nro_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_fecha_nota_dbi_snc']['readonly'] = true;
                $this->data['ubi_nro_exp_snc']['readonly'] = true;
                $this->data['ubi_fecha_entrada_snc']['readonly'] = true;
                $this->data['ubi_fecha_salida_snc']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
            
*/            
            $this->template->admin_render('expedientes/seg_gab_desa', $this->data);
    }
    public function seg_sg_desa($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
/*         $this->data['habilitado']['coor'] = grupo_usuario(31);
        $this->data['habilitado']['coor_UBI'] = grupo_usuario(16);
        $this->data['habilitado']['op'] = grupo_usuario(32);*/
        $this->data['habilitado']['sup'] = grupo_usuario(33); 
        $this->data['habilitado']['op'] = grupo_usuario(42);

        /* $coordinador = grupo_usuario(31);
        $operador = grupo_usuario(32); 
        $supervisor = grupo_usuario(33);*/
        $operador = grupo_usuario(42);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit

        
   
        if (isset($_POST) && ! empty($_POST)) {
            if (! empty($_POST['sg_fecha_entrada_borrador_resolucion'])) {
                    $arraycampos['sg_fecha_entrada_borrador_resolucion']     = $_POST['sg_fecha_entrada_borrador_resolucion'];
            } else {
                    $arraycampos['sg_fecha_entrada_borrador_resolucion']     = null;
            }
            if (! empty($_POST['sg_fecha_remision_resolucion_dbi'])) {
                    $arraycampos['sg_fecha_remision_resolucion_dbi']     = $_POST['sg_fecha_remision_resolucion_dbi'];
            } else {
                    $arraycampos['sg_fecha_remision_resolucion_dbi']     = null;
            }
            if (! empty($_POST['sg_fecha_entrada_borrador_decreto'])) {
                    $arraycampos['sg_fecha_entrada_borrador_decreto']     = $_POST['sg_fecha_entrada_borrador_decreto'];
            } else {
                    $arraycampos['sg_fecha_entrada_borrador_decreto']     = null;
            }
            if (! empty($_POST['sg_fecha_remision_presidencia'])) {
                    $arraycampos['sg_fecha_remision_presidencia']     = $_POST['sg_fecha_remision_presidencia'];
            } else {
                    $arraycampos['sg_fecha_remision_presidencia']     = null;
            }
            if ($_POST['daj_codigo_cexter']) {
                $arraycampos['daj_codigo_cexter']                       = $_POST['daj_codigo_cexter'];
            }
            if (! empty($_POST['sg_fecha_remision_decreto_dbi'])) {
                    $arraycampos['sg_fecha_remision_decreto_dbi']     = $_POST['sg_fecha_remision_decreto_dbi'];
            } else {
                    $arraycampos['sg_fecha_remision_decreto_dbi']     = null;
            }
            if (! empty($_POST['sg_fecha_entrada_borrador_dictamen_pgr'])) {
                    $arraycampos['sg_fecha_entrada_borrador_dictamen_pgr']     = $_POST['sg_fecha_entrada_borrador_dictamen_pgr'];
            } else {
                    $arraycampos['sg_fecha_entrada_borrador_dictamen_pgr']     = null;
            }
            if (! empty($_POST['sg_fecha_remision_pgr'])) {
                    $arraycampos['sg_fecha_remision_pgr']     = $_POST['sg_fecha_remision_pgr'];
            } else {
                    $arraycampos['sg_fecha_remision_pgr']     = null;
            }
            if ($_POST['sg_nro_entrada_pgr']) {
                $arraycampos['sg_nro_entrada_pgr']                       = $_POST['sg_nro_entrada_pgr'];
            }
            if (! empty($_POST['sg_fecha_remision_orden_deposito_dbi'])) {
                    $arraycampos['sg_fecha_remision_orden_deposito_dbi']     = $_POST['sg_fecha_remision_orden_deposito_dbi'];
            } else {
                    $arraycampos['sg_fecha_remision_orden_deposito_dbi']     = null;
            }
            if (! empty($_POST['sg_fecha_entrada_borrador_protocolo'])) {
                    $arraycampos['sg_fecha_entrada_borrador_protocolo']     = $_POST['sg_fecha_entrada_borrador_protocolo'];
            } else {
                    $arraycampos['sg_fecha_entrada_borrador_protocolo']     = null;
            }
            if (! empty($_POST['sg_fecha_entrega_escribano'])) {
                    $arraycampos['sg_fecha_entrega_escribano']     = $_POST['sg_fecha_entrega_escribano'];
            } else {
                    $arraycampos['sg_fecha_entrega_escribano']     = null;
            }
            $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_sg_desa/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_sg_desa/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
   
            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );
            
            $this->data['sg_fecha_entrada_borrador_resolucion'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_entrada_borrador_resolucion',
                'id'       => 'sg_fecha_entrada_borrador_resolucion',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_entrada_borrador_resolucion']['value'] = $this->form_validation->set_value('sg_fecha_entrada_borrador_resolucion', isset($expediente->sg_fecha_entrada_borrador_resolucion) ? formato_fecha($expediente->sg_fecha_entrada_borrador_resolucion) : '');
            
            $this->data['sg_fecha_remision_resolucion_dbi'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_remision_resolucion_dbi',
                'id'       => 'sg_fecha_remision_resolucion_dbi',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_remision_resolucion_dbi']['value'] = $this->form_validation->set_value('sg_fecha_remision_resolucion_dbi', isset($expediente->sg_fecha_remision_resolucion_dbi) ? formato_fecha($expediente->sg_fecha_remision_resolucion_dbi) : '');
            $this->data['sg_fecha_entrada_borrador_decreto'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_entrada_borrador_decreto',
                'id'       => 'sg_fecha_entrada_borrador_decreto',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_entrada_borrador_decreto']['value'] = $this->form_validation->set_value('sg_fecha_entrada_borrador_decreto', isset($expediente->sg_fecha_entrada_borrador_decreto) ? formato_fecha($expediente->sg_fecha_entrada_borrador_decreto) : '');
            $this->data['sg_fecha_remision_presidencia'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_remision_presidencia',
                'id'       => 'sg_fecha_remision_presidencia',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_remision_presidencia']['value'] = $this->form_validation->set_value('sg_fecha_remision_presidencia', isset($expediente->sg_fecha_remision_presidencia) ? formato_fecha($expediente->sg_fecha_remision_presidencia) : '');
            $this->data['daj_codigo_cexter'] = array(
                'type'     => 'text',
                'name'     => 'daj_codigo_cexter',
                'id'       => 'daj_codigo_cexter',
                'value'    => $this->form_validation->set_value('daj_codigo_cexter', $expediente->daj_codigo_cexter),
                'class'    => 'form-control'
            );
            $this->data['sg_fecha_remision_decreto_dbi'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_remision_decreto_dbi',
                'id'       => 'sg_fecha_remision_decreto_dbi',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_remision_decreto_dbi']['value'] = $this->form_validation->set_value('sg_fecha_remision_decreto_dbi', isset($expediente->sg_fecha_remision_decreto_dbi) ? formato_fecha($expediente->sg_fecha_remision_decreto_dbi) : '');
            $this->data['sg_fecha_entrada_borrador_dictamen_pgr'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_entrada_borrador_dictamen_pgr',
                'id'       => 'sg_fecha_entrada_borrador_dictamen_pgr',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_entrada_borrador_dictamen_pgr']['value'] = $this->form_validation->set_value('sg_fecha_entrada_borrador_dictamen_pgr', isset($expediente->sg_fecha_entrada_borrador_dictamen_pgr) ? formato_fecha($expediente->sg_fecha_entrada_borrador_dictamen_pgr) : '');
            $this->data['sg_fecha_remision_pgr'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_remision_pgr',
                'id'       => 'sg_fecha_remision_pgr',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_remision_pgr']['value'] = $this->form_validation->set_value('sg_fecha_remision_pgr', isset($expediente->sg_fecha_remision_pgr) ? formato_fecha($expediente->sg_fecha_remision_pgr) : '');
            $this->data['sg_nro_entrada_pgr'] = array(
                'type'     => 'text',
                'name'     => 'sg_nro_entrada_pgr',
                'id'       => 'sg_nro_entrada_pgr',
                'value'    => $this->form_validation->set_value('sg_nro_entrada_pgr', $expediente->sg_nro_entrada_pgr),
                'class'    => 'form-control'
            );
            $this->data['sg_fecha_remision_orden_deposito_dbi'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_remision_orden_deposito_dbi',
                'id'       => 'sg_fecha_remision_orden_deposito_dbi',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_remision_orden_deposito_dbi']['value'] = $this->form_validation->set_value('sg_fecha_remision_orden_deposito_dbi', isset($expediente->sg_fecha_remision_orden_deposito_dbi) ? formato_fecha($expediente->sg_fecha_remision_orden_deposito_dbi) : '');
           $this->data['sg_fecha_entrada_borrador_protocolo'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_entrada_borrador_protocolo',
                'id'       => 'sg_fecha_entrada_borrador_protocolo',
                'class'    => 'form-control',
                ); 
    
            $this->data['sg_fecha_entrada_borrador_protocolo']['value'] = $this->form_validation->set_value('sg_fecha_entrada_borrador_protocolo', isset($expediente->sg_fecha_entrada_borrador_protocolo) ? formato_fecha($expediente->sg_fecha_entrada_borrador_protocolo) : '');
            $this->data['sg_fecha_entrega_escribano'] = array(
                'type'     => 'text',
                'name'     => 'sg_fecha_entrega_escribano',
                'id'       => 'sg_fecha_entrega_escribano',
                'class'    => 'form-control', 
                );  
    
            $this->data['sg_fecha_entrega_escribano']['value'] = $this->form_validation->set_value('sg_fecha_entrega_escribano', isset($expediente->sg_fecha_entrega_escribano) ? formato_fecha($expediente->sg_fecha_entrega_escribano) : '');
          
            
            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            //$observaciones = $this->expedientes_model->observacion_area($expe_id, 'ubi');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
            $this->template->admin_render('expedientes/seg_sg_desa', $this->data);
    }
    

    public function seg_financiero($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(5);

        $operador = grupo_usuario(5);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
        
            if (! empty($_POST['seg_fecha_inicio_tramite'])) {
                    $arraycampos['seg_fecha_inicio_tramite']     = $_POST['seg_fecha_inicio_tramite'];
            } else {
            		$arraycampos['seg_fecha_inicio_tramite']     = null;
            }

            if (! empty($_POST['seg_certificado_pago'])) {
                    $arraycampos['seg_certificado_pago']     = $_POST['seg_certificado_pago'];
            } else {
            		$arraycampos['seg_certificado_pago']     = null;
            }

            if (! empty($_POST['seg_fecha_pagado'])) {
                    $arraycampos['seg_fecha_pagado']     = $_POST['seg_fecha_pagado'];
            } else {
            		$arraycampos['seg_fecha_pagado']     = null;
            }
            
            if (! empty($_POST['finan_devuelto_cta_origen'])) {
                $arraycampos['finan_devuelto_cta_origen'] = $_POST['finan_devuelto_cta_origen'];
        
            }             
            
            if (! empty($_POST['finan_fecha_devuelto_cta_origen'])) {
                    $arraycampos['finan_fecha_devuelto_cta_origen']     = $_POST['finan_fecha_devuelto_cta_origen'];
            } else {
                    $arraycampos['finan_fecha_devuelto_cta_origen']     = null;
            }
            
            if ($_POST['observacion_avance']) {
                $observaciones['observacion_avance']['valor'] = $_POST['observacion_avance'];
                $observaciones['observacion_avance']['nombre'] = 'avance';
            }


                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_financiero/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_financiero/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['seg_fecha_inicio_tramite'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_inicio_tramite',
            'id'       => 'seg_fecha_inicio_tramite',
            //'value'    => $this->form_validation->set_value('seg_fecha_inicio_tramite', $expediente->seg_fecha_inicio_tramite), 
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_inicio_tramite']['value'] = $this->form_validation->set_value('seg_fecha_inicio_tramite', isset($expediente->seg_fecha_inicio_tramite) ? formato_fecha($expediente->seg_fecha_inicio_tramite) : '');
            

            $this->data['seg_certificado_pago'] = array(
            'type'     => 'text',
            'name'     => 'seg_certificado_pago',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'seg_certificado_pago',
            'value'    => $this->form_validation->set_value('seg_certificado_pago', $expediente->seg_certificado_pago),
            'class'    => 'form-control'
            );
            

            $this->data['seg_fecha_pagado'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_pagado',
            'id'       => 'seg_fecha_pagado',
            //'value'    => $this->form_validation->set_value('seg_fecha_pagado', $expediente->seg_fecha_pagado),     
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_pagado']['value'] = $this->form_validation->set_value('seg_fecha_pagado', isset($expediente->seg_fecha_pagado) ? formato_fecha($expediente->seg_fecha_pagado) : '');
            
            $this->data['finan_fecha_devuelto_cta_origen'] = array(
                'type'     => 'text',
                'name'     => 'finan_fecha_devuelto_cta_origen',
                'id'       => 'finan_fecha_devuelto_cta_origen',
                'class'    => 'form-control',
                ); 
    
            $this->data['finan_fecha_devuelto_cta_origen']['value'] = $this->form_validation->set_value('finan_fecha_devuelto_cta_origen', isset($expediente->finan_fecha_devuelto_cta_origen) ? formato_fecha($expediente->finan_fecha_devuelto_cta_origen) : '');
                
            $this->data['finan_devuelto_cta_origen'] = array(
                'type'     => 'radio',
                'name'     => 'finan_devuelto_cta_origen',
                'id'       => 'finan_devuelto_cta_origen',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
            	'value'    => $this->form_validation->set_value('finan_devuelto_cta_origen', $expediente->finan_devuelto_cta_origen),
                'class'    => 'form-control'
            );
                  
                            /*
                        echo '<pre>';
                        print_r($this->data['finan_devuelto_cta_origen']['value'] );
                        echo '</pre>';
                        show_error(1);
                       */
    
    		if ($this->data['finan_devuelto_cta_origen']['value'] == 'SI') {
                $this->data['finan_devuelto_cta_origen']['checked_n'] = false;
                $this->data['finan_devuelto_cta_origen']['checked_s'] = true;
            } else {
                $this->data['finan_devuelto_cta_origen']['checked_n'] = true;
                $this->data['finan_devuelto_cta_origen']['checked_s'] = false;                
            }

            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'fin');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
            
            if (!$operador) {
                $this->data['seg_fecha_inicio_tramite']['readonly'] = true;
                $this->data['seg_certificado_pago']['readonly'] = true;
                $this->data['seg_fecha_pagado']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
            
            
            $this->template->admin_render('expedientes/seg_financiero', $this->data);
    }

	public function ver_exp_obs($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(5);

        $operador = grupo_usuario(5);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
                
        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
            if ($_POST['seg_fecha_inicio_tramite']) {
                    $arraycampos['seg_fecha_inicio_tramite']     = $_POST['seg_fecha_inicio_tramite'];
            }

            if ($_POST['seg_certificado_pago']) {
                    $arraycampos['seg_certificado_pago']     = $_POST['seg_certificado_pago'];
            }

            if ($_POST['seg_fecha_pagado']) {
                    $arraycampos['seg_fecha_pagado']     = $_POST['seg_fecha_pagado'];
            }

            if ($_POST['observacion_avance']) {
                $observaciones['observacion_avance']['valor'] = $_POST['observacion_avance'];
                $observaciones['observacion_avance']['nombre'] = 'avance';
            }
                      
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                //$actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                //$guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/ver_exp_obs/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/ver_exp_obs/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['seg_fecha_inicio_tramite'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_inicio_tramite',
            'id'       => 'seg_fecha_inicio_tramite',
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_inicio_tramite']['value'] = $this->form_validation->set_value('seg_fecha_inicio_tramite', isset($expediente->seg_fecha_inicio_tramite) ? formato_fecha($expediente->seg_fecha_inicio_tramite) : '');
            

            $this->data['seg_certificado_pago'] = array(
            'type'     => 'text',
            'name'     => 'seg_certificado_pago',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'seg_certificado_pago',
            'value'    => $this->form_validation->set_value('seg_certificado_pago', $expediente->seg_certificado_pago),
            'class'    => 'form-control'
            );
            

            $this->data['seg_fecha_pagado'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_pagado',
            'id'       => 'seg_fecha_pagado',
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_pagado']['value'] = $this->form_validation->set_value('seg_fecha_pagado', isset($expediente->seg_fecha_pagado) ? formato_fecha($expediente->seg_fecha_pagado) : '');
            

            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'fin');
    		$observaciones_fin = $this->expedientes_model->observacion_area($expe_id, 'fin');
    		$observaciones_gen = $this->expedientes_model->observacion_area($expe_id, 'gen');
    		$observaciones_ubi = $this->expedientes_model->observacion_area($expe_id, 'ubi');
    		$observaciones_dao = $this->expedientes_model->observacion_area($expe_id, 'dao');
    		$observaciones_daj = $this->expedientes_model->observacion_area($expe_id, 'daj');
    

            if (!empty($observaciones_fin)) {
                $this->data['tiene_observaciones_fin'] = true;
            } else {
                $this->data['tiene_observaciones_fin'] = false;
            }
    
            if (!empty($observaciones_gen)) {
                $this->data['tiene_observaciones_gen'] = true;
            } else {
                $this->data['tiene_observaciones_gen'] = false;
            }
            if (!empty($observaciones_ubi)) {
                $this->data['tiene_observaciones_ubi'] = true;
            } else {
                $this->data['tiene_observaciones_ubi'] = false;
            }
            if (!empty($observaciones_dao)) {
                $this->data['tiene_observaciones_dao'] = true;
            } else {
                $this->data['tiene_observaciones_dao'] = false;
            }
            if (!empty($observaciones_daj)) {
                $this->data['tiene_observaciones_daj'] = true;
            } else {
                $this->data['tiene_observaciones_daj'] = false;
            }
            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }    
            
    /*
            if (!$operador) {
                $this->data['seg_fecha_inicio_tramite']['readonly'] = true;
                $this->data['seg_certificado_pago']['readonly'] = true;
                $this->data['seg_fecha_pagado']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
    */        
            
            $this->template->admin_render('expedientes/ver_exp_obs', $this->data);
    }

    public function seg_financiero2($expe_id)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin() or ! $expe_id or empty($expe_id)) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes_edit'), 'expedientes/edit');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();


        
        /* Variables *///Trae de la base de datos la fila seleccionada  Generate view
        $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

        $this->data['id'] = $expe_id;
        $this->data['habilitado']['sis'] = grupo_usuario(3);
        $this->data['habilitado']['op'] = grupo_usuario(5);

        $operador = grupo_usuario(5);
        
        if (isset($expediente->id_proyecto)) {
            $proyecto = $this->db->get_where('proyectos', array('id_proyecto' => $expediente->id_proyecto))->row();
            $this->data['descripcion']['proyecto'] = $proyecto->descripcion;
        }

        if (isset($expediente->id_tramo)) {
            $tramo = $this->db->get_where('tramos', array('id_tramo' => $expediente->id_tramo))->row();
            $this->data['descripcion']['tramo'] = $tramo->nombre;
        }

        if (isset($expediente->id_departamento)) {
            $departamento = $this->db->get_where('ide.dpto', array('dpto' => $expediente->id_departamento))->row();
            if (isset($departamento)) {
                $this->data['descripcion']['departamento'] = $departamento->dpto_desc;
            } else {
                $this->data['descripcion']['departamento'] = ' ';
            }
        }

        if (isset($expediente->id_distrito)) {
            $distrito = $this->db->get_where('ide.distritos', array('dpto' => $expediente->id_departamento, 'distrito' => $expediente->id_distrito))->row();
            if (isset($distrito)) {
                $this->data['descripcion']['distrito'] = $distrito->dist_desc;
            } else {
                $this->data['descripcion']['distrito'] = ' ';
            }
        }

        if (isset($expediente->id_tipo_afectacion)) {
            $afeccion = $this->db->get_where('tipos_afeccion', array('id_tipo_afeccion' => $expediente->id_tipo_afectacion))->row();
            $this->data['descripcion']['afeccion'] = $afeccion->nombre;
        }

        if (isset($expediente->id_condicion_dominio)) {
            $dominio = $this->db->get_where('tipos_ocupacion', array('id_tipo_ocupacion' => $expediente->id_condicion_dominio))->row();
            $this->data['descripcion']['dominio'] = $dominio->nombre;
        }

        $this->data['expediente']  = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->result();
    
    
                     /*       
                        echo '<pre>';
                        print_r($this->data['expediente']);
                        echo '</pre>';
                        show_error(1);
                       */ 
                
        //Se produce cuando el usuario da click en el submit
        if (isset($_POST) && ! empty($_POST)) {
        
            if (! empty($_POST['seg_fecha_inicio_tramite'])) {
                    $arraycampos['seg_fecha_inicio_tramite']     = $_POST['seg_fecha_inicio_tramite'];
            } else {
            		$arraycampos['seg_fecha_inicio_tramite']     = null;
            }


            if ($_POST['seg_certificado_pago']) {
                    $arraycampos['seg_certificado_pago']     = $_POST['seg_certificado_pago'];
            }

            if ($_POST['seg_fecha_pagado']) {
                    $arraycampos['seg_fecha_pagado']     = $_POST['seg_fecha_pagado'];
            }
                       
        
            if (! empty($_POST['finan_devuelto_cta_origen'])) {
                    $arraycampos['finan_devuelto_cta_origen'] = $_POST['finan_devuelto_cta_origen'];
            
            }             
            
            if (! empty($_POST['finan_fecha_devuelto_cta_origen'])) {
                    $arraycampos['finan_fecha_devuelto_cta_origen']     = $_POST['finan_fecha_devuelto_cta_origen'];
            } else {
            		$arraycampos['finan_fecha_devuelto_cta_origen']     = null;
            }
        

            if ($_POST['observacion_avance']) {
                $observaciones['observacion_avance']['valor'] = $_POST['observacion_avance'];
                $observaciones['observacion_avance']['nombre'] = 'avance';
            }
                      
                $accion = 0;
            if (isset($_POST['accion'])) {
                $accion = intval($_POST['accion']);
            } else {
                $accion = 0;
            }
    
            if (isset($arraycampos)) {
                $actualizar_expediente = $this->expedientes_model->actualizar_expediente($expe_id, $arraycampos);
            }
                
            if (isset($observaciones)) {
                $guardar_observacion = $this->expedientes_model->guardar_observacion($expe_id, $observaciones, 'fin');
            }
                
                //if ($resul)
            if ($actualizar_expediente || $guardar_observacion) {
                //una prueba de que trae los valores es reemplazando $this->lang->line('edit_geocolonia_saved') por $_POST('id') por ejemplo
                $this->session->set_flashdata('message', $this->lang->line('expedientes_update_successful'));
                redirect('expedientes/expedientes/seg_financiero2/'.$expe_id);
            } else {
                $this->session->set_flashdata('message', $this->ion_auth->errors());
                redirect('expedientes/expedientes/seg_financiero2/'.$expe_id);
            }

                //aquí se designa a que pantalla irá al finalizar independientemente de que el proceso de actualización haya sido satisfactorio
                //redirect('man_espacial/geocolonias/geocolonias', 'refresh');
        }
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->codigo.'_'.$expediente->des_codigo_proyecto
            );

            $this->data['seg_fecha_inicio_tramite'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_inicio_tramite',
            'id'       => 'seg_fecha_inicio_tramite',
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_inicio_tramite']['value'] = $this->form_validation->set_value('seg_fecha_inicio_tramite', isset($expediente->seg_fecha_inicio_tramite) ? formato_fecha($expediente->seg_fecha_inicio_tramite) : '');
            

            $this->data['seg_certificado_pago'] = array(
            'type'     => 'text',
            'name'     => 'seg_certificado_pago',
            'pattern'  => '^([1-9][0-9]{0,10})?$',
            'id'       => 'seg_certificado_pago',
            'value'    => $this->form_validation->set_value('seg_certificado_pago', $expediente->seg_certificado_pago),
            'class'    => 'form-control'
            );
            

            $this->data['seg_fecha_pagado'] = array(
            'type'     => 'text',
            'name'     => 'seg_fecha_pagado',
            'id'       => 'seg_fecha_pagado',
            'class'    => 'form-control',
            );
            $this->data['seg_fecha_pagado']['value'] = $this->form_validation->set_value('seg_fecha_pagado', isset($expediente->seg_fecha_pagado) ? formato_fecha($expediente->seg_fecha_pagado) : '');
            
        
            $this->data['finan_fecha_devuelto_cta_origen'] = array(
                'type'     => 'text',
                'name'     => 'finan_fecha_devuelto_cta_origen',
                'id'       => 'finan_fecha_devuelto_cta_origen',
                'class'    => 'form-control',
                ); 
    
            $this->data['finan_fecha_devuelto_cta_origen']['value'] = $this->form_validation->set_value('finan_fecha_devuelto_cta_origen', isset($expediente->finan_fecha_devuelto_cta_origen) ? formato_fecha($expediente->finan_fecha_devuelto_cta_origen) : '');
                
            $this->data['finan_devuelto_cta_origen'] = array(
                'type'     => 'radio',
                'name'     => 'finan_devuelto_cta_origen',
                'id'       => 'finan_devuelto_cta_origen',
                'value_s'  => 'SI',
                'value_n'  => 'NO',
            	'value'    => $this->form_validation->set_value('finan_devuelto_cta_origen', $expediente->finan_devuelto_cta_origen),
                'class'    => 'form-control'
            );
                  
                            /*
                        echo '<pre>';
                        print_r($this->data['finan_devuelto_cta_origen']['value'] );
                        echo '</pre>';
                        show_error(1);
                       */
    
    		if ($this->data['finan_devuelto_cta_origen']['value'] == 'SI') {
                $this->data['finan_devuelto_cta_origen']['checked_n'] = false;
                $this->data['finan_devuelto_cta_origen']['checked_s'] = true;
            } else {
                $this->data['finan_devuelto_cta_origen']['checked_n'] = true;
                $this->data['finan_devuelto_cta_origen']['checked_s'] = false;                
            }

            $this->data['observacion_avance'] = array(
            'type'     => 'text',
            'name'     => 'observacion_avance',
            'id'       => 'observacion_avance',
            'value'    => $this->form_validation->set_value('observacion_avance'),
            'class'    => 'form-control textarea'
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, 'fin');

            if (!empty($observaciones)) {
                $this->data['tiene_observaciones'] = true;
            } else {
                $this->data['tiene_observaciones'] = false;
            }
            
            if (!$operador) {
                $this->data['seg_fecha_inicio_tramite']['readonly'] = true;
                $this->data['seg_certificado_pago']['readonly'] = true;
                $this->data['seg_fecha_pagado']['readonly'] = true;
                $this->data['observacion_avance']['readonly'] = true;
            }
            
            
            $this->template->admin_render('expedientes/seg_financiero2', $this->data);
    }

    public function ver_observacion($expe_id, $area = null)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['area'] = array(
                'type'     => 'hidden',
                'name'     => 'area',
                'id'       => 'area',
                'value'    => $area
            );
            $this->data['id'] = $expe_id;

            $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
            $this->data['expediente']  = $expediente;

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->des_codigo_unico
            );

            $nombre_usuario;
            switch ($area) {
                case 'ubi':
                    $nombre_usuario = $expediente->ubi_supervisor;
                    break;
                case 'dao':
                    $nombre_usuario = $expediente->dao_supervisor;
                    break;
                case 'daj':
                    $nombre_usuario = $expediente->daj_supervisor;
                    break;
                default:
                    $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                    $nombre_usuario = $usuario->first_name.' '.$usuario->last_name;
                    break;
            }

            $nombre_area='N';
            if ($area == 'ubi') {
                    $nombre_area='BIENES INMOBILIARIOS';
            } else {
              if ($area == 'dao') {
                    $nombre_area='AVALÚO';
              } else {
                 if ($area == 'daj') {
                    $nombre_area='JURÍDICA';
                 } else {
                    $nombre_area='N';
                 }
              }
            }
        	
        	$this->data['nombre_area'] = $nombre_area;
            $this->data['usuario'] = $nombre_usuario;
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            if (isset($_POST) && ! empty($_POST)) {
                $observaciones = $this->expedientes_model->observacion_area($expe_id, $area, $_POST['rangoFecha']);
                if (empty($observaciones)) {
                    $this->session->set_flashdata('message', 'NO EXISTEN OBSERVACIONES EN EL RANGO DE FECHA SELECCIONADO');
                    redirect('expedientes/expedientes/ver_observacion/'.$expe_id.'/'.$area);
                }
            } else {
                $observaciones = $this->expedientes_model->observacion_area($expe_id, $area);
            }

            $this->data['observaciones'] = $observaciones;


            $ul = count($observaciones) - 1;


            $this->data['fecha_inicio'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_inicio',
                'value'    => formato_fecha($observaciones[0]['fecha'])
            );

            $this->data['fecha_fin'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_fin',
                'value'    => formato_fecha($observaciones[$ul]['fecha'])
            );

            $this->data['rangoFecha'] = array(
                'type'     => 'text',
                'id'       => 'rangoFecha',
                'name'       => 'rangoFecha',
                'class'    => 'form-control pull-right',
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, $area);
        
            $ul = count($observaciones) - 1;


            $this->data['fecha_min'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_min',
                'value'    => formato_fecha($observaciones[0]['fecha'])
            );

            $this->data['fecha_max'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_max',
                'value'    => formato_fecha($observaciones[$ul]['fecha'])
            );

            /* Load Template */
            $this->template->admin_render('expedientes/ver_observacion', $this->data);
        }
    }

public function ver_exp_obs_detalle($expe_id, $area = null)
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth/login', 'refresh');
        } else {
            /* Breadcrumbs */
            $this->breadcrumbs->unshift(2, 'Información Expediente', 'admin/groups/profile');
            $this->data['breadcrumb'] = $this->breadcrumbs->show();

            $this->data['area'] = array(
                'type'     => 'hidden',
                'name'     => 'area',
                'id'       => 'area',
                'value'    => $area
            );
            $this->data['id'] = $expe_id;

            $expediente = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();
            $this->data['expediente']  = $expediente;

            $this->data['codigo_unico'] = array(
                'type'     => 'hidden',
                'name'     => 'codigo_unico',
                'id'       => 'codigo_unico',
                'value'    => $expediente->des_codigo_unico
            );

            $nombre_usuario;
            switch ($area) {
                case 'ubi':
                    $nombre_usuario = $expediente->ubi_supervisor;
                    break;
                case 'dao':
                    $nombre_usuario = $expediente->dao_supervisor;
                    break;
                case 'daj':
                    $nombre_usuario = $expediente->daj_supervisor;
                    break;
                default:
                    $usuario = $this->expedientes_model->view('users', array('id' => $_SESSION['user_id']))->row();
                    $nombre_usuario = $usuario->first_name.' '.$usuario->last_name;
                    break;
            }

            $nombre_area='N';
            if ($area == 'ubi') {
                    $nombre_area='BIENES INMOBILIARIOS';
            } else {
              if ($area == 'dao') {
                    $nombre_area='AVALÚO';
              } else {
                 if ($area == 'daj') {
                    $nombre_area='JURÍDICA';
                 } else {
                    $nombre_area='N';
                 }
              }
            }
        	
        	$this->data['nombre_area'] = $nombre_area;
            $this->data['usuario'] = $nombre_usuario;
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            if (isset($_POST) && ! empty($_POST)) {
                $observaciones = $this->expedientes_model->observacion_area($expe_id, $area, $_POST['rangoFecha']);
                if (empty($observaciones)) {
                    $this->session->set_flashdata('message', 'NO EXISTEN OBSERVACIONES EN EL RANGO DE FECHA SELECCIONADO');
                    redirect('expedientes/expedientes/ver_observacion/'.$expe_id.'/'.$area);
                }
            } else {
                $observaciones = $this->expedientes_model->observacion_area($expe_id, $area);
            }

            $this->data['observaciones'] = $observaciones;


            $ul = count($observaciones) - 1;


            $this->data['fecha_inicio'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_inicio',
                'value'    => formato_fecha($observaciones[0]['fecha'])
            );

            $this->data['fecha_fin'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_fin',
                'value'    => formato_fecha($observaciones[$ul]['fecha'])
            );

            $this->data['rangoFecha'] = array(
                'type'     => 'text',
                'id'       => 'rangoFecha',
                'name'       => 'rangoFecha',
                'class'    => 'form-control pull-right',
            );

            $observaciones = $this->expedientes_model->observacion_area($expe_id, $area);
        
            $ul = count($observaciones) - 1;


            $this->data['fecha_min'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_min',
                'value'    => formato_fecha($observaciones[0]['fecha'])
            );

            $this->data['fecha_max'] = array(
                'type'     => 'hidden',
                'id'       => 'fecha_max',
                'value'    => formato_fecha($observaciones[$ul]['fecha'])
            );

            /* Load Template */
            $this->template->admin_render('expedientes/ver_exp_obs_detalle', $this->data);
        }
    }

    public function tiene_salida()
    {
        $expe_id = $_POST['expe_id'];

        $expe = $this->expedientes_model->view('exp', array('expe_id' => $expe_id, 'expe_estado' => 'P'))->row();

        if ($expe) {
            echo 'SI';
        } else {
            echo 'NO';
        }
    }

    public function existe_grafico()
    {
        $id_expediente  = $_POST['id_expediente'];
        $gestion        = $_POST['gestion'];

        $expe = $this->expedientes_model->existe_grafico($id_expediente, $gestion)->row()->f_existe_grafico;

        echo $expe;
    }

    public function existe_grafico_expe_id()
    {
        $expe_id    = $_POST['expe_id'];

        $expe = $this->expedientes_model->existe_grafico_expe_id($expe_id)->row()->resul_id;

        echo $expe;
    }

    public function existe_exp()
    {
        $exp        = $_POST['exp'];
        $gestion    = $_POST['gest'];

        $expe = $this->expedientes_model->dropdown_data('exp', array('expe_id_expediente' => $exp, 'expe_gestion' => $gestion))->num_rows();

        if ($expe > 0) {
            echo 'SI';
        } else {
            echo 'NO';
        }
    }

    public function existe_exp_uk()
    {
        $exp        = $_POST['exp'];
        $gestion    = $_POST['gest'];
        $dep    = $_POST['dep'];

        $expe = $this->expedientes_model->dropdown_data('exp', array('expe_id_expediente' => $exp,
                                                                      'expe_gestion' => $gestion,
                                                                      'expe_id_dependencia' => $dep
                                                                      ))->num_rows();

        if ($expe > 0) {
            echo 'SI';
        } else {
            echo 'NO';
        }
    }

    public function reingreso_exp()
    {
        $exp    = $_POST['exp'];
        $gest   = $_POST['gest'];

        $expe_id = $this->expedientes_model->dropdown_data('exp', array('expe_id_expediente' => $exp, 'expe_gestion' => $gest))->row()->expe_id;

        echo $expe_id;

        //$reingreso  = $this->expedientes_model->actualizar_expediente($expe_id, array('expe_id_expediente_ref' => $exp, 'expe_id' => ));


        //redirect('expedientes/expedientes/edit_expe/'.$expe_id);
    }

    public function dar_salida_expe($expe_id, $expe_id_expediente, $expe_gestion, $expe_provdg = null)
    {

        $i_exp      = $expe_id_expediente;
        $i_gest     = $expe_gestion;


                    $i_user = $this->session->userdata('username');
                    //echo $i_user;
                    //show_error(1);



        if (!is_null($i_exp) and $i_gest > 0) {
            if (grupo_usuario(18)) {
                //if ($expe_provdg == NULL) {
                if (is_null($expe_provdg)) {
                    $provdg = 0;
                } else {
                    $provdg = $expe_provdg;
                }

                if ($provdg == 0) {
                    $i_max = $this->expedientes_model->campo_valor_maximo('exp', 'expe_provdg', array('expe_director' => $i_user ));

                    $i_max = $i_max+1;

                    $str    = date_default_timezone_get();
                    $fecha  = date("d/m/Y", strtotime($str));

                    $salida = $this->expedientes_model->actualizar_expediente($expe_id, array('expe_provdg'   => $i_max,
                                                                                              'expe_director' => $this->session->userdata('username'),
                                                                                              'expe_salida'   => $fecha,
                                                                                              'expe_estado'   => 'P'));
                    if ($salida) {
                        $this->session->set_flashdata('message', '¡Se DIÓ SALIDA exitosamente!');
                        redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                    } else {
                        $this->session->set_flashdata('message', '¡No se pudo DAR SALIDA!');
                        redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                    }
                } else {
                    $this->session->set_flashdata('message', '¡Campo PROV. DG sin dato!');
                    redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                }
            } else {
                $this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
                redirect('expedientes/expedientes/edit_expe/'.$expe_id);
            }
        } else {
            redirect('expedientes/expedientes/edit_expe/'.$expe_id);
        }
    }

    public function anular_salida_expe($expe_id)
    {

        //echo($expe_id);
        $expe = $this->expedientes_model->dropdown_data('exp', array('expe_id' => $expe_id))->result();


        //echo '<option value="">Seleccione el distrito</option>';

        foreach ($expe as $value) {
            $i_exp       = $value->expe_id_expediente;
            $i_gest      = $value->expe_gestion;
            $i_provdg = $value->expe_provdg;
        }

        if (!is_null($i_exp) and $i_gest > 0) {
            if (grupo_usuario(18)) {
                if ($i_provdg == null) {
                    $provdg = 0;
                } else {
                    $provdg = $i_provdg;
                }

                if ($provdg != 0) {
                    $salida = $this->expedientes_model->actualizar_expediente($expe_id, array('expe_provdg'   => null,
                                                                                              'expe_director' => '',
                                                                                              'expe_salida'   => null,
                                                                                              'expe_estado'   => 'A'));
                    if ($salida) {
                        $this->session->set_flashdata('message', '¡Se ANULÓ LA SALIDA exitosamente!');
                        redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                    } else {
                        $this->session->set_flashdata('message', '¡No se pudo ANULAR SALIDA!');
                        //redirect('expedientes/expedientes/edit_expe/'.$expe_id);
                        redirect('expedientes/expedientes/index/');
                    }
                }
            } else {
                $this->session->set_flashdata('message', 'NO TIENE PRIVILEGIOS PARA ESTA ACCIÓN');
                //redirect('expedientes/expedientes/index/'.$expe_id);
                redirect('expedientes/expedientes/index/');
            }
        } else {
            //redirect('expedientes/expedientes/index/'.$expe_id);
            redirect('expedientes/expedientes/index/');
        }
    }

    public function call_bat()
    {
        $cmd = system('cmd /c C:/espacio_trabajo/importar_shape_ide.bat');
    }

    public function form_expediente()
    {
        if (! $this->ion_auth->logged_in() or ! $this->ion_auth->is_admin()) {
            redirect('auth', 'refresh');
        }

        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_expedientes'), 'geocolonias/create');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Validate form input */
        $this->form_validation->set_rules('col_cod', 'lang:geocolonia_col_cod', 'required');
        $this->form_validation->set_rules('col_desc', 'lang:geocolonia_col_desc', 'required');

        if ($this->form_validation->run() == true) {
            $arraycampos = array('dpto_cod'     => $_POST['dpto_cod'],
                                 'dist_cod'     => $_POST['dist_cod'],
                                 'id_codgeo'    => $_POST['id_codgeo'],
                                 'col_cod'      => $_POST['col_cod'],
                                 'col_desc'     => strtoupper($_POST['col_desc']),
                                );

            $new_geocolonia_id = $this->geocolonias_model->create_geocolonia($arraycampos);
            if ($new_geocolonia_id) {
                $this->session->set_flashdata('message', $this->ion_auth->messages());

                redirect('man_espacial/geocolonias/geocolonias');
            }
        } else {
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

            $this->data['dpto_cod'] = array(
                'name'  => 'dpto_cod',
                'id'    => 'dpto_cod',
                'type'  => 'text',
                'class' => 'form-control',
                //'value' => $this->form_validation->set_value('dpto_cod')
                );
            $this->data['dist_cod'] = array(
                'name'  => 'dist_cod',
                'id'    => 'dist_cod',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('dist_cod')
                );
            $this->data['col_cod'] = array(
                'name'  => 'col_cod',
                'id'    => 'col_cod',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('col_cod')
                );
            $this->data['id_codgeo'] = array(
                'name'  => 'id_codgeo',
                'id'    => 'id_codgeo',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('id_codgeo'),
                'readonly' => true,
                );
            $this->data['col_desc'] = array(
                'name'  => 'col_desc',
                'id'    => 'col_desc',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('col_desc')
                );

            $dptos[''] = 'Seleccione el departamento';
            $departamentos = $this->expedientes_model->dropdown_data('departamentos', '', 'dpto_id_departamento')->result_array();
            //inserta en un array asociativo para poder utilizarlo en el form_dropdown
            foreach ($departamentos as $dpto) {
                $dptos[$dpto['dpto_id_departamento']] = $dpto['dpto_id_departamento'].' - '.$dpto['dpto_descripcion'];
            }
            $this->data['departamentos'] = $dptos;

            ///* Load Template */
            $this->template->admin_render('expedientes/form_expediente', $this->data);
        }
    }

    public function trae_distritos()
    {
        $dpto      = $_POST['departamento'];

        $distritos = $this->expedientes_model->dropdown_data('distritos', array('dpto' => $dpto), 'distrito')->result();

        echo '<option value="">Seleccione el distrito</option>';
        foreach ($distritos as $dist) {
            echo '<option value="' . $dist->distrito . '">' . $dist->distrito . ' - ' . $dist->dist_desc . '</option>';
        }

        //echo json_encode($distritos);
    }

    public function traer_tramos()
    {
        $proyecto      = $_POST['proyecto'];

        $tramos = $this->expedientes_model->dropdown_data('tramos', array('id_proyecto' => $proyecto, 'tramo_padre' => null), 'id_tramo')->result();

        echo '<option value="">Seleccione el tramo</option>';
        foreach ($tramos as $tr) {
            echo '<option value="'.$tr->id_tramo.'">'.$tr->nombre.'</option>';
        }

        //echo json_encode($distritos);
    }

    public function traer_subtramos()
    {
        $tramo      = $_POST['tramo'];

        $subtramos = $this->expedientes_model->dropdown_data('tramos', array('tramo_padre' => $tramo), 'id_tramo')->result();

        echo '<option value="">Seleccione el subtramo</option>';
        foreach ($subtramos as $subtr) {
            echo '<option value="'.$subtr->id_tramo.'">'.$subtr->nombre.'</option>';
        }

        //echo json_encode($distritos);
    }

    public function trae_expe_ref()
    {
        $expe      = $_POST['expe_id_expediente_ref'];

        $expes = $this->expedientes_model->dropdown_data('exp', array('expe_id_expediente_ref' => $expe), 'expe_id')->result();

        echo '<option value="">Seleccione Expediente</option>';
        foreach ($expes as $value) {
            $expes[$ex['expe_id']] = $ex['expe_id_expediente'].'-'.$ex['expe_gestion'].'-'.$ex['expe_id_dependencia'].'-'.$ex['expe_secuencia'];

            echo '<option value="' . $value->expe_id . '">' . $value->expe_id_expediente . '-' . $value->expe_gestion . '-' . $value->expe_id_dependencia . '-' . $value->expe_secuencia .  '</option>';
        }

        //echo json_encode($distritos);
    }

    public function delete($expe_id = null)
    {
        $documentos = $this->expedientes_model->view('documentos_sge', array('id_expediente' => $expe_id))->result_array();

        if (!empty($documentos)) {
            $this->eliminar_archivos($expe_id, $documentos);
        }
        
        $delete  = $this->expedientes_model->eliminar_expediente($expe_id);
        $this->session->set_flashdata('message', '¡El expediente se eliminó correctamente!');

        //$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

        //echo 'SI';
        redirect('expedientes/expedientes/index');
    }

    
//    public function verparcela_expe_id($expe_id)
//    {
//
//            $i_jameuge = "http://10.68.8.52:8065/jmap/index.html?expe_id=" . $expe_id;
//
//            redirect($i_jameuge);
//    }


}
  