<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Salud2 extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		$_SESSION['url_anterior'] = 'http://jaimito.site/sge/index.php/censo/censo/index';

		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'SALUD2') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'SALUD2') {
				
				$_SESSION['arraywhere_salud2'] = NULL;
				$_SESSION['arraywhere_salud2_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'SALUD2';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}


	public function salud2_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('salud2_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
		$salud2 = $this->censo_model->view('salud2', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('salud2_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['salud2_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['salud2_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['salud2_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

/*
	salud2_id
    level_1_id
    mujeres_embarazadas
    tiempo_de_embarazo
    lugar_de_consulta
    distancia_recorrida1
    miembro_flia_disc
    discapacidad
    tipo_de_discapacidad
    cuenta_con_centro_de_salud
    distancia_recorrida2
*/
		if ($_POST) {

			/*
			if ($_POST['salud2_id']) 
			{
				$arraycampos['salud2_id']                       = $_POST['salud2_id'];
			}else{
				$arraycampos['salud2_id']                       = NULL;
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}else{
				$arraycampos['level_1_id']   					= NULL;
			}
			*/

			if ($_POST['dgsa_salud2_mujeres_embarazadas']) 
			{
				$arraycampos['mujeres_embarazadas']        				= $_POST['dgsa_salud2_mujeres_embarazadas'];
				if (trim($_POST['dgsa_salud2_mujeres_embarazadas']) == '') {
					$arraycampos['mujeres_embarazadas']   = NULL;
				} else {
					$arraycampos['mujeres_embarazadas']   = (int)$_POST['dgsa_salud2_mujeres_embarazadas'];
				}				
			}

			if ($_POST['tiempo_de_embarazo']) 
			{
				$arraycampos['tiempo_de_embarazo']        		= $_POST['tiempo_de_embarazo'];
			}else{
				$arraycampos['tiempo_de_embarazo']        		= NULL;
			}

			if ($_POST['lugar_de_consulta']) 
			{
				$arraycampos['lugar_de_consulta']      			= $_POST['lugar_de_consulta'];
			}else{
				$arraycampos['lugar_de_consulta']      			= NULL;
			}

			if ($_POST['dgsa_salud2_distancia_recorrida1']) 
			{
				$arraycampos['distancia_recorrida1']        				= $_POST['dgsa_salud2_distancia_recorrida1'];
				if (trim($_POST['dgsa_salud2_distancia_recorrida1']) == '') {
					$arraycampos['distancia_recorrida1']   = NULL;
				} else {
					$arraycampos['distancia_recorrida1']   = (int)$_POST['dgsa_salud2_distancia_recorrida1'];
				}				
			}

			if ($_POST['dgsa_salud2_miembro_flia_disc']) 
			{
				$arraycampos['miembro_flia_disc']        				= $_POST['dgsa_salud2_miembro_flia_disc'];
				if (trim($_POST['dgsa_salud2_miembro_flia_disc']) == '') {
					$arraycampos['miembro_flia_disc']   = NULL;
				} else {
					$arraycampos['miembro_flia_disc']   = (int)$_POST['dgsa_salud2_miembro_flia_disc'];
				}				
			}

			if ($_POST['dgsa_salud2_discapacidad']) 
			{
				$arraycampos['discapacidad']        				= $_POST['dgsa_salud2_discapacidad'];
				if (trim($_POST['dgsa_salud2_discapacidad']) == '') {
					$arraycampos['discapacidad']   = NULL;
				} else {
					$arraycampos['discapacidad']   = (int)$_POST['dgsa_salud2_discapacidad'];
				}				
			}

			if ($_POST['dgsa_salud2_tipo_de_discapacidad']) 
			{
				$arraycampos['tipo_de_discapacidad']        				= $_POST['dgsa_salud2_tipo_de_discapacidad'];
				if (trim($_POST['dgsa_salud2_tipo_de_discapacidad']) == '') {
					$arraycampos['tipo_de_discapacidad']   = NULL;
				} else {
					$arraycampos['tipo_de_discapacidad']   = (int)$_POST['dgsa_salud2_tipo_de_discapacidad'];
				}				
			}

			if ($_POST['dgsa_salud2_cuenta_con_centro_de_salud']) 
			{
				$arraycampos['cuenta_con_centro_de_salud']        				= $_POST['dgsa_salud2_cuenta_con_centro_de_salud'];
				if (trim($_POST['dgsa_salud2_cuenta_con_centro_de_salud']) == '') {
					$arraycampos['cuenta_con_centro_de_salud']   = NULL;
				} else {
					$arraycampos['cuenta_con_centro_de_salud']   = (int)$_POST['dgsa_salud2_cuenta_con_centro_de_salud'];
				}				
			}

			if ($_POST['dgsa_salud2_distancia_recorrida2']) 
			{
				$arraycampos['distancia_recorrida2']        				= $_POST['dgsa_salud2_distancia_recorrida2'];
				if (trim($_POST['dgsa_salud2_distancia_recorrida2']) == '') {
					$arraycampos['distancia_recorrida2']   = NULL;
				} else {
					$arraycampos['distancia_recorrida2']   = (int)$_POST['dgsa_salud2_distancia_recorrida2'];
				}				
			}

			

			/*
			if (grupo_usuario(6)) {			
				$this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']),
													 'monitoreo',
													 array('reg_modificado' => 1)
													);
			}
			*/

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'salud2', $arraycampos);

			/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
			//función para validar pestaña
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['salud2'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/****** Actualizar tabla MONITOREO Y ASIGNACIONLOTES *********************/
			/**
			 **Se actualiza el campo PROCESO pasa a ser A03
			**/

			//$monitoreoasignacion = $this->censo_model->view('monitoreo_verificador', array('id_registro_lote' => $_SESSION['identificador']))->row();
			//$salud2 = $this->censo_model->view('salud2', array('id_registro_lote' => $_SESSION['identificador']))->row();
			/*if ($monitoreoasignacion->proceso == 'A04' || $monitoreoasignacion->proceso == 'A07') 
			{   
				$arraycampos1 = array('registro_analizado' => 0
					,'proceso'            => 'A03'
					//,'mapear'             => $salud2->mapear
					);
						//show_error($salud2->mapear. ' RECH ');
				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos1
					);

				$cantidad_reg_analizado = $monitoreoasignacion->cantidad_reg_analizado - 1;

				$arraycampos2 = array('cantidad_reg_analizado' => $cantidad_reg_analizado);
				$update_asignacion = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
																		  'asignacionlotes',
																		  $arraycampos2
																		  );
			}elseif ($monitoreoasignacion->proceso == 'A02' || $monitoreoasignacion->proceso == 'A03') 
			{

				if ((string)$monitoreoasignacion->fecha_procesado_4 == '0001-01-01' || 
					(string)$monitoreoasignacion->fecha_procesado_4 == '1970-01-01' || 
					$monitoreoasignacion->fecha_procesado_4 == null || 
					$monitoreoasignacion->fecha_procesado_4 == "" )  {
					$str = date_default_timezone_get();
					$fecha_procesado_4 =date("d/m/Y", strtotime($str));
					
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $salud2->mapear
					,'procesado_4'		   => 1
					,'fecha_procesado_4'	   => $fecha_procesado_4
					
					);
				}
				else {

				$str = date_default_timezone_get();
				$fecha_procesado_4 = date("d/m/Y", strtotime($str));
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $salud2->mapear
					,'procesado_4'		   => 1
					
					);
				}


				//$arraycampos3 = array('proceso'            => 'A03',
				//					  'mapear'             => $salud2->mapear
				//					  );
				

				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos3
					);
				
				$str = date_default_timezone_get();
				$fecha = date("d/m/Y", strtotime($str));
				$arraycampos4 = array('fecha_inicio' => $fecha);

				$update_monitoreo = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
					'asignacionlotes',
					$arraycampos4
					);
			}
			*/
			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/salud2/salud2_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

/*
		salud2_id
    level_1_id
    mujeres_embarazadas
    tiempo_de_embarazo
    lugar_de_consulta
    distancia_recorrida1
    miembro_flia_disc
    discapacidad
    tipo_de_discapacidad
    cuenta_con_centro_de_salud
    distancia_recorrida2
*/


		$this->data['salud2_id'] = array(
			'type'    => 'text',
			'name'    => 'salud2_id',
			'id'      => 'salud2_id',
			'value'   => $this->form_validation->set_value('salud2_salud2_id', trim($salud2->salud2_id)),
			'class'   => 'form-control',			
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('salud2_level_1_id', trim($salud2->level_1_id)),
			'class' => 'form-control'
			);
/*
		$this->data['mujeres_embarazadas'] = array(
			'type'  => 'text',
			'name'  => 'mujeres_embarazadas',
			'id'    => 'mujeres_embarazadas',
			'value' => $this->form_validation->set_value('salud2_mujeres_embarazadas', trim($salud2->mujeres_embarazadas)),
			'class' => 'form-control'
			);
*/
		$this->data['tiempo_de_embarazo'] = array(
			'type'  => 'text',
			'name'  => 'tiempo_de_embarazo',
			'id'    => 'tiempo_de_embarazo',
			'value' => $this->form_validation->set_value('salud2_tiempo_de_embarazo', trim($salud2->tiempo_de_embarazo)),
			'class' => 'form-control',
			'maxlength'=> '15'
		);
		$this->data['lugar_de_consulta'] = array(
			'type'  => 'text',
			'name'  => 'lugar_de_consulta',
			'id'    => 'lugar_de_consulta',
			'value' => $this->form_validation->set_value('salud2_lugar_de_consulta', trim($salud2->lugar_de_consulta)),
			'class' => 'form-control',
			'maxlength'=> '20'
		);
/*
		$this->data['distancia_recorrida1'] = array(
			'type'  => 'text',
			'name'  => 'distancia_recorrida1',
			'id'    => 'distancia_recorrida1',
			'value' => $this->form_validation->set_value('salud2_distancia_recorrida1', trim($salud2->distancia_recorrida1)),
			'class' => 'form-control'
		);
		$this->data['miembro_flia_disc'] = array(
			'type'  => 'text',
			'name'  => 'miembro_flia_disc',
			'id'    => 'miembro_flia_disc',
			'value' => $this->form_validation->set_value('salud2_miembro_flia_disc', trim($salud2->miembro_flia_disc)),
			'class' => 'form-control'
		);
        $this->data['discapacidad'] = array(
			'type'  => 'text',
			'name'  => 'discapacidad',
			'id'    => 'discapacidad',
			'value' => $this->form_validation->set_value('salud2_discapacidad', trim($salud2->discapacidad)),
			'class' => 'form-control'
		);

		$this->data['tipo_de_discapacidad'] = array(
			'type'  => 'text',
			'name'  => 'tipo_de_discapacidad',
			'id'    => 'tipo_de_discapacidad',
			'value' => $this->form_validation->set_value('salud2_tipo_de_discapacidad', trim($salud2->tipo_de_discapacidad)),
			'class' => 'form-control'
		);
		$this->data['cuenta_con_centro_de_salud'] = array(
			'type'  => 'text',
			'name'  => 'cuenta_con_centro_de_salud',
			'id'    => 'cuenta_con_centro_de_salud',
			'value' => $this->form_validation->set_value('salud2_cuenta_con_centro_de_salud', trim($salud2->cuenta_con_centro_de_salud)),
			'class' => 'form-control'
		);
		$this->data['distancia_recorrida2'] = array(
			'type'  => 'text',
			'name'  => 'distancia_recorrida2',
			'id'    => 'distancia_recorrida2',
			'value' => $this->form_validation->set_value('salud2_distancia_recorrida2', trim($salud2->distancia_recorrida2)),
			'class' => 'form-control'
		);
*/
		
/*
		$departamentos[''] = 'Seleccione el departamento';
		$departamento = $this->censo_model->dropdown_data('departamento')->result_array();
		foreach ($departamento as $dep) {
			$departamentos[$dep['dpto_sncs']] = $dep['dpto_snc'].' - '.$dep['dpto_desc'];
		}
		$this->data['departamento'] = $departamentos;
		$this->data['departamento_sel'] = $salud2->departamento;

		$distritos[''] = 'Seleccione el distrito';
		$distrito = $this->censo_model->dropdown_data('distrito', array('dpto_snc' => $salud2->departamento))->result_array();
		foreach ($distrito as $dist) {
			$distritos[$dist['dist_snc']] = $dist['dist_snc'].' - '.$dist['dist_desc'];
		}
		$this->data['distrito'] = $distritos;
		$this->data['distrito_sel'] = $salud2->distrito;
*/

		$mujeres_embarazadas = $this->censo_model->concepto('MUJERES_EMBARAZADAS',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($mujeres_embarazadas as $af) 
		{
			$mujeres_embarazadass[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['mujeres_embarazadas'] = $mujeres_embarazadass;

		if (ctype_space($salud2->mujeres_embarazadas)) {
			$this->data['mujeres_embarazadas_sel'] = '  ';
		}else{
			$this->data['mujeres_embarazadas_sel'] = (int)$salud2->mujeres_embarazadas;
		}

		$distancia_recorrida1 = $this->censo_model->concepto('DISTANCIA_RECORRIDA1',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distancia_recorrida1 as $af) 
		{
			$distancia_recorrida1s[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['distancia_recorrida1'] = $distancia_recorrida1s;

		if (ctype_space($salud2->distancia_recorrida1)) {
			$this->data['distancia_recorrida1_sel'] = '  ';
		}else{
			$this->data['distancia_recorrida1_sel'] = (int)$salud2->distancia_recorrida1;
		}

		$miembro_flia_disc = $this->censo_model->concepto('MIEMBRO_FLIA_DISC',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($miembro_flia_disc as $af) 
		{
			$miembro_flia_discs[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['miembro_flia_disc'] = $miembro_flia_discs;

		if (ctype_space($salud2->miembro_flia_disc)) {
			$this->data['miembro_flia_disc_sel'] = '  ';
		}else{
			$this->data['miembro_flia_disc_sel'] = (int)$salud2->miembro_flia_disc;
		}

		$discapacidad = $this->censo_model->concepto('DISCAPACIDAD',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($discapacidad as $af) 
		{
			$discapacidads[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['discapacidad'] = $discapacidads;

		if (ctype_space($salud2->discapacidad)) {
			$this->data['discapacidad_sel'] = '  ';
		}else{
			$this->data['discapacidad_sel'] = (int)$salud2->discapacidad;
		}

		$tipo_de_discapacidad = $this->censo_model->concepto('TIPO_DE_DISCAPACIDAD',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($tipo_de_discapacidad as $af) 
		{
			$tipo_de_discapacidads[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['tipo_de_discapacidad'] = $tipo_de_discapacidads;

		if (ctype_space($salud2->tipo_de_discapacidad)) {
			$this->data['tipo_de_discapacidad_sel'] = '  ';
		}else{
			$this->data['tipo_de_discapacidad_sel'] = (int)$salud2->tipo_de_discapacidad;
		}

		$cuenta_con_centro_de_salud = $this->censo_model->concepto('CUENTA_CON_CENTRO_DE_SALUD',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($cuenta_con_centro_de_salud as $af) 
		{
			$cuenta_con_centro_de_saluds[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['cuenta_con_centro_de_salud'] = $cuenta_con_centro_de_saluds;

		if (ctype_space($salud2->cuenta_con_centro_de_salud)) {
			$this->data['cuenta_con_centro_de_salud_sel'] = '  ';
		}else{
			$this->data['cuenta_con_centro_de_salud_sel'] = (int)$salud2->cuenta_con_centro_de_salud;
		}

		$distancia_recorrida2 = $this->censo_model->concepto('DISTANCIA_RECORRIDA2',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distancia_recorrida2 as $af) 
		{
			$distancia_recorrida2s[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['distancia_recorrida2'] = $distancia_recorrida2s;

		if (ctype_space($salud2->distancia_recorrida2)) {
			$this->data['distancia_recorrida2_sel'] = '  ';
		}else{
			$this->data['distancia_recorrida2_sel'] = (int)$salud2->distancia_recorrida2;
		}


		/* Load Template */
		$this->template->admin_render('censo/salud2', $this->data);
	}

}
//Llave de finalizacion de la clase