<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Censo extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		$_SESSION['url_anterior'] = 'http://jaimito.site/sge/index.php/censo/censo/index';

		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'UBI_GEO') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'UBI_GEO') {
				
				$_SESSION['arraywhere_ubi_geo'] = NULL;
				$_SESSION['arraywhere_ubi_geo_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'UBI_GEO';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}


	public function index()
	{
		$_SESSION['id_modulo'] = 'UBI_GEO';

		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			if ($_POST) {
				/*
				if ($_POST['ubi_geo_id']) 
				{
					$arraywhere['ubi_geo_id'] 								= $_POST['ubi_geo_id'];
					$arraywherebusq['ubi_geo_id'] 							= $_POST['ubi_geo_id'];
				}
				*/
				if ($_POST['level_1_id']) 
				{
					$arraywhere['level_1_id'] 							= $_POST['level_1_id'];
					$arraywherebusq[' lower(cast(level_1_id as varchar)) like'] 					= '%'.$_POST['level_1_id'].'%';
				}
				if ($_POST['departamento']) 
				{
					$arraywhere['departamento'] 								= $_POST['departamento'];
					$arraywherebusq[' lower(cast(departamento as varchar)) like'] 	= '%'.strtolower($_POST['departamento']).'%';
				}
				if ($_POST['distrito']) 
				{
					$arraywhere['distrito'] 								= $_POST['distrito'];
					$arraywherebusq[' lower(cast(distrito as varchar)) like'] 	= '%'.strtolower($_POST['distrito']).'%';
				}
				if ($_POST['zona_urbana']) 
				{
					$arraywhere['zona_urbana'] 								= $_POST['zona_urbana'];
					$arraywherebusq[' lower(cast(zona_urbana as varchar)) like'] 	= '%'.strtolower($_POST['zona_urbana']).'%';
				}
				if ($_POST['direccion']) 
				{
					if (is_numeric($_POST['direccion'])) {
						$arraywhere['direccion'] 							= $_POST['direccion'];
						$arraywherebusq['lower(cast(direccion as varchar)) like'] 	= $_POST['direccion'];
					}
				}
				if ($_POST['n_de_foto']) 
				{
					$arraywhere['n_de_foto'] 						= $_POST['n_de_foto'];
					$arraywherebusq[' lower(cast(n_de_foto as varchar)) like'] 	= '%'.strtolower($_POST['n_de_foto']).'%';
				}
				if ($_POST['tramo']) 
				{
					$arraywhere['tramo'] 					= $_POST['tramo'];
					$arraywherebusq[' lower(cast(tramo as varchar)) like'] = '%'.strtolower($_POST['tramo']).'%';
				}
				if ($_POST['margen']) 
				{
					$arraywhere['margen'] 			= $_POST['margen'];
					$arraywherebusq[' lower(cast(margen as varchar)) like'] = '%'.strtolower($_POST['margen']).'%';
				}

				$_SESSION['arraywhere_ubi_geo'] 		= $arraywhere;
				$_SESSION['arraywhere_ubi_geo_busq']	= $arraywherebusq;

				redirect('censo/censo/index');				
			}

			// ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'censo/censo/index/',  // url completa de la pagina paginada
				'ubi_geo',		// scheme y nombre de la tabla, para la consulta
				$_SESSION['arraywhere_ubi_geo_busq']
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['censos']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'ubi_geo',					// el nombre de la tabla a consultar $nombre_tabla
 				$_SESSION['arraywhere_ubi_geo_busq']
 				)->result();
			// ----- Fin paginacion


			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();

			//$this->data['censo'] = $this->censo_model->censo()->result();
			

			/*$this->data['identificador'] = array(
				'name'  => 'identificador',
				'id'    => 'identificador',
				'type'  => 'hidden',
				'class' => 'form-control',
				'value' => '<?php echo $values->id_registro_lote ?>'
				);
			*/

			/* Load Template */
			$this->template->admin_render('censo/index', $this->data);
		}
	}

	

    public function delete($level_1_id = null)
    {
       /* $documentos = $this->expedientes_model->view('documentos_dgsa', array('level_1_id' => $level_1_id))->result_array();

        if (!empty($documentos)) {
            $this->eliminar_archivos($expe_id, $documentos);
        }*/
        
        $delete  = $this->censo_model->eliminar_censo($level_1_id);
        $this->session->set_flashdata('message', '¡El censo se eliminó correctamente!');

        //$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

        //echo 'SI';
        redirect('censo/censo/index');
    }

}
//Llave de finalizacion de la clase