<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ubi_geo extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];


		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'UBI_GEO') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'UBI_GEO') {
				
				$_SESSION['arraywhere_ubi_geo'] = NULL;
				$_SESSION['arraywhere_ubi_geo_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'UBI_GEO';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}

	public function ubi_geo_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('ubi_geo_tiutlo'), 'ubi_geo/create_ubi_geo');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		//$max   = $this->censo_model->valor_maximo('ubi_geo', 'occ', array('level_1_id' => $_SESSION['identificador']))->row()->max;
		//$max   = $max + 1;
		//$ubi_geo = $this->censo_model->view('ubi_geo', array('level_1_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		//$this->form_validation->set_rules('ubi_geo', 'lang:ubi_geo_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
    
    
    
			$level_1_id 								= NULL;
			$arraycamposinsert['fecha']         		= NULL;
			$arraycamposinsertlevel1['proyecto']		= NULL;
			$arraycamposinsertlevel1['usuario']			= NULL;
			$arraycamposinsertlevel1['codigo_censal']   = NULL;
			$arraycamposinsertlevel1['codigo']         	= NULL;
			$arraycamposinsert['departamento']   		= NULL;
			$arraycamposinsert['distrito']   			= NULL;
			$arraycamposinsert['zona_urbana']   		= NULL;
			$arraycamposinsert['direccion']   			= NULL;
			$arraycamposinsert['n_de_gps_x']   			= NULL;
			$arraycamposinsert['n_de_gps_y']   			= NULL;
			$arraycamposinsert['n_de_gps_x_geo']   		= NULL;
			$arraycamposinsert['n_de_gps_y_geo']   		= NULL;
			$arraycamposinsert['n_de_foto']   			= NULL;
			$arraycamposinsert['tramo']   				= NULL;
			$arraycamposinsert['margen']  				= NULL;
			$_SESSION['identificador'] 					= $level_1_id;

			$arraycamposinsert['level_1_id']  			= (string)$_SESSION['identificador'];
			$arraycamposinsert['ubi_geo_id']  			= (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['level_1_id']  	= (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['case_id']  		= (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['fichacensal_id']  = NULL;
													      
			$arraycamposinsert['proyecto']  	 		= $arraycamposinsertlevel1['proyecto'];
			$arraycamposinsert['usuario']  		 		= $arraycamposinsertlevel1['usuario'];	
			$arraycamposinsert['codigo_censal']  		= $arraycamposinsertlevel1['codigo_censal'];
			$arraycamposinsert['codigo']  		 		= $arraycamposinsertlevel1['codigo'];	
			$arraycamposinsert['fichacensal_id'] 		= $arraycamposinsertlevel1['fichacensal_id'];	


		if ($_POST)
		{
			//$arraycamposinsert['occ']         		= $max;

			if ($_POST['fecha']) {
				$arraycamposinsert['fecha']         	= $_POST['fecha'];
			}
        
			if ($_POST['dgsa_ubi_geo_proyecto']) 
			{
				$arraycamposinsertlevel1['proyecto']        				= $_POST['dgsa_ubi_geo_proyecto'];
				if (trim($_POST['dgsa_ubi_geo_proyecto']) == '') {
					$arraycamposinsertlevel1['proyecto']   = NULL;
				} else {
					$arraycamposinsertlevel1['proyecto']   = (int)$_POST['dgsa_ubi_geo_proyecto'];
				}				
			}
			$arraycamposinsertlevel1['usuario']   = NULL;
			if ($_POST['dgsa_ubi_geo_usuario']) 
			{
				$arraycamposinsertlevel1['usuario']       = $_POST['dgsa_ubi_geo_usuario'];
				if (trim($_POST['dgsa_ubi_geo_usuario']) == '') {
					$arraycamposinsertlevel1['usuario']   = NULL;
				} else {
					$arraycamposinsertlevel1['usuario']   = (int)$_POST['dgsa_ubi_geo_usuario'];
				}				
			}
			
			if ($_POST['codigo_censal']) {
				$arraycamposinsertlevel1['codigo_censal']   = $_POST['codigo_censal'];
			}

			if ($_POST['codigo']) {
				$arraycamposinsertlevel1['codigo']         	= $_POST['codigo'];
			}
			
			if ($_POST['dgsa_ubi_geo_departamento']) 
			{
				$arraycamposinsert['departamento']      = $_POST['dgsa_ubi_geo_departamento'];
				if (trim($_POST['dgsa_ubi_geo_departamento']) == '') {
					$arraycamposinsert['departamento']   = NULL;
				} else {
					//$arraycamposinsert['departamento']   = (int)$_POST['dgsa_ubi_geo_departamento'];
					$arraycamposinsert['departamento']   = $_POST['dgsa_ubi_geo_departamento'];
                }				
			}

			if ($_POST['dgsa_ubi_geo_distrito']) 
			{
				$arraycamposinsert['distrito']        				= $_POST['dgsa_ubi_geo_distrito'];
				if (trim($_POST['dgsa_ubi_geo_distrito']) == '') {
					$arraycamposinsert['distrito']   = NULL;
				} else {
					$arraycamposinsert['distrito']   = (int)$_POST['dgsa_ubi_geo_distrito'];
				}				
			}

			if ($_POST['dgsa_ubi_geo_zona_urbana']) 
			{
				$arraycamposinsert['zona_urbana']        				= $_POST['dgsa_ubi_geo_zona_urbana'];
				if (trim($_POST['dgsa_ubi_geo_zona_urbana']) == '') {
					$arraycamposinsert['zona_urbana']   = NULL;
				} else {
					$arraycamposinsert['zona_urbana']   = (int)$_POST['dgsa_ubi_geo_zona_urbana'];
				}				
			}

			if (strlen(trim($_POST['direccion'])) == 0) {
					$arraycamposinsert['direccion']   = NULL;
			} else {
					$arraycamposinsert['direccion']   = $_POST['direccion'];
			}

			if (strlen(trim($_POST['n_de_gps_x'])) == 0) {
					$arraycamposinsert['n_de_gps_x']   = NULL;
			} else {
					$arraycamposinsert['n_de_gps_x']   = (float)$_POST['n_de_gps_x'];
			}

			if (strlen(trim($_POST['n_de_gps_y'])) == 0) {
					$arraycamposinsert['n_de_gps_y']   = NULL;
			} else {
					$arraycamposinsert['n_de_gps_y']   = (float)$_POST['n_de_gps_y'];
			}

			if (strlen(trim($_POST['n_de_gps_x_geo'])) == 0) {
					$arraycamposinsert['n_de_gps_x_geo']   = NULL;
			} else {
					$arraycamposinsert['n_de_gps_x_geo']   = $_POST['n_de_gps_x_geo'];
			}

			if (strlen(trim($_POST['n_de_gps_y_geo'])) == 0) {
					$arraycamposinsert['n_de_gps_y_geo']   = NULL;
			} else {
					$arraycamposinsert['n_de_gps_y_geo']   = $_POST['n_de_gps_y_geo'];
			}

			if (strlen(trim($_POST['n_de_foto'])) == 0) {
					$arraycamposinsert['n_de_foto']   = NULL;
			} else {
					$arraycamposinsert['n_de_foto']   = $_POST['n_de_foto'];
			}

			if (strlen(trim($_POST['tramo'])) == 0) {
					$arraycamposinsert['tramo']   = NULL;
			} else {
					$arraycamposinsert['tramo']   = $_POST['tramo'];
			}

			if ($_POST['dgsa_ubi_geo_margen']) 
			{
				$arraycamposinsert['margen']        				= $_POST['dgsa_ubi_geo_margen'];
				if (trim($_POST['dgsa_ubi_geo_margen']) == '') {
					$arraycamposinsert['margen']   = NULL;
				} else {
					$arraycamposinsert['margen']   = (int)$_POST['dgsa_ubi_geo_margen'];
				}				
			}

			$level_1_id = $this->censo_model->obtener_nextval('dgsa.level_1_id_seq');

			$_SESSION['identificador'] = $level_1_id;

			$arraycamposinsert['level_1_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsert['ubi_geo_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['level_1_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['case_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsertlevel1['fichacensal_id']  = (int)$arraycamposinsertlevel1['proyecto']*10000000 + 
			                                        (int)$arraycamposinsertlevel1['usuario']*10000 + 
													(int)$arraycamposinsertlevel1['codigo_censal'] ; 
													      
			$arraycamposinsert['proyecto']  	 = $arraycamposinsertlevel1['proyecto'];
			$arraycamposinsert['usuario']  		 = $arraycamposinsertlevel1['usuario'];	
			$arraycamposinsert['codigo_censal']  = $arraycamposinsertlevel1['codigo_censal'];
			$arraycamposinsert['codigo']  		 = $arraycamposinsertlevel1['codigo'];	
			$arraycamposinsert['fichacensal_id'] = $arraycamposinsertlevel1['fichacensal_id'];	
			
			$level_1_id = (string)$_SESSION['identificador'];
        
            $cantidad = $this->censo_model->existe_codigo_dgsa($arraycamposinsert['codigo']);

        	if ($cantidad == 0) {
  				$create_ubi_geo = $this->censo_model->crear_registro('level_1', $arraycamposinsertlevel1);
				$create_ubi_geo = $this->censo_model->crear_registro('ubi_geo', $arraycamposinsert);
            	$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
				redirect('censo/ubi_geo/ubi_geo_edit/'.$level_1_id.'/E');            
                
			} else {
				$this->data['message'] = 'Ya existe este '.$arraycamposinsert['codigo'].' codigo censal  ';
				$this->session->set_flashdata('message', $this->ion_auth->errors());
            }

		}
		else
		{
        			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
		}
        
			/* 
			ubi_geo_id
			level_1_id
			fecha
			departamento
			distrito
			zona_urbana
			direccion
			n_de_gps_x
			n_de_gps_y
			n_de_foto
			tramo
			margen
			*/
			$this->data['fichacensal_id'] = array(
				'name'  => 'fichacensal_id',
				'id'    => 'fichacensal_id',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('fichacensal_id', $arraycamposinsert['fichacensal_id']),
				//'value'   => $this->form_validation->set_value('fichacensal_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);	
			$this->data['ubi_geo_id'] = array(
				'name'  => 'ubi_geo_id',
				'id'    => 'ubi_geo_id',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ubi_geo_id', $arraycamposinsert['ubi_geo_id']),
				//'value'   => $this->form_validation->set_value('ubi_geo_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['level_1_id'] = array(
				'name'  => 'level_1_id',
				'id'    => 'level_1_id',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('level_1_id', $arraycamposinsert['level_1_id']),
				//'value'   => $this->form_validation->set_value('level_1_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['fecha'] = array(
				'type'     => 'text',
				'name'     => 'fecha',
				'id'       => 'fecha',
				'value'    => $this->form_validation->set_value('fecha_ingreso', date('d/m/Y')),
				'class'    => 'form-control',
				'required' => 'true'
				);     
			$this->data['codigo_censal'] = array(
				'name'  => 'codigo_censal',
				'id'    => 'codigo_censal',
				'type'  => 'text',
				'pattern'  => '^([1-9][0-9]{0,19})?$',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('codigo_censal', $arraycamposinsert['codigo_censal']),
				'required' => 'true',
				'maxlength' => 4 
				);        				
			$this->data['codigo'] = array(
				'name'  => 'codigo',
				'id'    => 'codigo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('codigo', $arraycamposinsert['codigo']),
				'required' => 'true',
				'maxlength' => 10
				);							
			$this->data['direccion'] = array(
				'name'  => 'direccion',
				'id'    => 'direccion',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('direccion', $arraycamposinsert['direccion']),
				'maxlength' => 60
				);
			$this->data['n_de_gps_x'] = array(
				'type'  => 'text',
				'name'  => 'n_de_gps_x',
				'placeholder' => 'xxxxxx.xxxxxxxxx',
				'pattern'  => '^\d{0,6}(\.\d{0,9})?$',
				'id'    => 'n_de_gps_x',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_gps_x', $arraycamposinsert['n_de_gps_x']),
				'maxlength' => 20
				); 
			$this->data['n_de_gps_y'] = array(
				'type'  => 'text',
				'name'  => 'n_de_gps_y',
				'placeholder' => 'xxxxxxx.xxxxxxxx',
				'pattern'  => '^\d{0,7}(\.\d{0,8})?$',
				'id'    => 'n_de_gps_y',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_gps_y', $arraycamposinsert['n_de_gps_y']),
				'maxlength' => 20
				); 	
			$this->data['n_de_gps_x_geo'] = array(
				'type'     => 'text',
				'name'  => 'n_de_gps_x_geo',
				//'placeholder' => 'xx-xx-xx.x',
				//'pattern'  => '^\d{0,2}(\°\d{0,2})?(\'\d{0,2})?(\.\d{0,1}\"\)?$',
				'pattern'  => '^\d{0,2}(\-\d{0,2})?(\-\d{0,2})?(\.\d{0,1}\\)?$',
                //'pattern'  => '^([1-9][0-9]{0,2})?$',
            	'id'    => 'n_de_gps_x_geo',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_gps_x_geo', $arraycamposinsert['n_de_gps_x_geo']),
				'maxlength' => 11
				); 
			$this->data['n_de_gps_y_geo'] = array(
				'type'     => 'text',
				'name'  => 'n_de_gps_y_geo',
				'placeholder' => 'xxx-xx-xx.x',
				'pattern'  => '^\d{0,3}(\-\d{0,2})?(\-\d{0,2})?(\.\d{0,1}\\)?$',
				'id'    => 'n_de_gps_y_geo',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_gps_y_geo', $arraycamposinsert['n_de_gps_y_geo']),
				'maxlength' => 12
				);			
			$this->data['n_de_foto'] = array(
				'name'  => 'n_de_foto',
				'id'    => 'n_de_foto',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_foto', $arraycamposinsert['n_de_foto']),
				'maxlength' => 10
				); 	
			$this->data['tramo'] = array(
				'name'  => 'tramo',
				'id'    => 'tramo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('tramo', $arraycamposinsert['tramo']),
				'maxlength' => 60
				); 	

			$proyectos[''] = 'Seleccione el proyecto';
			$proyecto = $this->censo_model->dropdown_data('v_proyectos',null,'id_proyecto')->result_array();
			foreach ($proyecto as $proy) {
				$proyectos[$proy['id_proyecto']] = $proy['id_proyecto'].' - '.$proy['nombre'];
			}
			$this->data['proyecto'] = $proyectos;
			$this->data['proyecto_sel'] = $arraycamposinsert['proyecto'];

			$usuarios[''] = 'Seleccione el usuario';
			$usuario = $this->censo_model->dropdown_data('users',null,'id')->result_array();
			foreach ($usuario as $usr) {
				$usuarios[$usr['id']] = $usr['username'].' - '.$usr['id'].' - '.$usr['first_name'].' '.$usr['last_name'];
			}
			$this->data['usuario'] = $usuarios;
			$this->data['usuario_sel'] = $arraycamposinsert['usuario'];			

			$departamentos[''] = 'Seleccione el departamento';
			$departamento = $this->censo_model->dropdown_data('departamentos',null,'cod_snc')->result_array();
			foreach ($departamento as $dep) {
				$departamentos[$dep['cod_snc']] = $dep['cod_snc'].' - '.$dep['dpto_desc'];
			}
			$this->data['departamento'] = $departamentos;
			$this->data['departamento_sel'] = $arraycamposinsert['departamento'];	

			$distritos[''] = 'Seleccione el distrito';
			//$distrito = $this->censo_model->dropdown_data('distritos', array('dpto_snc' => $ubi_geo->departamento),'dist_snc')->result_array();
			$distrito = $this->censo_model->dropdown_data('distritos', null,'dist_snc')->result_array();
			foreach ($distrito as $dist) {
				$distritos[$dist['dist_snc']] = $dist['dist_snc'].' - '.$dist['dist_desc'];
			}
			$this->data['distrito'] = $distritos;
			$this->data['distrito_sel'] = $arraycamposinsert['distrito'];	

			$zona_urbana = $this->censo_model->concepto('ZONA_URBANA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($zona_urbana as $zu) {
				$zona_urbanas[$zu['concepto']] = $zu['concepto'].' - '.$zu['nombre'];
			}
			$this->data['zona_urbana'] = $zona_urbanas;
    	    $this->data['zona_urbana_sel'] = $arraycamposinsert['zona_urbana'];	

			$margen = $this->censo_model->concepto('MARGEN',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($margen as $ma) {
				$margens[$ma['concepto']] = $ma['concepto'].' - '.$ma['nombre'];
			}
			$this->data['margen'] = $margens;	
    		$this->data['margen_sel'] = $arraycamposinsert['margen'];	


			/* Load Template */
			$this->template->admin_render('censo/ubi_geo_create', $this->data);
		//} //aSI ESTA EXPEDIENTES HAY QUE INVESTIGAR PERO ASI FUNCIONA
	}



	public function ubi_geo_edit($level_1_id, $modo_cuest)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
    
        if ($_SESSION['id_modulo_ant'] != 'UBI_GEO') {
			
			if (isset($_SERVER["HTTP_REFERER"])) {
				$_SESSION['url_anterior'] = $_SERVER["HTTP_REFERER"];
			}
		}
		
		$_SESSION['modo_cuest'] = $modo_cuest;
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('ubi_geo_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
    
		$level_1 = $this->censo_model->view('level_1', array('level_1_id' => $_SESSION['identificador']))->row();
		$ubi_geo = $this->censo_model->view('ubi_geo', array('level_1_id' => $_SESSION['identificador']))->row();
    	$jefe_flia = $this->censo_model->view('jefe_flia', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('ubi_geo_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['ubi_geo_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['ubi_geo_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['ubi_geo_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

		/*
				ubi_geo_id 
				level_1_id
				fecha 
				departamento 
				distrito 
				zona_urbana 
				direccion 
				n_de_gps_x 
				n_de_gps_y 
				n_de_foto 
				tramo 
				margen 
		*/
		if ($_POST) {

			/*
			if ($_POST['ubi_geo_id']) 
			{
				$arraycampos['ubi_geo_id']                       = $_POST['ubi_geo_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}
			*/

			if ($_POST['fecha']) 
			{
				$arraycampos['fecha']        			= $_POST['fecha'];
			}
	
			if ($_POST['dgsa_ubi_geo_proyecto']) 
			{
				$arraycamposlevel1['proyecto']        				= $_POST['dgsa_ubi_geo_proyecto'];
				if (trim($_POST['dgsa_ubi_geo_proyecto']) == '') {
					$arraycamposlevel1['proyecto']   = NULL;
				} else {
					$arraycamposlevel1['proyecto']   = (int)$_POST['dgsa_ubi_geo_proyecto'];
				}				
			}
			
			if ($_POST['dgsa_ubi_geo_usuario']) 
			{
				$arraycamposlevel1['usuario']       = $_POST['dgsa_ubi_geo_usuario'];
				if (trim($_POST['dgsa_ubi_geo_usuario']) == '') {
					$arraycamposlevel1['usuario']   = NULL;
				} else {
					$arraycamposlevel1['usuario']   = (int)$_POST['dgsa_ubi_geo_usuario'];
				}				
			}

			if ($_POST['codigo_censal']) {
				$arraycamposlevel1['codigo_censal']  = $_POST['codigo_censal'];
				if ($_POST['codigo_censal'] == '') {
				   $arraycamposlevel1['codigo_censal']   = NULL;
				}                    
			} else {
				if ($_POST['codigo_censal'] == '') {
				   $arraycamposlevel1['codigo_censal']   = NULL;
				}
			} 

			if ($_POST['codigo']) {
				$arraycamposlevel1['codigo']         	= $_POST['codigo'];
			}

			if ($_POST['dgsa_ubi_geo_departamento']) 
			{
				$arraycampos['departamento']        			= $_POST['dgsa_ubi_geo_departamento'];
			}

			if ($_POST['dgsa_ubi_geo_distrito']) 
			{
				$arraycampos['distrito']      					= $_POST['dgsa_ubi_geo_distrito'];
			}

			if ($_POST['dgsa_ubi_geo_zona_urbana']) 
			{
				$arraycampos['zona_urbana']        				= $_POST['dgsa_ubi_geo_zona_urbana'];
				if (trim($_POST['dgsa_ubi_geo_zona_urbana']) == '') {
					$arraycampos['zona_urbana']   = NULL;
				} else {
					$arraycampos['zona_urbana']   = (int)$_POST['dgsa_ubi_geo_zona_urbana'];
				}				
			}

			if (strlen(trim($_POST['direccion'])) == 0) {
					$arraycampos['direccion']   = NULL;
			} else {
					$arraycampos['direccion']   = $_POST['direccion'];
			}

			if (strlen(trim($_POST['n_de_gps_x'])) == 0) {
					$arraycampos['n_de_gps_x']   = NULL;
			} else {
					$arraycampos['n_de_gps_x']   = (float)$_POST['n_de_gps_x'];
			}

			if (strlen(trim($_POST['n_de_gps_y'])) == 0) {
					$arraycampos['n_de_gps_y']   = NULL;
			} else {
					$arraycampos['n_de_gps_y']   = (float)$_POST['n_de_gps_y'];
			}	

			if (strlen(trim($_POST['n_de_gps_x_geo'])) == 0) {
					$arraycampos['n_de_gps_x_geo']   = NULL;
			} else {
					$arraycampos['n_de_gps_x_geo']   = $_POST['n_de_gps_x_geo'];
			}

			if (strlen(trim($_POST['n_de_gps_y_geo'])) == 0) {
					$arraycampos['n_de_gps_y_geo']   = NULL;
			} else {
					$arraycampos['n_de_gps_y_geo']   = $_POST['n_de_gps_y_geo'];
			}

			if (strlen(trim($_POST['n_de_foto'])) == 0) {
					$arraycampos['n_de_foto']   = NULL;
			} else {
					$arraycampos['n_de_foto']   = $_POST['n_de_foto'];
            }

			if (strlen(trim($_POST['tramo'])) == 0) {
					$arraycampos['tramo']   = NULL;
			} else {
					$arraycampos['tramo']   = $_POST['tramo'];
			}

			if ($_POST['dgsa_ubi_geo_margen']) 
			{
				if ($_POST['dgsa_ubi_geo_margen'] == '') 
				{
					$arraycampos['margen']	= null;
				} else {
					$arraycampos['margen']	= $_POST['dgsa_ubi_geo_margen'];
				}
			}

			/*
			if (grupo_usuario(6)) {			
				$this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']),
													 'monitoreo',
													 array('reg_modificado' => 1)
													);
			}
			*/
        

			$arraycampos['proyecto']		= $arraycamposlevel1['proyecto'];
			$arraycampos['usuario']		    = $arraycamposlevel1['usuario'];	
			$arraycampos['codigo_censal']	= $arraycamposlevel1['codigo_censal'];	
			$arraycampos['codigo']  		= $arraycamposlevel1['codigo'];
        
			$arraycamposinsertlevel1['fichacensal_id']  = (int)$arraycamposinsertlevel1['proyecto']*10000000 + 
			                                        (int)$arraycamposinsertlevel1['usuario']*10000 + 
													(int)$arraycamposinsertlevel1['codigo_censal'] ; 
        
			$arraycampos['fichacensal_id']  = $arraycamposlevel1['fichacensal_id'];	
            
            $_SESSION['arraycampos'] 		= $arraycampos;

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'level_1', $arraycamposlevel1);
			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'ubi_geo', $arraycampos);

			/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
			//función para validar pestaña
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['ubi_geo'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/****** Actualizar tabla MONITOREO Y ASIGNACIONLOTES *********************/
			/**
			 **Se actualiza el campo PROCESO pasa a ser A03
			**/

			//$monitoreoasignacion = $this->censo_model->view('monitoreo_verificador', array('id_registro_lote' => $_SESSION['identificador']))->row();
			//$ubi_geo = $this->censo_model->view('ubi_geo', array('id_registro_lote' => $_SESSION['identificador']))->row();
			/*if ($monitoreoasignacion->proceso == 'A04' || $monitoreoasignacion->proceso == 'A07') 
			{   
				$arraycampos1 = array('registro_analizado' => 0
					,'proceso'            => 'A03'
					//,'mapear'             => $ubi_geo->mapear
					);
						//show_error($ubi_geo->mapear. ' RECH ');
				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos1
					);

				$cantidad_reg_analizado = $monitoreoasignacion->cantidad_reg_analizado - 1;

				$arraycampos2 = array('cantidad_reg_analizado' => $cantidad_reg_analizado);
				$update_asignacion = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
																		  'asignacionlotes',
																		  $arraycampos2
																		  );
			}elseif ($monitoreoasignacion->proceso == 'A02' || $monitoreoasignacion->proceso == 'A03') 
			{

				if ((string)$monitoreoasignacion->fecha_procesado_4 == '0001-01-01' || 
					(string)$monitoreoasignacion->fecha_procesado_4 == '1970-01-01' || 
					$monitoreoasignacion->fecha_procesado_4 == null || 
					$monitoreoasignacion->fecha_procesado_4 == "" )  {
					$str = date_default_timezone_get();
					$fecha_procesado_4 =date("d/m/Y", strtotime($str));
					
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $ubi_geo->mapear
					,'procesado_4'		   => 1
					,'fecha_procesado_4'	   => $fecha_procesado_4
					
					);
				}
				else {

				$str = date_default_timezone_get();
				$fecha_procesado_4 = date("d/m/Y", strtotime($str));
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $ubi_geo->mapear
					,'procesado_4'		   => 1
					
					);
				}


				//$arraycampos3 = array('proceso'            => 'A03',
				//					  'mapear'             => $ubi_geo->mapear
				//					  );
				

				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos3
					);
				
				$str = date_default_timezone_get();
				$fecha = date("d/m/Y", strtotime($str));
				$arraycampos4 = array('fecha_inicio' => $fecha);

				$update_monitoreo = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
					'asignacionlotes',
					$arraycampos4
					);
			}
			*/
			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/ubi_geo/ubi_geo_edit/'.$level_1_id.'/E');
		}else{

		    $level_1 = $this->censo_model->view('level_1', array('level_1_id' => $_SESSION['identificador']))->row();
		    $ubi_geo = $this->censo_model->view('ubi_geo', array('level_1_id' => $_SESSION['identificador']))->row();
        
        
			$arraycamposlevel1['fichacensal_id']    = $level_1->fichacensal_id;
        	$arraycampos['fecha']        			= $ubi_geo->fecha;
			$arraycamposlevel1['proyecto']   		= $level_1->proyecto;
			$arraycamposlevel1['usuario']   		= $level_1->usuario;
			$arraycamposlevel1['codigo_censal']  	= $level_1->codigo_censal;
			$arraycamposlevel1['codigo']         	= $level_1->codigo;
			$arraycampos['departamento']        	= $ubi_geo->departamento;
			$arraycampos['distrito']      			= $ubi_geo->distrito;
			$arraycampos['zona_urbana']        		= $ubi_geo->zona_urbana;
			$arraycampos['direccion']   			= $ubi_geo->direccion;
			$arraycampos['n_de_gps_x']   			= $ubi_geo->n_de_gps_x;
			$arraycampos['n_de_gps_y']   			= $ubi_geo->n_de_gps_y;
			$arraycampos['n_de_gps_x_geo']   		= $ubi_geo->n_de_gps_x_geo;
			$arraycampos['n_de_gps_y_geo']   		= $ubi_geo->n_de_gps_y_geo;
			$arraycampos['n_de_foto']   			= $ubi_geo->n_de_foto;
			$arraycampos['tramo']   				= $ubi_geo->tramo;
			$arraycampos['margen']					= $ubi_geo->margen;
        	$arraycampos['proyecto']				= $arraycamposlevel1['proyecto'];
			$arraycampos['usuario']		    		= $arraycamposlevel1['usuario'];	
			$arraycampos['codigo_censal']			= $arraycamposlevel1['codigo_censal'];	
			$arraycampos['codigo']  				= $arraycamposlevel1['codigo'];
			$arraycampos['fichacensal_id']  		= $arraycamposlevel1['fichacensal_id'];	
        	$arraycamposjefe_flia['nacionalidad']   = $jefe_flia->nacionalidad;	
        	$arraycamposjefe_flia['nombreapellido'] = $jefe_flia->nombreapellido;	
        	$arraycamposjefe_flia['c_i']            = $jefe_flia->c_i;	

        
            $_SESSION['arraycampos'] 				= $arraycampos;
            $_SESSION['arraycamposjefe_flia'] 	    = $arraycamposjefe_flia;
        	
        
        
		    $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
        
        
        }
		/*
				ubi_geo_id 
				level_1_id
				fecha 
				departamento 
				distrito 
				zona_urbana 
				direccion 
				n_de_gps_x 
				n_de_gps_y 
				n_de_foto 
				tramo 
				margen 
		*/
		$this->data['fichacensal_id'] = array(
			'type'    => 'text',
			'name'    => 'fichacensal_id',
			'id'      => 'fichacensal_id',
			'value'   => $this->form_validation->set_value('ubi_geo_fichacensal_id', trim($ubi_geo->fichacensal_id)),
			'class'   => 'form-control',
			'readonly' => 'true'
			);
		$this->data['ubi_geo_id'] = array(
			'type'    => 'text',
			'name'    => 'ubi_geo_id',
			'id'      => 'ubi_geo_id',
			'value'   => $this->form_validation->set_value('ubi_geo_ubi_geo_id', trim($ubi_geo->ubi_geo_id)),
			'class'   => 'form-control',
			'readonly' => 'true'
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('ubi_geo_level_1_id', trim($ubi_geo->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['fecha'] = array(
			'type'     => 'text',
			'name'     => 'fecha',
			'id'       => 'fecha',
			'value'    => $this->form_validation->set_value('ubi_geo_fecha', trim($ubi_geo->fecha)),
			'class'    => 'form-control',
			'required' => 'true'
			);		
        $this->data['codigo_censal'] = array(
			'type'     => 'text',
			'name'     => 'codigo_censal',
			'pattern'  => '^([1-9][0-9]{0,19})?$',
			'id'       => 'codigo_censal',
			'value'    => $this->form_validation->set_value('codigo_censal', trim($level_1->codigo_censal)),
			'class'    => 'form-control',
            'maxlength'=> '4'
			);
		$this->data['codigo'] = array(
			'type'  => 'text',
			'name'  => 'codigo',
			'id'    => 'codigo',
			'value' => $this->form_validation->set_value('codigo', trim($level_1->codigo)),
			'class' => 'form-control',
            'maxlength'=> '10'
			);
		$this->data['direccion'] = array(
			'type'  => 'text',
			'name'  => 'direccion',
			'id'    => 'direccion',
			'value' => $this->form_validation->set_value('ubi_geo_direccion', trim($ubi_geo->direccion)),
			'class' => 'form-control',
            'maxlength'=> '60'
		);
		$this->data['n_de_gps_x'] = array(
			'type'  => 'text',
			'name'  => 'n_de_gps_x',
            'placeholder' => 'xxxxxx.xxxxxxxxx',
            'pattern'  => '^\d{0,6}(\.\d{0,9})?$',
			'id'    => 'n_de_gps_x',
			'value' => $this->form_validation->set_value('ubi_geo_n_de_gps_x', trim($ubi_geo->n_de_gps_x)),
			'class' => 'form-control',
            'maxlength'=> '16'
		);
		$this->data['n_de_gps_y'] = array(
			'type'  => 'text',
			'name'  => 'n_de_gps_y',
            'placeholder' => 'xxxxxxx.xxxxxxxx',
            'pattern'  => '^\d{0,7}(\.\d{0,8})?$',
			'id'    => 'n_de_gps_y',
			'value' => $this->form_validation->set_value('ubi_geo_n_de_gps_y', trim($ubi_geo->n_de_gps_y)),
			'class' => 'form-control',
            'maxlength'=> '16'
		);
		$this->data['n_de_gps_x_geo'] = array(
			'type'  => 'text',
			'name'  => 'n_de_gps_x_geo',
            'placeholder' => 'xx.xx.xx.x',
            'pattern'  => '^\d{0,2}(\°\d{0,2})?(\'\d{0,2})?(\.\d{0,1}\"\)?$',
			'id'    => 'n_de_gps_x_geo',
			'value' => $this->form_validation->set_value('ubi_geo_n_de_gps_x_geo', trim($ubi_geo->n_de_gps_x_geo)),
			'class' => 'form-control',
            'maxlength'=> '11'
		);
		$this->data['n_de_gps_y_geo'] = array(
			'type'  => 'text',
			'name'  => 'n_de_gps_y_geo',
            'placeholder' => 'xxx.xx.xx.x',
            'pattern'  => '^\d{0,3}(\°\d{0,2})?(\'\d{0,2})?(\.\d{0,1}\"\)?$',
			'id'    => 'n_de_gps_y_geo',
			'value' => $this->form_validation->set_value('ubi_geo_n_de_gps_y_geo', trim($ubi_geo->n_de_gps_y_geo)),
			'class' => 'form-control',
            'maxlength'=> '12'
		);
		$this->data['n_de_foto'] = array(
			'type'  => 'text',
			'name'  => 'n_de_foto',
			'id'    => 'n_de_foto',
			'value' => $this->form_validation->set_value('ubi_geo_n_de_foto', trim($ubi_geo->n_de_foto)),
			'class' => 'form-control',
            'maxlength'=> '10'
		);
		/*
		$this->data['departamento'] = array(
			'type'  => 'text',
			'name'  => 'departamento',
			'id'    => 'departamento',
			'value' => $this->form_validation->set_value('ubi_geo_departamento', trim($ubi_geo->departamento)),
			'class' => 'form-control'
		);
		$this->data['distrito'] = array(
			'type'  => 'text',
			'name'  => 'distrito',
			'id'    => 'distrito',
			'value' => $this->form_validation->set_value('ubi_geo_distrito', trim($ubi_geo->distrito)),
			'class' => 'form-control'
		);
		$this->data['zona_urbana'] = array(
			'type'  => 'text',
			'name'  => 'zona_urbana',
			'id'    => 'zona_urbana',
			'value' => $this->form_validation->set_value('ubi_geo_zona_urbana', trim($ubi_geo->zona_urbana)),
			'class' => 'form-control'
		);
		*/
		$this->data['tramo'] = array(
			'type'  => 'text',
			'name'  => 'tramo',
			'id'    => 'tramo',
			'value' => $this->form_validation->set_value('ubi_geo_tramo', trim($ubi_geo->tramo)),
			'class' => 'form-control',
            'maxlength'=> '60'
		);

		$proyectos[''] = 'Seleccione el proyecto';
		$proyecto = $this->censo_model->dropdown_data('v_proyectos',null,'id_proyecto')->result_array();
		foreach ($proyecto as $proy) {
			$proyectos[$proy['id_proyecto']] = $proy['id_proyecto'].' - '.$proy['nombre'];
		}
		$this->data['proyecto'] = $proyectos;
		$this->data['proyecto_sel'] = $ubi_geo->proyecto;

		$usuarios[''] = 'Seleccione el usuario';
		$usuario = $this->censo_model->dropdown_data('users',null,'id')->result_array();
		foreach ($usuario as $usr) {
			$usuarios[$usr['id']] = $usr['username'].' - '.$usr['id'].' - '.$usr['first_name'].' '.$usr['last_name'];
		}
		$this->data['usuario'] = $usuarios;
		$this->data['usuario_sel'] = $ubi_geo->usuario;		

		/*
		$this->data['margen'] = array(
			'type'  => 'text',
			'name'  => 'margen',
			'id'    => 'margen',
			'value' => $this->form_validation->set_value('ubi_geo_margen', trim($ubi_geo->margen)),
			'class' => 'form-control'
		);
		*/
		
		$departamentos[''] = 'Seleccione el departamento';
		$departamento = $this->censo_model->dropdown_data('departamentos',null,'cod_snc')->result_array();
		foreach ($departamento as $dep) {
			$departamentos[$dep['cod_snc']] = $dep['cod_snc'].' - '.$dep['dpto_desc'];
		}
		$this->data['departamento'] = $departamentos;
		$this->data['departamento_sel'] = $ubi_geo->departamento;

		$distritos[''] = 'Seleccione el distrito';
		$distrito = $this->censo_model->dropdown_data('distritos', array('dpto_snc' => $ubi_geo->departamento),'dist_snc')->result_array();
		foreach ($distrito as $dist) {
			$distritos[$dist['dist_snc']] = $dist['dist_snc'].' - '.$dist['dist_desc'];
		}
		$this->data['distrito'] = $distritos;
		$this->data['distrito_sel'] = $ubi_geo->distrito;
		
		$zona_urbana = $this->censo_model->concepto('ZONA_URBANA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($zona_urbana as $af) 
		{
			$zona_urbanas[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['zona_urbana'] = $zona_urbanas;

		if (ctype_space($ubi_geo->zona_urbana)) {
			$this->data['zona_urbana_sel'] = '  ';
		}else{
			$this->data['zona_urbana_sel'] = (int)$ubi_geo->zona_urbana;
		}
		
		$margen = $this->censo_model->concepto('MARGEN',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($margen as $af) 
		{
			$margens[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['margen'] = $margens;

		if (ctype_space($ubi_geo->margen)) {
			$this->data['margen_sel'] = '  ';
		}else{
			$this->data['margen_sel'] = (int)$ubi_geo->margen;
		}

		/* Load Template */
		$this->template->admin_render('censo/ubi_geo', $this->data);
		
	}

    public function trae_distritos_snc()
    {
        //$dpto      = $_GET['departamento'];
		$dpto      = $_POST['departamento'];


        $distritos = $this->censo_model->dropdown_data('distritos', array('dpto_snc' => $dpto))->result();

        echo '<option value="">Seleccione el distrito</option>';
        foreach ($distritos as $dist) {
            echo '<option value="' . $dist->dist_snc . '">' . $dist->dist_snc . ' - ' . $dist->dist_desc . '</option>';
        }

        //echo json_encode($distritos);
    }


}
//Llave de finalizacion de la clase