<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Org_vecinal extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];


		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'ORG_VECINAL') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'ORG_VECINAL') {
				
				$_SESSION['arraywhere_org_vecinal'] = NULL;
				$_SESSION['arraywhere_org_vecinal_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'ORG_VECINAL';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}


	public function org_vecinal_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('org_vecinal_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
		$org_vecinal = $this->censo_model->view('org_vecinal', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('org_vecinal_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['org_vecinal_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['org_vecinal_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['org_vecinal_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

/*
    org_vecinal_id
    level_1_id
    mayor_problema 
    mejora_en_el_barrio
    pertenece_a_algunaorgan 
    espacioparasociabili 
    nombre_vecinolderecho
    nombre_vecinolizquierdo 
    nombre_vecinofrente
    otraocupacion
    donde_otraocupacion 
    otroterreno
    donde_otroterreno 
    donde_semudarian
*/
		if ($_POST) {

			/*
			if ($_POST['org_vecinal_id']) 
			{
				$arraycampos['org_vecinal_id']                       = $_POST['org_vecinal_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}
			*/

			if (strlen(trim($_POST['mayor_problema'])) == 0) {
					$arraycampos['mayor_problema']   = NULL;
			} else {
					$arraycampos['mayor_problema']   = $_POST['mayor_problema'];
            }

			if (strlen(trim($_POST['mejora_en_el_barrio'])) == 0) {
					$arraycampos['mejora_en_el_barrio']   = NULL;
			} else {
					$arraycampos['mejora_en_el_barrio']   = $_POST['mejora_en_el_barrio'];
            }

			if (strlen(trim($_POST['pertenece_a_algunaorgan'])) == 0) {
					$arraycampos['pertenece_a_algunaorgan']   = NULL;
			} else {
					$arraycampos['pertenece_a_algunaorgan']   = $_POST['pertenece_a_algunaorgan'];
            }

			if (strlen(trim($_POST['espacioparasociabili'])) == 0) {
					$arraycampos['espacioparasociabili']   = NULL;
			} else {
					$arraycampos['espacioparasociabili']   = $_POST['espacioparasociabili'];
            }

			if (strlen(trim($_POST['nombre_vecinolderecho'])) == 0) {
					$arraycampos['nombre_vecinolderecho']   = NULL;
			} else {
					$arraycampos['nombre_vecinolderecho']   = $_POST['nombre_vecinolderecho'];
            }

			if (strlen(trim($_POST['nombre_vecinolizquierdo'])) == 0) {
					$arraycampos['nombre_vecinolizquierdo']   = NULL;
			} else {
					$arraycampos['nombre_vecinolizquierdo']   = $_POST['nombre_vecinolizquierdo'];
            }

			if (strlen(trim($_POST['nombre_vecinofrente'])) == 0) {
					$arraycampos['nombre_vecinofrente']   = NULL;
			} else {
					$arraycampos['nombre_vecinofrente']   = $_POST['nombre_vecinofrente'];
            }

			if ($_POST['dgsa_org_vecinal_otraocupacion']) 
			{
				$arraycampos['otraocupacion']        				= $_POST['dgsa_org_vecinal_otraocupacion'];
				if (trim($_POST['dgsa_org_vecinal_otraocupacion']) == '') {
					$arraycampos['otraocupacion']   = NULL;
				} else {
					$arraycampos['otraocupacion']   = (int)$_POST['dgsa_org_vecinal_otraocupacion'];
				}				
			}

			if (strlen(trim($_POST['donde_otraocupacion'])) == 0) {
					$arraycampos['donde_otraocupacion']   = NULL;
			} else {
					$arraycampos['donde_otraocupacion']   = $_POST['donde_otraocupacion'];
            }

			if ($_POST['dgsa_org_vecinal_otroterreno']) 
			{
				$arraycampos['otroterreno']        				= $_POST['dgsa_org_vecinal_otroterreno'];
				if (trim($_POST['dgsa_org_vecinal_otroterreno']) == '') {
					$arraycampos['otroterreno']   = NULL;
				} else {
					$arraycampos['otroterreno']   = (int)$_POST['dgsa_org_vecinal_otroterreno'];
				}				
			}

			if (strlen(trim($_POST['donde_otroterreno'])) == 0) {
					$arraycampos['donde_otroterreno']   = NULL;
			} else {
					$arraycampos['donde_otroterreno']   = $_POST['donde_otroterreno'];
            }

			if (strlen(trim($_POST['donde_semudarian'])) == 0) {
					$arraycampos['donde_semudarian']   = NULL;
			} else {
					$arraycampos['donde_semudarian']   = $_POST['donde_semudarian'];
            }

			/*
			if (grupo_usuario(6)) {			
				$this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']),
													 'monitoreo',
													 array('reg_modificado' => 1)
													);
			}
			*/

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'org_vecinal', $arraycampos);

			/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
			//función para validar pestaña
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['org_vecinal'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/****** Actualizar tabla MONITOREO Y ASIGNACIONLOTES *********************/
			/**
			 **Se actualiza el campo PROCESO pasa a ser A03
			**/

			//$monitoreoasignacion = $this->censo_model->view('monitoreo_verificador', array('id_registro_lote' => $_SESSION['identificador']))->row();
			//$org_vecinal = $this->censo_model->view('org_vecinal', array('id_registro_lote' => $_SESSION['identificador']))->row();
			/*if ($monitoreoasignacion->proceso == 'A04' || $monitoreoasignacion->proceso == 'A07') 
			{   
				$arraycampos1 = array('registro_analizado' => 0
					,'proceso'            => 'A03'
					//,'mapear'             => $org_vecinal->mapear
					);
						//show_error($org_vecinal->mapear. ' RECH ');
				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos1
					);

				$cantidad_reg_analizado = $monitoreoasignacion->cantidad_reg_analizado - 1;

				$arraycampos2 = array('cantidad_reg_analizado' => $cantidad_reg_analizado);
				$update_asignacion = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
																		  'asignacionlotes',
																		  $arraycampos2
																		  );
			}elseif ($monitoreoasignacion->proceso == 'A02' || $monitoreoasignacion->proceso == 'A03') 
			{

				if ((string)$monitoreoasignacion->fecha_procesado_4 == '0001-01-01' || 
					(string)$monitoreoasignacion->fecha_procesado_4 == '1970-01-01' || 
					$monitoreoasignacion->fecha_procesado_4 == null || 
					$monitoreoasignacion->fecha_procesado_4 == "" )  {
					$str = date_default_timezone_get();
					$fecha_procesado_4 =date("d/m/Y", strtotime($str));
					
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $org_vecinal->mapear
					,'procesado_4'		   => 1
					,'fecha_procesado_4'	   => $fecha_procesado_4
					
					);
				}
				else {

				$str = date_default_timezone_get();
				$fecha_procesado_4 = date("d/m/Y", strtotime($str));
				$arraycampos3 = array('proceso' 		   => 'A03'
					//,'mapear' 			   => $org_vecinal->mapear
					,'procesado_4'		   => 1
					
					);
				}


				//$arraycampos3 = array('proceso'            => 'A03',
				//					  'mapear'             => $org_vecinal->mapear
				//					  );
				

				$update_monitoreo = $this->censo_model->actualizar_censo(array('id_registro_lote' => $_SESSION['identificador']),
					'monitoreo',
					$arraycampos3
					);
				
				$str = date_default_timezone_get();
				$fecha = date("d/m/Y", strtotime($str));
				$arraycampos4 = array('fecha_inicio' => $fecha);

				$update_monitoreo = $this->censo_model->actualizar_censo(array('lote' => $monitoreoasignacion->lote),
					'asignacionlotes',
					$arraycampos4
					);
			}
			*/
			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/org_vecinal/org_vecinal_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

/*
org_vecinal_id
level_1_id
mayor_problema
mejora_en_el_barrio
pertenece_a_algunaorgan
espacioparasociabili
nombre_vecinolderecho
nombre_vecinolizquierdo
nombre_vecinofrente
otraocupacion
donde_otraocupacion
otroterreno
donde_otroterreno
donde_semudarian
*/


		$this->data['org_vecinal_id'] = array(
			'type'    => 'text',
			'name'    => 'org_vecinal_id',
			'id'      => 'org_vecinal_id',
			'value'   => $this->form_validation->set_value('org_vecinal_org_vecinal_id', trim($org_vecinal->org_vecinal_id)),
			'class'   => 'form-control',
			'readonly' => 'true'
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('org_vecinal_level_1_id', trim($org_vecinal->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['mayor_problema'] = array(
			'type'  => 'text',
			'name'  => 'mayor_problema',
			'id'    => 'mayor_problema',
			'value' => $this->form_validation->set_value('org_vecinal_mayor_problema', trim($org_vecinal->mayor_problema)),
			'class' => 'form-control',
            'maxlength'=> '50'
			);
		$this->data['mejora_en_el_barrio'] = array(
			'type'  => 'text',
			'name'  => 'mejora_en_el_barrio',
			'id'    => 'mejora_en_el_barrio',
			'value' => $this->form_validation->set_value('org_vecinal_mejora_en_el_barrio', trim($org_vecinal->mejora_en_el_barrio)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['pertenece_a_algunaorgan'] = array(
			'type'  => 'text',
			'name'  => 'pertenece_a_algunaorgan',
			'id'    => 'pertenece_a_algunaorgan',
			'value' => $this->form_validation->set_value('org_vecinal_pertenece_a_algunaorgan', trim($org_vecinal->pertenece_a_algunaorgan)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['espacioparasociabili'] = array(
			'type'  => 'text',
			'name'  => 'espacioparasociabili',
			'id'    => 'espacioparasociabili',
			'value' => $this->form_validation->set_value('org_vecinal_espacioparasociabili', trim($org_vecinal->espacioparasociabili)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['nombre_vecinolderecho'] = array(
			'type'  => 'text',
			'name'  => 'nombre_vecinolderecho',
			'id'    => 'nombre_vecinolderecho',
			'value' => $this->form_validation->set_value('org_vecinal_nombre_vecinolderecho', trim($org_vecinal->nombre_vecinolderecho)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['nombre_vecinolizquierdo'] = array(
			'type'  => 'text',
			'name'  => 'nombre_vecinolizquierdo',
			'id'    => 'nombre_vecinolizquierdo',
			'value' => $this->form_validation->set_value('org_vecinal_nombre_vecinolizquierdo', trim($org_vecinal->nombre_vecinolizquierdo)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['nombre_vecinofrente'] = array(
			'type'  => 'text',
			'name'  => 'nombre_vecinofrente',
			'id'    => 'nombre_vecinofrente',
			'value' => $this->form_validation->set_value('org_vecinal_nombre_vecinofrente', trim($org_vecinal->nombre_vecinofrente)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
		$this->data['donde_otraocupacion'] = array(
			'type'  => 'text',
			'name'  => 'donde_otraocupacion',
			'id'    => 'donde_otraocupacion',
			'value' => $this->form_validation->set_value('org_vecinal_donde_otraocupacion', trim($org_vecinal->donde_otraocupacion)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		$this->data['donde_otroterreno'] = array(
			'type'  => 'text',
			'name'  => 'donde_otroterreno',
			'id'    => 'donde_otroterreno',
			'value' => $this->form_validation->set_value('org_vecinal_donde_otroterreno', trim($org_vecinal->donde_otroterreno)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		$this->data['donde_semudarian'] = array(
			'type'  => 'text',
			'name'  => 'donde_semudarian',
			'id'    => 'donde_semudarian',
			'value' => $this->form_validation->set_value('org_vecinal_donde_semudarian', trim($org_vecinal->donde_semudarian)),
			'class' => 'form-control',
            'maxlength'=> '50'
		);
	
		
		$otraocupacion = $this->censo_model->concepto('OTRAOCUPACION',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($otraocupacion as $oc) 
		{
			$otraocupacions[$oc['concepto']] = $oc['concepto'].' - '.$oc['nombre'];
		}
		$this->data['otraocupacion'] = $otraocupacions;

		if (ctype_space($org_vecinal->otraocupacion)) {
			$this->data['otraocupacion_sel'] = '  ';
		}else{
			$this->data['otraocupacion_sel'] = (int)$org_vecinal->otraocupacion;
		}
		
		$otroterreno = $this->censo_model->concepto('OTROTERRENO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($otroterreno as $af) 
		{
			$otroterrenos[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['otroterreno'] = $otroterrenos;

		if (ctype_space($org_vecinal->otroterreno)) {
			$this->data['otroterreno_sel'] = '  ';
		}else{
			$this->data['otroterreno_sel'] = (int)$org_vecinal->otroterreno;
		}

		/* Load Template */
		$this->template->admin_render('censo/org_vecinal', $this->data);
		
	}

    public function trae_distritos_snc()
    {
        //$dpto      = $_GET['departamento'];
		$dpto      = $_POST['departamento'];


        $distritos = $this->censo_model->dropdown_data('distritos', array('dpto_snc' => $dpto))->result();

        echo '<option value="">Seleccione el distrito</option>';
        foreach ($distritos as $dist) {
            echo '<option value="' . $dist->dist_snc . '">' . $dist->dist_snc . ' - ' . $dist->dist_desc . '</option>';
        }

        //echo json_encode($distritos);
    }


}
//Llave de finalizacion de la clase