<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Identif_poblac extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];


		//echo '<pre>';
		//print_r($_SESSION['id_modulo_ant']);
		//echo '</pre>';
		//show_error(1);

		//if ($_SESSION['id_modulo'] != 'censos' AND $_SESSION['id_modulo'] != 'CONSULTAS_REG') {

		if ($_SESSION['id_modulo'] != 'UBI_GEO') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'UBI_GEO') {
				
				$_SESSION['arraywhere_identif_poblac'] = NULL;
				$_SESSION['arraywhere_identif_poblac_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'UBI_GEO';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}


	public function identif_poblac_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('identif_poblac_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;

		$identif_poblac = $this->censo_model->view('identif_poblac', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('identif_poblac_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['identif_poblac_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['identif_poblac_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['identif_poblac_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

/*
    identif_poblac_id 
    level_1_id
    identif_pob 
    comunidad 
    pueblo
    tiempo_de_salida 
    tiempo_de_estadia 
    motivo_migracion
    especificar_motivo_migracion 
    tipo_de_ocupacion
    condicion_vivienda
*/
		if ($_POST) {

			if ($_POST['identif_poblac_id']) 
			{
				$arraycampos['identif_poblac_id']                       = $_POST['identif_poblac_id'];
			}else{
				$arraycampos['identif_poblac_id']                       = NULL;
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   							= $_POST['level_1_id'];
			}else{
				$arraycampos['level_1_id']   							= NULL;
			}

			if ($_POST['dgsa_identif_poblac_identif_pob']) 
			{
				if (trim($_POST['dgsa_identif_poblac_identif_pob']) == '') {
					$arraycampos['identif_pob']   = NULL;
				} else {	
                    $arraycampos['identif_pob'] = (int)$_POST['dgsa_identif_poblac_identif_pob'];
				} 
            }

			if (strlen(trim($_POST['comunidad'])) == 0) {
					$arraycampos['comunidad']   = NULL;
			} else {
					$arraycampos['comunidad']   = $_POST['comunidad'];
			}

			if (strlen(trim($_POST['pueblo'])) == 0) {
					$arraycampos['pueblo']   = NULL;
			} else {
					$arraycampos['pueblo']   = $_POST['pueblo'];
			}

			if (strlen(trim($_POST['tiempo_de_salida'])) == 0) {
					$arraycampos['tiempo_de_salida']   = NULL;
			} else {
					$arraycampos['tiempo_de_salida']   = $_POST['tiempo_de_salida'];
			}

			if (strlen(trim($_POST['tiempo_de_estadia'])) == 0) {
					$arraycampos['tiempo_de_estadia']   = NULL;
			} else {
					$arraycampos['tiempo_de_estadia']   = $_POST['tiempo_de_estadia'];
			}

			if ($_POST['dgsa_identif_poblac_motivo_migracion']) 
			{
				if (trim($_POST['dgsa_identif_poblac_motivo_migracion']) == '') {
					$arraycampos['motivo_migracion']   = NULL;
				} else {	
                    $arraycampos['motivo_migracion'] = (int)$_POST['dgsa_identif_poblac_motivo_migracion'];
				} 
            }

			if (strlen(trim($_POST['especificar_motivo_migracion'])) == 0) {
					$arraycampos['especificar_motivo_migracion']   = NULL;
			} else {
					$arraycampos['especificar_motivo_migracion']   = $_POST['especificar_motivo_migracion'];
			}

			if ($_POST['dgsa_identif_poblac_tipo_de_ocupacion']) 
			{
				if (trim($_POST['dgsa_identif_poblac_tipo_de_ocupacion']) == '') {
					$arraycampos['tipo_de_ocupacion']   = NULL;
				} else {	
                    $arraycampos['tipo_de_ocupacion'] = (int)$_POST['dgsa_identif_poblac_tipo_de_ocupacion'];
				} 
            }

			if ($_POST['dgsa_identif_poblac_condicion_vivienda']) 
			{
				if (trim($_POST['dgsa_identif_poblac_condicion_vivienda']) == '') {
					$arraycampos['condicion_vivienda']   = NULL;
				} else {	
                    $arraycampos['condicion_vivienda'] = (int)$_POST['dgsa_identif_poblac_condicion_vivienda'];
				} 
            }


			/*
			if (grupo_usuario(6)) {			
				$this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']),
													 'monitoreo',
													 array('reg_modificado' => 1)
													);
			}
			*/

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador']), 'identif_poblac', $arraycampos);

			/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
			//función para validar pestaña
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
			//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['identif_poblac'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			
			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/identif_poblac/identif_poblac_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

/*
    identif_poblac_id 
    level_1_id
    identif_pob 
    comunidad 
    pueblo
    tiempo_de_salida 
    tiempo_de_estadia 
    motivo_migracion
    especificar_motivo_migracion 
    tipo_de_ocupacion
    condicion_vivienda
*/


		$this->data['identif_poblac_id'] = array(
			'type'    => 'text',
			'name'    => 'identif_poblac_id',
			'id'      => 'identif_poblac_id',
			'value'   => $this->form_validation->set_value('identif_poblac_identif_poblac_id', trim($identif_poblac->level_1_id)),
			'class'   => 'form-control',
			'readonly' => 'true'			
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('identif_poblac_level_1_id', trim($identif_poblac->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'	
			);
/*
		$this->data['identif_pob'] = array(
			'type'  => 'text',
			'name'  => 'identif_pob',
			'id'    => 'identif_pob',
			'value' => $this->form_validation->set_value('identif_poblac_identif_pob', trim($identif_poblac->identif_pob)),
			'class' => 'form-control'
			);
*/			
		$this->data['comunidad'] = array(
			'type'  => 'text',
			'name'  => 'comunidad',
			'id'    => 'comunidad',
			'value' => $this->form_validation->set_value('identif_poblac_comunidad', trim($identif_poblac->comunidad)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
		$this->data['pueblo'] = array(
			'type'  => 'text',
			'name'  => 'pueblo',
			'id'    => 'pueblo',
			'value' => $this->form_validation->set_value('identif_poblac_pueblo', trim($identif_poblac->pueblo)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
		$this->data['tiempo_de_salida'] = array(
			'type'  => 'text',
			'name'  => 'tiempo_de_salida',
			'id'    => 'tiempo_de_salida',
			'value' => $this->form_validation->set_value('identif_poblac_tiempo_de_salida', trim($identif_poblac->tiempo_de_salida)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
		$this->data['tiempo_de_estadia'] = array(
			'type'  => 'text',
			'name'  => 'tiempo_de_estadia',
			'id'    => 'tiempo_de_estadia',
			'value' => $this->form_validation->set_value('identif_poblac_tiempo_de_estadia', trim($identif_poblac->tiempo_de_estadia)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
/*
		$this->data['motivo_migracion'] = array(
			'type'  => 'text',
			'name'  => 'motivo_migracion',
			'id'    => 'motivo_migracion',
			'value' => $this->form_validation->set_value('identif_poblac_motivo_migracion', trim($identif_poblac->motivo_migracion)),
			'class' => 'form-control'
		);
*/		
		$this->data['especificar_motivo_migracion'] = array(
			'type'  => 'text',
			'name'  => 'especificar_motivo_migracion',
			'id'    => 'especificar_motivo_migracion',
			'value' => $this->form_validation->set_value('identif_poblac_especificar_motivo_migracion', trim($identif_poblac->especificar_motivo_migracion)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
/*
		$this->data['tipo_de_ocupacion'] = array(
			'type'  => 'text',
			'name'  => 'tipo_de_ocupacion',
			'id'    => 'tipo_de_ocupacion',
			'value' => $this->form_validation->set_value('identif_poblac_tipo_de_ocupacion', trim($identif_poblac->tipo_de_ocupacion)),
			'class' => 'form-control'
		);
		$this->data['condicion_vivienda'] = array(
			'type'  => 'text',
			'name'  => 'condicion_vivienda',
			'id'    => 'condicion_vivienda',
			'value' => $this->form_validation->set_value('identif_poblac_condicion_vivienda', trim($identif_poblac->condicion_vivienda)),
			'class' => 'form-control'
		);
*/
		$identif_pob = $this->censo_model->concepto('IDENTIF_POB',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($identif_pob as $af) 
		{
			$identif_pobs[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['identif_pob'] = $identif_pobs;

		if (ctype_space($identif_poblac->identif_pob)) {
			$this->data['identif_pob_sel'] = '  ';
		}else{
			$this->data['identif_pob_sel'] = (int)$identif_poblac->identif_pob;
		}	
		
		$motivo_migracion = $this->censo_model->concepto('MOTIVO_MIGRACION',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($motivo_migracion as $af) 
		{
			$motivo_migracions[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['motivo_migracion'] = $motivo_migracions;

		if (ctype_space($identif_poblac->motivo_migracion)) {
			$this->data['motivo_migracion_sel'] = '  ';
		}else{
			$this->data['motivo_migracion_sel'] = (int)$identif_poblac->motivo_migracion;
		}

		$tipo_de_ocupacion = $this->censo_model->concepto('TIPO_DE_OCUPACION',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($tipo_de_ocupacion as $af) 
		{
			$tipo_de_ocupacions[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['tipo_de_ocupacion'] = $tipo_de_ocupacions;

		if (ctype_space($identif_poblac->tipo_de_ocupacion)) {
			$this->data['tipo_de_ocupacion_sel'] = '  ';
		}else{
			$this->data['tipo_de_ocupacion_sel'] = (int)$identif_poblac->tipo_de_ocupacion;
		}

		$condicion_vivienda = $this->censo_model->concepto('CONDICION_VIVIENDA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($condicion_vivienda as $af) 
		{
			$condicion_viviendas[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['condicion_vivienda'] = $condicion_viviendas;

		if (ctype_space($identif_poblac->condicion_vivienda)) {
			$this->data['condicion_vivienda_sel'] = '  ';
		}else{
			$this->data['condicion_vivienda_sel'] = (int)$identif_poblac->condicion_vivienda;
		}
/*
		$departamentos[''] = 'Seleccione el departamento';
		$departamento = $this->censo_model->dropdown_data('departamento')->result_array();
		foreach ($departamento as $dep) {
			$departamentos[$dep['dpto_sncs']] = $dep['dpto_snc'].' - '.$dep['dpto_desc'];
		}
		$this->data['departamento'] = $departamentos;
		$this->data['departamento_sel'] = $identif_poblac->departamento;

		$distritos[''] = 'Seleccione el distrito';
		$distrito = $this->censo_model->dropdown_data('distrito', array('dpto_snc' => $identif_poblac->departamento))->result_array();
		foreach ($distrito as $dist) {
			$distritos[$dist['dist_snc']] = $dist['dist_snc'].' - '.$dist['dist_desc'];
		}
		$this->data['distrito'] = $distritos;
		$this->data['distrito_sel'] = $identif_poblac->distrito;
*/
		/* Load Template */
		$this->template->admin_render('censo/identif_poblac', $this->data);
	}

}
//Llave de finalizacion de la clase