<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auditoria extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('auditoria/auditoria_model');
		$this->lang->load('auditoria/auditoria_lang');


		/* Title Page :: Common */
		$this->page_title->push(lang('menu_auditoria'));
		$this->data['pagetitle'] = $this->page_title->show();
		$_SESSION['id_modulo'] = 'AUDITORIA';

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_auditoria'), 'admin/auditoria');
	}
	
	
	public function index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
			$this->data['breadcrumb'] = $this->breadcrumbs->show();
			// ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 										// resultados por por_pagina, 
				5, 											// segmento uri a leer, 
				5, 											// cantidad_enlaces,
				base_url().'auditoria/auditoria/index/',  	// url completa de la pagina paginada
				'auditoria'									//Se define si es de orden ASC(ascendente) o DESC(descendente)
				);

			$this->data['pagination'] 				= $mi_paginacion['pagination'];

			$this->data['auditoria']	  		= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 				// resultados por pagina
 				5,											// segmento uri a leer
 				'auditoria'								// el nombre de la tabla a consultar $nombre_tabla
 				)->result();
			// ----- Fin paginacion


			/*// ----- Paginacion Generica 
			$mi_paginacion = $this->ion_auth->paginacion_generica(
				12, 						// resultados por por_pagina, 
				4, 							// segmento uri a leer, 
				5, 							// cantidad_enlaces,
				base_url(). 'auditoria/auditoria/index/',  // url completa de la pagina paginada
				'auditoria',		// scheme y nombre de la tabla, para la consulta
				NULL
				);

			$this->data['pagination'] 		= $mi_paginacion['pagination'];

			$this->data['auditoria']	  	= $this->ion_auth_model->segmentador_paginas(
 				$mi_paginacion['per_page'], 	// resultados por pagina
 				4,								// segmento uri a leer
 				'auditoria',					// el nombre de la tabla a consultar $nombre_tabla
 				NULL
 				)->result();
			// ----- Fin paginacion*/

			//$this->data['auditoria'] = $this->auditoria_model->auditoria_all()->result();

			/* Load Template */
			$this->template->admin_render('auditoria/index', $this->data);
		}
	}
	
	public function mostrar($id)
	{
		
        /* Breadcrumbs */
        $this->breadcrumbs->unshift(2, lang('menu_auditoria'), 'auditoria/auditoria');
        $this->data['breadcrumb'] = $this->breadcrumbs->show();

        /* Data */
       //$id = (int) $id;

     //  	$this->data['auditoria_info'] = $this->auditoria_model->mostrar_all('auditoria',array('user_id' => $id))->row();
       	$this->data['auditoria_info'] = $this->auditoria_model->mostrar_all('auditoria',array('id' => $id))->row();
    
        /* Load Template */
		$this->template->admin_render('auditoria/mostrar', $this->data);
	} 

	  public function delete($id){

		$auditoria_delete = $this->auditoria_model->delete_auditoria($id);

		if ($sesion_delete)
		{
			$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
			redirect('auditoria/auditoria');
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
		}
	}
}