<?php

// Define la URL para el punto final del servicio web
$url = "http://cronos3:8080/consulta-meu/rest/PRObtenerExpediente";

// Prepara el cuerpo de la solicitud con datos de JSON
$requestBody = json_encode(array("anho" => 2018, "nroexpediente" => 35480));

// Establece encabezados para la solicitud
$headers = array(
  "Content-Type: application/json",
);

// Inicializa el recurso cURL
$ch = curl_init($url);

// Establece opciones cURL
curl_setopt_array($ch, array(
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST => true,
  CURLOPT_POSTFIELDS => $requestBody,
  CURLOPT_HTTPHEADER => $headers,
));

// Ejecuta la solicitud y captura la respuesta
$response = curl_exec($ch);

// Verifica errores de cURL
if (curl_errno($ch)) {
  echo "Error: " . curl_error($ch);
  exit();
}

// Cierra el recurso cURL
curl_close($ch);

// Decodifica la respuesta JSON
$decodedResponse = json_decode($response, true);

// Verifica si la respuesta se decodificó correctamente
if ($decodedResponse) {
  // Extrae los datos principales de la respuesta
  $expedienteData = $decodedResponse['SDTExpediente'];

  // Imprime la respuesta con etiquetas HTML para un mejor formato
  echo "<!DOCTYPE html>";
  echo "<html>";
  echo "<head>";
  echo "<title>Información del Expediente</title>";
  echo "</head>";
  echo "<body>";

  echo "<h1>Información del Expediente</h1>";
  echo "<ul>";
  echo "  <li>Año: {$expedienteData['Anho']}</li>";
  echo "  <li>Dependencia Actual: {$expedienteData['DependenciaActual']}</li>";
  echo "  <li>Dirección Actual: {$expedienteData['DireccionActual']}</li>";
  echo "  <li>Estado Actual: {$expedienteData['EstadoActual']}</li>";
  echo "  <li>Fecha Actual: {$expedienteData['FechaActual']}</li>";
  echo "  <li>Hora Actual: {$expedienteData['HoraActual']}</li>";
  echo "</ul>";

  // Itera a través del historial de movimientos
  echo "<h2>Movimiento</h2>";
  echo "<ul>";
  $movimiento = $expedienteData['Movimiento'];
  foreach ($movimiento as $movimientoItem) {
    echo "  <li>";
    echo "    <strong>Dependencia 1:</strong> {$movimientoItem['Dependencia1']}<br>";
    echo "    <strong>Dependencia 2:</strong> {$movimientoItem['Dependencia2']}<br>";
    echo "    <strong>Dirección 1:</strong> {$movimientoItem['Direccion1']}<br>";
    echo "    <strong>Dirección 2:</strong> {$movimientoItem['Direccion2']}<br>";
    echo "    <strong>Estado 1:</strong> {$movimientoItem['Estado1']}<br>";
    echo "    <strong>Estado 2:</strong> {$movimientoItem['Estado2']}<br>";
    echo "    <strong>Fecha:</strong> {$movimientoItem['Fecha']}<br>";
    echo "    <strong>Hora:</strong> {$movimientoItem['Hora']}<br>";
    echo "    <strong>Número:</strong> {$movimientoItem['Numero']}<br>";
    echo "  </li>";
  }
  echo "</ul>";

  // Imprime detalles adicionales
  echo "<h2>Información Adicional</h2>";
  echo "<ul>";
  echo "  <li>Número: {$expedienteData['Numero']}</li>";
  echo "  <li>Referencia: {$expedienteData['Referencia']}</li>";
  echo "  <li>Tipo: {$expedienteData['Tipo']}</li>";
  echo "  <li>Titular: {$expedienteData['Titular']}</li>";
  echo "  <li>Tópico: {$expedienteData['Topico']}</li>";
  echo "</ul>";

  echo "</body>";
  echo "</html>";
} else {
  echo "Error al decodificar la respuesta JSON.";
}

?>
