<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Expedientes_model extends Ion_auth_model
{

    public function __construct()
    {
        parent::__construct();
    }

    /**
     * geocolonias
     *
     * @return object
     * @author Ben Edmunds
     **/
    public function view_all()
    {
        //$this->trigger_events('geocolonias');

        // run each where that was passed


        if (isset($this->_ion_where) && !empty($this->_ion_where)) {
            foreach ($this->_ion_where as $where) {
                $this->db->where($where);
            }
            $this->_ion_where = array();
        }

        if (isset($this->_ion_limit) && isset($this->_ion_offset)) {
            $this->db->limit($this->_ion_limit, $this->_ion_offset);

            $this->_ion_limit  = null;
            $this->_ion_offset = null;
        } else if (isset($this->_ion_limit)) {
            $this->db->limit($this->_ion_limit);

            $this->_ion_limit  = null;
        }

        // set the order
        if (isset($this->_ion_order_by) && isset($this->_ion_order)) {
            $this->db->order_by($this->_ion_order_by, $this->_ion_order);
        }

        $this->response = $this->db->get($this->tables['geocolonias']);

        return $this;
    }

    public function dropdown_data($tabla = null, $where = null, $order_by = null)  
    {
        $this->response = $this->db->select('*');
        $this->response = $this->db->from($this->tables[$tabla]);

        if ($where != null) {
            foreach ($where as $k => $v) {
                $this->response = $this->db->where($k, $v);
            }
        }

        $this->response = $this->db->order_by($order_by);
        $this->response = $this->db->get();
        //$this->response = $this->db->get_where($this->tables[$tabla],$where);

        return $this;
    }


    public function select_data($tabla = null, $where = null)
    {
        $this->response = $this->db->get_where($this->tables[$tabla], $where);

        //return $this;
    }


    /**
     * Expedientes
     *
     * @return object
     * @author Ben Edmunds
     **/
    public function view($tabla = null, $where = null, $order_by = null)
    {
        $this->trigger_events('expedientes');

        $this->response = $this->db->get_where($this->tables[$tabla], $where, null, null, $order_by);

        return $this;
    }


    /**
     * Expedientes
     *
     * @return object
     * @author Ben Edmunds
     **/
    public function view_registro_null($tabla = null)
    {
        $this->trigger_events($tabla);

        $this->response = $this->db->query('select * from '.$this->tables[$tabla].' limit 1');

        return $this;
    }


    /**
     * existe_grafico
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function existe_grafico($exp = null, $gest = null)
    {
        $resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO('".$exp."',".$gest.");");

        return $resultado;
    }


    /**
     * existe_grafico_expe_id
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function existe_grafico_expe_id($expe_id = null, $codigo = null, $id_proyecto = null)
    {
        $resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_EXPE_ID(".$expe_id.");");

        return $resultado;
    }


    /**
     * f_existe_grafico_expe_id
     *
     * @return int
     * @author Jaime Rojas
     **/
    /*public function f_existe_grafico_expe_id($expe_id = null)
    {
        $resultado = $this->db->query("SELECT IDE.F_EXISTE_GRAFICO_EXPE_ID(".$expe_id.");")->row()->f_existe_grafico_expe_id;

        return $resultado;
    }*/





    /**
     * actualizar_shapes
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function actualizar_shapes($id_expediente = NULL, $codigo = NULL, $id_proyecto = NULL, $id_epsg = NULL)
    {

        $resultado = $this->db->query("SELECT ide.actualizar_shapes(".$id_expediente.",'".$codigo."',".$id_proyecto.",".$id_epsg.");");

        return $resultado;
    }
/**
     * actualizar_shapes
     *
     * @return int
     * @author Gustavo Lopez
     **/
    public function f_crear_resto_pol_afectacion_y_terreno($id_expediente = NULL)
    {

        $resultado = $this->db->query("SELECT ide.f_crear_resto_pol_afectacion_y_terreno(".$id_expediente.");");

        return $resultado;
    }
     /*
     * actualizar_shapes
     *
     * @return int
     * @author Jaime Rojas 
     **/
    public function f_crear_resto_pol_fd_y_terreno($id_expediente = NULL)
    {

        $resultado = $this->db->query("SELECT ide.f_crear_resto_pol_fd_y_terreno(".$id_expediente.");");

        return $resultado;
    }


    /**
     * importar_coordenadas
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function importar_coordenadas($id_expediente = NULL, $id_epsg = NULL)
    {

        $resultado = $this->db->query("SELECT ide.importar_coordenadas(".$id_expediente.",".$id_epsg.");");

        return $resultado;
    }



    /**
     * eliminar_sobrepuestos
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function eliminar_sobrepuestos($id_expediente = NULL)
    {

        $resultado = $this->db->query("SELECT ide.f_eliminar_sobrepuestos(".$id_expediente.");");

        return $resultado;
    }





    /**
     * eliminar_geometrias
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function eliminar_geometrias($id_expediente = NULL, $id_proyecto = NULL, $codigo = NULL)
    {
        $resultado = $this->db->query("select ide.f_eliminar_geometrias(".$id_expediente.");");

        return $resultado;
    }



    /**
     * contador_registros
     *  Obtiene la cantidad de registro de una tabla y condición dada
     * @return int
     * @author Diego Ferreira
     **/
    public function contador_registros($tabla = null, $arraywhere = null)
    {
        foreach ($arraywhere as $k => $v) {
            $this->db->where($k, $v);
        }
        $this->db->from($this->tables[$tabla]);
        return $this->db->count_all_results();
    }

    /**
     * obtener_nextval
     *
     * @return int
     * @author Jaime Rojas
     **/
    public function obtener_nextval($sequence)
    {
        $seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

        return $seq;
    }

    public function buscar_geo($abuscar)
    {
        //usamos after para decir que empiece a buscar por
        //el principio de la cadena
        //ej SELECT poblacion from poblacion
        //WHERE poblacion LIKE '%$abuscar' limit 12
        //$this->db->select('geocolonias');

        //$this->db->like('poblacion',$abuscar,'after');

        $resultados = $this->db->get('geocoloniaS');

        //si existe algún resultado lo devolvemos
        if ($resultados->num_rows() > 0) {
            return $resultados->result();

        //en otro caso devolvemos false
        } else {
            return false;
        }
    }



    /**
     * crear_expediente
     *
     * @return integer
     * @author Jonathan Merlo
    */
    public function crear_expediente($arraycampos = null)
    {
        // bail if the group name already exists
        $existe_expediente = $this->db->get_where($this->tables['expedientes'], $arraycampos)->num_rows();


        if ($existe_expediente !== 0) {
            $this->ion_auth->set_error('expedientes_already_exists');
            return false;
        }

        // insert the new expediente
        $arraycampos['ubi_estado'] = "PENDIENTE";
        $arraycampos['dao_estado'] = "PENDIENTE";
        $arraycampos['daj_estado'] = "PENDIENTE";
        $this->db->insert($this->tables['expedientes'], $arraycampos);
        $expe_id = $this->db->query("SELECT MAX(id) FROM ide.expedientes;")->row()->max;


        //$expe_id = $this->db->insert_id();

        // report success
        $this->ion_auth->set_message('expedientes_creation_successful');
        // return the brand new group id
        return $expe_id;
    }


    /**
     * actualizar_expediente
     *
     * @return bool
     * @author Jaime Rojas
     **/
    public function actualizar_expediente($expe_id = null, $arraycampos = null)
    {

        $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));

        $this->set_message('expedientes_update_successful');

        return 'TRUE';
    }

    public function mensaje_error($expe_id = NULL)
	{
		$this->response = $this->db->query("SELECT descrip_error FROM ide.errores where id_exp=".$expe_id.";");
		return $this;
	}

    public function aprobar_expediente($expe_id = false, $arraycampos = null, $area = null)
    {
        switch ($area) {
            case 'dao':
                $arraycampos['editable_dao'] = false;
                $arraycampos['dao_estado'] = "APROBADO";
                $arraycampos['dao_fecha_aprobacion'] = date('d/m/Y');
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
            case 'daj':
                $arraycampos['editable_daj'] = false;
                $arraycampos['daj_estado'] = "APROBADO";
                $arraycampos['daj_fecha_aprobacion'] = date('d/m/Y');
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
            case 'ubi':
                $arraycampos['editable_ubi'] = false;
                $arraycampos['ubi_estado'] = "APROBADO";
                $arraycampos['ubi_fecha_aprobacion'] = date('d/m/Y');
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
        }
        return 'TRUE';
    }

    public function habilitar_expediente($expe_id, $arraycampos = null, $area = null)
    {
        switch ($area) {
            case 'dao':
                $arraycampos['editable_dao'] = true;
                $arraycampos['dao_estado'] = "PENDIENTE";
                $arraycampos['dao_fecha_aprobacion'] = null;
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
            case 'daj':
                $arraycampos['editable_daj'] = true;
                $arraycampos['daj_estado'] = "PENDIENTE";
                $arraycampos['daj_fecha_aprobacion'] = null;
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
            case 'ubi':
                $arraycampos['editable_ubi'] = true;
                $arraycampos['ubi_estado'] = "PENDIENTE";
                $arraycampos['ubi_fecha_aprobacion'] = null;
                $this->db->update($this->tables['expedientes'], $arraycampos, array('id' => $expe_id));
                break;
        }
        return 'TRUE';
    }

    public function guardar_coordenadas($expe_id, $coordenadas = null, $coordenadas_existentes = null)
    {
        if (is_array($coordenadas) and !empty($coordenadas)) {
            $i = 0;

            if (!empty($coordenadas_existentes)) {
                $e = 0;
                foreach ($coordenadas_existentes as $coordenada_existente) {
                    if ($coordenadas[$e]['nro'] != $coordenada_existente['nro']) {              ////////////////////////////
                        $this->db->delete($this->tables['coordenadas'], array('id_expediente' => $expe_id, 'nro' => $coordenada_existente['nro']));
                    }
                     $e++;
                }
                foreach ($coordenadas as $coordenada) {
                    if ($coordenada['nro'] == $coordenadas_existentes[$i]['nro']) {             ////////////////////////////
                        $this->db->update($this->tables['coordenadas'], array('coordenada_e' => $coordenada['E'][$i], 'coordenada_n' => $coordenada['N'][$i]), array('id_expediente' => $expe_id, 'nro' => $i+1));
                    } else {
                        $this->db->insert($this->tables['coordenadas'], array('coordenada_e' => $coordenada['E'][$i], 'coordenada_n' => $coordenada['N'][$i], 'id_expediente' => $expe_id, 'nro' => $i+1));
                    }
                    $i++;
                }
            } else {
                foreach ($coordenadas as $coor) {
                    $this->db->insert($this->tables['coordenadas'], array('coordenada_e' => $coor['E'][$i], 'coordenada_n' => $coor['N'][$i], 'id_expediente' => $expe_id, 'nro' => $i+1));
                    $i++;
                }
            }
            return 'TRUE';
        } else {
            $this->db->delete($this->tables['coordenadas'], array('id_expediente' => $expe_id));
        }
    }

    public function guardar_linderos($expe_id, $linderos = null)
    {
        if (is_array($linderos) and !empty($linderos)) {
             $i = 0;
            foreach ($linderos as $lind) {
                $this->db->update($this->tables['coordenadas'], array('lindero' => $lind['lindero']), array('nro' => $i+1, 'id_expediente' => $expe_id));
                $i++;
            }
            
            return 'TRUE';
        } else {
            return 'FALSE';
        }
    }

    public function guardar_observacion($expe_id = null, $observaciones = null, $area = null)
    {
        if (is_array($observaciones)) {
            foreach ($observaciones as $ob) {
                $this->db->insert($this->tables['exp_observ'], array('nombre_campo' => $ob['nombre'], 'descripcion' => $ob['valor'], 'expediente_id' => $expe_id, 'area' => $area));
            }
        }

        return 'TRUE';
    }

    public function guardar_documento($expe_id, $documentos = null)
    {

        if (!empty($documentos)) {
            if (!is_array($documentos)) {
                $documentos = array($documentos);
            }
            $this->db->delete($this->tables['documentos'], array('expediente_id' => $expe_id));

            foreach ($documentos as $doc) {
                $this->db->insert($this->tables['documentos'], array('tipo_documento_id' => $doc, 'expediente_id' => $expe_id));
            }
        } else {
            $this->db->delete($this->tables['documentos'], array('expediente_id' => $expe_id));
        }

        return 'TRUE';
    }

    public function guardar_archivo($id, $codigo, $nompdf, $ruta_completa, $expediente_pdf)
    {
        $archivo = $this->db->get_where($this->tables['documentos_sge'], array('id_expediente' => $id, 'ruta_completa' => $ruta_completa))->num_rows();

        if ($archivo !== 0) {
            $this->db->update($this->tables['documentos_sge'], array('fecha_insercion' => date('Y-m-d H:i')), array('id_expediente' => $id, 'ruta_completa' => $ruta_completa, 'expediente_pdf' => $expediente_pdf));
        } else {
            $this->db->insert($this->tables['documentos_sge'], array('id_expediente' => $id, 'archivo' => $nompdf, 'ruta_completa' => $ruta_completa, 'expediente_pdf' => $expediente_pdf));
        }

        return 'TRUE';
    }

    public function eliminar_archivo($id)
    {
        $this->db->delete($this->tables['documentos_sge'], array('id' => $id));
        return true;
    }

    public function observacion_area($expe_id, $area = null, $rangoFecha = null)
    {
        if (isset($rangoFecha)) {
            $inicio = substr($rangoFecha, 0, strpos($rangoFecha, "--"));
            $fin = substr($rangoFecha, 12, strpos($rangoFecha, "--"));

            $fechaInicio = date("Y-m-d", strtotime(str_replace('/', '-', $inicio)));
            $fechaFin =    date("Y-m-d 23:59", strtotime(str_replace('/', '-', $fin)));

            $observaciones = $this->db->get_where($this->tables['exp_observ'], array('expediente_id' => $expe_id, 'area' => $area, 'fecha_observacion >=' => $fechaInicio, 'fecha_observacion <=' => $fechaFin), null, null, array('column' => 'fecha_observacion', 'direction' => 'ASC'))->result_array();
        } else {
            $observaciones = $this->db->get_where($this->tables['exp_observ'], array('expediente_id' => $expe_id, 'area' => $area), null, null, array('column' => 'fecha_observacion', 'direction' => 'ASC'))->result_array();
        }
        
        $observaciones_area = array();

        foreach ($observaciones as $obs) {
            switch ($area) {
                case 'ubi':
                    if ($obs['nombre_campo'] == 'plano_inmueble') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Plano de inmueble';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'informe_pericial') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Informe pericial';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'planilla_superficie') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Planilla de superficie';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    break;
                case 'dao':
                    if ($obs['nombre_campo'] == 'plano_mejoras') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Plano de mejoras';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'planilla_terreno') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Planilla de cálculo del valor del terreno';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'gastos_transferencia') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Gastos de transferencia';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'planilla_forestal') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Planilla agroforestal';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'avaluo_conformidad') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Notificación de avalúo y conformidad';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    break;
                case 'daj':
                    if ($obs['nombre_campo'] == 'condicion_dominio') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Condición de dominio';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'documentacion_faltante') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Documentación faltante';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'notificacion_avaluo') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Notificación de avalúo';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'conformidad_afectado') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Conformidad del afectado';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    break;
                case 'fin':
                    if ($obs['nombre_campo'] == 'avance') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Avance';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    break;
                default:
                    if ($obs['nombre_campo'] == 'caratula') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Carátula';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'cedula_identidad') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Cédula de notificación';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    if ($obs['nombre_campo'] == 'autorizacion') {
                        $areaObs['fecha'] = $obs['fecha_observacion'];
                        $areaObs['nombre'] = 'Autorización';
                        $areaObs['descripcion'] = $obs['descripcion'];
                        array_push($observaciones_area, $areaObs);
                    }
                    
                    break;
            }
        }
        return $observaciones_area;
    }


    /**
     * valor_maximo
     *  Obtiene el valor máximo de una columna y tabla específica
     * @return int
     * @author Diego Ferreira
     **/
    public function valor_maximo($tabla = null, $columna = null, $arraywhere = null)
    {
        $this->db->select("MAX(".$columna.") max");

        if ($arraywhere != null) {
            foreach ($arraywhere as $k => $v) {
                $this->db->where($k, $v);
            }
        }

        $this->db->from($this->tables[$tabla]);

        return $this->db->get()->row()->max;
    }


    /**
     * campo_valor_maximo
     *  Obtiene el valor máximo de una columna y tabla específica
     * @return int
     * @author Jaime Rojas
     **/
    public function obtener_valor_campo($tabla = null, $columna = null, $arraywhere = null)
    {
        $this->db->select($columna." campo");

        foreach ($arraywhere as $k => $v) {
            $this->db->where($k, $v);
        }

        $this->db->from($this->tables[$tabla]);

        return $this->db->get()->row()->campo;
    }

    /**
     * campo_valor_maximo
     *  Obtiene el valor máximo de una columna y tabla específica
     * @return int
     * @author Jaime Rojas
     **/
    public function campo_valor_maximo($tabla = null, $columna = null, $arraywhere = null)
    {
        $this->db->select("MAX(".$columna.") max");

        foreach ($arraywhere as $k => $v) {
            $this->db->where($k, $v);
        }

        $this->db->from($this->tables[$tabla]);

        return $this->db->get()->row()->max;
    }

    /**
     * eliminar_expediente
     *  Obtiene el valor máximo de una columna y tabla específica
     * @return int
     * @author Jaime Rojas
     **/
    public function eliminar_expediente($expe_id)
    {
        $this->db->delete($this->tables['historial_meu'], array('expediente_id' => $expe_id));
        $this->db->delete($this->tables['historial_fecha_ingreso'], array('expediente_id' => $expe_id));
        $this->db->delete($this->tables['historial_notificacion'], array('expediente_id' => $expe_id));
        $this->db->delete($this->tables['exp_observ'], array('expediente_id' => $expe_id));
        $this->db->delete($this->tables['documentos'], array('expediente_id' => $expe_id));
        $this->db->delete($this->tables['documentos_sge'], array('id_expediente' => $expe_id));
        $this->db->delete($this->tables['coordenadas'], array('id_expediente' => $expe_id));
        $this->db->delete($this->tables['expedientes'], array('id' => $expe_id));
        return true;
    }

    /**
     * eliminar_licencia
     *  Obtiene el valor máximo de una columna y tabla específica
     * @return int
     * @author Jaime Rojas
     **/

    public function departamentos()
    {
        $this->response = $this->db->get($this->tables['departamentos']);

        return $this;
    }

    public function distritos()
    {
        $this->response = $this->db->query("SELECT * FROM INDERT.DISTRITOS ORDER BY DISTRITO");
        return $this;
    }

    //PAGINATION
    public function get_pagination($number_per_page)
    {
        if ($this->uri->segment(5) == null | $this->uri->segment(5) == '') {
            $this->response = $this->db->get($this->tables['geocolonias'], $number_per_page, 0);
        } else {
            $this->response = $this->db->get($this->tables['geocolonias'], $number_per_page, $this->uri->segment(5));
        }

        return $this;
    }

    public function dir_is_empty($dir)
    {
        $iterator = new \FilesystemIterator($dir);
        $isDirEmpty = !$iterator->valid();
        return $isDirEmpty;
    }

    public function num_post()
    {
        $number = $this->db->query("SELECT count(*) as number FROM indert.geocolonia")->row()->number; //rápido
        return intval($number);
    }



    public function mapabb($expe_id)
    {


            $i_sql = "select ";
            $i_sql = $i_sql. "round(cast((x.campo1+x.campo1*(0.0002)) as decimal),13) as ext1, ";
            $i_sql = $i_sql. "round(cast((x.campo2+x.campo2*(0.0002)) as decimal),13) as ext2, ";
            $i_sql = $i_sql. "round(cast((x.campo3-x.campo3*(0.0002)) as decimal),13) as ext3, ";
            $i_sql = $i_sql. "round(cast((x.campo4-x.campo4*(0.0002)) as decimal),13) as ext4 ";
            $i_sql = $i_sql. "from ";
            $i_sql = $i_sql. "(";

            $i_sql = $i_sql. "select ";
            $i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[1] as decimal) as campo1,";
            $i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[2] as decimal) as campo2,";
            $i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[3] as decimal) as campo3,";
            $i_sql = $i_sql. "cast((regexp_split_to_array(bb, E','))[4] as decimal) as campo4";
            $i_sql = $i_sql. " from ( ";

            $i_sql = $i_sql . "select ";
            $i_sql = $i_sql . "replace(";
            $i_sql = $i_sql . "replace(substr(cast(a.bb as varchar),5),' ',',')";
            $i_sql = $i_sql . ",')','') as bb ";
            $i_sql = $i_sql . "FROM (select ST_Extent(the_geom) as bb ";
            $i_sql = $i_sql . "from i3geo.MOPC_poligono ";
            $i_sql = $i_sql . "where expe_id=" . $expe_id . " ";
            $i_sql = $i_sql . "group by expe_id) as a) as t1 ";
            //$i_sql = $i_sql . ";";
            $i_sql = $i_sql . ") as x;";

            $response = $this->db->query($i_sql)->result_array();

            return $response;
    }


    /**f_existe_coordafecta
     * f_existe_licencia_expe_id
     *
     * @return int
     * @author Gustavo Lopez
     **/
    public function f_existe_coordafecta($coord_id_expediente=NULL,$coord_id_terreno=NULL,$coord_id_afecta=NULL,$coord_orden=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from ide.coordafecta where id_expediente =".$coord_id_expediente." AND id_terreno=".$coord_id_terreno." AND id_afecta =".$coord_id_afecta." AND orden=".$coord_orden.";")->row()->cnt;

        return $resultado;
    }


    /**insertar_corrdafecta
     * f_existe_licencia_expe_id
     *
     * @return int
     * @author Gustavo Lopez
     **/


    public function insertar_coordafecta($arraycampos = NULL)
    {
       // bail if the group name already exists
        $existe_coordafecta = $this->db->get_where($this->tables['coordafecta'], $arraycampos)->num_rows();


        if($existe_coordafecta !== 0)
        {
            $this->ion_auth->set_error('coordafecta_already_exists');
            return FALSE;
        }
        else
        {
            try {
                // insert the new expediente
                $this->db->insert($this->tables['coordafecta'], $arraycampos);
                //$expe_id = $this->db->insert_id();
                //$this->ion_auth->set_message('coordafecta_creation_successful');
                return  TRUE;
            } catch(Exception $e) {
                //echo 'Message: ' .$e->getMessage();
                //$this->ion_auth->set_message('coordafecta_creation_successful');
                return  FALSE;
            }

            // report success

            // return the brand new group id

        }
    }


    /**
     * actualizar_corrdafecta
     *
     * @return bool
     * @author Gustavo Lopez
     **/
    public function actualizar_corrdafecta($coord_id_expediente = NULL,$coord_id_terreno = NULL,$coord_id_afecta=NULL,$coord_orden = NULL,$arraycampos=NULL)
    {

        $this->db->update($this->tables['coordafecta'], $arraycampos, array('id_expediente' => $coord_id_expediente, 'id_terreno' => $coord_id_terreno, 'id_afecta' => $coord_id_afecta, 'orden' => $coord_orden));

        $this->set_message('expedientes_update_successful');

        return 'TRUE';

    }

    public function eliminar_coordafecta($id = NULL)
    {

        $resultado_off = $this->db->query("delete from ide.coordafecta where id = ".$id);
        $resultado = $this->db->query("SELECT count (*) cnt from ide.coordafecta where id =".$id.";")->row()->cnt;

        return $resultado;
    }

    public function generar_geometrias($id_proyecto = NULL,$expe_id = FALSE)
    {

         $resultado = $this->db->query("SELECT ide.f_generar_geometrias(".$id_proyecto.",".$expe_id.");");


        return $resultado;
    }

    public function validar_geometrias($expe_id = NULL)
    {

         $resultado = $this->db->query("SELECT ide.f_validar_geometrias(".$expe_id.");");


        return $resultado;
    }

    public function pericias_afectaciones_exp($expe_id = NULL)
    {

         $resultado = $this->db->query("SELECT ide.pericias_afectaciones_exp(".$expe_id.");");


        return $resultado;
    }

    public function contar_puntos($id_expediente=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from ide.v_validar_afectacion_coord where id_exp =".$id_expediente.";")->row()->cnt;

        return $resultado;
    }

    public function contar_ciper($id_expediente=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from ide.afectaciones_ciper1 where id_exp =".$id_expediente.";")->row()->cnt;

        return $resultado;
    }

    public function contar_genper($id_expediente=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from ide.afectaciones_genper1 where id_exp =".$id_expediente.";")->row()->cnt;

        return $resultado;
    }

    public function contar_v_ciper($id_expediente=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from jmap.v_afectaciones_ciper_a where id_exp =".$id_expediente.";")->row()->cnt;

        return $resultado;
    }

    public function contar_v_genper($id_expediente=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from jmap.v_afectaciones_genper_a where id_exp =".$id_expediente.";")->row()->cnt;

        return $resultado;
    }

    public function validar_afectacion_coord($id_expediente=NULL,$validacion=NULL)
    {
        $resultado = $this->db->query("SELECT count (*) cnt from ide.v_validar_afectacion_coord where id_exp =".$id_expediente." AND validacion=".$validacion.";")->row()->cnt;

        return $resultado;
    }

}
