<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Censo_model extends Ion_auth_model {
	
    public function __construct()
    {
        parent::__construct();
	}
/*********************** UBI_GEO *******************************/
	/**
	 * ubi_geo
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function ubi_geo()
	{ 
		$this->trigger_events('ubi_geo');

		$this->response = $this->db->get($this->tables['ubi_geo']);

		return $this; 
	}

/*********************** IDENTIF_POBLAC *******************************/
	/**
	 * identif_poblac
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function identif_poblac()
	{ 
		$this->trigger_events('identif_poblac');

		$this->response = $this->db->get($this->tables['identif_poblac']);

		return $this; 
	}	
	
/*********************** JEFE__FLIA *******************************/
	/**
	 * jefe_flia
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function jefe_flia()
	{ 
		$this->trigger_events('jefe_flia');

		$this->response = $this->db->get($this->tables['jefe_flia']);

		return $this; 
	}
	
/*********************** SALUD *******************************/
	/**
	 * salud
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Maria Eugenia Gonzales
	 **/
	public function salud()
	{ 
		$this->trigger_events('salud');

		$this->response = $this->db->get($this->tables['salud']);

		return $this; 
	}	

/*********************** SALUD2 *******************************/
	/**
	 * salud
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Maria Eugenia Gonzales
	 **/
	public function salud2()
	{ 
		$this->trigger_events('salud');

		$this->response = $this->db->get($this->tables['salud2']);

		return $this; 
	}	

/*********************** SERV_BASICOS *******************************/
	/**
	 * serv_basicos
	 *
	 * @return object
	 * @author Ben Edmunds
	 * @author Maria Eugenia Gonzales
	 **/
	public function serv_basicos()
	{ 
		$this->trigger_events('serv_basicos');

		$this->response = $this->db->get($this->tables['serv_basicos']);

		return $this; 
	}	

	/**
	 * View
	 *
	 * @return array //campos de un registro
	 * @author Ben Edmunds
	 **/

	public function view($tabla = NULL, $arraywhere = NULL) 
	{
		$this->trigger_events('view');
		
		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);
		foreach ($arraywhere as $k => $v) {

			$this->response = $this->db->where($k, $v);
		}

		$this->response = $this->db->limit(1);


		$this->response = $this->db->get();

		return $this;
	}

	public function viewlist_abm($tabla = NULL, $level_1_id = NULL, $orderby = NULL) 
	{
		$this->trigger_events('viewlist_abm');

		$this->response = $this->db->select('*');
		$this->response = $this->db->from($this->tables[$tabla]);

		$this->response = $this->db->where('level_1_id', $level_1_id);

		if ($orderby != NULL) {
			$this->response = $this->db->order_by($orderby);
		}

		$this->response = $this->db->get();

		return $this;
		
		if (isset($level_1_id))
		{
			$this->response = $this->db->get_where($this->tables[$tabla],array('level_1_id' => $level_1_id));	
		}

		return $this;
	}

	public function eliminar_reg($level_1_id)
	{
		$this->db->query("SELECT dgsa.eliminar_reg('".$level_1_id."')");

		return TRUE;
	}

	public function concepto ($where1, $blanco = FALSE, $orderby = FALSE, $where2 = FALSE)
	{
		$query = "SELECT CONCEPTO, NOMBRE, DESCRIPCION, TIPOCONCEPTO FROM dgsa_admin.CONCEPTOS WHERE TIPOCONCEPTO = '".$where1."'";

		if ($where2 == TRUE) {
			$query = $query . " AND CONCEPTO = '" . $where2 . "'";
		}

		if ($blanco == TRUE) {
			$query = $query . " UNION SELECT '  ', 'DEJAR EN BLANCO', '', ''";
		}
		if ($orderby) {
			$query = $query . " ORDER BY ".$orderby;
		}
		$this->response = $this->db->query($query);

		$_SESSION['last_query'] = $this->db->last_query();

		return $this;
	}

	public function eliminar_censo($level_1_id)
    {

		$this->db->delete($this->tables['identif_poblac'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['jefe_flia'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['resumen_integr_familia'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['carac_tierravivienda'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['serv_basicos'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['total_ingresos'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['egre_familiares'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['total_egresos'], array('level_1_id' => $level_1_id));
        $this->db->delete($this->tables['economia2'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['salud2'], array('level_1_id' => $level_1_id));		
		$this->db->delete($this->tables['org_vecinal'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['observaciones'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['economia'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['educacion'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['grupofamiliar'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['salud'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['ubi_geo'], array('level_1_id' => $level_1_id));
		$this->db->delete($this->tables['level_1'], array('level_1_id' => $level_1_id));						
        return true;
    }


	public function eliminar_grupofamiliar($level_1_id,$occ)
    {

		$array_where['level_1_id'] = $level_1_id;
		$array_where['occ'] = $occ;
		$this->db->delete($this->tables['grupofamiliar'], $array_where);
        return true;
    }
	public function eliminar_economia($level_1_id,$occ)
    {

		$array_where['level_1_id'] = $level_1_id;
		$array_where['occ'] = $occ;
		$this->db->delete($this->tables['economia'], $array_where);
        return true;
    }
	public function eliminar_educacion($level_1_id,$occ)
    {

		$array_where['level_1_id'] = $level_1_id;
		$array_where['occ'] = $occ;
		$this->db->delete($this->tables['educacion'], $array_where);
        return true;
    }
	public function eliminar_salud($level_1_id,$occ)
    {

		$array_where['level_1_id'] = $level_1_id;
		$array_where['occ'] = $occ;
		$this->db->delete($this->tables['salud'], $array_where);
        return true;
    }
	public function dropdown_data($tabla = NULL, $where = NULL, $order_by = NULL)
	{
		if ($where) {
			foreach ($where as $k => $v) {

				$this->response = $this->db->where($k, $v);
			}
		}
		
		if ($order_by) {
			$this->response = $this->db->order_by($order_by, 'ASC');
		}

		$this->response = $this->db->get($this->tables[$tabla]);

		return $this;
	}

	
	/**
	 * contador_registros
	 *	Obtiene la cantidad de registro de una tabla y condición dada
	 * @return int
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function contador_registros ($tabla = NULL, $arraywhere = NULL)
	{
		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}
		$this->db->from($this->tables[$tabla]);
		return $this->db->count_all_results();
	}

	/**
	 * valor_maximo
	 *	Obtiene el valor máximo de una columna y tabla específica
	 * @return int
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function valor_maximo ($tabla = NULL, $columna = NULL, $arraywhere = NULL)
	{
		$this->db->select("MAX(".$columna.") max");

		foreach ($arraywhere as $k => $v) {

			$this->db->where($k, $v);
		}

		$this->db->from($this->tables[$tabla]);

		return $this->db->get();
	}

	/**
	 * actualizar_cuest
	 *	Función encargada de actualizar el cuestionario en la tabla y con la condición propuesta
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
    public function actualizar_censo($where = NULL, $tabla = NULL, $arraycampos = NULL)
	{
		if (empty($arraycampos)) {
			return FALSE;
		} else {	
			$this->db->update($this->tables[$tabla], $arraycampos, $where);

			$this->set_message('update_successful');

			return TRUE;
		}
    }

	/**
	 * create_reg
	 *	Función encargada de crear un nuevo cuestionario
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function create_censo($arraycampos)
	{
		if ($arraycampos) {
			$this->db->query("SELECT dgsa.adicionar_censo(". $arraycampos['dpto'].",". $arraycampos['distrito'].",". $arraycampos['barrio'].",". $arraycampos['colonia'].",". $arraycampos['area'].",". $arraycampos['ae'].",'". $arraycampos['manzana']."','". $arraycampos['lote_a']."','". $arraycampos['lote_b']."','". $arraycampos['finca']."','". $arraycampos['padron']."',". $arraycampos['cuest'].",". $arraycampos['verificador'].")");
		}
		
		return TRUE;
	}

	/**
	 * crear_registro
	 *	Función encargada de crear un nuevo registro en la tabla y con la condición propuesta
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function crear_registro($tabla = NULL, $arraycampos = NULL)
	{
		if (empty($arraycampos)) return FALSE;

		$this->db->insert($this->tables[$tabla], $arraycampos);

		$this->set_message('ubi_geo_update_successful');

		return TRUE;
	}

	/**
	 * eliminar_registro
	 *	Función encargada de eliminar un registro dada la tabla y la condición de la misma
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function eliminar_registro($tabla = NULL, $arraywhere){

		$eliminar = $this->db->delete($tabla, $arraywhere);

		if ($eliminar) {
			return TRUE;
		}else{
			return FALSE;
		}
	}

	/**
	 * validar_pestanha
	 *	Función encargada de llamar a la función de base de datos encargada de validar la pestaña modificada
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function validar_pestanha($level_1_id, $id_pestanha)
	{
		return $this->db->query("SELECT dgsa.validar_cuestionario('" . $level_1_id . "','" . $id_pestanha . "');");
	}

	/**
	 * actualizar_reg09
	 *	Función encargada de crear un registro en reg09 si no existe
	 * @return bool
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function actualizar_reg09($level_1_id)
	{
		return $this->db->query("SELECT dgsa.actualizar_reg09('" . $level_1_id . "');");
	}

	/**
	 * obtener_errores
	 *	Función encargada de obtener los errores de la tabla public.reg_errores
	 * @return array
	 * @author Lissy Jameuge Rojas Gonzales
	 **/
	public function obtener_errores($level_1_id, $id_pestanha)
	{
		return $this->db->get_where("dgsa.reg_errores",array('level_1_id' => $level_1_id,
														'pestanha'		   => $id_pestanha
														));
	}

	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function obtener_nextval($sequence)
	{
		$seq = $this->db->query("SELECT NEXTVAL('" . $sequence . "');")->row()->nextval;

		return $seq;
	}

	/**
	 * obtener_nextval
	 *
	 * @return int
	 * @author Jaime Rojas
	 **/
	public function existe_codigo_dgsa($codigo)
	{
		$cantidad = $this->db->query("select count(*) cantidad from dgsa.ubi_geo where codigo = '" . $codigo . "';")->row()->cantidad;

		return $cantidad;
	}

	
}
	