<?php
defined('BASEPATH') or exit('No direct script access allowed');

if (! function_exists('active_link_controller')) {
    function active_link_controller($controller)
    {
        $CI    =& get_instance();
        $class = $CI->router->fetch_class();

        return ($class == $controller) ? 'active' : null;
    }
}

if (! function_exists('active_link_function')) {
    function active_link_function($controller)
    {
        $CI    =& get_instance();
        $class = $CI->router->fetch_method();

        return ($class == $controller) ? 'active' : null;
    }
}

if (! function_exists('menu_habilitado')) {
    function menu_habilitado($valor)
    {
        if ($_SESSION['grupos'] != null) {
            foreach ($_SESSION['grupos'] as $value) {
                if ($valor == $value) {
                    return true;
                }
            }
        } else {
            return false;
        }
    }
}

if (! function_exists('grupo_usuario')) {
    function grupo_usuario($valor)
    {
        if ($_SESSION['user_groups'] != null) {
            foreach ($_SESSION['user_groups'] as $value) {
                if ($valor == $value) {
                    return true;
                }
            }
        } else {
            return false;
        }
    }
}

if (! function_exists('no_grupo_usuario')) {
    function no_grupo_usuario($valor)
    {
        if ($_SESSION['user_groups'] != null) {
            foreach ($_SESSION['user_groups'] as $value) {
                if ($valor != $value) {
                    return true;
                }
            }
        } else {
            return false;
        }
    }
}

if (! function_exists('formato_fecha')) {
    function formato_fecha($valor = null)
    {
        if (isset($valor)) {
            return date('d/m/Y', strtotime($valor));
        } else {
            return '';
        }
    }
}

if (! function_exists('formato_fecha_hora')) {
    function formato_fecha_hora($valor = null)
    {
        return date('d/m/Y H:i', strtotime($valor));
    }
}

if (! function_exists('formatear_moneda')) {
    function formatear_moneda($valor = null)
    {
        if (isset($valor)) {
            return number_format($valor, 0, ",", ".");
        } else {
            return '';
        }
    }
}

if (! function_exists('formatear_numero')) {
    function formatear_numero($valor = null)
    {
        if (isset($valor)) {
            return number_format($valor, 0, ",", ".");
        } else {
            return '';
        }
    }
}

if (! function_exists('calculate_limit_day')) {
    function calculate_limit_day($day)
    {

        $holidayDates = ['*-01-01', '*-03-01', '*-05-01', '*-05-14', '2019-06-17', '*-08-15', '*-09-29', '*-12-08', '*-12-25', '2020-04-09', '2020-04-10'];

        $count5WD = 0;
        $temp = strtotime($day);
        while ($count5WD<5) {
            $next1WD = strtotime('+1 weekday', $temp);
            $next1WDDate = date('Y-m-d', $next1WD);
            if (!in_array($next1WDDate, $holidayDates)) {
                $count5WD++;
            }
            $temp = $next1WD;
        }

        // $next5WD = date("Y-m-d", $temp);

        return $temp;
    }
}


if (! function_exists('number_of_working_days')) {
    function number_of_working_days($from, $to)
    {
        $workingDays = [1, 2, 3, 4, 5];
        $holidayDays = ['*-01-01', '*-03-01', '*-05-01', '*-05-14', '2019-06-17', '*-08-15', '*-09-29', '*-12-08', '*-12-25', '2020-04-09', '2020-04-10'];

        $from = new DateTime($from);
        $to = new DateTime($to);
        $to->modify('+1 day');
        $interval = new DateInterval('P1D');
        $periods = new DatePeriod($from, $interval, $to);

        $days = 0;
        foreach ($periods as $period) {
            if (!in_array($period->format('N'), $workingDays)) {
                continue;
            }
            if (in_array($period->format('Y-m-d'), $holidayDays)) {
                continue;
            }
            if (in_array($period->format('*-m-d'), $holidayDays)) {
                continue;
            }
            $days++;
        }
        return $days;
    }
}


function rearrange($arr)
{
    foreach ($arr as $key => $all) {
        foreach ($all as $i => $val) {
            $new[$i][$key] = $val;
        }
    }
    return $new;
}
