<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('tramos/tramos_model');
		$this->lang->load('tramos/tramos_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_tramos'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		
		if ($_SESSION['id_modulo'] != 'TRAMOS') {

			$_SESSION['arraywhere_tramos'] 		 = NULL;
			$_SESSION['arraywhere_tramos_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'TRAMOS';
		}
		

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_tramos'), 'tramos/tramos');
	}

	public function tramo_mantenimiento($id_tramo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'tramos/tramos');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $tramo_datos = $this->tramos_model->view('tramos', array('id_tramo' => $id_tramo))->row();

			$id_proyecto 				= $tramo_datos->id_proyecto;
			$id_tramo 					= $tramo_datos->id_tramo;
			$cod_geografico 			= $tramo_datos->cod_geografico;
			$nombre 					= $tramo_datos->nombre;
			$fecha  					= $tramo_datos->fecha;
			$hora  						= $tramo_datos->hora;
			$usuario  					= $tramo_datos->usuario;
			$tramo_padre 				= $tramo_datos->tramo_padre;
			
	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
			
			/*
			echo '<pre>';
        	print_r( $id_proyecto." :: ".$id_tramo.":".$cod_geografico );
        	echo '</pre>';
        	show_error(1);
			*/

			$tramos_info  = $this->tramos_model->view('tramos', array('id_tramo' => $id_tramo))->result_array();



			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_TRAMO'] = $this->tramos_model->contador_registros('tramos_ide', array('id_tramo' => $id_tramo));

			/************* FIN CANTIDAD DATOS GRAFICOS ****************/



			$this->data['tramos_info'] 		= $tramos_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['id_tramo'] = array(
				'type'     => 'hidden',
				'name'     => 'id_tramo',
				'id'       => 'id_tramo',
				'value'    => $id_tramo
			);

			$this->data['id_proyecto'] = array(
				'type'     => 'hidden',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $id_proyecto
			);

			$this->data['cod_geografico'] = array(
				'type'     => 'hidden',
				'name'     => 'cod_geografico',
				'id'       => 'cod_geografico',
				'value'    => $cod_geografico
			);

			$this->data['nombre'] = array(
				'type'     => 'hidden',
				'name'     => 'nombre',
				'id'       => 'nombre',
				'value'    => $nombre
			);
			$this->data['tramo_padre'] = array(
				'type'     => 'hidden',
				'name'     => 'tramo_padre',
				'id'       => 'tramo_padre',
				'value'    => $tramo_padre
			);
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ?
				$this->ion_auth->errors() : $this->session->flashdata('message')));

			/* Load Template */
            $this->template->admin_render('tramos/mantenimiento', $this->data);
		}
	}
/*HASTA AQUI 220319*/

	public function eliminar_geometrias_tramo($id_tramo = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');


		$resultado = $this->tramos_model->eliminar_geometrias_tramo($id_tramo);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('tramos/Mantenimiento/tramo_mantenimiento/'.$id_tramo);

	}

	public function download_tramo($id_tramo = NULL)
	{

        	//exec('cmd /c "C:\dir_intercambio\exp_mopc_expropia_tramos_tabla_a_shp.bat sge 2l2f1nt22022i '.trim($id_tramo).'"');
        	//Se reciben 3 parametros, usuario, password e id de tramo}
        	$resultado = exec("/dir_intercambio/exp_mopc_expropia_tramos_tabla_a_shp.sh sge 2l2f1nt22022i ".trim($id_tramo));
        /*
                $user_xampp = exec("whoami");

        	//echo phpinfo();
        	$user = getenv('APACHE_RUN_USER');
        	$group = getenv('APACHE_RUN_GROUP');


        	echo '<pre>';
        	print_r( $user_xampp." :: ".$user.":".$group."  ".$id_tramo." ".$resultado );
        	echo '</pre>';
        	show_error(1);
        	

        	$download_file = "mopc_tramo_shp".$id_tramo.".zip";

		if ( ! empty($download_file)) {
        		//If you want to download an existing file from your server you'll need to read the file into a string
        		$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        		$name = $download_file;
        		force_download($name, $data);
    		}
		*/
		redirect('tramos/Mantenimiento/tramo_mantenimiento/'.$id_tramo);

	}

	public function importar_shapes()
	{
		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('tramos/mantenimiento/tramo_mantenimiento/'.$_POST['id_tramo']);
		}

		$id_proyecto 	= $_POST['id_proyecto'];
		$id_tramo 	 	= $_POST['id_tramo'];
		$cod_geografico = $_POST['cod_geografico'];
		$nombre 	 	= $_POST['nombre'];
/* 	
echo '<pre>';
print_r( $id_proyecto." :: ".$id_tramo.":".$cod_geografico );
echo '</pre>';
show_error(1);
*/



		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}


		// pregunta sin existen datos graficos del tramo.
		//echo 'tramo: '.$id_tramo;
		//show_error('TEMPORALMENTE INACTIVO');
		$tramo = $this->tramos_model->existe_grafico_id_tramo($id_tramo)->row()->f_existe_grafico_id_tramo;
			
		if ($tramo>0) {
			$this->session->set_flashdata('message', 'EL tramo YA TIENE DATOS ESPACIALES!');
			redirect('tramos/mantenimiento/tramo_mantenimiento/'.$_POST['id_tramo']);
		}
		else {
			
			//exec('cmd /c "'.trim('md C:\dir_intercambio\tramos\ ').trim($id_tramo).'"');
			exec('rm -R /dir_intercambio/tramos/tramo'.trim($id_tramo));
			exec(trim('mkdir /dir_intercambio/tramos/tramo ').trim($id_tramo));
			exec(trim('chmod 777 /dir_intercambio/tramos/tramo ').trim($id_tramo));
			exec(trim('chmod 777 /dir_intercambio/tramos/tramo ').trim($id_tramo).'/*');
			$ruta_dest = trim('/dir_intercambio/tramos/tramo ').trim($id_tramo).trim('/ ');


			//echo 'tramo: '.$tramo;
			//show_error('TEMPORALMENTE INACTIVO');

			
			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					default:
						$i = $i + 1;
						break;

				}
			}

			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) {
				$id_epsg = 32720;
			} elseif ($accion == 3) {
				$id_epsg = 4326;
			} else  {
				$id_epsg = 32721;
			}
		//echo 'tramo: '.$id_tramo.'; '.$cod_geografico;
		//show_error('TEMPORALMENTE INACTIVO');
			exec('/dir_intercambio/imp_mopc_expropia_tramos_shp_a_tabla.sh '.trim($id_tramo).' '.$id_epsg);
			
			$actu = $this->tramos_model->actualizar_shapes_tramo($id_proyecto, $id_tramo, $id_epsg)->row()->actualizar_shapes_tramo;
			$actu = $this->tramos_model->actualizar_fd_unificacion($id_proyecto)->row()->actualizar_fd_unificacion;

			if ($actu>0) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('tramos/mantenimiento/tramo_mantenimiento/'.$id_tramo);
			}
			else {
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3>');

				redirect('tramos/mantenimiento/tramo_mantenimiento/'.$id_tramo);

			}
		}
	}

	public function vergrafico ($id_tramo = NULL) {

        	//$i_jameuge = "http://172.16.55.150/jmap/index.html?id_tramo=" . $id_tramo;
			//$i_jameuge = "http://172.16.55.134:8065/sgeMap/index.html?id_tramo=" . $id_tramo;
    		
    
            $jerarquia_tramo = $this->tramos_model->obtener_jerarquia_tramo($id_tramo);
/*
echo '<pre>';
print_r($jerarquia_tramo);
echo '</pre>';
show_error(1);
*/
    
    //$this->session->set_flashdata('message', 'Tramo sin grafico!!');
    
            /*if ($jerarquia_tramo  == 1) {
				$i_jameuge = "http://134.255.178.19/sgeMap/index.html?id_tramo=" . $id_tramo;
				$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_tramos_lineas_id_tramo";               
            }
    		elseif ($jerarquia_tramo  == 2) {
					$this->session->set_flashdata('message', 'Tramo sin grafico!!');
			}else {
				$i_jameuge = "http://134.255.178.19/sgeMap/index.html?id_tramo=";
				$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_tramos_id_tramo_padre&id_tramo_padre=" . $id_tramo;
			}
			*/
			$cnt_registro = $this->tramos_model->contador_registros('tramos_ide',array('id_tramo' => $id_tramo));	//si existe tramo grafico para este id_tramo
    		$cnt_registro_padre = $this->tramos_model->contador_registros('v_tramos_con_padre',array('id_tramo_padre' => $id_tramo));	//si existe tramo grafico para este id_tramo
    
    
			$es_padre = $this->tramos_model->es_padre($id_tramo); //1 es hijo, 0 es padre. 
			
			/*echo '<pre>';
			print_r($cnt_registro);
			print_r($es_padre);
			print_r($id_tramo);			
			echo '</pre>';
			show_error(1);*/
			          
			if($es_padre>0){
				if($cnt_registro>0){
					$i_jameuge = "http://134.255.178.19/sgeMap/index.html?id_tramo=" . $id_tramo;
					$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_tramos_lineas_id_tramo";
					redirect($i_jameuge);
				}else {
					$this->session->set_flashdata('message', '<h3>¡TRAMO SIN GRAFICO! </h3>');
	                //$_SESSION['message2'] = '<h3>¡TRAMO SIN GRAFICOS! </h3>';
					redirect('tramos/tramos/index/');     				
				}
			}else{
				if($cnt_registro>0){
                	$i_jameuge = "http://134.255.178.19/sgeMap/index.html?id_tramo=" . $id_tramo;
					$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_tramos_lineas_id_tramo";
					redirect($i_jameuge);              
				}
				else {
					if($cnt_registro_padre>0){                
						$i_jameuge = "http://134.255.178.19/sgeMap/index.html?id_tramo=";
						$i_jameuge = $i_jameuge . "&tipo_consulta=mopc_tramos_id_tramo_padre&id_tramo_padre=" . $id_tramo;
						redirect($i_jameuge);  
                    }
                	else {
						$this->session->set_flashdata('message', '<h3>¡TRAMO SIN GRAFICOS! </h3>');
                    	//$_SESSION['message2'] = '<h3>¡TRAMO SIN GRAFICOS! </h3>';
						redirect('tramos/tramos/index/');                    
                    }
				}
			}

			
			

			//redirect($i_jameuge);    
	}
    
}
