<?php 
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('expedientes/expedientes_model');
		$this->lang->load('expedientes/expedientes_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_expedientes'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'EXPEDIENTES') {

			$_SESSION['arraywhere_expedientes'] 		 = NULL;
			$_SESSION['arraywhere_expedientes_busqueda'] = NULL;
			$_SESSION['id_modulo'] = 'EXPEDIENTES';
		}   
		
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_expedientes'), 'expedientes/expedientes');
	}

	public function expe_mantenimiento($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'expedientes/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->expedientes_model->view('expedientes', array('id' => $expe_id))->row();

	        $expe_id_expediente 	= $exp_datos->expe_id_expediente;
	        $expe_gestion			= $exp_datos->expe_gestion;
	        $expe_estado			= $exp_datos->expe_estado;
	        $expe_tipo_ref			= $exp_datos->expe_tipo_ref;
	        $expe_tipo_dictamen		= $exp_datos->expe_tipo_dictamen;
	        $expe_id_imagen1		= $exp_datos->expe_id_imagen1;
	        $expe_id_imagen2		= $exp_datos->expe_id_imagen2;
	        $expe_id_imagen3		= $exp_datos->expe_id_imagen3;
	        $expe_id_imagen4		= $exp_datos->expe_id_imagen4;
	        $expe_dictamen			= $exp_datos->expe_dictamen;

	        //$_SESSION['archivo_shp'] = "/intercambio/uso_actual.*";
	        
			$expe_info  = $this->expedientes_model->view('v_exp01', array('expe_id' => $expe_id))->result_array();
			
			$expe_info[0]["expe_tipo_ref_desc"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre' , array('tipoconcepto' => 'TIPO_REF', 'concepto' => $expe_info[0]["expe_tipo_ref"]));

			$expe_info[0]["expe_estado_desc"] = $this->expedientes_model->obtener_valor_campo('conceptos', 'nombre', array('tipoconcepto' => 'EXPE_ESTADO', 'concepto' => $expe_info[0]["expe_estado"]));

//echo $expe_info[0]["expe_tipo_ref_desc"];
//show_error('TEMPORALMENTE INACTIVO');

			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['MOPC_POLIGONO']		= $this->expedientes_model->contador_registros('MOPC_POLIGONO', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_UACTUAL']		= $this->expedientes_model->contador_registros('MOPC_UACTUAL', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_UALTER']		= $this->expedientes_model->contador_registros('MOPC_UALTER', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_U86']			= $this->expedientes_model->contador_registros('MOPC_U86',  array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_U04']			= $this->expedientes_model->contador_registros('MOPC_U04',  array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_TSUELO']		= $this->expedientes_model->contador_registros('MOPC_TSUELO', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_FINCAS']		= $this->expedientes_model->contador_registros('MOPC_FINCAS', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_CAP_SUELO']	= $this->expedientes_model->contador_registros('MOPC_CAP_SUELO', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_CLA_ECO']		= $this->expedientes_model->contador_registros('MOPC_CLA_ECO', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_COMP_DEF']		= $this->expedientes_model->contador_registros('MOPC_COMP_DEF', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_DEF_BOS']		= $this->expedientes_model->contador_registros('MOPC_DEF_BOS', array('expe_id' => $expe_id));
			$datos_graficos[0]['MOPC_PROP_CERT']	= $this->expedientes_model->contador_registros('MOPC_PROP_CERT', array('expe_id' => $expe_id));
			/************* FIN CANTIDAD DATOS GRAFICOS ****************/

			$this->data['expe_info'] 		= $expe_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['expe_id_expediente'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id_expediente',
				'id'       => 'expe_id_expediente',
				'value'    => $expe_id_expediente
			);
			$this->data['expe_gestion'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_gestion',
				'id'       => 'expe_gestion',
				'value'    => $expe_gestion
			);
			$this->data['expe_id'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_id',
				'id'       => 'expe_id',
				'value'    => $expe_id
			);
			$this->data['expe_estado'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_estado',
				'id'       => 'expe_estado',
				'value'    => $expe_estado
			);
			$this->data['expe_tipo_ref'] = array(
				'type'     => 'hidden',
				'name'     => 'expe_tipo_ref',
				'id'       => 'expe_tipo_ref',
				'value'    => $expe_tipo_ref
			);	


			$tipo_dictamens[''] = 'Seleccione la Tipo Dictamen';
			$tipo_dictamen = $this->expedientes_model->dropdown_data('conceptos',array('tipoconcepto' => 'TIPO_DICTAMEN'))->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($tipo_dictamen as $dic) {
				$tipo_dictamens[$dic['concepto']] = $dic['concepto'].' - '.$dic['nombre'];
			}
			$this->data['expe_tipo_dictamen'] = $tipo_dictamens;
			$this->data['expe_tipo_dictamen_sel'] = $expe_tipo_dictamen;


			$imagen1s[''] = 'Seleccione mapfile';
			$imagen1 = $this->expedientes_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen1 as $img) {
				$imagen1s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['expe_id_imagen1'] 	= $imagen1s;
			$this->data['expe_id_imagen1_sel'] = $expe_id_imagen1;


			$imagen2s[''] = 'Seleccione mapfile';
			$imagen2 = $this->expedientes_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen2 as $img) {
				$imagen2s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['expe_id_imagen2'] 	= $imagen2s;
			$this->data['expe_id_imagen2_sel'] = $expe_id_imagen2;


			$imagen3s[''] = 'Seleccione mapfile';
			$imagen3 = $this->expedientes_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen3 as $img) {
				$imagen3s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['expe_id_imagen3'] 	= $imagen3s;
			$this->data['expe_id_imagen3_sel'] = $expe_id_imagen3;


			$imagen4s[''] = 'Seleccione mapfile';
			$imagen4 = $this->expedientes_model->dropdown_data('imagenes','','imgn_id_imagen')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($imagen4 as $img) {
				$imagen4s[$img['imgn_id_imagen']] = $img['imgn_id_imagen'].' - '.$img['imgn_codigo'];
			}
			$this->data['expe_id_imagen4'] 	= $imagen4s;
			$this->data['expe_id_imagen4_sel'] = $expe_id_imagen4;


			$this->data['expe_dictamen'] = array(
				'type'     => 'text',
				'name'     => 'expe_dictamen',
				'id'       => 'expe_dictamen', 
				'style'	   => 'height: 200px',
				'value'    => $this->form_validation->set_value('expe_dictamen', $expe_dictamen),
				'class'    => 'form-control'
			);


			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ?
				$this->ion_auth->errors() : $this->session->flashdata('message')));
	        
			/* Load Template */
            $this->template->admin_render('expedientes/Mantenimiento', $this->data);
		}
	}


	public function eliminar_geometrias($exp = NULL, $gest = NULL, $expe_id = NULL)
	{
		//show_error('AÚN NO PUEDE ELIMINAR GEOMETRÍAS');

        
		$resultado = $this->expedientes_model->eliminar_geometrias($exp,$gest,$expe_id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$expe_id);
		
	}

	public function download_expe($exp = NULL, $gest = NULL, $expe_id = NULL)
	{

        exec('cmd /c "C:\espacio_trabajo\exp_tabla_a_shp.bat sge 2l2f1nt22022i '.trim($expe_id).'"');	

        $download_file = "expe".$expe_id.".zip";

		if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}

		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$expe_id);
		
	}

	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
		}

		$id_expediente 	= $_POST['expe_id_expediente'];
		$gestion 		= $_POST['expe_gestion'];
		$expe_id 		= $_POST['expe_id'];
		$expe_estado 	= $_POST['expe_estado'];



		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		


		// pregunta sin existen datos graficos del expediente.
		$expe = $this->expedientes_model->existe_grafico_expe_id($expe_id)->row()->f_existe_grafico;

		if ($expe>0) {
			$this->session->set_flashdata('message', 'EL EXPEDIENTE YA TIENE DATOS ESPACIALES!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
		}
		else { 		


			exec('cmd /c "'.trim('md C:\espacio_trabajo\ ').trim($expe_id).'"');		

			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');

			$ruta_dest = trim('C:\espacio_trabajo\ ').trim($expe_id).trim('\ ');

			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;		
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;
					
					default:
						$i = $i + 1;
						break;			

				}
			}				
			
			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) { 	
				$id_epsg = 32720;
			} elseif ($accion == 3) { 	
				$id_epsg = 4326;
			} else  { 	
				$id_epsg = 32721;
			}

			exec('cmd /c "C:\espacio_trabajo\imp_shp_a_tabla.bat '.trim($expe_id).' '.$id_epsg.'"');				

			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');

			$actu = $this->expedientes_model->actualizar_shapes($id_expediente, $gestion, $expe_id, $id_epsg)->row()->actualizar_shapes;

			if ($actu>0) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
			}
			else { 	
				$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> ');		

				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);

			}
		}
	}

	public function verparcela ($expe_id , $expe_gest) {
	
        	$i_jameuge = "http://181.120.125.178:8065/jmap/index.html?exp=" . $expe_id;
        	$i_jameuge = $i_jameuge . "&gest=" . $expe_gest;

			redirect($i_jameuge);
	}



	public function actualizar_dictamen()
	{


		$id_expediente 	= $_POST['expe_id_expediente'];
		$gestion 		= $_POST['expe_gestion'];
		$expe_id 		= $_POST['expe_id'];
		$expe_estado 	= $_POST['expe_estado'];



		$expe_tipo_dictamen 	= $_POST['expe_tipo_dictamen'];
		$expe_id_imagen1 		= $_POST['expe_id_imagen1'];
		$expe_id_imagen2 		= $_POST['expe_id_imagen2'];
		$expe_id_imagen3 		= $_POST['expe_id_imagen3'];
		$expe_dictamen 			= $_POST['expe_dictamen'];


        $datos_update['expe_tipo_dictamen'] = $_POST['expe_tipo_dictamen'];
        $datos_update['expe_id_imagen1'] 	= $_POST['expe_id_imagen1'];
        $datos_update['expe_id_imagen2'] 	= $_POST['expe_id_imagen2'];
        $datos_update['expe_id_imagen3'] 	= $_POST['expe_id_imagen3'];
        $datos_update['expe_dictamen'] 		= $_POST['expe_dictamen'];

		$accion = 0;	
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}		


		// pregunta sin existen datos graficos del expediente.
		$cnt_grafico = $this->expedientes_model->f_existe_grafico_expe_id($expe_id);


		//echo($cnt_licencia);
		//show_error(1);

		if ($cnt_grafico=0) {
			$this->session->set_flashdata('message', 'Expediente sin Datos espaciales!!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
		}
		else { 		

			$actu = $this->expedientes_model->actualizar_dictamen($expe_id, $datos_update);	
			
			$this->session->set_flashdata('message', 'Actualizacion Realizada!');

			if ($actu) {
				$this->session->set_flashdata('message', '¡Actualización Realizada!');
				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
			}
			else { 	
				$this->session->set_flashdata('message', '¡No actualizo!');		
				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['expe_id']);
			}
		}
	}

	public function imprimirdictamen ($expe_id = NULL , $expe_tipo_dictamen = NULL) {
	
		$bbox = $this->expedientes_model->mapabb($expe_id);
		if ($bbox)
		{
			$data['ext1'] = $bbox[0]['ext1'];
        	$data['ext2'] = $bbox[0]['ext2'];
        	$data['ext3'] = $bbox[0]['ext3'];
        	$data['ext4'] = $bbox[0]['ext4'];

        	$data['concat'] = $bbox[0]['ext1']. ' ' . $bbox[0]['ext2'] . ' ' .$bbox[0]['ext3']. ' ' . $bbox[0]['ext4'];
			
			if ($expe_tipo_dictamen)
			{
				if ($expe_tipo_dictamen)
				{
					if ($expe_tipo_dictamen == 'D2')
					{
			        	$i_jameuge = "http://181.120.125.178:8062/i3geo/ferramentas/imprimir/Mapa_A3_MOPC_dictamen2.php?";
			        	$i_jameuge = $i_jameuge . "&expe_id=" . $expe_id;
			        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
			        	
						redirect($i_jameuge);
					}
					else
					{
			        	$i_jameuge = "http://181.120.125.178:8062/i3geo/ferramentas/imprimir/Mapa_A3_MOPC_dictamen3.php?";
			        	$i_jameuge = $i_jameuge . "&expe_id=" . $expe_id;
			        	$i_jameuge = $i_jameuge . "&mapexten=". $data['concat'];
			        	
						redirect($i_jameuge);
					}
				}
			}
		}
		else
		{
			//$this->session->set_flashdata('message', $this->ion_auth->errors());
			$this->session->set_flashdata('message', 'No tiene datos graficos!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$expe_id);
		}
	}
}