<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class salud extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		
		if ($_SESSION['id_modulo'] != 'salud') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'salud') {
				
				$_SESSION['arraywhere_salud'] = NULL;
				$_SESSION['arraywhere_salud_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'salud';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}

	public function salud_index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
    
		$_SESSION['url_sub_anterior_dgsa'] = 'https://mopc.gov.py/sge/index.php/censo/salud/salud_index';
    
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('salud_titulo'), 'censo/ubi_geo/index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->data['salud'] = $this->censo_model->viewlist_abm('v_salud', $_SESSION['identificador'])->result();

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('//message')));

		/* Load Template */
		$this->template->admin_render('censo/salud_index', $this->data);
	}

	public function salud_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('salud_tiutlo'), 'salud/create_salud');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$max   = $this->censo_model->valor_maximo('salud', 'occ', array('level_1_id' => $_SESSION['identificador']))->row()->max;
		$max   = $max + 1;
		$salud = $this->censo_model->view('salud', array('level_1_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		$this->form_validation->set_rules('salud', 'lang:salud_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
		if ($_POST)
		{

			$arraycamposinsert['level_1_id']  	= (string)$_SESSION['identificador'];
			$arraycamposinsert['salud_id']  	= (string)$_SESSION['identificador'];


			$arraycamposinsert['occ']         	= $max;
		
			if ($_POST['n_de_miembro1']) {
				$arraycamposinsert['n_de_miembro1']         = $_POST['n_de_miembro1'];
			}

			if ($_POST['dgsa_salud_enfermo_cronico']) 
			{
				$arraycamposinsert['enfermo_cronico']		= $_POST['dgsa_salud_enfermo_cronico'];
				if (trim($_POST['dgsa_salud_enfermo_cronico']) == '') {
					$arraycamposinsert['enfermo_cronico']   = NULL;
				} else {
					$arraycamposinsert['enfermo_cronico']   = (int)$_POST['dgsa_salud_enfermo_cronico'];
				}				
			}

			if (strlen(trim($_POST['especif_enfermedad'])) == 0) {
					$arraycamposinsert['especif_enfermedad']   = NULL;
			} else {
					$arraycamposinsert['especif_enfermedad']   = $_POST['especif_enfermedad'];
			}

			if ($_POST['dgsa_salud_sigue_tratamiento']) 
			{
				$arraycamposinsert['sigue_tratamiento']     = $_POST['dgsa_salud_sigue_tratamiento'];
				if (trim($_POST['dgsa_salud_sigue_tratamiento']) == '') {
					$arraycamposinsert['sigue_tratamiento']	= NULL;
				} else {
					$arraycamposinsert['sigue_tratamiento']	= (int)$_POST['dgsa_salud_sigue_tratamiento'];
				}				
			}

			if (strlen(trim($_POST['lugar'])) == 0) {
					$arraycamposinsert['lugar']   = NULL;
			} else {
					$arraycamposinsert['lugar']   = $_POST['lugar'];
			}

			if ($_POST['dgsa_salud_distanciarecorrida']) 
			{
				$arraycamposinsert['distanciarecorrida']		= $_POST['dgsa_salud_distanciarecorrida'];
				if (trim($_POST['dgsa_salud_distanciarecorrida']) == '') {
					$arraycamposinsert['distanciarecorrida']	= NULL;
				} else {
					$arraycamposinsert['distanciarecorrida']	= (int)$_POST['dgsa_salud_distanciarecorrida'];
				}				
			}


			$create_salud = $this->censo_model->crear_registro('salud', $arraycamposinsert);

			/*
			$str = date_default_timezone_get();
			$fecha_procesado_4 = date("d/m/Y", strtotime($str));
			$arraycampos3 = array('proceso' 		   => 'A03'
				//,'mapear' 			   => $reg02->mapear
				,'procesado_4'		   => 1
				,'fecha_procesado_4'	   => $fecha_procesado_4
					
			);
			*/					
			/*****************************************************************/
			
			redirect('censo/salud/salud_index');
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
    salud_id
    level_1_id
    occ
    n_de_miembro1
    enfermo_cronico
    especif_enfermedad
    sigue_tratamiento
    lugar
    distanciarecorrida
*/	
			$this->data['salud_id'] = array(
				'name'  => 'salud_id',
				'id'    => 'salud_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('salud_id'),
				'value'   => $this->form_validation->set_value('salud_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['level_1_id'] = array(
				'name'  => 'level_1_id',
				'id'    => 'level_1_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('level_1_id'),
				'value'   => $this->form_validation->set_value('level_1_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['occ'] = array(
				'name'  => 'occ',
				'id'    => 'occ',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('occ'),
				'value'   => $this->form_validation->set_value('occ', trim($max)), 			
				'maxlength' => 20,
				'readonly' => 'true'
				);
			$this->data['n_de_miembro1'] = array(
				'name'  => 'n_de_miembro1',
				'pattern'  => '^([0-9][0-9]{0,2})?$',
				'id'    => 'n_de_miembro1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_miembro1'),
				'maxlength'=> '2'
				);
/*
			$this->data['enfermo_cronico'] = array(
				'name'  => 'enfermo_cronico',
				'id'    => 'enfermo_cronico',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('enfermo_cronico'),
				'maxlength' => 7
				);
*/
			$this->data['especif_enfermedad'] = array(
				'name'  => 'especif_enfermedad',
				'id'    => 'especif_enfermedad',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('especif_enfermedad'),
				'maxlength'=> '30'
				);
/*
			$this->data['sigue_tratamiento'] = array(
				'name'  => 'sigue_tratamiento',
				'id'    => 'sigue_tratamiento',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('sigue_tratamiento'),
				'maxlength' => 20
				);
*/
			$this->data['lugar'] = array(
				'name'  => 'lugar',
				'id'    => 'lugar',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('lugar'),
				'maxlength'=> '15'
				);
/*
			$this->data['distanciarecorrida'] = array(
				'name'  => 'distanciarecorrida',
				'id'    => 'distanciarecorrida',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('distanciarecorrida'),
				'maxlength' => 20
				);
*/

			$enfermo_cronico = $this->censo_model->concepto('ENFERMO_CRONICO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($enfermo_cronico as $ec) {
				$enfermo_cronicos[$ec['concepto']] = $ec['concepto'].' - '.$ec['nombre'];
			}
			$this->data['enfermo_cronico'] = $enfermo_cronicos;

			$sigue_tratamiento = $this->censo_model->concepto('SIGUE_TRATAMIENTO',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($sigue_tratamiento as $st) {
				$sigue_tratamientos[$st['concepto']] = $st['concepto'].' - '.$st['nombre'];
			}
			$this->data['sigue_tratamiento'] = $sigue_tratamientos;			

			$distanciarecorrida = $this->censo_model->concepto('DISTANCIARECORRIDA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($distanciarecorrida as $dr) {
				$distanciarecorridas[$dr['concepto']] = $dr['concepto'].' - '.$dr['nombre'];
			}
			$this->data['distanciarecorrida'] = $distanciarecorridas;

			/*
			$p02_filtro = $this->reg01_model->concepto('P02_FILTRO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($p02_filtro as $p02f) {
				$p02_fs[$p02f['concepto']] = $p02f['concepto'].' - '.$p02f['nombre'];
			}
			$this->data['p02_filtro'] = $p02_fs;
			*/

			/* Load Template */
			$this->template->admin_render('censo/salud_create', $this->data);
		}
	}

	public function salud_edit($level_1_id, $occ, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('salud_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;

		$where_level_1_id['level_1_id'] = $level_1_id;
		$where_level_1_id['occ'] = $occ;

		$salud = $this->censo_model->view('salud', $where_level_1_id)->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('salud_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['salud_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['salud_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['salud_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

    /* 
    salud_id
    level_1_id
    occ
    n_de_miembro1
    enfermo_cronico
    especif_enfermedad
    sigue_tratamiento
    lugar
    distanciarecorrida
    */

		if ($_POST) {

			/*
			if ($_POST['salud_id']) 
			{
				$arraycampos['salud_id']                       = $_POST['salud_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}
			
			if ($_POST['occ']) 
			{
				$arraycampos['occ']             				= $_POST['occ'];
			}
			*/

			if ($_POST['n_de_miembro1']) 
			{
				$arraycampos['n_de_miembro1']        					= $_POST['n_de_miembro1'];
			}

			if ($_POST['dgsa_salud_enfermo_cronico']) 
			{
				$arraycampos['enfermo_cronico']        				= $_POST['dgsa_salud_enfermo_cronico'];
				if (trim($_POST['dgsa_salud_enfermo_cronico']) == '') {
					$arraycampos['enfermo_cronico']   = NULL;
				} else {
					$arraycampos['enfermo_cronico']   = (int)$_POST['dgsa_salud_enfermo_cronico'];
				}				
			}

			if (strlen(trim($_POST['especif_enfermedad'])) == 0) {
					$arraycampos['especif_enfermedad']   = NULL;
			} else {
					$arraycampos['especif_enfermedad']   = $_POST['especif_enfermedad'];
            }

			if ($_POST['dgsa_salud_sigue_tratamiento']) 
			{
				$arraycampos['sigue_tratamiento']        				= $_POST['dgsa_salud_sigue_tratamiento'];
				if (trim($_POST['dgsa_salud_sigue_tratamiento']) == '') {
					$arraycampos['sigue_tratamiento']   = NULL;
				} else {
					$arraycampos['sigue_tratamiento']   = (int)$_POST['dgsa_salud_sigue_tratamiento'];
				}				
			}

			if (strlen(trim($_POST['lugar'])) == 0) {
					$arraycampos['lugar']   = NULL;
			} else {
					$arraycampos['lugar']   = $_POST['lugar'];
            }

			if ($_POST['dgsa_salud_distanciarecorrida']) 
			{
				$arraycampos['distanciarecorrida']        				= $_POST['dgsa_salud_distanciarecorrida'];
				if (trim($_POST['dgsa_salud_distanciarecorrida']) == '') {
					$arraycampos['distanciarecorrida']   = NULL;
				} else {
					$arraycampos['distanciarecorrida']   = (int)$_POST['dgsa_salud_distanciarecorrida'];
				}				
			}


			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador'],'occ' => $salud->occ), 'salud', $arraycampos);

			
			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['salud'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/salud/salud_edit/'.$level_1_id.'/'.$occ.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
    salud_id
    level_1_id
    occ
    n_de_miembro1
    enfermo_cronico
    especif_enfermedad
    sigue_tratamiento
    lugar
    distanciarecorrida
*/

		$this->data['salud_id'] = array(
			'type'    => 'text',
			'name'    => 'salud_id',
			'id'      => 'salud_id',
			'value'   => $this->form_validation->set_value('salud_salud_id', trim($salud->salud_id)),
			'class'   => 'form-control',	
			'readonly' => 'true'		
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('salud_level_1_id', trim($salud->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['occ'] = array(
			'type'  => 'text',
			'name'  => 'occ',
			'id'    => 'occ',
			'value' => $this->form_validation->set_value('salud_occ', trim($salud->occ)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['n_de_miembro1'] = array(
			'type'  => 'text',
			'name'  => 'n_de_miembro1',
			'pattern'  => '^([1-9][0-9]{0,2})?$',
			'id'    => 'n_de_miembro1',
			'value' => $this->form_validation->set_value('salud_n_de_miembro1', trim($salud->n_de_miembro1)),
			'class' => 'form-control',
            'maxlength'=> '2'
		);
/*
		$this->data['enfermo_cronico'] = array(
			'type'  => 'text',
			'name'  => 'enfermo_cronico',
			'id'    => 'enfermo_cronico',
			'value' => $this->form_validation->set_value('salud_enfermo_cronico', trim($salud->enfermo_cronico)),
			'class' => 'form-control'
		);
*/
		$this->data['especif_enfermedad'] = array(
			'type'  => 'text',
			'name'  => 'especif_enfermedad',
			'id'    => 'especif_enfermedad',
			'value' => $this->form_validation->set_value('salud_especif_enfermedad', trim($salud->especif_enfermedad)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
/*
		$this->data['sigue_tratamiento'] = array(
			'type'  => 'text',
			'name'  => 'sigue_tratamiento',
			'id'    => 'sigue_tratamiento',
			'value' => $this->form_validation->set_value('salud_sigue_tratamiento', trim($salud->sigue_tratamiento)),
			'class' => 'form-control'
		);
*/
		$this->data['lugar'] = array(
			'type'  => 'text',
			'name'  => 'lugar',
			'id'    => 'lugar',
			'value' => $this->form_validation->set_value('salud_lugar', trim($salud->lugar)),
			'class' => 'form-control',
            'maxlength'=> '15'
		);
/*
		$this->data['distanciarecorrida'] = array(
			'type'  => 'text',
			'name'  => 'distanciarecorrida',
			'id'    => 'distanciarecorrida',
			'value' => $this->form_validation->set_value('salud_distanciarecorrida', trim($salud->distanciarecorrida)),
			'class' => 'form-control'
		);
*/

		$enfermo_cronico = $this->censo_model->concepto('ENFERMO_CRONICO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($enfermo_cronico as $ec) 
		{
			$enfermo_cronicos[$ec['concepto']] = $ec['concepto'].' - '.$ec['nombre'];
		}
		$this->data['enfermo_cronico'] = $enfermo_cronicos;

		if (ctype_space($salud->enfermo_cronico)) {
			$this->data['enfermo_cronico_sel'] = '  ';
		}else{
			$this->data['enfermo_cronico_sel'] = (int)$salud->enfermo_cronico;
		}

		$sigue_tratamiento = $this->censo_model->concepto('SIGUE_TRATAMIENTO',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($sigue_tratamiento as $st) 
		{
			$sigue_tratamientos[$st['concepto']] = $st['concepto'].' - '.$st['nombre'];
		}
		$this->data['sigue_tratamiento'] = $sigue_tratamientos;

		if (ctype_space($salud->sigue_tratamiento)) {
			$this->data['sigue_tratamiento_sel'] = '  ';
		}else{
			$this->data['sigue_tratamiento_sel'] = (int)$salud->sigue_tratamiento;
		}		

		$distanciarecorrida = $this->censo_model->concepto('DISTANCIA_RECORRIDA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distanciarecorrida as $dr) 
		{
			$distanciarecorridas[$dr['concepto']] = $dr['concepto'].' - '.$dr['nombre'];
		}
		$this->data['distanciarecorrida'] = $distanciarecorridas;

		if (ctype_space($salud->distanciarecorrida)) {
			$this->data['distanciarecorrida_sel'] = '  ';
		}else{
			$this->data['distanciarecorrida_sel'] = (int)$salud->distanciarecorrida;
		}

		/* Load Template */
		$this->template->admin_render('censo/salud', $this->data);
	}
    public function delete($level_1_id = null,$occ = null)
    {
       /* $documentos = $this->expedientes_model->view('documentos_dgsa', array('level_1_id' => $level_1_id))->result_array();

        if (!empty($documentos)) {
            $this->eliminar_archivos($expe_id, $documentos);
        }*/
        
        $delete  = $this->censo_model->eliminar_salud($level_1_id, $occ);
        $this->session->set_flashdata('message', '¡El registro se eliminó correctamente!');

        //$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

        //echo 'SI';
        redirect('censo/salud/salud_index/'.$level_1_id.'/'.$occ.'/E');
    }
}
//Llave de finalizacion de la clase