<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Mantenimiento_dgsa extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('expedientes/expedientes_model');
		$this->lang->load('expedientes/expedientes_lang');

		/* Titulo de la pagina :: Common */
		$this->page_title->push(lang('menu_expedientes'));
		$this->data['pagetitle'] = $this->page_title->show();
		$this->load->helper('download');

		//verificación de módulo para el reset de las variables de sessión utilizadas en la misma
		if ($_SESSION['id_modulo'] != 'EXPEDIENTES') {
			$_SESSION['arraywhere_expedientes'] 		 = NULL;
			$_SESSION['arraywhere_expedientes_busqueda'] = NULL;
			$_SESSION['arraywhere_expedientes_busqueda'] = NULL;
		    $_SESSION['id_modulo'] = 'EXPEDIENTES';
		}
		if ( !isset($_SESSION['arraywhere_coordenadas'])) {
			$this->vaciar_campos_coordenadas();
		}
		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_expedientes'), 'expedientes/expedientes');
	}

	public function expe_mantenimiento($expe_id)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{
			/* Breadcrumbs */
	        $this->breadcrumbs->unshift(2, 'Mantenimiento', 'expedientes/expedientes');
	        $this->data['breadcrumb'] = $this->breadcrumbs->show();

	        $exp_datos = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->row();

			$id 					= $exp_datos->id;
			$codigo 				= $exp_datos->codigo;
			$id_proyecto 			= $exp_datos->id_proyecto;
			$tramo 					= $exp_datos->tramo;
			$subtramo 				= $exp_datos->subtramo;
			$nombre_completo 		= $exp_datos->nombre_completo;
			$cedula_identidad 		= $exp_datos->cedula_identidad;
			$tipo_afectacion		= $exp_datos->tipo_afectacion;
			$estado_agrupado 		= $exp_datos->estado_agrupado;
			$franja_dominio 		= $exp_datos->franja_dominio;
			$notificacion 			= $exp_datos->notificacion;
			$codigo_meu 			= $exp_datos->codigo_meu;
			$padron 				= $exp_datos->padron;
			$cta_cte_catastral 		= $exp_datos->cta_cte_catastral;
			$finca 					= $exp_datos->finca;
			$matricula 				= $exp_datos->matricula;
			$distrito 				= $exp_datos->distrito;
			$lugar 					= $exp_datos->lugar;
			$departamento 			= $exp_datos->departamento;
			$progresiva_inicial 	= $exp_datos->progresiva_inicial;
			$progresiva_final 		= $exp_datos->progresiva_final;
			$ubi_coordenada_e       = $exp_datos->ubi_coordenada_e;
			$ubi_coordenada_n       = $exp_datos->ubi_coordenada_n;

			$arraywhere_coordenadas = $_SESSION['arraywhere_coordenadas'];

			$coord_id = $arraywhere_coordenadas['coord_id'];
			$coord_id_expediente = $arraywhere_coordenadas['coord_id_expediente'];
			$coord_id_terreno = $arraywhere_coordenadas['coord_id_terreno'];
			$coord_id_afecta = $arraywhere_coordenadas['coord_id_afecta'];
			$coord_orden = $arraywhere_coordenadas['coord_orden'];
			$coord_coord_x = $arraywhere_coordenadas['coord_coord_x'];
			$coord_coord_y = $arraywhere_coordenadas['coord_coord_y'];
			$validacion = $arraywhere_coordenadas['validacion'];

			$expe_info  = $this->expedientes_model->view('v_expedientes', array('id' => $expe_id))->result_array();
			$expe_coord  = $this->expedientes_model->dropdown_data('coordafecta', array('id_expediente' => $expe_id), 'id_afecta ASC, orden ASC')->result_array();
			$validar = $this->expedientes_model->validar_afectacion_coord($expe_id,$validacion);
			$cant_puntos = $this->expedientes_model->contar_puntos($expe_id);
			
			$cant_ciper=$this->expedientes_model->contar_ciper($expe_id);
			$cant_genper=$this->expedientes_model->contar_genper($expe_id);
			$cant_v_ciper=$this->expedientes_model->contar_v_ciper($expe_id);
			$cant_v_genper=$this->expedientes_model->contar_v_genper($expe_id);

			//$pericia=$this->expedientes_model->pericias_afectaciones_exp($expe_id);
			//$this->ion_auth->errors() : $this->session->flashdata('Falla pericia')));
			//echo print_r($pericia);
			//show_error('TEMPORALMENTE INACTIVO');


			if ($cant_ciper==0 or $cant_genper==0){
				if($cant_v_ciper>0 or $cant_v_genper>0){
					//$actu = $this->expedientes_model->importar_coordenadas($expe_id, "32721")->row()->importar_coordenadas;
				}
				
			}

			if($cant_puntos==0){

				$datos_graficos[0]['ESTADO_VALIDACION']	= 'GEOMETRÍA SIN VALIDAR';
			}else{
				if($validar==0){
					$datos_graficos[0]['ESTADO_VALIDACION']	= 'GEOMETRÍA VALIDA';

				}else{

					$datos_graficos[0]['ESTADO_VALIDACION']	= 'GEOMETRÍA NO VALIDA';
				}
			}

			/************* CANTIDAD DATOS GRAFICOS ****************/
			$datos_graficos[0]['TERRENOS_CI']		= $this->expedientes_model->contador_registros('terrenos_ci', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS_CI']		= $this->expedientes_model->contador_registros('mejoras_ci', array('id_exp' => $expe_id));
			$datos_graficos[0]['AFECTACIONES_CI']	= $this->expedientes_model->contador_registros('afectaciones_ci', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS_AFECTADAS_CI']	= $this->expedientes_model->contador_registros('mejoras_afectadas_ci', array('id_exp' => $expe_id));

			$datos_graficos[0]['TERRENOS_GEN']		= $this->expedientes_model->contador_registros('terrenos_gen', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS_GEN']		= $this->expedientes_model->contador_registros('mejoras_gen', array('id_exp' => $expe_id));
			$datos_graficos[0]['AFECTACIONES_GEN']	= $this->expedientes_model->contador_registros('afectaciones_gen', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS_AFECTADAS_GEN']	= $this->expedientes_model->contador_registros('mejoras_afectadas_gen', array('id_exp' => $expe_id));
			$datos_graficos[0]['POLIGONO_RESTO']	= $this->expedientes_model->contador_registros('resto_snc', array('id_exp' => $expe_id));


			//echo print_r($datos_graficos[0]['AFECTACIONES_GEN']);
			//show_error('Corrigiendo error');

			$datos_graficos[0]['TERRENOS']		= $this->expedientes_model->contador_registros('terrenos', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS']		= $this->expedientes_model->contador_registros('mejoras', array('id_exp' => $expe_id));
			$datos_graficos[0]['AFECTACIONES']	= $this->expedientes_model->contador_registros('afectaciones', array('id_exp' => $expe_id));
			$datos_graficos[0]['MEJORAS_AFECTADAS']	= $this->expedientes_model->contador_registros('mejoras_afectadas', array('id_exp' => $expe_id));

			/************* FIN CANTIDAD DATOS GRAFICOS ****************/

			//echo print_r($arraywhere_coordenadas);
			//show_error('TEMPORALMENTE INACTIVO');

			$this->data['expe_info'] 		= $expe_info;

			$this->data['datos_graficos'] 	= $datos_graficos;

			$this->data['expe_coord'] 		= $expe_coord;

			$this->data['id'] = array(
				'type'     => 'hidden',
				'name'     => 'id',
				'id'       => 'id',
				'value'    => $id
			);
			$this->data['codigo'] = array(
				'type'     => 'hidden',
				'name'     => 'codigo',
				'id'       => 'codigo',
				'value'    => $codigo
			);
			$this->data['id_proyecto'] = array(
				'type'     => 'hidden',
				'name'     => 'id_proyecto',
				'id'       => 'id_proyecto',
				'value'    => $id_proyecto
			);
			$this->data['tramo'] = array(
				'type'     => 'hidden',
				'name'     => 'tramo',
				'id'       => 'tramo',
				'value'    => $tramo
			);
			$this->data['coord_id'] = array(
				'type'     => 'hidden',
				'name'     => 'coord_id',
				'id'       => 'coord_id',
				'value'    => $coord_id
			);
			$this->data['coord_id_expediente'] = array(
				'type'     => 'hidden',
				'name'     => 'coord_id_expediente',
				'id'       => 'coord_id_expediente',
				'value'    => $coord_id_expediente
			);
			$this->data['coord_id_terreno'] = array(
				'type'     => 'hidden',
				'name'     => 'coord_id_terreno',
				'id'       => 'coord_id_terreno',
				'value'    => $coord_id_terreno
			);
			$this->data['coord_id_afecta'] = array(
				'type'     => 'text',
				'name'     => 'coord_id_afecta',
				'pattern'  => '^([1-9][0-9]{0,10})?$',
				'id'       => 'coord_id_afecta',
				//'value'    => $this->form_validation->set_value('coord_id_afecta'),
				'value'    => $this->form_validation->set_value('coord_id_afecta', $coord_id_afecta),
				'class'    => 'form-control',
				'maxlength'=> '2'
			);
			$this->data['coord_orden'] = array(
				'type'     => 'text',
				'name'     => 'coord_orden',
				'pattern'  => '^([1-9][0-9]{0,10})?$',
				'id'       => 'coord_orden',
				//'value'    => $this->form_validation->set_value('coord_orden'),
				'value'    => $this->form_validation->set_value('coord_orden', $coord_orden),
				'class'    => 'form-control',
				'maxlength'=> '2'
			);
			$this->data['coord_coord_x'] = array(
    		    'type'     => 'text',
           		'name'     => 'coord_coord_x',
           		'pattern'  => '^\s*-?[0-9]{1,12}\s*(\.\d{0,4})?$',
           		'id'       => 'coord_coord_x',
           		'value'    => $this->form_validation->set_value('coord_coord_x', $coord_coord_x),
           		'class'    => 'form-control',
           		'required' => 'true'
            );
			$this->data['coord_coord_y'] = array(
    		    'type'     => 'text',
           		'name'     => 'coord_coord_y',
           		'pattern'  => '^\s*-?[0-9]{1,13}\s*(\.\d{0,4})?$',
           		'id'       => 'coord_coord_y',
           		'value'    => $this->form_validation->set_value('coord_coord_y', $coord_coord_y),
           		'class'    => 'form-control',
           		'required' => 'true'
            );

			//WINDOWS
        	//exec('cmd /c "C:\dir_intercambio\exp_mopc_expropia_expedientes_tabla_a_shp.bat sge 2l2f1nt22022i '.trim($expe_id).'"');	

        	//LINUX
			$resultado= exec("/dir_intercambio/exp_mopc_expropia_expedientes_tabla_a_shp.sh sge 2l2f1nt22022i ".trim($id));


			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
			$this->data['message'] = $resultado;
			/* Load Template */
            $this->template->admin_render('censo/mantenimiento_dgsa', $this->data);
		}
	}


	public function eliminar_geometrias($id_expediente = NULL, $id_proyecto = NULL, $codigo = NULL)
	{
		/*echo '<pre>';
			 print_r( $id_expediente );
			 echo '</pre>';
			 show_error(1);*/
		$resultado = $this->expedientes_model->eliminar_geometrias($id_expediente,$id_proyecto,$codigo)->row()->f_eliminar_geometrias;

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LOS DATOS ESPACIALES SE ELIMINARON!');
		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);

	}



	public function download_expe($id = NULL)
	{
    	//WINDOWS
		//exec('cmd /c "C:\dir_intercambio\exp_mopc_expropia_expedientes_tabla_a_shp.bat sge 2l2f1nt22022i '.trim($id).'"');
        
    	//LINUX
    	$resultado= exec("/dir_intercambio/exp_mopc_expropia_expedientes_tabla_a_shp.sh sge 2l2f1nt22022i ".trim($id));

        //$name_file = "mopc_expediente_shp".$id.".zip";
		//$download_file = base_url("/download/".$name_file); // Read the file's contents

				//echo 'base_url: '.$id.' - codigo: '.$codigo.' - id_proyecto: '.$id_proyecto;
				//show_error('TEMPORALMENTE INACTIVO');

		/*if ( ! empty($download_file)) {
        	//If you want to download an existing file from your server you'll need to read the file into a string
        	$data = file_get_contents(base_url("/download/".$download_file)); // Read the file's contents
        	$name = $download_file;
        	force_download($name, $data);
    	}*/
			//if (file_exists($download_file)) {
	        	//If you want to download an existing file from your server you'll need to read the file into a string
			//			$data = file_get_contents($download_file); // Read the file's contents
	        //	force_download($name_file, $data);
	    	//}

		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id);

	}

	/*
	public function download_expe($id)
	{

			$documento = $this->expedientes_model->view('documentos_sge', array('id' => $id))->row();

			$ruta_dest = MEDIA_FOLDER.$documento->ruta_completa;

			if (realpath($ruta_dest)) {
					$data = file_get_contents($ruta_dest);
					force_download($documento->archivo, $data);
			} else {
					$this->session->set_flashdata('message', 'No existe un archivo para descargar');
					redirect('expedientes/expedientes/edit_expe/'.$id);
			}

			//redirect('expedientes/expedientes/edit_expe/'.$id);

	}
	*/


	public function importar_shapes()
	{

		if (empty($_FILES['shapes']['name'][0])) {
			$this->session->set_flashdata('message', '¡PRIMERO SELECCIONE LA CARPETA!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['id']);
		}


		$id 			= $_POST['id'];
		$codigo 		= $_POST['codigo'];
		$id_proyecto 	= $_POST['id_proyecto'];


		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}


		// pregunta sin existen datos graficos del expediente.
		$expe = $this->expedientes_model->existe_grafico_expe_id($id,$codigo,$id_proyecto)->row()->existe_grafico_expe_id;


		if ($expe>0) {
			$this->session->set_flashdata('message', 'EL EXPEDIENTE YA TIENE DATOS ESPACIALES!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['id']);
		}
		else {

        	//WINDOWS
			//exec('cmd /c "'.trim('rd /Q/S C:\dir_intercambio\expedientes\expediente ').trim($id).'"');
			//exec('cmd /c "'.trim('md C:\dir_intercambio\expedientes\expediente ').trim($id).'"');		
			//$ruta_dest = trim('c:\dir_intercambio\expedientes\expediente ').trim($id).trim('\ ');
			
        	//LINUX
			exec('rm -R /dir_intercambio/expedientes/expediente'.trim($id));
     		exec(trim('mkdir /dir_intercambio/expedientes/expediente ').trim($id));
			exec(trim('chmod 777 /dir_intercambio/expedientes/expediente ').trim($id));
			exec(trim('chmod 777 /dir_intercambio/expedientes/expediente ').trim($id).'/*');
			$ruta_dest = trim('/dir_intercambio/expedientes/expediente ').trim($id).trim('/ ');
			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');
                          

			$i = 0;
			while (isset($_FILES['shapes']['name'][$i])) {

				switch (substr($_FILES['shapes']['name'][$i],-3)) {
					case 'dbf':

						$nomdbf = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomdbf);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shp':

						$nomshp = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest.$nomshp);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					case 'shx':

						$nom_i = $_FILES['shapes']['name'][$i];
						copy($_FILES['shapes']['tmp_name'][$i], $ruta_dest . $_FILES['shapes']['name'][$i]);

						$arrayfiles[] = $_FILES['shapes']['name'][$i];
						$i = $i + 1;
						break;

					default:
						$i = $i + 1;
						break;

				}
			}

			$id_epsg = 32721;
			if ($accion==1) {
				$id_epsg = 32721;
			} elseif ($accion == 2) {
				$id_epsg = 32720;
			} elseif ($accion == 3) {
				$id_epsg = 4326;
			} else  {
				$id_epsg = 32721;
			}

        
				//exec('cmd /c "'.trim('md C:\dir_trabajo_server\ ').trim($gid).'"');		
				//$ruta_dest = trim('C:\dir_trabajo_server\ ').trim($gid).trim('\ ');				
				
 			//WINDOWS
			//exec('cmd /c "C:\dir_intercambio\imp_mopc_expropia_expedientes_shp_a_tabla.bat '.trim($id).' '.$id_epsg.'"');
			
			//LINUX
        	exec('/dir_intercambio/imp_mopc_expropia_expedientes_shp_a_tabla.sh '.trim($id).' '.$id_epsg);

			//echo 'expe_id: '.$expe_id;
			//show_error('TEMPORALMENTE INACTIVO');

			$actu = $this->expedientes_model->actualizar_shapes($id, $codigo, $id_proyecto, $id_epsg)->row()->actualizar_shapes;
			$actu = $this->expedientes_model->importar_coordenadas($id, $id_epsg)->row()->importar_coordenadas;
			//$actu = $this->expedientes_model->crear_resto_pol_afectacion_y_terreno($id)->row()->crear_resto_pol_afectacion_y_terreno;
			$actu = $this->expedientes_model->f_crear_resto_pol_fd_y_terreno($id)->row()->f_crear_resto_pol_fd_y_terreno;
			$actu = $this->expedientes_model->eliminar_sobrepuestos($id)->row()->eliminar_sobrepuestos;

			if ($actu>1) {
				$this->session->set_flashdata('message', 'NO importo!!');
				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['id']);
			}
			else {
				if ($actu==1) {
					$this->session->set_flashdata('message', 'Hubo error al importar la geometria, verificar shapes!');
					redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['id']);
				}
				else {
					$this->session->set_flashdata('message', '<h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> <h3>¡IMPORTADOS! </h3> ');
				}
				redirect('expedientes/mantenimiento/expe_mantenimiento/'.$_POST['id']);
			}
		}
	}

	public function vergrafico ($codigo, $level_1_id) {


		$cnt_registro = $this->expedientes_model->contador_registros('dgsa_terrenos',array('codigo' => $codigo));

		if ($cnt_registro > 0) {
			//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
			$i_jamap = "http://134.255.178.19/sgeMap/index.html?codigo=" . $codigo;
        	$i_jamap = $i_jamap . "&tipo_consulta=mopc_dgsa_terrenos_codigo";
        	if (grupo_usuario(14)) {
        		$i_jamap = $i_jamap . "&tiene_edicion_grafica=1";
        	} else {
        		$i_jamap = $i_jamap . "&tiene_edicion_grafica=0";
        	}

        	
        	redirect($i_jamap);
		} else {
		  $cnt_registro = $this->expedientes_model->contador_registros('mejoras_ci',array('id_exp' => $id_exp));
		  /*echo '<pre>';
		        print_r( $cnt_registro.$id_exp);
		        echo '</pre>';
		        show_error(1);*/
			if ($cnt_registro > 0) {
				//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
				$i_jamap = "http://134.255.178.19/sgeMap/index.html?id_exp=" . $id_exp;
				$i_jamap = $i_jamap . "&tipo_consulta=mopc_mejoras_id_exp";
				redirect($i_jamap);
			} else {
				$cnt_registro = $this->expedientes_model->contador_registros('afectaciones_gen',array('id_exp' => $id_exp));
				if ($cnt_registro > 0) {
			 		//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
					$i_jamap = "http://134.255.178.19/sgeMap/index.html?id_exp=" . $id_exp;
			  		$i_jamap = $i_jamap . "&tipo_consulta=mopc_afectacion_id_exp";
			  		redirect($i_jamap);
				} else {
			  		$this->session->set_flashdata('message', 'No existe datos a mostrar!!');
			  		redirect('expedientes/mantenimiento/expe_mantenimiento/'.$id_exp);
				}
			}
	    }
	}

	public function verpuntos ($codigo, $level_1_id) {


		$cnt_registro = $this->expedientes_model->contador_registros('dgsa_puntos',array('codigo' => $codigo));

		if ($cnt_registro > 0) {
			//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
			$i_jamap = "http://134.255.178.19/sgeMap/index.html?codigo=" . $codigo;
        	$i_jamap = $i_jamap . "&tipo_consulta=mopc_dgsa_puntos_codigo";
        	if (grupo_usuario(14)) {
        		$i_jamap = $i_jamap . "&tiene_edicion_grafica=1";
        	} else {
        		$i_jamap = $i_jamap . "&tiene_edicion_grafica=0";
        	}

        	
        	redirect($i_jamap);
		} else {
		  $cnt_registro = $this->expedientes_model->contador_registros('mejoras_ci',array('id_exp' => $id_exp));
		  /*echo '<pre>';
		        print_r( $cnt_registro.$id_exp);
		        echo '</pre>';
		        show_error(1);*/
			if ($cnt_registro > 0) {
				//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
				$i_jamap = "http://134.255.178.19/sgeMap/index.html?id_exp=" . $id_exp;
				$i_jamap = $i_jamap . "&tipo_consulta=mopc_mejoras_id_exp";
				redirect($i_jamap);
			} else {
				$cnt_registro = $this->expedientes_model->contador_registros('afectaciones_gen',array('id_exp' => $id_exp));
				if ($cnt_registro > 0) {
			 		//$i_jamap = "http://172.16.55.150/jmap/index.html?id_exp=" . $id_exp;
					$i_jamap = "http://134.255.178.19/sgeMap/index.html?id_exp=" . $id_exp;
			  		$i_jamap = $i_jamap . "&tipo_consulta=mopc_afectacion_id_exp";
			  		redirect($i_jamap);
				} else {
			  		$this->session->set_flashdata('message', 'No existe datos a mostrar!!');
			  		redirect('expedientes/mantenimiento/expe_mantenimiento/'.$id_exp);
				}
			}
	    }
	}



	public function generar_planoindividualA4 ($id_exp,$id_proyecto,$par_escala,$hoja) {
	
		$bbox = $this->expedientes_model->mapabb($id_exp);
		if ($bbox)
		{

			//$i_jameuge = $_SESSION['url_mapserver']."/i3geo/ferramentas/imprimir/mopc_A4_plano_individual.php?";
			$i_jameuge = "https://www.mopc.gov.py//sgeReport/i3geo/ferramentas/imprimir/mopc_A4_plano_individual.php?";
	        $i_jameuge = $i_jameuge . "mapfile=C:/ms4w/Apache/htdocs/i3geo/aplicmap/mopc_A4_plano_individual.map";
	        //$i_jameuge = $i_jameuge . "&interface=googlemaps";
	        $i_jameuge = $i_jameuge . "&id_exp=".$id_exp;	
	        $i_jameuge = $i_jameuge . "&colonia=".$id_proyecto;
	        $i_jameuge = $i_jameuge . "&usr=".$_SESSION['user_id'];
        	//$i_jameuge = $i_jameuge . "&hoja=".$hoja;        	
        	//$i_jameuge = $i_jameuge . "&par_escala=".$par_escala;   
        	//$i_jameuge = $i_jameuge . "&genera_per=N";  
        	redirect($i_jameuge);

			//header("Location: ".$i_jameuge);
			
		}
		else
		{
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$id_exp);
		}

	}


	/*actualizar_coordafecta*/
    public function actualizar_coordafecta()
	{

		$coord_id_expediente 	= $_POST['id'];
		$terrenos_data = $this->expedientes_model->view('terrenos_ci', array('id_exp' => $coord_id_expediente))->row();
		$coord_id_terreno= $terrenos_data->gid;

		$coord_id_afecta 		= $_POST['coord_id_afecta'];
		$coord_orden 			= $_POST['coord_orden'];
		$coord_coord_x 			= $_POST['coord_coord_x'];
		$coord_coord_y 			= $_POST['coord_coord_y'];

		$datos_update['id_expediente']	= $_POST['id'];
        $datos_update['id_terreno'] 	= $coord_id_terreno;
        $datos_update['id_afecta'] 		= $_POST['coord_id_afecta'];
        $datos_update['orden'] 			= $_POST['coord_orden'];
        $datos_update['coord_x'] 		= $_POST['coord_coord_x'];
        $datos_update['coord_y'] 		= $_POST['coord_coord_y'];

        $coordafecta_seq = $this->expedientes_model->obtener_nextval('ide.coordafecta_id_seq');

        $datos_insert['id']				= $coordafecta_seq;
        $datos_insert['id_expediente']	= $coord_id_expediente;
        $datos_insert['id_terreno'] 	= $coord_id_terreno;
        $datos_insert['id_afecta'] 		= $coord_id_afecta;
        $datos_insert['orden'] 			= $coord_orden;
        $datos_insert['coord_x'] 		= $coord_coord_x;
        $datos_insert['coord_y'] 		= $coord_coord_y;


		$arraywhere_coordenadas['coord_id']      				= $coordafecta_seq;
		$arraywhere_coordenadas['coord_id_expediente']      	= $coord_id_expediente;
		$arraywhere_coordenadas['coord_id_terreno']      		= $coord_id_terreno;
		$arraywhere_coordenadas['coord_id_afecta']      		= $coord_id_afecta;
		$arraywhere_coordenadas['coord_orden']      			= $coord_orden;
		$arraywhere_coordenadas['coord_coord_x']      			= $coord_coord_x;
		$arraywhere_coordenadas['coord_coord_y']      			= $coord_coord_y;
		$arraywhere_coordenadas['validacion']      				= 0;

		$_SESSION['arraywhere_coordenadas'] 		 			= $arraywhere_coordenadas;

		/*
				echo '<pre>';
		        print_r( $_SESSION['arraywhere_coordenadas'] );
		        echo '</pre>';
		        show_error(1);
		*/

		$accion = 0;
		if (isset($_POST['accion'])){
			$accion = intval($_POST['accion']);
		}else{
			$accion = 0;
		}

		// pregunta sin existen datos graficos del expediente.
		$cnt_registro = $this->expedientes_model->f_existe_coordafecta($coord_id_expediente,$coord_id_terreno,$coord_id_afecta,$coord_orden);
		//echo($cnt_licencia);
		//show_error(1);
		if ($coord_coord_x > 999999 or $coord_coord_y > 9999999) {
			$this->session->set_flashdata('message', 'Coordenadas exenden los limites!!');
			redirect('expedientes/mantenimiento/expe_mantenimiento/'.$coord_id_expediente);
		} else {
			if ($cnt_registro==0) {
				/*echo '<pre>';
		        print_r( $datos_insert );
		        echo '</pre>';
		        show_error(1); */

	            try {
	                // insert the new expediente
					$actu = $this->expedientes_model->insertar_coordafecta($datos_insert);
					$this->session->set_flashdata('message', 'Coordenada agregada!!');
					$this->limpiar_campos_coordenadas($coord_id_expediente);
					redirect('expedientes/mantenimiento/expe_mantenimiento/'.$coord_id_expediente);
	            }
	            catch(Exception $e) {
	                //echo 'Message: ' .$e->getMessage();
	                $this->session->set_flashdata('message', 'Error de datos!');
	                redirect('expedientes/mantenimiento/expe_mantenimiento/'.$coord_id_expediente);
	            }

			}
			else {


	            try {
	                // insert the new expediente

	                $actu = $this->expedientes_model->actualizar_corrdafecta($coord_id_expediente,$coord_id_terreno,$coord_id_afecta,$coord_orden,$datos_update);
	                //$expe_id = $this->db->insert_id();
	                //$this->ion_auth->set_message('coordafecta_creation_successful');

					if ($actu) {
						$this->session->set_flashdata('message', '¡Actualización Realizada!');
						$this->limpiar_campos_coordenadas($coord_id_expediente);
						redirect('expedientes/mantenimiento/expe_mantenimiento/'.$coord_id_expediente);
					}
					else {
						$this->session->set_flashdata('message', '¡No actualizo!');
						redirect('expedientes/mantenimiento/expe_mantenimiento/'.$coord_id_expediente);
					}

	            } catch(Exception $e) {
	                //echo 'Message: ' .$e->getMessage();
	                $this->session->set_flashdata('message', '¡Error de coordenadas! :'.$e);
	                //$this->ion_auth->set_message('coordafecta_creation_successful');
	            }
			}
		}

	}


	public function vaciar_campos_coordenadas($id_expediente = NULL)
	{


		$arraywhere_coordenadas['coord_id']      				= NULL;
		$arraywhere_coordenadas['coord_id_expediente']      	= $id_expediente;
		$arraywhere_coordenadas['coord_id_terreno']      		= 0;
		$arraywhere_coordenadas['coord_id_afecta']      		= NULL;
		$arraywhere_coordenadas['coord_orden']      			= NULL;
		$arraywhere_coordenadas['coord_coord_x']      			= NULL;
		$arraywhere_coordenadas['coord_coord_y']      			= NULL;
		$arraywhere_coordenadas['validacion']      				= 0;
		$_SESSION['arraywhere_coordenadas'] 		 			= $arraywhere_coordenadas;
	}


	public function limpiar_campos_coordenadas($id_expediente = NULL)
	{


		$this -> vaciar_campos_coordenadas($id_expediente);

		$this->session->set_flashdata('message', 'Los campos de coordenadas estan vacias!');
		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);

	}

	public function eliminar_coordafecta($id_expediente = NULL, $id = NULL)
	{

		$resultado = $this->expedientes_model->eliminar_coordafecta($id);

		//if (condition) {
		//	# code...
		//}
		$this->session->set_flashdata('message', 'LA COORDENADA SE ELIMINO!');
		redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);

	}

	public function generar_geometrias($id_proyecto = NULL, $id_expediente = NULL)
	{
		// pregunta sin existen datos graficos de afectaciones_gen del expediente respectivo.
		$cnt_registro = $this->expedientes_model->contador_registros('afectaciones_gen',array('id_exp' => $id_expediente));
		if ($cnt_registro==0) {
			$resultado = $this->expedientes_model->generar_geometrias($id_proyecto, $id_expediente)->row()->f_generar_geometrias;

				/*echo '<pre>';
		        print_r( $id_expediente );
		        echo '</pre>';
		        show_error(1); */

			$this->session->set_flashdata('message', 'SE HA CREADO LA(S) GEOMETRÍA(S) de afectaciones GEN');
			redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);
		} else {
			$this->session->set_flashdata('message', 'Ya existe registros de afectaciones!!');
			redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);
		}
	}

	public function validar_geometrias($id_expediente = NULL)
	{
		// pregunta sin existen datos graficos de afectaciones_gen del expediente respectivo.
		$cnt_registro = $this->expedientes_model->contador_registros('afectaciones_gen',array('id_exp' => $id_expediente));
		if ($cnt_registro==0) {
			$resultado = $this->expedientes_model->validar_geometrias($id_expediente)->row()->f_validar_geometrias;

				/*echo '<pre>';
		        print_r( $id_expediente);
		        echo '</pre>';
		        show_error(1);*/

			$this->session->set_flashdata('message', 'GEOMETRÍA(S) VALIDADA(S)');
			redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);
		} else {
			$this->session->set_flashdata('message', 'GEOMETRÍA(S) NO VALIDADA(S)');
			redirect('expedientes/Mantenimiento/expe_mantenimiento/'.$id_expediente);
		}
	}

}
