<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class grupofamiliar extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];


		
		if ($_SESSION['id_modulo'] != 'grupofamiliar') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'grupofamiliar') {
				
				$_SESSION['arraywhere_grupofamiliar'] = NULL;
				$_SESSION['arraywhere_grupofamiliar_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'grupofamiliar';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}

	public function grupofamiliar_index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
    
        $_SESSION['url_sub_anterior_dgsa'] = 'https://mopc.gov.py/sge/index.php/censo/grupofamiliar/grupofamiliar_index';
    
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('grupofamiliar_titulo'), 'censo/ubi_geo/index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->data['grupofamiliar'] = $this->censo_model->viewlist_abm('v_grupofamiliar', $_SESSION['identificador'])->result();

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('//message')));

		/* Load Template */
		$this->template->admin_render('censo/grupofamiliar_index', $this->data);
	}

	public function grupofamiliar_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('grupofamiliar_tiutlo'), 'grupofamiliar/create_grupofamiliar');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$max   = $this->censo_model->valor_maximo('grupofamiliar', 'occ', array('level_1_id' => $_SESSION['identificador']))->row()->max;
		$max   = $max + 1;
		$grupofamiliar = $this->censo_model->view('grupofamiliar', array('level_1_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		$this->form_validation->set_rules('grupofamiliar', 'lang:grupofamiliar_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
		if ($_POST)
		{

			$arraycamposinsert['level_1_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsert['grupofamiliar_id']  = (string)$_SESSION['identificador'];


			$arraycamposinsert['occ']         		= $max;
/*
            grupofamiliar_id 
            level_1_id 
            occ 
            nombres
            apellidos
            n_de_documento
            fecha_de_nacimiento
            edad1 
            idioma1 
            parentesco_familiar 
            sexo1
            estado_civil1 
            estudia
            trabaja 
*/            
		
			if ($_POST['n_de_miembro3']) {
				$arraycamposinsert['n_de_miembro3']         	= $_POST['n_de_miembro3'];
			}

			if ($_POST['nombres']) {
				$arraycamposinsert['nombres']         	= $_POST['nombres'];
			}

			if ($_POST['apellidos']) {
				$arraycamposinsert['apellidos']  	= $_POST['apellidos'];
			}

			if ($_POST['n_de_documento']) {
				$arraycamposinsert['n_de_documento']         	= $_POST['n_de_documento'];
			}
			
			if ($_POST['fecha_de_nacimiento']) {
				$arraycamposinsert['fecha_de_nacimiento']         	= $_POST['fecha_de_nacimiento'];
			}

        
        	if (strlen(trim($_POST['edad1'])) == 0) {
					$arraycampos['edad1']   = NULL;
              
			} else {
					$arraycampos['edad1']   = $_POST['edad1'];             
			}	

        
			if ($_POST['idiomax']) 
			{
				$arraycamposinsert['idiomax']        				= $_POST['idiomax'];
				if (trim($_POST['idiomax']) == '') {
					$arraycamposinsert['idiomax']   = 'NULL';
				} else {
					$arraycamposinsert['idiomax']   = (int)$_POST['idiomax'];
				}				
			}


			if (strlen(trim($_POST['idioma1'])) == 0) {
					$arraycampos['idioma1']   = NULL;
              
			} else {
					$arraycampos['idioma1']   = $_POST['idioma1'];             
			}	    
        				

        
			if ($_POST['parentesco_familiar']) 
			{
				$arraycamposinsert['parentesco_familiar']        				= $_POST['parentesco_familiar'];
				if (trim($_POST['parentesco_familiar']) == '') {
					$arraycamposinsert['parentesco_familiar']   = NULL;
				} else {
					$arraycamposinsert['parentesco_familiar']   = (int)$_POST['parentesco_familiar'];
				}				
			}

			if ($_POST['sexo1']) 
			{
				$arraycamposinsert['sexo1']        				= $_POST['sexo1'];
				if (trim($_POST['sexo1']) == '') {
					$arraycamposinsert['sexo1']   = NULL;
				} else {
					$arraycamposinsert['sexo1']   = (int)$_POST['sexo1'];
				}				
			}

			if ($_POST['estado_civil1']) 
			{
				$arraycamposinsert['estado_civil1']        				= $_POST['estado_civil1'];
				if (trim($_POST['estado_civil1']) == '') {
					$arraycamposinsert['estado_civil1']   = NULL;
				} else {
					$arraycamposinsert['estado_civil1']   = (int)$_POST['estado_civil1'];
				}				
			}

			if ($_POST['estudia']) 
			{
				$arraycamposinsert['estudia']        				= $_POST['estudia'];
				if (trim($_POST['estudia']) == '') {
					$arraycamposinsert['estudia']   = NULL;
				} else {
					$arraycamposinsert['estudia']   = (int)$_POST['estudia'];
				}				
			}

			if ($_POST['trabaja']) 
			{
				$arraycamposinsert['trabaja']        				= $_POST['trabaja'];
				if (trim($_POST['trabaja']) == '') {
					$arraycamposinsert['trabaja']   = NULL;
				} else {
					$arraycamposinsert['trabaja']   = (int)$_POST['trabaja'];
				}				
			}

			$create_grupofamiliar = $this->censo_model->crear_registro('grupofamiliar', $arraycamposinsert);

			/*
			$str = date_default_timezone_get();
			$fecha_procesado_4 = date("d/m/Y", strtotime($str));
			$arraycampos3 = array('proceso' 		   => 'A03'
				//,'mapear' 			   => $reg02->mapear
				,'procesado_4'		   => 1
				,'fecha_procesado_4'	   => $fecha_procesado_4
					
			);
			*/					
			/*****************************************************************/
			
			redirect('censo/grupofamiliar/grupofamiliar_index');
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
        grupofamiliar_id 
        level_1_id 
        occ 
        nombres
        apellidos
        n_de_documento
        fecha_de_nacimiento
        edad1 
        idioma1 
        parentesco_familiar 
        sexo1
        estado_civil1 
        estudia
        trabaja 
*/	
			$this->data['grupofamiliar_id'] = array(
				'name'  => 'grupofamiliar_id',
				'id'    => 'grupofamiliar_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('grupofamiliar_id'),
				'value'   => $this->form_validation->set_value('grupofamiliar_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['level_1_id'] = array(
				'name'  => 'level_1_id',
				'id'    => 'level_1_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('level_1_id'),
				'value'   => $this->form_validation->set_value('level_1_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['occ'] = array(
				'name'  => 'occ',
				'id'    => 'occ',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('occ'),
				'value'   => $this->form_validation->set_value('occ', trim($max)), 			
				'maxlength' => 20,
				'readonly' => 'true'
				);
			$this->data['n_de_miembro3'] = array(
				'name'  => 'n_de_miembro3',
				'id'    => 'n_de_miembro3',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_miembro3'),
				'maxlength' => 2
				);
			$this->data['nombres'] = array(
				'name'  => 'nombres',
				'id'    => 'nombres',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('nombres'),
				'maxlength' => 30
				);
			$this->data['apellidos'] = array(
				'name'  => 'apellidos',
				'id'    => 'apellidos',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('apellidos'),
				'maxlength' => 30
				);
			$this->data['n_de_documento'] = array(
				'name'  => 'n_de_documento',
				'pattern'  => '^([0-9][0-9]{0,8})?$',
				'id'    => 'n_de_documento',
				'type'  => 'number',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_documento'),
				'maxlength' => 8
				);
			$this->data['fecha_de_nacimiento'] = array(
				'type'     => 'text',
				'name'     => 'fecha_de_nacimiento',
				'id'       => 'fecha_de_nacimiento',
				'value'    => $this->form_validation->set_value('fecha_de_nacimiento'),
				'class'    => 'form-control',
				'required' => 'true'
				);
			$this->data['edad1'] = array(
				'name'  => 'edad1',
				'pattern'  => '^([0-9][0-9]{0,3})?$',
				'id'    => 'edad1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('edad1'),
				'maxlength' => 3
				);
			$this->data['idioma1'] = array(
				'name'  => 'idioma1',
				'id'    => 'idioma1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('idioma1'),
				'maxlength' => 30
				);
/*
			$this->data['parentesco_familiar'] = array(
				'name'  => 'parentesco_familiar',
				'id'    => 'parentesco_familiar',
				'type'  => 'number',
				'max'   => 110,
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('parentesco_familiar'),
				'maxlength' => 3
				);
			$this->data['sexo1'] = array(
				'name'  => 'sexo1',
				'id'    => 'sexo1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('sexo1'),
				'maxlength' => 20
				);
			$this->data['estado_civil1'] = array(
				'name'  => 'estado_civil1',
				'id'    => 'estado_civil1',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('estado_civil1'),
				'maxlength' => 20
				);
			$this->data['estudia'] = array(
				'name'  => 'estudia',
				'id'    => 'estudia',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('estudia'),
				'maxlength' => 20
				);
			$this->data['trabaja'] = array(
				'name'  => 'trabaja',
				'id'    => 'trabaja',
				'type'  => 'number',
				'max'   => 110,
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('trabaja'),
				'maxlength' => 3
				);
*/			      
				
		$parentesco_familiar = $this->censo_model->concepto('PARENTESCO_FAMILIAR',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($parentesco_familiar as $pf) {
			$parentesco_familiars[$pf['concepto']] = $pf['concepto'].' - '.$pf['nombre'];
		}
		$this->data['parentesco_familiar'] = $parentesco_familiars;

		$sexo1 = $this->censo_model->concepto('SEXO1',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($sexo1 as $se) {
			$sexo1s[$se['concepto']] = $se['concepto'].' - '.$se['nombre'];
		}
		$this->data['sexo1'] = $sexo1s;

		$estado_civil1 = $this->censo_model->concepto('ESTADO_CIVIL1',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estado_civil1 as $ec) {
			$estado_civil1s[$ec['concepto']] = $ec['concepto'].' - '.$ec['nombre'];
		}
		$this->data['estado_civil1'] = $estado_civil1s;

		$estudia = $this->censo_model->concepto('ESTUDIA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estudia as $es) {
			$estudias[$es['concepto']] = $es['concepto'].' - '.$es['nombre'];
		}
		$this->data['estudia'] = $estudias;	

		$trabaja = $this->censo_model->concepto('TRABAJA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($trabaja as $tr) {
			$trabajas[$tr['concepto']] = $tr['concepto'].' - '.$tr['nombre'];
		}
		$this->data['trabaja'] = $trabajas;		
        
        
        
        $idiomax = $this->censo_model->concepto('IDIOMA',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($idiomax as $pf) {
			$idiomaxs[$pf['concepto']] = $pf['concepto'].' - '.$pf['nombre'];
		}
		$this->data['idiomax'] = $idiomaxs;

        
           /*
			$p02_filtro = $this->reg01_model->concepto('P02_FILTRO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($p02_filtro as $p02f) {
				$p02_fs[$p02f['concepto']] = $p02f['concepto'].' - '.$p02f['nombre'];
			}
			$this->data['p02_filtro'] = $p02_fs;
			*/

			/* Load Template */
			$this->template->admin_render('censo/grupofamiliar_create', $this->data);
		}
	}

	public function grupofamiliar_edit($level_1_id, $occ, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('grupofamiliar_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();
/*
		SELECT *  
		FROM dgsa.grupo_familiar 
		WHERE level_1_id = 49 
		AND occ = 1

		$where_level_1_id = array('level_1_id' => 49,
                                  'occ' => 1);
		
		$level_1_id = 49;
		$occ = 1;

		//Formato digamos original o tipo matematico de Array 	
		$where_level_1_id = array('level_1_id' => $_SESSION['identificador'],
                                  'occ' => $occ);
								  
		//Formato digamos de programacion de lenguaje acuales 
		$where_level_1_id['level_1_id'] = $level_1_id;
		$where_level_1_id['occ'] = $occ;

*/	 
		$where_level_1_id['level_1_id'] = $level_1_id;
		$where_level_1_id['occ'] = $occ;

		//$where_level_1_id = array('level_1_id' => $_SESSION['identificador'],
	    //                          'occ' => $occ);

		//$where_level_1_id = array('level_1_id' => $_SESSION['identificador'],'occ' => $occ);								  
								  
 
		$_SESSION['identificador'] = $level_1_id;

		//$grupofamiliar = $this->censo_model->view('grupofamiliar', array('level_1_id' => $_SESSION['identificador'],'occ' => $occ))->row();

		$grupofamiliar = $this->censo_model->view('grupofamiliar',$where_level_1_id )->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('grupofamiliar_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['grupofamiliar_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['grupofamiliar_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['grupofamiliar_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

    /* 
    grupofamiliar_id
    level_1_id
    occ
    n_de_miembro1
    enfermo_cronico
    especif_enfermedad
    sigue_tratamiento
    lugar
    distanciarecorrida
    */

		if ($_POST) {

			/*
			if ($_POST['grupofamiliar_id']) 
			{
				$arraycampos['grupofamiliar_id']                       = $_POST['grupofamiliar_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					= $_POST['level_1_id'];
			}
			
			if ($_POST['occ']) 
			{
				$arraycampos['occ']             				    = $_POST['occ'];
			}
			*/

			if ($_POST['n_de_miembro3']) 
			{
				$arraycampos['n_de_miembro3']        			            = $_POST['n_de_miembro3'];
			}

			if ($_POST['nombres']) 
			{
				$arraycampos['nombres']        			            = $_POST['nombres'];
			}

			if ($_POST['apellidos']) 
			{
				$arraycampos['apellidos']      					    = $_POST['apellidos'];
			}

			if ($_POST['n_de_documento']) 
			{
				$arraycampos['n_de_documento']        				= $_POST['n_de_documento'];
			}

			if ($_POST['fecha_de_nacimiento']) 
			{
				$arraycampos['fecha_de_nacimiento']        			= $_POST['fecha_de_nacimiento'];
			}

			if (strlen(trim($_POST['edad1'])) == 0) {
					$arraycampos['edad1']   = NULL;
			} else {
					$arraycampos['edad1']   = (int)$_POST['edad1'];
            }
        
			if ($_POST['idiomax'])
			{
				$arraycampos['idiomax']        				= $_POST['idiomax'];
				if (trim($_POST['idiomax']) == '') {
					$arraycampos['idiomax']   = NULL;
				} else {
					$arraycampos['idiomax']   = (int)$_POST['idiomax'];
				}				
			}
			/*
                echo '<pre>';
				echo  strlen(trim($_POST['idioma1']));
                echo  $arraycampos['idioma1'];
				echo '</pre>';  
            	show_error(1);
            */
 
			if (strlen(trim($_POST['idioma1'])) == 0) {
					$arraycampos['idioma1']   = NULL;
              
			} else {
					$arraycampos['idioma1']   = $_POST['idioma1'];             
			}	    
        
			if ($_POST['parentesco_familiar']) 
			{
				$arraycampos['parentesco_familiar']        				= $_POST['parentesco_familiar'];
				if (trim($_POST['parentesco_familiar']) == '') {
					$arraycampos['parentesco_familiar']   = NULL;
				} else {
					$arraycampos['parentesco_familiar']   = (int)$_POST['parentesco_familiar'];
				}				
			}

			if ($_POST['sexo1']) 
			{
				$arraycampos['sexo1']        				= $_POST['sexo1'];
				if (trim($_POST['sexo1']) == '') {
					$arraycampos['sexo1']   = NULL;
				} else {
					$arraycampos['sexo1']   = (int)$_POST['sexo1'];
				}				
			}

			if ($_POST['estado_civil1']) 
			{
				$arraycampos['estado_civil1']        				= $_POST['estado_civil1'];
				if (trim($_POST['estado_civil1']) == '') {
					$arraycampos['estado_civil1']   = NULL;
				} else {
					$arraycampos['estado_civil1']   = (int)$_POST['estado_civil1'];
				}				
			}

			if ($_POST['estudia']) 
			{
				$arraycampos['estudia']        				= $_POST['estudia'];
				if (trim($_POST['estudia']) == '') {
					$arraycampos['estudia']   = NULL;
				} else {
					$arraycampos['estudia']   = (int)$_POST['estudia'];
				}				
			}

			if ($_POST['trabaja']) 
			{
				$arraycampos['trabaja']        				= $_POST['trabaja'];
				if (trim($_POST['trabaja']) == '') {
					$arraycampos['trabaja']   = NULL;
				} else {
					$arraycampos['trabaja']   = (int)$_POST['trabaja'];
				}				
			}

			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador'],'occ' => $grupofamiliar->occ), 'grupofamiliar', $arraycampos);

			
			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['grupofamiliar'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/grupofamiliar/grupofamiliar_edit/'.$level_1_id.'/'.$occ.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
grupofamiliar_id
level_1_id
occ
nombres
apellidos
n_de_documento
fecha_de_nacimiento
edad1
idioma1
parentesco_familiar
sexo1
estado_civil1
estudia
trabaja
*/

		$this->data['grupofamiliar_id'] = array(
			'type'    => 'text',
			'name'    => 'grupofamiliar_id',
			'id'      => 'grupofamiliar_id',
			'value'   => $this->form_validation->set_value('grupofamiliar_grupofamiliar_id', trim($grupofamiliar->grupofamiliar_id)),
			'class'   => 'form-control',	
			'readonly' => 'true'		
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('grupofamiliar_level_1_id', trim($grupofamiliar->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['occ'] = array(
			'type'  => 'text',
			'name'  => 'occ',
			'id'    => 'occ',
			'value' => $this->form_validation->set_value('grupofamiliar_occ', trim($grupofamiliar->occ)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['n_de_miembro3'] = array(
			'type'  => 'text',
			'name'  => 'n_de_miembro3',
			'id'    => 'n_de_miembro3',
			'value' => $this->form_validation->set_value('grupofamiliar_n_de_miembro3', trim($grupofamiliar->n_de_miembro3)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		$this->data['nombres'] = array(
			'type'  => 'text',
			'name'  => 'nombres',
			'id'    => 'nombres',
			'value' => $this->form_validation->set_value('grupofamiliar_nombres', trim($grupofamiliar->nombres)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		$this->data['apellidos'] = array(
			'type'  => 'text',
			'name'  => 'apellidos',
			'id'    => 'apellidos',
			'value' => $this->form_validation->set_value('grupofamiliar_apellidos', trim($grupofamiliar->apellidos)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		$this->data['n_de_documento'] = array(
			'type'  => 'text',
			'name'  => 'n_de_documento',	
            'pattern'  => '^([1-9][0-9]{0,8})?$',
			'id'    => 'n_de_documento',
			'value' => $this->form_validation->set_value('grupofamiliar_n_de_documento', trim($grupofamiliar->n_de_documento)),
			'class' => 'form-control',
            'maxlength'=> '8'
		);	
		$this->data['fecha_de_nacimiento'] = array(
			'type'     => 'text',
			'name'     => 'fecha_de_nacimiento',
			'id'       => 'fecha_de_nacimiento',
			'value'    => $this->form_validation->set_value('grupofamiliar_fecha_de_nacimiento', trim($grupofamiliar->fecha_de_nacimiento)),
			'class'    => 'form-control',
			'required' => 'true'
			);
		$this->data['edad1'] = array(
			'type'  => 'text',
			'name'  => 'edad1',
			'id'    => 'edad1',
			'value' => $this->form_validation->set_value('grupofamiliar_edad1', trim($grupofamiliar->edad1)),
			'class' => 'form-control',
            'maxlength'=> '3'
		);
		$this->data['idioma1'] = array(
			'type'  => 'text',
			'name'  => 'idioma1',
			'id'    => 'idioma1',
			'value' => $this->form_validation->set_value('grupofamiliar_idioma1', trim($grupofamiliar->idioma1)),
			'class' => 'form-control',
            'maxlength'=> '30'
		);
		/*
		$this->data['parentesco_familiar'] = array(
			'type'  => 'text',
			'name'  => 'parentesco_familiar',
			'id'    => 'parentesco_familiar',
			'value' => $this->form_validation->set_value('grupofamiliar_parentesco_familiar', trim($grupofamiliar->parentesco_familiar)),
			'class' => 'form-control'
		);
		$this->data['sexo1'] = array(
			'type'  => 'text',
			'name'  => 'sexo1',
			'id'    => 'sexo1',
			'value' => $this->form_validation->set_value('grupofamiliar_sexo1', trim($grupofamiliar->sexo1)),
			'class' => 'form-control'
		);
		$this->data['estado_civil1'] = array(
			'type'  => 'text',
			'name'  => 'estado_civil1',
			'id'    => 'estado_civil1',
			'value' => $this->form_validation->set_value('grupofamiliar_estado_civil1', trim($grupofamiliar->estado_civil1)),
			'class' => 'form-control'
		);
		$this->data['estudia'] = array(
			'type'  => 'text',
			'name'  => 'estudia',
			'id'    => 'estudia',
			'value' => $this->form_validation->set_value('grupofamiliar_estudia', trim($grupofamiliar->estudia)),
			'class' => 'form-control'
		);
		$this->data['trabaja'] = array(
			'type'  => 'text',
			'name'  => 'trabaja',
			'id'    => 'trabaja',
			'value' => $this->form_validation->set_value('grupofamiliar_trabaja', trim($grupofamiliar->trabaja)),
			'class' => 'form-control'
		);
		*/

		$parentesco_familiar = $this->censo_model->concepto('PARENTESCO_FAMILIAR',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($parentesco_familiar as $af) 
		{
			$parentesco_familiars[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['parentesco_familiar'] = $parentesco_familiars;

		if (ctype_space($grupofamiliar->parentesco_familiar)) {
			$this->data['parentesco_familiar_sel'] = '  ';
		}else{
			$this->data['parentesco_familiar_sel'] = (int)$grupofamiliar->parentesco_familiar;
		}

		$sexo1 = $this->censo_model->concepto('SEXO1',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($sexo1 as $se) 
		{
			$sexo1s[$se['concepto']] = $se['concepto'].' - '.$se['nombre'];
		}
		$this->data['sexo1'] = $sexo1s;

		if (ctype_space($grupofamiliar->sexo1)) {
			$this->data['sexo1_sel'] = '  ';
		}else{
			$this->data['sexo1_sel'] = (int)$grupofamiliar->sexo1;
		}

		$estado_civil1 = $this->censo_model->concepto('ESTADO_CIVIL1',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estado_civil1 as $ec) 
		{
			$estado_civil1s[$ec['concepto']] = $ec['concepto'].' - '.$ec['nombre'];
		}
		$this->data['estado_civil1'] = $estado_civil1s;

		if (ctype_space($grupofamiliar->estado_civil1)) {
			$this->data['estado_civil1_sel'] = '  ';
		}else{
			$this->data['estado_civil1_sel'] = (int)$grupofamiliar->estado_civil1;
		}

		$estudia = $this->censo_model->concepto('ESTUDIA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($estudia as $es) 
		{
			$estudias[$es['concepto']] = $es['concepto'].' - '.$es['nombre'];
		}
		$this->data['estudia'] = $estudias;

		if (ctype_space($grupofamiliar->estudia)) {
			$this->data['estudia_sel'] = '  ';
		}else{
			$this->data['estudia_sel'] = (int)$grupofamiliar->estudia;
		}

		$trabaja = $this->censo_model->concepto('TRABAJA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($trabaja as $tr) 
		{
			$trabajas[$tr['concepto']] = $tr['concepto'].' - '.$tr['nombre'];
		}
		$this->data['trabaja'] = $trabajas;

		if (ctype_space($grupofamiliar->trabaja)) {
			$this->data['trabaja_sel'] = '  ';
		}else{
			$this->data['trabaja_sel'] = (int)$grupofamiliar->trabaja;
		}

		$idiomax = $this->censo_model->concepto('IDIOMA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($idiomax as $af) 
		{
			$idiomaxs[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['idiomax'] = $idiomaxs;

		if (ctype_space($grupofamiliar->idiomax)) {
			$this->data['idiomax_sel'] = '  ';
		}else{
			$this->data['idiomax_sel'] = (int)$grupofamiliar->idiomax;
		}


		/* Load Template */
		$this->template->admin_render('censo/grupofamiliar', $this->data);
	}

    public function delete($level_1_id = null,$occ = null)
    {
       /* $documentos = $this->expedientes_model->view('documentos_dgsa', array('level_1_id' => $level_1_id))->result_array();

        if (!empty($documentos)) {
            $this->eliminar_archivos($expe_id, $documentos);
        }*/
        
        $delete  = $this->censo_model->eliminar_grupofamiliar($level_1_id, $occ);
        $this->session->set_flashdata('message', '¡El grupo familiar se eliminó correctamente!');

        //$_SESSION['last_exp_delete'] = '¡El expediente <b>'.$_POST['exp'].'</b>, gestión <b>'.$_POST['gest'].'</b> se eliminó correctamente!';

        //echo 'SI';
        redirect('censo/Grupofamiliar/grupofamiliar_index/'.$level_1_id.'/'.$occ.'/E');
    }
}
//Llave de finalizacion de la clase