<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class economia extends Admin_Controller {

	public function __construct()
	{
		parent::__construct();

		$this->load->model('censo/censo_model');
		$this->lang->load('censo/censo_lang');

		/* Title Page :: Common */
		$this->page_title->push(lang('menu_dgsa_censo'));
		$this->data['pagetitle'] = $this->page_title->show();

		$_SESSION['id_modulo_ant'] = $_SESSION['id_modulo'];

		$_SESSION['url_anterior'] = 'http://jaimito.site/sge/index.php/censo/censo/index';

		
		if ($_SESSION['id_modulo'] != 'economia') {
			//show_error($_SESSION['id_modulo']);
			if ($_SESSION['id_modulo'] != 'economia') {
				
				$_SESSION['arraywhere_economia'] = NULL;
				$_SESSION['arraywhere_economia_busq'] = NULL;	
			}
			
			$_SESSION['id_modulo'] = 'economia';

			$_SESSION['errores_censo'] = NULL;
			is_array($_SESSION['errores_censo']);
		}

		/* Breadcrumbs :: Common */
		$this->breadcrumbs->unshift(1, lang('menu_censos'), 'censo/censo/index');
	}

	public function economia_index()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		$_SESSION['url_sub_anterior'] = 'http://jaimito.site/sge/index.php/censo/economia/economia_index';
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('economia_titulo'), 'censo/ubi_geo/index');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$this->data['economia'] = $this->censo_model->viewlist_abm('economia', $_SESSION['identificador'])->result();

		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('//message')));

		/* Load Template */
		$this->template->admin_render('censo/economia_index', $this->data);
	}

	public function economia_create()
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		/* Breadcrumbs */
		$this->breadcrumbs->unshift(3, lang('economia_tiutlo'), 'economia/create_economia');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$max   = $this->censo_model->valor_maximo('economia', 'occ', array('level_1_id' => $_SESSION['identificador']))->row()->max;
		$max   = $max + 1;
		$economia = $this->censo_model->view('economia', array('level_1_id' => $_SESSION['identificador']))->row();

		/* Validate form input */
		$this->form_validation->set_rules('economia', 'lang:economia_occ' , 'required');
		//$this->form_validation->set_rules('p01_b','lang:geocolonia_col_desc', 'required');

		//if ($this->form_validation->run() == TRUE)
		if ($_POST)
		{

			$arraycamposinsert['level_1_id']  = (string)$_SESSION['identificador'];
			$arraycamposinsert['economia_id']  = (string)$_SESSION['identificador'];


			$arraycamposinsert['occ']         		= $max;
		
			if ($_POST['n_de_miembro']) {
				$arraycamposinsert['n_de_miembro']         			= $_POST['n_de_miembro'];
			}

			if ($_POST['lugar_de_trabajo']) {
				$arraycamposinsert['lugar_de_trabajo']  			= $_POST['lugar_de_trabajo'];
			}

			if ($_POST['ciudad']) {
				$arraycamposinsert['ciudad']         				= $_POST['ciudad'];
			}

			if ($_POST['antiguedad']) {
				$arraycamposinsert['antiguedad']         			= $_POST['antiguedad'];
			}

			if ($_POST['ocupacion']) {
				$arraycamposinsert['ocupacion']      				= $_POST['ocupacion'];
			}

			if ($_POST['horario']) {
				$arraycamposinsert['horario']     					= $_POST['horario'];
			}

			if ($_POST['dgsa_economia_distancia_recorrida']) 
			{
				$arraycamposinsert['distancia_recorrida']        				= $_POST['dgsa_economia_distancia_recorrida'];
				if (trim($_POST['dgsa_economia_distancia_recorrida']) == '') {
					$arraycamposinsert['distancia_recorrida']   = NULL;
				} else {
					$arraycamposinsert['distancia_recorrida']   = (int)$_POST['dgsa_economia_distancia_recorrida'];
				}				
			}

			if ($_POST['fijo']) {
				$arraycamposinsert['fijo']      					= $_POST['fijo'];
			}

			if ($_POST['ocasional']) {
				$arraycamposinsert['ocasional']     				= $_POST['ocasional'];
			}


			$create_economia = $this->censo_model->crear_registro('economia', $arraycamposinsert);

			/*
			$str = date_default_timezone_get();
			$fecha_procesado_4 = date("d/m/Y", strtotime($str));
			$arraycampos3 = array('proceso' 		   => 'A03'
				//,'mapear' 			   => $reg02->mapear
				,'procesado_4'		   => 1
				,'fecha_procesado_4'	   => $fecha_procesado_4
					
			);
			*/					
			/*****************************************************************/
			
			redirect('censo/economia/economia_index');
		}
		else
		{
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
economia_id
level_1_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
*/	
			$this->data['economia_id'] = array(
				'name'  => 'economia_id',
				'id'    => 'economia_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('economia_id'),
				'value'   => $this->form_validation->set_value('economia_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['level_1_id'] = array(
				'name'  => 'level_1_id',
				'id'    => 'level_1_id',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('level_1_id'),
				'value'   => $this->form_validation->set_value('level_1_id', trim($_SESSION['identificador'])),
				'maxlength' => 15,
				'readonly' => 'true'
				);
			$this->data['occ'] = array(
				'name'  => 'occ',
				'id'    => 'occ',
				'type'  => 'text',
				'class' => 'form-control',
				//'value' => $this->form_validation->set_value('occ'),
				'value'   => $this->form_validation->set_value('occ', trim($max)), 			
				'maxlength' => 20,
				'readonly' => 'true'
				);
			$this->data['n_de_miembro'] = array(
				'name'  => 'n_de_miembro',
				'id'    => 'n_de_miembro',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('n_de_miembro'),
				'maxlength' => 20
				);
			$this->data['lugar_de_trabajo'] = array(
				'name'  => 'lugar_de_trabajo',
				'id'    => 'lugar_de_trabajo',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('lugar_de_trabajo'),
				'maxlength' => 7
				);
			$this->data['ciudad'] = array(
				'name'  => 'ciudad',
				'id'    => 'ciudad',
				'type'  => 'number',
				'max'   => 110,
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ciudad'),
				'maxlength' => 3
				);
			$this->data['antiguedad'] = array(
				'name'  => 'antiguedad',
				'id'    => 'antiguedad',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('antiguedad'),
				'maxlength' => 20
				);
			$this->data['ocupacion'] = array(
				'name'  => 'ocupacion',
				'id'    => 'ocupacion',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('ocupacion'),
				'maxlength' => 20
				);
			$this->data['horario'] = array(
				'name'  => 'horario',
				'id'    => 'horario',
				'type'  => 'text',
				'class' => 'form-control',
				'value' => $this->form_validation->set_value('horario'),
				'maxlength' => 20
				);
/*
            $this->data['distancia_recorrida'] = array(
                'name'  => 'distancia_recorrida',
                'id'    => 'distancia_recorrida',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('distancia_recorrida'),
                'maxlength' => 20
                );
*/
            $this->data['fijo'] = array(
                'name'  => 'fijo',
                'id'    => 'fijo',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('fijo'),
                'maxlength' => 20
                );
            $this->data['ocasional'] = array(
                'name'  => 'ocasional',
                'id'    => 'ocasional',
                'type'  => 'text',
                'class' => 'form-control',
                'value' => $this->form_validation->set_value('ocasional'),
                'maxlength' => 20
                );

		
			$distancia_recorrida = $this->censo_model->concepto('DISTANCIA_RECORRIDA',false,'CONCEPTO')->result_array();
				//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($distancia_recorrida as $dr) {
				$distancia_recorridas[$dr['concepto']] = $dr['concepto'].' - '.$dr['nombre'];
			}
			$this->data['distancia_recorrida'] = $distancia_recorridas;

				
			/*
			$p02_filtro = $this->reg01_model->concepto('P02_FILTRO',false,'CONCEPTO')->result_array();
			//inserta en un array asociativo para poder utilizarlo en el form_dropdown
			foreach ($p02_filtro as $p02f) {
				$p02_fs[$p02f['concepto']] = $p02f['concepto'].' - '.$p02f['nombre'];
			}
			$this->data['p02_filtro'] = $p02_fs;
			*/

			/* Load Template */
			$this->template->admin_render('censo/economia_create', $this->data);
		}
	}

	public function economia_edit($level_1_id, $modo_censo)
	{
		if ( ! $this->ion_auth->logged_in() OR ! $this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}
		/* Breadcrumbs */
		$this->breadcrumbs->unshift(2, lang('economia_level_1_id'), 'censo/create');
		$this->data['breadcrumb'] = $this->breadcrumbs->show();

		$_SESSION['identificador'] = $level_1_id;
		$economia = $this->censo_model->view('economia', array('level_1_id' => $_SESSION['identificador']))->row();

			//declara el indice del array si es que no existe
		if (is_array($_SESSION['errores_censo']) && !array_key_exists('economia_level_1_id' , $_SESSION['errores_censo'])) {
			$_SESSION['errores_censo']['economia_level_1_id'] = NULL;     
		}

		/**** BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/
		//función para validar pestaña
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '3');
		//$this->censo_model->validar_pestanha($_SESSION['identificador'], '6');

		//obtiene los errores de la tabla
		$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

		foreach ($errores as $value) {

			$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

			if (isset($concepto[0])) {
				$error[$value['error']] = $concepto[0]['descripcion'];
			}
		}

		if (isset($error)) {
			$_SESSION['errores_censo']['economia_level_1_id'] = $error;
		}else{
			$_SESSION['errores_censo']['economia_level_1_id'] = NULL;
		}
		/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

    /* 
economia_id
level_1_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
    */

		if ($_POST) {

			/*
			if ($_POST['economia_id']) 
			{
				$arraycampos['economia_id']                             = $_POST['economia_id'];
			}

			if ($_POST['level_1_id'])
			{
				$arraycampos['level_1_id']   					        = $_POST['level_1_id'];
			}
			
			if ($_POST['occ']) 
			{
				$arraycampos['occ']             				        = $_POST['occ'];
			}
			*/

			if ($_POST['n_de_miembro']) 
			{
				$arraycampos['n_de_miembro']        			        = $_POST['n_de_miembro'];
			}

			if ($_POST['lugar_de_trabajo']) 
			{
				$arraycampos['lugar_de_trabajo']      					= $_POST['lugar_de_trabajo'];
			}

			if ($_POST['ciudad']) 
			{
				$arraycampos['ciudad']        				            = $_POST['ciudad'];
			}

			if ($_POST['antiguedad']) 
			{
				$arraycampos['antiguedad']        				        = $_POST['antiguedad'];
			}

			if ($_POST['ocupacion']) 
			{
				$arraycampos['ocupacion']    					        = $_POST['ocupacion'];
			}

			if ($_POST['horario']) 
			{
				$arraycampos['horario']    					            = $_POST['horario'];
			}

			if ($_POST['dgsa_economia_distancia_recorrida']) 
			{
				$arraycampos['distancia_recorrida']        				= $_POST['dgsa_economia_distancia_recorrida'];
				if (trim($_POST['dgsa_economia_distancia_recorrida']) == '') {
					$arraycampos['distancia_recorrida']   = NULL;
				} else {
					$arraycampos['distancia_recorrida']   = (int)$_POST['dgsa_economia_distancia_recorrida'];
				}				
			}

			if ($_POST['fijo']) 
			{
				$arraycampos['fijo']    					            = $_POST['fijo'];
			}

			if ($_POST['ocasional']) 
			{
				$arraycampos['ocasional']    					        = $_POST['ocasional'];
			}


			$update_reg = $this->censo_model->actualizar_censo(array('level_1_id' => $_SESSION['identificador'],'occ' => $economia->occ), 'economia', $arraycampos);

			
			//obtiene los errores de la tabla
			$errores = $this->censo_model->obtener_errores($_SESSION['identificador'], '3')->result_array();

			foreach ($errores as $value) {

				$concepto = $this->censo_model->concepto('CENSO_ERRORES', false, 'CONCEPTO', $value['error'])->result_array();

				if (isset($concepto[0])) {
					$error[$value['error']] = $concepto[0]['descripcion'];
				}
			}

			$_SESSION['errores_censo']['economia'] = $error;
			/**** FIN BLOQUE DE VALIDACIÓN DE PESTAÑANA ****/

			/*****************************************************************/
			if ($update_reg)
			{
				$this->session->set_flashdata('message', $this->lang->line('edit_in_temp_saved'));
			}else{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
			}

			redirect('censo/economia/economia_edit/'.$level_1_id.'/E');
		}


		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
/* 
economia_id
level_1_id
occ
n_de_miembro
lugar_de_trabajo
ciudad
antiguedad
ocupacion
horario
distancia_recorrida
fijo
ocasional
*/

		$this->data['economia_id'] = array(
			'type'    => 'text',
			'name'    => 'economia_id',
			'id'      => 'economia_id',
			'value'   => $this->form_validation->set_value('economia_economia_id', trim($economia->economia_id)),
			'class'   => 'form-control',	
			'readonly' => 'true'		
			);
		$this->data['level_1_id'] = array(
			'type'  => 'text',
			'name'  => 'level_1_id',
			'id'    => 'level_1_id',
			'value' => $this->form_validation->set_value('economia_level_1_id', trim($economia->level_1_id)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['occ'] = array(
			'type'  => 'text',
			'name'  => 'occ',
			'id'    => 'occ',
			'value' => $this->form_validation->set_value('economia_occ', trim($economia->occ)),
			'class' => 'form-control',
			'readonly' => 'true'
			);
		$this->data['n_de_miembro'] = array(
			'type'  => 'text',
			'name'  => 'n_de_miembro',
			'id'    => 'n_de_miembro',
			'value' => $this->form_validation->set_value('economia_n_de_miembro', trim($economia->n_de_miembro)),
			'class' => 'form-control',
            'maxlength'=> '2'
		);
		$this->data['lugar_de_trabajo'] = array(
			'type'  => 'text',
			'name'  => 'lugar_de_trabajo',
			'id'    => 'lugar_de_trabajo',
			'value' => $this->form_validation->set_value('economia_lugar_de_trabajo', trim($economia->lugar_de_trabajo)),
			'class' => 'form-control',
            'maxlength'=> '20'
		);
		$this->data['ciudad'] = array(
			'type'  => 'text',
			'name'  => 'ciudad',
			'id'    => 'ciudad',
			'value' => $this->form_validation->set_value('economia_ciudad', trim($economia->ciudad)),
			'class' => 'form-control',
            'maxlength'=> '15'
		);
		$this->data['antiguedad'] = array(
			'type'  => 'text',
			'name'  => 'antiguedad',
			'id'    => 'antiguedad',
			'value' => $this->form_validation->set_value('economia_antiguedad', trim($economia->antiguedad)),
			'class' => 'form-control',
            'maxlength'=> '2'
		);
		$this->data['ocupacion'] = array(
			'type'  => 'text',
			'name'  => 'ocupacion',
			'id'    => 'ocupacion',
			'value' => $this->form_validation->set_value('economia_ocupacion', trim($economia->ocupacion)),
			'class' => 'form-control',
            'maxlength'=> '15'
		);
		$this->data['horario'] = array(
			'type'  => 'text',
			'name'  => 'horario',
			'id'    => 'horario',
			'value' => $this->form_validation->set_value('economia_horario', trim($economia->horario)),
			'class' => 'form-control',
            'maxlength'=> '4'
		);
/*
		$this->data['distancia_recorrida'] = array(
			'type'  => 'text',
			'name'  => 'distancia_recorrida',
			'id'    => 'distancia_recorrida',
			'value' => $this->form_validation->set_value('economia_distancia_recorrida', trim($economia->distancia_recorrida)),
			'class' => 'form-control'
		);
*/
		$this->data['fijo'] = array(
			'type'  => 'text',
			'name'  => 'fijo',
			'id'    => 'fijo',
			'value' => $this->form_validation->set_value('economia_fijo', trim($economia->fijo)),
			'class' => 'form-control',
            'maxlength'=> '11'
		);
		$this->data['ocasional'] = array(
			'type'  => 'text',
			'name'  => 'ocasional',
			'id'    => 'ocasional',
			'value' => $this->form_validation->set_value('economia_ocasional', trim($economia->ocasional)),
			'class' => 'form-control',
            'maxlength'=> '11'
		);

		$distancia_recorrida = $this->censo_model->concepto('DISTANCIA_RECORRIDA',true,'concepto')->result_array();
		//inserta en un array asociativo para poder utilizarlo en el form_dropdown
		foreach ($distancia_recorrida as $af) 
		{
			$distancia_recorridas[$af['concepto']] = $af['concepto'].' - '.$af['nombre'];
		}
		$this->data['distancia_recorrida'] = $distancia_recorridas;

		if (ctype_space($economia->distancia_recorrida)) {
			$this->data['distancia_recorrida_sel'] = '  ';
		}else{
			$this->data['distancia_recorrida_sel'] = (int)$economia->distancia_recorrida;
		}

		/* Load Template */
		$this->template->admin_render('censo/economia', $this->data);
	}

}
//Llave de finalizacion de la clase